from .model import BaseVisitor


class UpstreamChecker(BaseVisitor):
    RULE = 'ATTEMPTS'

    def check_Balancer2(self, module, path):
        if not module.get('attempts').value:
            if module.attempts_rate_limiter:
                self.warn(path, 'NO_ATTEMPTS,ATTEMPTS_LIMITER_ENABLED',
                          tags={'no-attempts'})
            else:
                self.warn(path, 'NO_ATTEMPTS,ATTEMPTS_LIMITER_DISABLED',
                          tags={'no-attempts', 'no-attempts-rate-limiter'})
