from .model import BaseVisitor


class UpstreamChecker(BaseVisitor):
    RULE = 'REWRITE'

    def check_Rewrite(self, module, path):
        for action in module.actions:
            if not action.get('rewrite').value:
                self.warn(path, 'EMPTY_REWRITE',
                          tags={'empty-rewrite'})
