from .model import BaseVisitor


def to_names(path):
    return [item[0] for item in path]


class UpstreamChecker(BaseVisitor):
    """
    Very quick and dirty implementation, to be refined and refactored.
    """
    RULE = 'UEM'

    ok = False

    def fail(self, path):
        self.warn(path, 'Does not look easy', tags={'total'})
        self.ok = False
        return False, []

    def check_Balancer2(self, module, path):
        original_path = list(path)

        def ignore_all(ms, ignored_name):
            return [(name, m) for name, m in ms if name != ignored_name]

        def require(ms, name):
            head_name, _ = ms[0]
            if head_name != name:
                return self.fail(original_path)
            return True, ms[1:]

        def require_prefix(ms, prefix):
            head_name, _ = ms[0]
            if not head_name.startswith(prefix):
                return self.fail(original_path)
            return True, ms[1:]

        def allow(ms, name):
            head_name, _ = ms[0]
            if head_name == name:
                return True, ms[1:]
            return True, ms

        def allow_allof(ms, names):
            names = set(names)
            head_name, m = ms[0]
            while head_name in names:
                ms = ms[1:]
                names.remove(head_name)
                head_name, m = ms[0]
            return True, ms

        is_terminal = module.generated_proxy_backends
        if not is_terminal:
            return

        # we skip balancer2 inside sink or on_error
        for name, _ in original_path:
            if name == 'sink' or name == 'on_error':
                return

        path = ignore_all(path, 'stats_eater')

        ok, path = require(path, 'regexp_section')
        if not ok: return

        ok, path = allow(path, 'shared')
        if not ok: return

        ok, path = allow_allof(path, {'report', 'threshold', 'rewrite', 'pinger',
                                      'headers', 'response_headers', 'request_replier', 'antirobot_macro'})
        if not ok: return

        ok, path = require(path, 'balancer2')
        if not ok: return

        if path:
            ok, path = require_prefix(path, 'backend')
            if not ok: return

            ok, path = allow(path, 'report')
            if not ok: return

            ok, path = require(path, 'balancer2')
            if not ok: return
        self.ok = True

    def check_SlbPingMacro(self, module, path):
        id = self.full_id.id
        if id in ('slbping', 'slb_ping'):
            ns = to_names(path)
            if ns != ['regexp_section', 'slb_ping_macro']:
                self.fail(path)
                return
            self.ok = True

    def check_ErrorDocument(self, module, path):
        id = self.full_id.id
        if id in ('awacs-balancer-health-check',):
            ns = to_names(path)
            if ns != ['regexp_section', 'errordocument']:
                self.fail(path)
                return
            self.ok = True
