from awacs.wrappers.main import Balancer2, Regexp, Ipdispatch, PrefixPathRouter
from .model import BaseVisitor, UI_TAG


class UpstreamChecker(BaseVisitor):
    RULE = 'UNSAFE_OUTER_BALANCER2'

    TO_VISIT_BRANCHES_TYPES = (Balancer2, Regexp, Ipdispatch, PrefixPathRouter)

    def _check_branches_ends_by_balancer2(self, balancer2_module):
        """
        :type balancer2_module: Balancer2
        :rtype bool
        """
        modules = [list(b.walk_chain())[-1] for b in balancer2_module.backends]
        for m in modules:
            if isinstance(m, Balancer2):
                return True
            if not isinstance(m, self.TO_VISIT_BRANCHES_TYPES):
                continue
            for branch in m.get_branches():
                modules.append(list(branch.walk_chain())[-1])
        return False

    def check_Balancer2(self, module, path):
        assert isinstance(module, Balancer2)
        if not module.backends:
            return
        policy_kinds = module.balancing_policy and module.balancing_policy.list_policy_kinds() or set()
        uses_wm_policy = 'watermark_policy' in policy_kinds
        if not (module.attempts_rate_limiter or uses_wm_policy):
            return

        if self._check_branches_ends_by_balancer2(module):
            if module.attempts_rate_limiter:
                self.warn(path, 'Attempts rate limiter is configured in outer balancer2.',
                          tags={UI_TAG, 'unsafe-outer-balancer2'})
            elif uses_wm_policy:
                self.warn(path, 'Watermark policy is configured in outer balancer2.',
                          tags={UI_TAG, 'unsafe-outer-balancer2'})
