# coding: utf-8
import collections
import uuid


class Node(object):
    __slots__ = ('id', 'config_id', 'config', 'config_uuid', 'children')

    def __init__(self, config_id, config=None, id=None, config_uuid=None, children=None):
        self.id = id or str(uuid.uuid1())
        self.config = config
        self.config_id = config_id
        self.config_uuid = config_uuid
        self.children = children or ()

    def __repr__(self):
        return '{}({!r})'.format(self.config_id, self.children)

    def bfs(self):
        queue = collections.deque([self])
        while queue:
            curr_v = queue.popleft()
            do_not_visit = yield curr_v
            if do_not_visit:
                continue
            queue.extend(curr_v.children)

    def remove_subtrees(self, subtrees_to_remove):
        """
        :type subtrees_to_remove: set[str]
        :return:
        """
        self.children = [child for child in self.children if child.id not in subtrees_to_remove]
        for child in self.children:
            child.remove_subtrees(subtrees_to_remove)

    def clone(self):
        return Node(
            config_id=self.config_id,
            id=self.id,
            config=self.config,
            config_uuid=self.config_id,
            children=[child.clone() for child in self.children]
        )
