# coding: utf-8
import six
import yaml


from awacs.lib import OrderedDict


class AwacsYamlDumper(yaml.SafeDumper):
    pass


def _dict_representer(dumper, data):
    return dumper.represent_mapping(yaml.resolver.BaseResolver.DEFAULT_MAPPING_TAG, list(six.iteritems(data)))


AwacsYamlDumper.add_representer(OrderedDict, _dict_representer)


class FTag(yaml.YAMLObject):
    yaml_tag = '!f'

    def __init__(self, expr):
        self.expr = expr

    @classmethod
    def to_yaml(cls, dumper, data):
        return dumper.represent_scalar(cls.yaml_tag, data.expr)


AwacsYamlDumper.add_multi_representer(FTag, FTag.to_yaml)


class KTag(yaml.YAMLObject):
    yaml_tag = '!k'

    def __init__(self, expr):
        self.expr = expr

    @classmethod
    def to_yaml(cls, dumper, data):
        return dumper.represent_scalar(cls.yaml_tag, data.expr)


AwacsYamlDumper.add_multi_representer(KTag, KTag.to_yaml)


class CTag(yaml.YAMLObject):
    yaml_tag = '!c'

    def __init__(self, expr):
        self.expr = expr

    @classmethod
    def to_yaml(cls, dumper, data):
        return dumper.represent_scalar(cls.yaml_tag, data.expr)


AwacsYamlDumper.add_multi_representer(CTag, CTag.to_yaml)
