default_ciphers = "kEECDH+AESGCM+AES128:kEECDH+AES128:kEECDH+AESGCM+AES256:kRSA+AESGCM+AES128:kRSA+AES128:RC4-SHA:DES-CBC3-SHA:!aNULL:!eNULL:!MD5:!EXPORT:!LOW:!SEED:!CAMELLIA:!IDEA:!PSK:!SRP:!SSLv2"


default_ranges = "1ms,4ms,7ms,11ms,17ms,26ms,39ms,58ms,87ms,131ms,197ms,296ms,444ms,666ms,1000ms,1500ms,2250ms,3375ms,5062ms,7593ms,11390ms,17085ms,30000ms,60000ms,150000ms"


function _call_func_providers(overridable_func_names)
  for _, func_name in pairs(overridable_func_names) do
    local func_provider_path = _G[func_name .. "_provider"]
    if func_provider_path ~= nil then
      local env = {}
      setmetatable(env, {__index = _G})
      local provider, err = loadfile(func_provider_path, nil, env)
      if provider == nil then
        error(string.format('Failed to import provider "%s": %s', func_provider_path, err))
      end
      ok, rv = pcall(provider)
      if ok then
        if type(rv) ~= 'function' then
          error(string.format('Provider "%s" must return a function, not %s.', func_provider_path, type(rv)))
        end
        _G["do_" .. func_name] = rv
      else
        error(string.format('Provider "%s" failed: %s', func_provider_path, rv))
      end
    end
  end
end


function gen_proxy_backends(backends, proxy_options)
  local result = {}

  for index, backend in pairs(backends) do
    local proxy = {
      host = backend[1] or backend['host'];
      port = backend[2] or backend['port'];
      cached_ip = backend[4] or backend['cached_ip'];
    };

    if proxy_options ~= nil then
      for optname, optvalue in pairs(proxy_options) do
        proxy[optname] = optvalue
      end
    end

    result[index] = {
      weight = backend[3] or backend['weight'];
      proxy = proxy;
    };
  end

  if next(result) == nil then
    error("backends list is empty")
  end

  return result
end


function check_int(value, var_name)
    return tonumber(value) or error("Could not cast variable \"" .. var_name .. "\" to a number.'")
end

function get_int_var(name, default)
  value = _G[name]
  return value and check_int(value) or default
end


function get_log_path(name, port, default_log_dir)
  default_log_dir = default_log_dir or "/place/db/www/logs"
  rv = (log_dir or default_log_dir) .. "/current-" .. name .. "-balancer";
  if port ~= nil then
    rv = rv .. "-" .. port;
  end
  return rv
end


function get_port_var(name, offset, default)
  value = get_int_var(name, default)
  if value == nil then
    error("Neither port variable \"" .. name .. "\" nor default port is specified.")
  end
  if value < 0 or value > 65535 then
    error("Variable \"" .. name .. "\" is not a valid port: " .. value)
  end
  if offset ~= nil then
    value = value + offset
  end
  return value
end


function get_private_cert_path(name, default_private_cert_dir)
  default_private_cert_dir = default_private_cert_dir or "/dev/shm/balancer/priv"
  return (private_cert_dir or default_private_cert_dir) .. "/" .. name;
end


function get_public_cert_path(name, default_public_cert_dir)
  default_public_cert_dir = default_public_cert_dir or "/dev/shm/balancer"
  return (public_cert_dir or default_public_cert_dir) .. "/" .. name;
end


function get_random_timedelta(start, end_, unit)
  return math.random(start, end_) .. unit;
end


function get_str_var(name, default)
  return _G[name] or default
end


function do_get_workers()
  -- actual get_workers() implementation, can be overridden
  value = _G["workers"]
  if value == nil then
    error('Variable "workers" is not specified.')
  end
  int_value = tonumber(value)
  if int_value == nil then
    error('Could not cast variable "workers" to a number.')
  end
  return int_value
end


function get_workers()
  value = do_get_workers()
  if type(value) ~= 'number' then
    error(string.format('Provided get_workers() implementation must return a number, not %s.', type(value)))
  end
  if value < 0 or value % 1 ~= 0 then
    error(string.format('Provided get_workers() implementation must return a non-negative integer, not %s', value))
  end
  return value
end


function prefix_with_dc(name, default_dc, separator)
  dc = DC or default_dc or "unknown";
  separator = separator or "_";
  return dc .. separator .. name;
end


function suffix_with_dc(name, default_dc, separator)
  dc = DC or default_dc or "unknown";
  separator = separator or "_";
  return name .. separator .. dc;
end


_call_func_providers({
  "get_workers";
})


instance = {
  buffer = 65536;
  maxconn = 1000;
  tcp_fastopen = 0;
  pinger_required = true;
  workers = get_workers();
  enable_reuse_port = true;
  private_address = "127.0.0.10";
  default_tcp_rst_on_error = true;
  events = {
    stats = "report";
  }; -- events
  state_directory = "/dev/shm/balancer-state";
  dns_ttl = get_random_timedelta(600, 900, "s");
  reset_dns_cache_file = "./controls/reset_dns_cache_file";
  log = get_log_path("childs_log", get_port_var("port"), "/place/db/www/logs");
  pinger_log = get_log_path("pinger_log", get_port_var("port"), "/place/db/www/logs/");
  dynamic_balancing_log = get_log_path("dynamic_balancing_log", get_port_var("port"), "/place/db/www/logs/");
  admin_addrs = {
    {
      ip = "127.0.0.1";
      port = get_port_var("port");
    };
    {
      ip = "::1";
      port = get_port_var("port");
    };
  }; -- admin_addrs
  cpu_limiter = {
    active_check_subnet_default = true;
    disable_file = "./controls/cpu_limiter_disabled";
    active_check_subnet_file = "./controls/active_check_subnets_list";
  }; -- cpu_limiter
  addrs = {
    {
      ip = "127.0.0.4";
      port = get_port_var("port");
    };
    {
      ip = "*";
      port = 80;
      disabled = get_int_var("disable_external", 0);
    };
    {
      ip = "*";
      port = get_port_var("port");
      disabled = get_int_var("disable_external", 0);
    };
    {
      ip = "*";
      port = 443;
      disabled = get_int_var("disable_external", 0);
    };
  }; -- addrs
  ipdispatch = {
    admin = {
      ips = {
        "127.0.0.1";
        "::1";
      }; -- ips
      ports = {
        get_port_var("port");
      }; -- ports
      http = {
        maxlen = 65536;
        maxreq = 65536;
        keepalive = true;
        no_keepalive_file = "./controls/keepalive_disabled";
        events = {
          stats = "report";
        }; -- events
        admin = {};
      }; -- http
    }; -- admin
    stats_storage = {
      ips = {
        "127.0.0.4";
      }; -- ips
      ports = {
        get_port_var("port");
      }; -- ports
      report = {
        uuid = "service_total";
        ranges = get_str_var("default_ranges");
        matcher_map = {
          molly = {
            match_fsm = {
              cgi = ".*everybodybecoolthisis=(crasher|molly).*";
              case_insensitive = true;
              surround = false;
            }; -- match_fsm
          }; -- molly
        }; -- matcher_map
        just_storage = true;
        disable_robotness = true;
        disable_sslness = true;
        events = {
          stats = "report";
        }; -- events
        http = {
          maxlen = 65536;
          maxreq = 65536;
          keepalive = true;
          no_keepalive_file = "./controls/keepalive_disabled";
          events = {
            stats = "report";
          }; -- events
          errordocument = {
            status = 204;
            force_conn_close = false;
          }; -- errordocument
        }; -- http
      }; -- report
    }; -- stats_storage
    http_section = {
      ips = {
        "*";
      }; -- ips
      ports = {
        80;
      }; -- ports
      errorlog = {
        log_level = "ERROR";
        log = get_log_path("error_log", 80, "/place/db/www/logs");
        http = {
          maxlen = 512768;
          maxreq = 512768;
          keepalive = true;
          no_keepalive_file = "./controls/keepalive_disabled";
          events = {
            stats = "report";
          }; -- events
          accesslog = {
            log = get_log_path("access_log", 80, "/place/db/www/logs");
            report = {
              uuid = "http";
              refers = "service_total";
              ranges = get_str_var("default_ranges");
              matcher_map = {
                molly = {
                  match_fsm = {
                    cgi = ".*everybodybecoolthisis=(crasher|molly).*";
                    case_insensitive = true;
                    surround = false;
                  }; -- match_fsm
                }; -- molly
              }; -- matcher_map
              just_storage = false;
              disable_robotness = true;
              disable_sslness = true;
              events = {
                stats = "report";
              }; -- events
              shared = {
                uuid = "6083265438936535885";
                rewrite = {
                  actions = {
                    {
                      global = true;
                      regexp = "/+";
                      rewrite = "/";
                      split = "path";
                      literal = false;
                      case_insensitive = false;
                    };
                  }; -- actions
                  headers = {
                    create_func = {
                      ["X-Start-Time"] = "starttime";
                    }; -- create_func
                    create = {
                      ["Start-Time"] = "1";
                    }; -- create
                    headers = {
                      create_func_weak = {
                        ["X-Start-Time"] = "starttime";
                      }; -- create_func_weak
                      create_weak = {
                        ["Start-Time"] = "1";
                      }; -- create_weak
                      headers = {
                        copy = {
                          ["X-Start-Time"] = "X-Forwarded-For-Y";
                        }; -- copy
                        headers = {
                          copy_weak = {
                            ["X-Start-Time"] = "X-Forwarded-For-Y";
                          }; -- copy_weak
                          headers = {
                            append_func = {
                              ["X-Source-Port-Y"] = "realport";
                            }; -- append_func
                            headers = {
                              append_func_weak = {
                                ["X-Source-Port-Y"] = "realport";
                              }; -- append_func_weak
                              log_headers = {
                                name_re = "\\w+";
                                headers = {
                                  delete = ".*";
                                  response_headers = {
                                    delete = ".*";
                                    response_headers = {
                                      append_func_weak = {
                                        ["X-Source-Port-Y"] = "realport";
                                      }; -- append_func_weak
                                      response_headers = {
                                        append_func = {
                                          ["X-Source-Port-Y"] = "realport";
                                        }; -- append_func
                                        response_headers = {
                                          copy_weak = {
                                            ["X-Start-Time"] = "X-Forwarded-For-Y";
                                          }; -- copy_weak
                                          response_headers = {
                                            copy = {
                                              ["X-Start-Time"] = "X-Forwarded-For-Y";
                                            }; -- copy
                                            log_headers = {
                                              cookie_fields = "C";
                                              response_name_re = "X-.*";
                                              log_headers = {
                                                cookie_fields = "A,B";
                                                response_name_re = ".*";
                                                response_headers = {
                                                  create_func_weak = {
                                                    ["X-Start-Time"] = "starttime";
                                                  }; -- create_func_weak
                                                  response_headers = {
                                                    create_func = {
                                                      ["X-Start-Time"] = "starttime";
                                                    }; -- create_func
                                                    regexp = {
                                                      configsearch = {
                                                        priority = 3;
                                                        match_fsm = {
                                                          URI = "/touchsearch(/.*)?";
                                                          case_insensitive = true;
                                                          surround = false;
                                                        }; -- match_fsm
                                                        report = {
                                                          uuid = "uuid1";
                                                          refers = "uuid2";
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          hasher = {
                                                            mode = "subnet";
                                                            take_ip_from = "X-Real-IP";
                                                            h100 = {
                                                              cutter = {
                                                                bytes = 512;
                                                                timeout = "0.1s";
                                                                antirobot = {
                                                                  cut_request = true;
                                                                  no_cut_request_file = "./controls/no_cut_request_file";
                                                                  file_switch = "./controls/touchsearch_disable_antirobot_module";
                                                                  cut_request_bytes = 512;
                                                                  checker = {
                                                                    report = {
                                                                      uuid = "antirobot";
                                                                      ranges = get_str_var("default_ranges");
                                                                      just_storage = false;
                                                                      disable_robotness = true;
                                                                      disable_sslness = true;
                                                                      events = {
                                                                        stats = "report";
                                                                      }; -- events
                                                                      stats_eater = {
                                                                        balancer2 = {
                                                                          unique_policy = {};
                                                                          attempts = 2;
                                                                          hashing = {
                                                                            unpack(gen_proxy_backends({
                                                                              { "antirobot.man.yandex.ru"; 80; 1.000; "2a02:6b8::4"; };
                                                                            }, {
                                                                              resolve_timeout = "10ms";
                                                                              connect_timeout = "30ms";
                                                                              backend_timeout = "100ms";
                                                                              fail_on_5xx = true;
                                                                              http_backend = true;
                                                                              buffering = false;
                                                                              keepalive_count = 0;
                                                                              need_resolve = true;
                                                                            }))
                                                                          }; -- hashing
                                                                        }; -- balancer2
                                                                      }; -- stats_eater
                                                                    }; -- report
                                                                  }; -- checker
                                                                  module = {
                                                                    stats_eater = {
                                                                      balancer2 = {
                                                                        unique_policy = {};
                                                                        attempts = 2;
                                                                        fast_attempts = 1;
                                                                        fast_503 = true;
                                                                        weighted2 = {
                                                                          slow_reply_time = "1s";
                                                                          correction_params = {
                                                                            max_weight = 5.000;
                                                                            min_weight = 0.050;
                                                                            history_time = "100s";
                                                                            feedback_time = "300s";
                                                                            plus_diff_per_sec = 0.050;
                                                                            minus_diff_per_sec = 0.100;
                                                                          }; -- correction_params
                                                                          unpack(gen_proxy_backends({
                                                                            { "mobile_heroism.yandex.ru"; 80; 1.000; "2a02:6b8::3"; };
                                                                          }, {
                                                                            resolve_timeout = "10ms";
                                                                            connect_timeout = "10ms";
                                                                            backend_timeout = "1s";
                                                                            fail_on_5xx = true;
                                                                            http_backend = true;
                                                                            buffering = false;
                                                                            keepalive_count = 0;
                                                                            need_resolve = true;
                                                                          }))
                                                                        }; -- weighted2
                                                                        on_error = {
                                                                          errordocument = {
                                                                            status = 504;
                                                                            force_conn_close = false;
                                                                          }; -- errordocument
                                                                        }; -- on_error
                                                                      }; -- balancer2
                                                                    }; -- stats_eater
                                                                  }; -- module
                                                                }; -- antirobot
                                                              }; -- cutter
                                                            }; -- h100
                                                          }; -- hasher
                                                        }; -- report
                                                      }; -- configsearch
                                                      jsonproxy = {
                                                        priority = 2;
                                                        match_fsm = {
                                                          URI = "/((m)?search/)?jsonproxy(/.*)?";
                                                          case_insensitive = true;
                                                          surround = false;
                                                        }; -- match_fsm
                                                        report = {
                                                          uuid = "uuid2";
                                                          ranges = get_str_var("default_ranges");
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          report = {
                                                            refers = "uuid2,uuid1";
                                                            ranges = get_str_var("default_ranges");
                                                            just_storage = false;
                                                            disable_robotness = true;
                                                            disable_sslness = true;
                                                            events = {
                                                              stats = "report";
                                                            }; -- events
                                                            hasher = {
                                                              mode = "subnet";
                                                              take_ip_from = "X-Real-IP";
                                                              h100 = {
                                                                cutter = {
                                                                  bytes = 512;
                                                                  timeout = "0.1s";
                                                                  headers = {
                                                                    create = {
                                                                      ["X-Antirobot-Req-Group"] = "some-req-group";
                                                                      ["X-Antirobot-Service-Y"] = "jsonproxy";
                                                                    }; -- create
                                                                    antirobot = {
                                                                      cut_request = true;
                                                                      no_cut_request_file = "./controls/no_cut_request_file";
                                                                      file_switch = "./controls/disable_antirobot_module";
                                                                      cut_request_bytes = 512;
                                                                      checker = {
                                                                        report = {
                                                                          ranges = get_str_var("default_ranges");
                                                                          just_storage = false;
                                                                          disable_robotness = true;
                                                                          disable_sslness = true;
                                                                          events = {
                                                                            stats = "report";
                                                                          }; -- events
                                                                          stats_eater = {
                                                                            balancer2 = {
                                                                              unique_policy = {};
                                                                              attempts = 2;
                                                                              hashing = {
                                                                                unpack(gen_proxy_backends({
                                                                                  { "antirobot_iss_prestable.yandex.ru"; 80; 1.000; "2a02:6b8::5"; };
                                                                                }, {
                                                                                  resolve_timeout = "10ms";
                                                                                  connect_timeout = "30ms";
                                                                                  backend_timeout = "100ms";
                                                                                  fail_on_5xx = true;
                                                                                  http_backend = true;
                                                                                  buffering = false;
                                                                                  keepalive_count = 0;
                                                                                  need_resolve = true;
                                                                                }))
                                                                              }; -- hashing
                                                                            }; -- balancer2
                                                                          }; -- stats_eater
                                                                          refers = "antirobot";
                                                                        }; -- report
                                                                      }; -- checker
                                                                      module = {
                                                                        rewrite = {
                                                                          actions = {
                                                                            {
                                                                              global = false;
                                                                              literal = false;
                                                                              rewrite = "/%2";
                                                                              case_insensitive = false;
                                                                              regexp = "/(m)?search/(.*)";
                                                                            };
                                                                          }; -- actions
                                                                          stats_eater = {
                                                                            cachalot = {
                                                                              collection = "abc";
                                                                              cacher = {
                                                                                errordocument = {
                                                                                  status = 200;
                                                                                  force_conn_close = false;
                                                                                }; -- errordocument
                                                                              }; -- cacher
                                                                              srcrwr_ext = {
                                                                                remove_prefix = "m";
                                                                                domains = "yp-c.yandex.net";
                                                                                balancer2 = {
                                                                                  timeout_policy = {
                                                                                    timeout = "1s";
                                                                                    by_name_policy = {
                                                                                      name = "xxx";
                                                                                      allow_zero_weights = true;
                                                                                      strict = true;
                                                                                      unique_policy = {};
                                                                                    }; -- by_name_policy
                                                                                  }; -- timeout_policy
                                                                                  attempts = 2;
                                                                                  weighted2 = {
                                                                                    slow_reply_time = "1s";
                                                                                    correction_params = {
                                                                                      max_weight = 5.000;
                                                                                      min_weight = 0.050;
                                                                                      history_time = "100s";
                                                                                      feedback_time = "300s";
                                                                                      plus_diff_per_sec = 0.050;
                                                                                      minus_diff_per_sec = 0.100;
                                                                                    }; -- correction_params
                                                                                    unpack(gen_proxy_backends({
                                                                                      { "mobile_heroism.yandex.ru"; 80; 1.000; "2a02:6b8::3"; };
                                                                                    }, {
                                                                                      resolve_timeout = "10ms";
                                                                                      connect_timeout = "150ms";
                                                                                      backend_timeout = "5s";
                                                                                      fail_on_5xx = true;
                                                                                      http_backend = true;
                                                                                      buffering = false;
                                                                                      keepalive_count = 0;
                                                                                      need_resolve = true;
                                                                                      switched_backend_timeout = "123ms";
                                                                                      backend_read_timeout = "10s";
                                                                                      client_read_timeout = "8s";
                                                                                      backend_write_timeout = "12s";
                                                                                      client_write_timeout = "18s";
                                                                                    }))
                                                                                  }; -- weighted2
                                                                                  on_error = {
                                                                                    errordocument = {
                                                                                      status = 504;
                                                                                      force_conn_close = false;
                                                                                    }; -- errordocument
                                                                                  }; -- on_error
                                                                                }; -- balancer2
                                                                              }; -- srcrwr_ext
                                                                            }; -- cachalot
                                                                          }; -- stats_eater
                                                                        }; -- rewrite
                                                                      }; -- module
                                                                    }; -- antirobot
                                                                  }; -- headers
                                                                }; -- cutter
                                                              }; -- h100
                                                            }; -- hasher
                                                          }; -- report
                                                        }; -- report
                                                      }; -- jsonproxy
                                                      by_name_policy_func = {
                                                        priority = 1;
                                                        match_fsm = {
                                                          URI = "/bnp";
                                                          case_insensitive = true;
                                                          surround = false;
                                                        }; -- match_fsm
                                                        balancer2 = {
                                                          by_name_policy = {
                                                            name = suffix_with_dc("bnp");
                                                            unique_policy = {};
                                                          }; -- by_name_policy
                                                          attempts = 1;
                                                          rr = {
                                                            [prefix_with_dc("bnp", "", "")] = {
                                                              weight = 1.000;
                                                              errordocument = {
                                                                status = 200;
                                                                force_conn_close = false;
                                                                content = "by_name_policy in man";
                                                              }; -- errordocument
                                                            }; -- [prefix_with_dc("bnp", "", "")]
                                                            [prefix_with_dc("bnp", "test")] = {
                                                              weight = 1.000;
                                                              errordocument = {
                                                                status = 200;
                                                                force_conn_close = false;
                                                                content = "by_name_policy in sas";
                                                              }; -- errordocument
                                                            }; -- [prefix_with_dc("bnp", "test")]
                                                          }; -- rr
                                                          on_error = {
                                                            errordocument = {
                                                              status = 504;
                                                              force_conn_close = false;
                                                            }; -- errordocument
                                                          }; -- on_error
                                                        }; -- balancer2
                                                      }; -- by_name_policy_func
                                                    }; -- regexp
                                                  }; -- response_headers
                                                }; -- response_headers
                                              }; -- log_headers
                                            }; -- log_headers
                                          }; -- response_headers
                                        }; -- response_headers
                                      }; -- response_headers
                                    }; -- response_headers
                                  }; -- response_headers
                                }; -- headers
                              }; -- log_headers
                            }; -- headers
                          }; -- headers
                        }; -- headers
                      }; -- headers
                    }; -- headers
                  }; -- headers
                }; -- rewrite
              }; -- shared
            }; -- report
          }; -- accesslog
        }; -- http
      }; -- errorlog
    }; -- http_section
    https_section = {
      ips = {
        "*";
      }; -- ips
      ports = {
        get_port_var("port");
        443;
      }; -- ports
      errorlog = {
        log_level = "ERROR";
        log = get_log_path("error_log", get_port_var("port"), "/place/db/www/logs");
        ssl_sni = {
          force_ssl = true;
          events = {
            stats = "report";
            reload_ocsp_response = "reload_ocsp";
            reload_ticket_keys = "reload_ticket";
          }; -- events
          ja3_enabled = true;
          contexts = {
            default = {
              priority = 1;
              timeout = "100800s";
              disable_sslv3 = true;
              ciphers = get_str_var("default_ciphers");
              log = get_log_path("ssl_sni", get_port_var("port"), "/place/db/www/logs");
              priv = get_private_cert_path("adm-nanny.yandex-team.ru.pem", "/dev/shm/balancer/priv");
              cert = get_public_cert_path("allCAs-adm-nanny.yandex-team.ru.pem", "/dev/shm/balancer");
              ticket_keys_list = {
                {
                  priority = 3;
                  keyfile = get_private_cert_path("1st.adm-nanny.yandex-team.ru.key", "/dev/shm/balancer/priv");
                };
                {
                  priority = 2;
                  keyfile = get_private_cert_path("2nd.adm-nanny.yandex-team.ru.key", "/dev/shm/balancer/priv");
                };
                {
                  priority = 1;
                  keyfile = get_private_cert_path("3rd.adm-nanny.yandex-team.ru.key", "/dev/shm/balancer/priv");
                };
              }; -- ticket_keys_list
            }; -- default
          }; -- contexts
          http = {
            maxlen = 512768;
            maxreq = 512768;
            keepalive = true;
            no_keepalive_file = "./controls/keepalive_disabled";
            events = {
              stats = "report";
            }; -- events
            accesslog = {
              log = get_log_path("access_log", get_port_var("port"), "/place/db/www/logs");
              report = {
                uuid = "https";
                refers = "service_total";
                ranges = get_str_var("default_ranges");
                matcher_map = {
                  molly = {
                    match_fsm = {
                      cgi = ".*everybodybecoolthisis=(crasher|molly).*";
                      case_insensitive = true;
                      surround = false;
                    }; -- match_fsm
                  }; -- molly
                }; -- matcher_map
                just_storage = false;
                disable_robotness = true;
                disable_sslness = true;
                events = {
                  stats = "report";
                }; -- events
                shared = {
                  uuid = "6083265438936535885";
                }; -- shared
              }; -- report
            }; -- accesslog
          }; -- http
        }; -- ssl_sni
      }; -- errorlog
    }; -- https_section
  }; -- ipdispatch
}