default_ciphers = "kEECDH+AESGCM+AES128:kEECDH+AES128:kEECDH+AESGCM+AES256:kRSA+AESGCM+AES128:kRSA+AES128:RC4-SHA:DES-CBC3-SHA:!aNULL:!eNULL:!MD5:!EXPORT:!LOW:!SEED:!CAMELLIA:!IDEA:!PSK:!SRP:!SSLv2"


default_ciphers_ecdsa = "ECDHE-ECDSA-AES128-GCM-SHA256:kEECDH+AESGCM+AES128:kEECDH+AES128:kEECDH+AESGCM+AES256:kRSA+AESGCM+AES128:kRSA+AES128:RC4-SHA:DES-CBC3-SHA:!aNULL:!eNULL:!MD5:!EXPORT:!LOW:!SEED:!CAMELLIA:!IDEA:!PSK:!SRP:!SSLv2"


default_ranges = "1ms,4ms,7ms,11ms,17ms,26ms,39ms,58ms,87ms,131ms,197ms,296ms,444ms,666ms,1000ms,1500ms,2250ms,3375ms,5062ms,7593ms,11390ms,17085ms,30000ms,60000ms,150000ms"


function _call_func_providers(overridable_func_names)
  for _, func_name in pairs(overridable_func_names) do
    local func_provider_path = _G[func_name .. "_provider"]
    if func_provider_path ~= nil then
      local env = {}
      setmetatable(env, {__index = _G})
      local provider, err = loadfile(func_provider_path, nil, env)
      if provider == nil then
        error(string.format('Failed to import provider "%s": %s', func_provider_path, err))
      end
      ok, rv = pcall(provider)
      if ok then
        if type(rv) ~= 'function' then
          error(string.format('Provider "%s" must return a function, not %s.', func_provider_path, type(rv)))
        end
        _G["do_" .. func_name] = rv
      else
        error(string.format('Provider "%s" failed: %s', func_provider_path, rv))
      end
    end
  end
end


function gen_proxy_backends(backends, proxy_options)
  local result = {}

  for index, backend in pairs(backends) do
    local proxy = {
      host = backend[1] or backend['host'];
      port = backend[2] or backend['port'];
      cached_ip = backend[4] or backend['cached_ip'];
    };

    if proxy_options ~= nil then
      for optname, optvalue in pairs(proxy_options) do
        proxy[optname] = optvalue
      end
    end

    result[index] = {
      weight = backend[3] or backend['weight'];
      proxy = proxy;
    };
  end

  if next(result) == nil then
    error("backends list is empty")
  end

  return result
end


function check_int(value, var_name)
    return tonumber(value) or error("Could not cast variable \"" .. var_name .. "\" to a number.'")
end

function get_int_var(name, default)
  value = _G[name]
  return value and check_int(value) or default
end


function get_log_path(name, port, default_log_dir)
  default_log_dir = default_log_dir or "/place/db/www/logs"
  rv = (log_dir or default_log_dir) .. "/current-" .. name .. "-balancer";
  if port ~= nil then
    rv = rv .. "-" .. port;
  end
  return rv
end


function get_port_var(name, offset, default)
  value = get_int_var(name, default)
  if value == nil then
    error("Neither port variable \"" .. name .. "\" nor default port is specified.")
  end
  if value < 0 or value > 65535 then
    error("Variable \"" .. name .. "\" is not a valid port: " .. value)
  end
  if offset ~= nil then
    value = value + offset
  end
  return value
end


function get_private_cert_path(name, default_private_cert_dir)
  default_private_cert_dir = default_private_cert_dir or "/dev/shm/balancer/priv"
  return (private_cert_dir or default_private_cert_dir) .. "/" .. name;
end


function get_public_cert_path(name, default_public_cert_dir)
  default_public_cert_dir = default_public_cert_dir or "/dev/shm/balancer"
  return (public_cert_dir or default_public_cert_dir) .. "/" .. name;
end


function get_random_timedelta(start, end_, unit)
  return math.random(start, end_) .. unit;
end


function get_str_env_var(name, default)
  rv = os.getenv(name)
  if rv == nil then
    if default == nil then
      error(string.format('Environment variable "%s" is not set.', name))
    else
      return default
    end
  else
    return rv
  end
end


function get_str_var(name, default)
  return _G[name] or default
end


function do_get_workers()
  -- actual get_workers() implementation, can be overridden
  value = _G["workers"]
  if value == nil then
    error('Variable "workers" is not specified.')
  end
  int_value = tonumber(value)
  if int_value == nil then
    error('Could not cast variable "workers" to a number.')
  end
  return int_value
end


function get_workers()
  value = do_get_workers()
  if type(value) ~= 'number' then
    error(string.format('Provided get_workers() implementation must return a number, not %s.', type(value)))
  end
  if value < 0 or value % 1 ~= 0 then
    error(string.format('Provided get_workers() implementation must return a non-negative integer, not %s', value))
  end
  return value
end


_call_func_providers({
  "get_workers";
})


instance = {
  buffer = 65536;
  maxconn = 20000;
  tcp_fastopen = 0;
  workers = get_workers();
  enable_reuse_port = true;
  tcp_listen_queue = 32768;
  private_address = "127.0.0.10";
  default_tcp_rst_on_error = true;
  events = {
    stats = "report";
  }; -- events
  dns_ttl = get_random_timedelta(600, 900, "s");
  reset_dns_cache_file = "./controls/reset_dns_cache_file";
  log = get_log_path("childs_log", get_port_var("port"), "/place/db/www/logs");
  admin_addrs = {
    {
      ip = "127.0.0.1";
      port = get_port_var("port");
    };
    {
      ip = "::1";
      port = get_port_var("port");
    };
  }; -- admin_addrs
  unistat = {
    addrs = {
      {
        ip = "*";
        port = get_port_var("port", 2);
        disabled = get_int_var("disable_external", 0);
      };
    }; -- addrs
    hide_legacy_signals = true;
  }; -- unistat
  sd = {
    client_name = "awacs-l7-balancer(betastatic.yastatic.net:betastatic.yastatic.net_iva)";
    host = "sd.yandex.net";
    port = 8080;
    connect_timeout = "50ms";
    request_timeout = "1s";
    cache_dir = "./sd_cache";
  }; -- sd
  addrs = {
    {
      ip = "*";
      port = 80;
      disabled = get_int_var("disable_external", 0);
    };
    {
      ip = "*";
      port = get_port_var("port");
      disabled = get_int_var("disable_external", 0);
    };
    {
      ip = "*";
      port = 443;
      disabled = get_int_var("disable_external", 0);
    };
    {
      ip = "*";
      port = get_port_var("port", 1);
      disabled = get_int_var("disable_external", 0);
    };
  }; -- addrs
  ipdispatch = {
    admin = {
      ips = {
        "127.0.0.1";
        "::1";
      }; -- ips
      ports = {
        get_port_var("port");
      }; -- ports
      http = {
        maxlen = 65536;
        maxreq = 65536;
        keepalive = true;
        no_keepalive_file = "./controls/keepalive_disabled";
        events = {
          stats = "report";
        }; -- events
        admin = {
          disable_xml_stats = true;
        }; -- admin
      }; -- http
    }; -- admin
    http_section = {
      ips = {
        "*";
      }; -- ips
      ports = {
        80;
        get_port_var("port");
      }; -- ports
      errorlog = {
        log_level = "ERROR";
        log = get_log_path("error_log", 80, "/place/db/www/logs");
        http = {
          maxlen = 65536;
          maxreq = 65536;
          keepalive = true;
          no_keepalive_file = "./controls/keepalive_disabled";
          events = {
            stats = "report";
          }; -- events
          accesslog = {
            log = get_log_path("access_log", 80, "/place/db/www/logs");
            report = {
              uuid = "service_total";
              ranges = get_str_var("default_ranges");
              just_storage = false;
              disable_robotness = true;
              disable_sslness = true;
              events = {
                stats = "report";
              }; -- events
              regexp = {
                options_methods = {
                  priority = 2;
                  match_method = {
                    methods = { "options"; };
                  }; -- match_method
                  shared = {
                    uuid = "8582412272410535953";
                    shared = {
                      uuid = "options_verb_section";
                    }; -- shared
                  }; -- shared
                }; -- options_methods
                default = {
                  priority = 1;
                  shared = {
                    uuid = "shared_http";
                    regexp = {
                      everybodybecoolthisis = {
                        priority = 2;
                        match_and = {
                          {
                            match_fsm = {
                              cgi = ".*everybodybecoolthisis.*";
                              case_insensitive = true;
                              surround = false;
                            }; -- match_fsm
                          };
                        }; -- match_and
                        report = {
                          uuid = "everybodybecoolthisis";
                          ranges = get_str_var("default_ranges");
                          just_storage = false;
                          disable_robotness = true;
                          disable_sslness = true;
                          events = {
                            stats = "report";
                          }; -- events
                          shared = {
                            uuid = "shared_http_secondpart";
                          }; -- shared
                        }; -- report
                      }; -- everybodybecoolthisis
                      default = {
                        priority = 1;
                        shared = {
                          uuid = "shared_http_secondpart";
                          headers = {
                            create_func_weak = {
                              ["X-Forwarded-Proto"] = "scheme";
                              ["X-Yandex-Http-Version"] = "proto";
                            }; -- create_func_weak
                            create = {
                              ["X-Yandex-L7"] = "yes";
                            }; -- create
                            log_headers = {
                              name_re = "X-Forwarded-For|Accept-Encoding|X-Request-Id|User-Agent|Cache-Control|Pragma";
                              response_name_re = "ETag|X-Nginx-Request-Id|Content-Encoding|Cache-Control";
                              response_headers_if = {
                                matcher = {
                                  match_not = {
                                    match_response_codes = {
                                      codes = { 200; 204; 206; 301; 302; 304; };
                                    }; -- match_response_codes
                                  }; -- match_not
                                }; -- matcher
                                delete_header = "service-worker-allowed|content-encoding|vary|cache-control|access-control-allow-origin|timing-allow-origin|strict-transport-security|expires";
                                response_headers = {
                                  delete = "valid-until|x-amz-id-2|x-amz-request-id|x-amz-meta-server-side-encryption|x-amz-server-side-encryption|x-amz-meta-s3cmd-attrs|Set-Cookie|X-Amz-Expiration";
                                  create = {
                                    Connection = "keep-alive";
                                    ["Keep-Alive"] = "timeout=600";
                                    Vary = "Accept-Encoding";
                                  }; -- create
                                  rewrite = {
                                    actions = {
                                      {
                                        global = false;
                                        literal = false;
                                        case_insensitive = false;
                                        rewrite = "/slovari-ng/%1";
                                        regexp = "/v-[^/a-zA-Z]+/slovari-ng/(.*)";
                                      };
                                      {
                                        global = false;
                                        literal = false;
                                        case_insensitive = false;
                                        rewrite = "/android-mail/feedback/%1";
                                        regexp = "/android-mail%2Ffeedback%2F(.*)";
                                      };
                                      {
                                        global = false;
                                        literal = false;
                                        rewrite = "/%2";
                                        regexp = "/([/]+)(.*)";
                                        case_insensitive = false;
                                      };
                                      {
                                        global = false;
                                        literal = false;
                                        case_insensitive = false;
                                        rewrite = "/crossdomain-xml/%1";
                                        regexp = "^/(crossdomain.xml)(\\?.*)?$";
                                      };
                                    }; -- actions
                                    rewrite = {
                                      actions = {
                                        {
                                          global = false;
                                          literal = false;
                                          case_insensitive = false;
                                          rewrite = "/encyc/articles_ng/%2";
                                          regexp = "^/encyc/articles_ng/(articles_ng/)+(.*)$";
                                        };
                                        {
                                          global = false;
                                          literal = false;
                                          case_insensitive = false;
                                          regexp = "^/encyc/articles_ng/pharma/(.*)$";
                                          rewrite = "/encyc/articles_generated/pharma/%1";
                                        };
                                      }; -- actions
                                      rewrite = {
                                        actions = {
                                          {
                                            global = false;
                                            rewrite = "%1";
                                            literal = false;
                                            regexp = "(.*):443";
                                            header_name = "Host";
                                            case_insensitive = false;
                                          };
                                          {
                                            global = false;
                                            rewrite = "%1";
                                            literal = false;
                                            regexp = "(.*):80";
                                            header_name = "Host";
                                            case_insensitive = false;
                                          };
                                        }; -- actions
                                        regexp = {
                                          from_cdn = {
                                            priority = 2;
                                            match_fsm = {
                                              header = {
                                                name = "X-Cdn-Location";
                                                value = "(.*)";
                                              }; -- header
                                              case_insensitive = true;
                                              surround = false;
                                            }; -- match_fsm
                                            headers = {
                                              copy = {
                                                ["X-Real-Ip"] = "X-Forwarded-For";
                                              }; -- copy
                                              shared = {
                                                uuid = "shared_cdn";
                                                regexp = {
                                                  weather_y5_lego_yandex_net = {
                                                    priority = 16;
                                                    match_fsm = {
                                                      header = {
                                                        name = "Host";
                                                        value = "(weather|y5|lego|img|js|i|video|kraski|blogs|ask|tv|perevod|jslibs)\\.static\\.yandex\\.net";
                                                      }; -- header
                                                      case_insensitive = true;
                                                      surround = false;
                                                    }; -- match_fsm
                                                    regexp = {
                                                      lego_static_yandex_net = {
                                                        priority = 4;
                                                        match_fsm = {
                                                          header = {
                                                            name = "Host";
                                                            value = "lego\\.static\\.yandex\\.net";
                                                          }; -- header
                                                          case_insensitive = true;
                                                          surround = false;
                                                        }; -- match_fsm
                                                        rewrite = {
                                                          actions = {
                                                            {
                                                              global = false;
                                                              literal = false;
                                                              regexp = "/(.*)";
                                                              rewrite = "/lego/%1";
                                                              case_insensitive = false;
                                                            };
                                                          }; -- actions
                                                          shared = {
                                                            uuid = "8041589589394459901";
                                                            shared = {
                                                              uuid = "weather_y5_lego_yandex_net_shared";
                                                            }; -- shared
                                                          }; -- shared
                                                        }; -- rewrite
                                                      }; -- lego_static_yandex_net
                                                      ljslibs_static_yandex_net = {
                                                        priority = 3;
                                                        match_fsm = {
                                                          header = {
                                                            name = "Host";
                                                            value = "ljslibs\\.static\\.yandex\\.net";
                                                          }; -- header
                                                          case_insensitive = true;
                                                          surround = false;
                                                        }; -- match_fsm
                                                        rewrite = {
                                                          actions = {
                                                            {
                                                              global = false;
                                                              literal = false;
                                                              regexp = "/(.*)";
                                                              rewrite = "/jslibs/%1";
                                                              case_insensitive = false;
                                                            };
                                                          }; -- actions
                                                          shared = {
                                                            uuid = "8041589589394459901";
                                                          }; -- shared
                                                        }; -- rewrite
                                                      }; -- ljslibs_static_yandex_net
                                                      js_static_yandex_net = {
                                                        priority = 2;
                                                        match_fsm = {
                                                          header = {
                                                            name = "Host";
                                                            value = "js\\.static\\.yandex\\.net";
                                                          }; -- header
                                                          case_insensitive = true;
                                                          surround = false;
                                                        }; -- match_fsm
                                                        rewrite = {
                                                          actions = {
                                                            {
                                                              global = false;
                                                              literal = false;
                                                              regexp = "/(.*)";
                                                              rewrite = "/js/%1";
                                                              case_insensitive = false;
                                                            };
                                                          }; -- actions
                                                          shared = {
                                                            uuid = "8041589589394459901";
                                                          }; -- shared
                                                        }; -- rewrite
                                                      }; -- js_static_yandex_net
                                                      default = {
                                                        priority = 1;
                                                        shared = {
                                                          uuid = "weather_y5_lego_yandex_net_shared";
                                                          regexp_path = {
                                                            all_root_redir = {
                                                              priority = 13;
                                                              pattern = "(/)?";
                                                              case_insensitive = true;
                                                              shared = {
                                                                uuid = "4050231810825788227";
                                                              }; -- shared
                                                            }; -- all_root_redir
                                                            all_errors_table = {
                                                              priority = 12;
                                                              pattern = "/errors_table/(.*)";
                                                              case_insensitive = true;
                                                              shared = {
                                                                uuid = "8384648238129770771";
                                                              }; -- shared
                                                            }; -- all_errors_table
                                                            all_favicon_ico = {
                                                              priority = 11;
                                                              pattern = "/favicon.ico(.*)";
                                                              case_insensitive = true;
                                                              shared = {
                                                                uuid = "264806882395022933";
                                                              }; -- shared
                                                            }; -- all_favicon_ico
                                                            all_google_verification = {
                                                              priority = 10;
                                                              pattern = "/google(.*)";
                                                              case_insensitive = true;
                                                              shared = {
                                                                uuid = "758824134262716168";
                                                              }; -- shared
                                                            }; -- all_google_verification
                                                            all_nearest_js = {
                                                              priority = 9;
                                                              pattern = "/nearest.js(.*)";
                                                              case_insensitive = true;
                                                              shared = {
                                                                uuid = "2837673959647856177";
                                                              }; -- shared
                                                            }; -- all_nearest_js
                                                            ["all_robots-txt"] = {
                                                              priority = 8;
                                                              pattern = "/robots.txt.*";
                                                              case_insensitive = true;
                                                              shared = {
                                                                uuid = "7592105171323000633";
                                                              }; -- shared
                                                            }; -- ["all_robots-txt"]
                                                            all_ssle_gif = {
                                                              priority = 7;
                                                              pattern = "/_ssle.gif(.*)";
                                                              case_insensitive = true;
                                                              shared = {
                                                                uuid = "6807314109941869051";
                                                              }; -- shared
                                                            }; -- all_ssle_gif
                                                            ["all_yandex-apps-api"] = {
                                                              priority = 6;
                                                              pattern = ".*/yandex-apps-api/__webview-intercepted/_api.js.*";
                                                              case_insensitive = true;
                                                              shared = {
                                                                uuid = "5657162669462195568";
                                                              }; -- shared
                                                            }; -- ["all_yandex-apps-api"]
                                                            ["weather_y5_lego_yandex_net_s3_crossdomain-xml"] = {
                                                              priority = 5;
                                                              pattern = "/crossdomain-xml(/.*)?";
                                                              case_insensitive = true;
                                                              report = {
                                                                uuid = "weather_y5_lego_yandex_net_s3_crossdomain-xml";
                                                                ranges = get_str_var("default_ranges");
                                                                just_storage = false;
                                                                disable_robotness = true;
                                                                disable_sslness = true;
                                                                events = {
                                                                  stats = "report";
                                                                }; -- events
                                                                shared = {
                                                                  uuid = "weather_y5_lego_yandex_net_s3_crossdomain-xml";
                                                                  headers = {
                                                                    create = {
                                                                      Host = "yastatic.s3.yandex.net";
                                                                    }; -- create
                                                                    response_headers = {
                                                                      delete = "cache-control|access-control-allow-origin|strict-transport-security|timing-allow-origin|expires";
                                                                      create_func = {
                                                                        Expires = "time:+1h";
                                                                      }; -- create_func
                                                                      shared = {
                                                                        uuid = "1781853103362096270";
                                                                      }; -- shared
                                                                    }; -- response_headers
                                                                  }; -- headers
                                                                }; -- shared
                                                              }; -- report
                                                            }; -- ["weather_y5_lego_yandex_net_s3_crossdomain-xml"]
                                                            weather_y5_lego_yandex_net_s3_js = {
                                                              priority = 4;
                                                              pattern = "/js(/.*)?";
                                                              case_insensitive = true;
                                                              report = {
                                                                uuid = "weather_y5_lego_yandex_net_s3_js";
                                                                ranges = get_str_var("default_ranges");
                                                                just_storage = false;
                                                                disable_robotness = true;
                                                                disable_sslness = true;
                                                                events = {
                                                                  stats = "report";
                                                                }; -- events
                                                                shared = {
                                                                  uuid = "weather_y5_lego_yandex_net_s3_js";
                                                                  response_headers = {
                                                                    delete = "cache-control|access-control-allow-origin|strict-transport-security|timing-allow-origin";
                                                                    rewrite = {
                                                                      actions = {
                                                                        {
                                                                          global = false;
                                                                          literal = false;
                                                                          regexp = "/js/(.*)";
                                                                          case_insensitive = false;
                                                                          rewrite = "/old-js-static-yandex-net/%1";
                                                                        };
                                                                      }; -- actions
                                                                      headers = {
                                                                        create = {
                                                                          Host = "yastatic.s3.yandex.net";
                                                                        }; -- create
                                                                        shared = {
                                                                          uuid = "weather_y5_lego_yandex_net_s3_js_common";
                                                                          shared = {
                                                                            uuid = "177686509217163545";
                                                                          }; -- shared
                                                                        }; -- shared
                                                                      }; -- headers
                                                                    }; -- rewrite
                                                                  }; -- response_headers
                                                                }; -- shared
                                                              }; -- report
                                                            }; -- weather_y5_lego_yandex_net_s3_js
                                                            weather_y5_lego_yandex_net_s3_jslibs = {
                                                              priority = 3;
                                                              pattern = "/jslibs(/.*)?";
                                                              case_insensitive = true;
                                                              report = {
                                                                uuid = "weather_y5_lego_yandex_net_s3_jslibs";
                                                                ranges = get_str_var("default_ranges");
                                                                just_storage = false;
                                                                disable_robotness = true;
                                                                disable_sslness = true;
                                                                events = {
                                                                  stats = "report";
                                                                }; -- events
                                                                shared = {
                                                                  uuid = "weather_y5_lego_yandex_net_s3_jslibs";
                                                                  response_headers = {
                                                                    delete = "cache-control|access-control-allow-origin|strict-transport-security|timing-allow-origin";
                                                                    create = {
                                                                      ["Access-Control-Allow-Origin"] = "*";
                                                                      ["Cache-Control"] = "public";
                                                                      ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                                      ["Timing-Allow-Origin"] = "*";
                                                                    }; -- create
                                                                    shared = {
                                                                      uuid = "2060916621982072321";
                                                                    }; -- shared
                                                                  }; -- response_headers
                                                                }; -- shared
                                                              }; -- report
                                                            }; -- weather_y5_lego_yandex_net_s3_jslibs
                                                            weather_y5_lego_yandex_net_s3_lego = {
                                                              priority = 2;
                                                              pattern = "/lego(/.*)?";
                                                              case_insensitive = true;
                                                              report = {
                                                                uuid = "weather_y5_lego_yandex_net_s3_lego";
                                                                ranges = get_str_var("default_ranges");
                                                                just_storage = false;
                                                                disable_robotness = true;
                                                                disable_sslness = true;
                                                                events = {
                                                                  stats = "report";
                                                                }; -- events
                                                                shared = {
                                                                  uuid = "weather_y5_lego_yandex_net_s3_lego";
                                                                  response_headers = {
                                                                    delete = "cache-control|access-control-allow-origin|strict-transport-security|timing-allow-origin";
                                                                    create = {
                                                                      ["Access-Control-Allow-Origin"] = "*";
                                                                      ["Cache-Control"] = "public, max-age=216013";
                                                                      ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                                      ["Timing-Allow-Origin"] = "*";
                                                                    }; -- create
                                                                    shared = {
                                                                      uuid = "2060916621982072321";
                                                                    }; -- shared
                                                                  }; -- response_headers
                                                                }; -- shared
                                                              }; -- report
                                                            }; -- weather_y5_lego_yandex_net_s3_lego
                                                            default = {
                                                              
                                                              shared = {
                                                                uuid = "7101341086594050669";
                                                              }; -- shared
                                                            }; -- default
                                                          }; -- regexp_path
                                                        }; -- shared
                                                      }; -- default
                                                    }; -- regexp
                                                  }; -- weather_y5_lego_yandex_net
                                                  widgets_yandex_ru = {
                                                    priority = 15;
                                                    match_fsm = {
                                                      header = {
                                                        name = "Host";
                                                        value = "(widgets|widgets\\.[a-zA-Z0-9]+)\\.yandex\\.(ru|net|st)";
                                                      }; -- header
                                                      case_insensitive = true;
                                                      surround = false;
                                                    }; -- match_fsm
                                                    regexp_path = {
                                                      all_root_redir = {
                                                        priority = 10;
                                                        pattern = "(/)?";
                                                        case_insensitive = true;
                                                        shared = {
                                                          uuid = "4050231810825788227";
                                                          report = {
                                                            uuid = "all_net_root_redir";
                                                            ranges = get_str_var("default_ranges");
                                                            just_storage = false;
                                                            disable_robotness = true;
                                                            disable_sslness = true;
                                                            events = {
                                                              stats = "report";
                                                            }; -- events
                                                            response_headers = {
                                                              create = {
                                                                Location = "https://api.yandex.ru/jslibs";
                                                              }; -- create
                                                              errordocument = {
                                                                status = 302;
                                                                force_conn_close = false;
                                                              }; -- errordocument
                                                            }; -- response_headers
                                                          }; -- report
                                                        }; -- shared
                                                      }; -- all_root_redir
                                                      all_errors_table = {
                                                        priority = 9;
                                                        pattern = "/errors_table/(.*)";
                                                        case_insensitive = true;
                                                        shared = {
                                                          uuid = "8384648238129770771";
                                                          report = {
                                                            uuid = "errors_table";
                                                            ranges = get_str_var("default_ranges");
                                                            just_storage = false;
                                                            disable_robotness = true;
                                                            disable_sslness = true;
                                                            events = {
                                                              stats = "report";
                                                            }; -- events
                                                            regexp = {
                                                              stats = {
                                                                priority = 2;
                                                                match_source_ip = {
                                                                  source_mask = "2a02:6b8::/32,2620:10f:d000::/44,5.45.208.0/26,5.45.228.0/25,5.45.229.0/25,5.45.232.0/25,5.45.240.0/25,5.45.243.64/26,5.45.247.0/25,5.255.192.0/26,5.255.194.64/26,5.255.195.0/25,5.255.196.0/25,5.255.197.0/25,5.255.200.0/25,5.255.252.0/25,37.9.73.0/25,37.140.136.0/26,37.140.137.0/26,77.88.35.0/25,77.88.48.0/26,77.88.54.0/25,84.201.159.0/26,95.108.180.128/25,100.43.94.0/25,141.8.154.64/26,141.8.155.0/26,141.8.174.0/25,213.180.202.0/25,213.180.223.128/25,5.45.203.0/26,37.9.125.0/24,95.108.147.0/24,95.108.233.0/24,178.154.234.0/24,37.140.164.80/28,95.108.220.128/28,95.108.225.48/28,178.154.221.32/28,37.140.141.80/28,84.201.146.80/28,84.201.158.32/28,95.108.194.224/28,213.180.206.176/28,5.45.194.0/24,5.45.202.0/24,5.255.220.0/23,5.255.242.0/24,5.255.254.0/24,37.9.71.0/24,37.140.176.0/22,84.201.134.0/23,93.158.172.0/23,95.108.128.0/24,95.108.150.0/23,95.108.206.0/24,141.8.148.0/24,141.8.177.0/24,141.8.187.0/24,178.154.150.0/24,178.154.151.0/24,178.154.182.0/23,178.154.187.0/24,178.154.208.0/23,178.154.212.0/23,213.180.207.0/24,37.9.122.0/24,93.158.152.0/24,95.108.179.0/24,100.43.81.0/24,100.43.85.0/24,100.43.90.0/24,100.43.91.0/24,141.8.184.0/24,178.154.149.0/24,178.154.189.0/24,5.45.236.0/22,37.9.80.0/22,37.9.84.0/22,37.9.92.0/22,37.9.114.0/24,37.140.128.0/23,84.201.163.0/25,84.201.176.0/22,84.201.180.0/25,84.201.182.0/23,93.158.142.0/23,95.108.216.0/23,141.8.179.0/24,178.154.132.0/22,178.154.140.0/23,178.154.144.0/22,178.154.156.0/22,178.154.160.0/23,178.154.184.0/23,178.154.193.0/24,178.154.216.0/22,178.154.223.0/24,213.180.198.0/24,213.180.214.0/24,5.45.244.64/26,5.255.198.0/26,5.255.211.64/26,84.201.148.192/26,87.250.243.64/26,87.250.246.192/26,141.8.173.192/27,141.8.147.32/28,141.8.147.48/28,141.8.147.64/28,141.8.147.80/28,141.8.147.96/28,141.8.147.112/29,141.8.147.120/29,141.8.147.128/29,141.8.147.136/29,141.8.147.144/29,141.8.147.152/29,141.8.147.160/29,141.8.147.168/29,141.8.147.176/29,37.9.72.32/29,37.140.181.168/29,37.140.189.64/26,95.108.133.32/27,5.45.222.112/28,95.108.137.176/28,95.108.201.144/28,141.8.185.16/28,84.201.146.136/29,95.108.189.56/29,5.45.223.0/24,5.255.204.0/24,5.255.238.64/27,37.9.103.0/24,37.9.116.0/23,84.201.181.0/24,87.250.232.0/29,95.108.142.0/24,95.108.186.0/24,95.108.189.40/29,100.43.92.168/29,141.8.166.192/29,178.154.220.0/24,178.154.225.72/29,5.45.192.64/26,5.45.255.64/26,37.140.189.192/26,84.201.143.32/27,95.108.133.192/26,95.108.225.192/26,188.166.38.207,2a03:b0c0:2:d0::3a9:d001,5.45.193.0/24,5.45.197.0/24,5.45.201.0/24,37.9.68.0/26,77.88.31.128/25";
                                                                }; -- match_source_ip
                                                                balancer2 = {
                                                                  simple_policy = {};
                                                                  attempts = 5;
                                                                  rr = {
                                                                    unpack(gen_proxy_backends({
                                                                      { "yastatic-top-fails-1.sas.yp-c.yandex.net"; 80; 1.000; "2a02:6b8:c16:1d85:0:696:f6d4:0"; };
                                                                      { "yastatic-top-fails-2.iva.yp-c.yandex.net"; 80; 1.000; "2a02:6b8:c0c:98e:0:696:4fbb:0"; };
                                                                    }, {
                                                                      resolve_timeout = "10ms";
                                                                      connect_timeout = "50ms";
                                                                      backend_timeout = "100ms";
                                                                      fail_on_5xx = true;
                                                                      http_backend = true;
                                                                      buffering = false;
                                                                      keepalive_count = 1;
                                                                      need_resolve = false;
                                                                      keepalive_timeout = "60s";
                                                                    }))
                                                                  }; -- rr
                                                                }; -- balancer2
                                                              }; -- stats
                                                              default = {
                                                                priority = 1;
                                                                errordocument = {
                                                                  status = 404;
                                                                  force_conn_close = false;
                                                                }; -- errordocument
                                                              }; -- default
                                                            }; -- regexp
                                                          }; -- report
                                                        }; -- shared
                                                      }; -- all_errors_table
                                                      all_favicon_ico = {
                                                        priority = 8;
                                                        pattern = "/favicon.ico(.*)";
                                                        case_insensitive = true;
                                                        shared = {
                                                          uuid = "264806882395022933";
                                                          report = {
                                                            uuid = "all_favicon_ico";
                                                            ranges = get_str_var("default_ranges");
                                                            just_storage = false;
                                                            disable_robotness = true;
                                                            disable_sslness = true;
                                                            events = {
                                                              stats = "report";
                                                            }; -- events
                                                            response_headers = {
                                                              create_func = {
                                                                Expires = "time:+3153600000s";
                                                              }; -- create_func
                                                              create = {
                                                                ["Access-Control-Allow-Origin"] = "*";
                                                                ["Cache-Control"] = "public, max-age=3153600000";
                                                                ["Content-Type"] = "image/gif";
                                                                ["Timing-Allow-Origin"] = "*";
                                                              }; -- create
                                                              errordocument = {
                                                                status = 200;
                                                                force_conn_close = false;
                                                                base64 = "R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7";
                                                              }; -- errordocument
                                                            }; -- response_headers
                                                          }; -- report
                                                        }; -- shared
                                                      }; -- all_favicon_ico
                                                      all_google_verification = {
                                                        priority = 7;
                                                        pattern = "/google(.*)";
                                                        case_insensitive = true;
                                                        shared = {
                                                          uuid = "758824134262716168";
                                                          report = {
                                                            uuid = "google_verification";
                                                            ranges = get_str_var("default_ranges");
                                                            just_storage = false;
                                                            disable_robotness = true;
                                                            disable_sslness = true;
                                                            events = {
                                                              stats = "report";
                                                            }; -- events
                                                            response_headers = {
                                                              create_func = {
                                                                Expires = "time:+216001s";
                                                              }; -- create_func
                                                              create = {
                                                                ["Access-Control-Allow-Origin"] = "*";
                                                                ["Cache-Control"] = "public, max-age=216013";
                                                                ["Content-Type"] = "text/html";
                                                                Etag = "5d49633c-35";
                                                                ["Last-Modified"] = "Tue, 06 Aug 2019 11:25:47 GMT";
                                                                ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                                ["Timing-Allow-Origin"] = "*";
                                                              }; -- create
                                                              regexp_path = {
                                                                google0531f764def6e2c0 = {
                                                                  priority = 14;
                                                                  pattern = "/google0531f764def6e2c0.html(.*)?";
                                                                  case_insensitive = true;
                                                                  errordocument = {
                                                                    status = 200;
                                                                    force_conn_close = false;
                                                                    content = "google-site-verification: google0531f764def6e2c0.html";
                                                                  }; -- errordocument
                                                                }; -- google0531f764def6e2c0
                                                                google1231de678febfc18 = {
                                                                  priority = 13;
                                                                  pattern = "/google1231de678febfc18.html(.*)?";
                                                                  case_insensitive = true;
                                                                  errordocument = {
                                                                    status = 200;
                                                                    force_conn_close = false;
                                                                    content = "google-site-verification: google1231de678febfc18.html";
                                                                  }; -- errordocument
                                                                }; -- google1231de678febfc18
                                                                google2f4db31764016ac7 = {
                                                                  priority = 12;
                                                                  pattern = "/google2f4db31764016ac7.html(.*)?";
                                                                  case_insensitive = true;
                                                                  errordocument = {
                                                                    status = 200;
                                                                    force_conn_close = false;
                                                                    content = "google-site-verification: google2f4db31764016ac7.html";
                                                                  }; -- errordocument
                                                                }; -- google2f4db31764016ac7
                                                                google3cc9a42f3ae9163d = {
                                                                  priority = 11;
                                                                  pattern = "/google3cc9a42f3ae9163d.html(.*)?";
                                                                  case_insensitive = true;
                                                                  errordocument = {
                                                                    status = 200;
                                                                    force_conn_close = false;
                                                                    content = "google-site-verification: google3cc9a42f3ae9163d.html";
                                                                  }; -- errordocument
                                                                }; -- google3cc9a42f3ae9163d
                                                                google4edc58ed4d4c4ea0 = {
                                                                  priority = 10;
                                                                  pattern = "/google4edc58ed4d4c4ea0.html(.*)?";
                                                                  case_insensitive = true;
                                                                  errordocument = {
                                                                    status = 200;
                                                                    force_conn_close = false;
                                                                    content = "google-site-verification: google4edc58ed4d4c4ea0.html";
                                                                  }; -- errordocument
                                                                }; -- google4edc58ed4d4c4ea0
                                                                google7d84d2bcb6ad9694 = {
                                                                  priority = 9;
                                                                  pattern = "/google7d84d2bcb6ad9694.html(.*)?";
                                                                  case_insensitive = true;
                                                                  errordocument = {
                                                                    status = 200;
                                                                    force_conn_close = false;
                                                                    content = "google-site-verification: google7d84d2bcb6ad9694.html";
                                                                  }; -- errordocument
                                                                }; -- google7d84d2bcb6ad9694
                                                                google8a688d7abeff0dc8 = {
                                                                  priority = 8;
                                                                  pattern = "/google8a688d7abeff0dc8.html(.*)?";
                                                                  case_insensitive = true;
                                                                  errordocument = {
                                                                    status = 200;
                                                                    force_conn_close = false;
                                                                    content = "google-site-verification: google8a688d7abeff0dc8.html";
                                                                  }; -- errordocument
                                                                }; -- google8a688d7abeff0dc8
                                                                google90adcf773a35f229 = {
                                                                  priority = 7;
                                                                  pattern = "/google90adcf773a35f229.html(.*)?";
                                                                  case_insensitive = true;
                                                                  errordocument = {
                                                                    status = 200;
                                                                    force_conn_close = false;
                                                                    content = "google-site-verification: google90adcf773a35f229.html";
                                                                  }; -- errordocument
                                                                }; -- google90adcf773a35f229
                                                                googleb4808cecd66755cf = {
                                                                  priority = 6;
                                                                  pattern = "/googleb4808cecd66755cf.html(.*)?";
                                                                  case_insensitive = true;
                                                                  errordocument = {
                                                                    status = 200;
                                                                    force_conn_close = false;
                                                                    content = "google-site-verification: googleb4808cecd66755cf.html";
                                                                  }; -- errordocument
                                                                }; -- googleb4808cecd66755cf
                                                                googlec6434c12127271e9 = {
                                                                  priority = 5;
                                                                  pattern = "/googlec6434c12127271e9.html(.*)?";
                                                                  case_insensitive = true;
                                                                  errordocument = {
                                                                    status = 200;
                                                                    force_conn_close = false;
                                                                    content = "google-site-verification: googlec6434c12127271e9.html";
                                                                  }; -- errordocument
                                                                }; -- googlec6434c12127271e9
                                                                googled807c02a74a757f4 = {
                                                                  priority = 4;
                                                                  pattern = "/googled807c02a74a757f4.html(.*)?";
                                                                  case_insensitive = true;
                                                                  errordocument = {
                                                                    status = 200;
                                                                    force_conn_close = false;
                                                                    content = "google-site-verification: googled807c02a74a757f4.html";
                                                                  }; -- errordocument
                                                                }; -- googled807c02a74a757f4
                                                                googlef8cc9d0d113dcb33 = {
                                                                  priority = 3;
                                                                  pattern = "/googlef8cc9d0d113dcb33.html(.*)?";
                                                                  case_insensitive = true;
                                                                  errordocument = {
                                                                    status = 200;
                                                                    force_conn_close = false;
                                                                    content = "google-site-verification: googlef8cc9d0d113dcb33.html";
                                                                  }; -- errordocument
                                                                }; -- googlef8cc9d0d113dcb33
                                                                googlefd26f18d2d0c1d94 = {
                                                                  priority = 2;
                                                                  pattern = "/googlefd26f18d2d0c1d94.html(.*)?";
                                                                  case_insensitive = true;
                                                                  errordocument = {
                                                                    status = 200;
                                                                    force_conn_close = false;
                                                                    content = "google-site-verification: googlefd26f18d2d0c1d94.html";
                                                                  }; -- errordocument
                                                                }; -- googlefd26f18d2d0c1d94
                                                                default = {
                                                                  errordocument = {
                                                                    status = 404;
                                                                    force_conn_close = false;
                                                                  }; -- errordocument
                                                                }; -- default
                                                              }; -- regexp_path
                                                            }; -- response_headers
                                                          }; -- report
                                                        }; -- shared
                                                      }; -- all_google_verification
                                                      all_nearest_js = {
                                                        priority = 6;
                                                        pattern = "/nearest.js(.*)";
                                                        case_insensitive = true;
                                                        shared = {
                                                          uuid = "2837673959647856177";
                                                          report = {
                                                            uuid = "nearest_js";
                                                            ranges = get_str_var("default_ranges");
                                                            just_storage = false;
                                                            disable_robotness = true;
                                                            disable_sslness = true;
                                                            events = {
                                                              stats = "report";
                                                            }; -- events
                                                            response_headers = {
                                                              create = {
                                                                ["Access-Control-Allow-Origin"] = "*";
                                                                ["Cache-Control"] = "public";
                                                                ["Content-Type"] = "application/x-javascript";
                                                                Etag = "W/5d4963bb-1e";
                                                                ["Last-Modified"] = "Tue, 06 Aug 2019 11:25:47 GMT";
                                                                ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                                ["Timing-Allow-Origin"] = "*";
                                                              }; -- create
                                                              errordocument = {
                                                                status = 200;
                                                                force_conn_close = false;
                                                                content = "var YaStaticRegion = \"default\"";
                                                              }; -- errordocument
                                                            }; -- response_headers
                                                          }; -- report
                                                        }; -- shared
                                                      }; -- all_nearest_js
                                                      ["all_robots-txt"] = {
                                                        priority = 5;
                                                        pattern = "/robots.txt.*";
                                                        case_insensitive = true;
                                                        shared = {
                                                          uuid = "7592105171323000633";
                                                          report = {
                                                            uuid = "all_robots-txt";
                                                            ranges = get_str_var("default_ranges");
                                                            just_storage = false;
                                                            disable_robotness = true;
                                                            disable_sslness = true;
                                                            events = {
                                                              stats = "report";
                                                            }; -- events
                                                            errordocument = {
                                                              status = 200;
                                                              force_conn_close = false;
                                                              content = "User-agent: *\nAllow: /";
                                                            }; -- errordocument
                                                          }; -- report
                                                        }; -- shared
                                                      }; -- ["all_robots-txt"]
                                                      all_ssle_gif = {
                                                        priority = 4;
                                                        pattern = "/_ssle.gif(.*)";
                                                        case_insensitive = true;
                                                        shared = {
                                                          uuid = "6807314109941869051";
                                                          report = {
                                                            uuid = "ssle_gif";
                                                            ranges = get_str_var("default_ranges");
                                                            just_storage = false;
                                                            disable_robotness = true;
                                                            disable_sslness = true;
                                                            events = {
                                                              stats = "report";
                                                            }; -- events
                                                            response_headers = {
                                                              create = {
                                                                ["Access-Control-Allow-Origin"] = "*";
                                                                ["Cache-Control"] = "public";
                                                                ["Content-Type"] = "image/gif";
                                                                ["Last-Modified"] = "Mon, 28 Sep 1970 06:00:00 GMT";
                                                                ["Timing-Allow-Origin"] = "*";
                                                              }; -- create
                                                              errordocument = {
                                                                status = 204;
                                                                force_conn_close = false;
                                                              }; -- errordocument
                                                            }; -- response_headers
                                                          }; -- report
                                                        }; -- shared
                                                      }; -- all_ssle_gif
                                                      ["all_yandex-apps-api"] = {
                                                        priority = 3;
                                                        pattern = ".*/yandex-apps-api/__webview-intercepted/_api.js.*";
                                                        case_insensitive = true;
                                                        shared = {
                                                          uuid = "5657162669462195568";
                                                          report = {
                                                            uuid = "all_yandex-apps-api";
                                                            ranges = get_str_var("default_ranges");
                                                            just_storage = false;
                                                            disable_robotness = true;
                                                            disable_sslness = true;
                                                            events = {
                                                              stats = "report";
                                                            }; -- events
                                                            errordocument = {
                                                              status = 200;
                                                              force_conn_close = false;
                                                              content = "Matched by flapping URL mask for yandex-apps-api";
                                                            }; -- errordocument
                                                          }; -- report
                                                        }; -- shared
                                                      }; -- ["all_yandex-apps-api"]
                                                      widgets_yandex_ru = {
                                                        priority = 2;
                                                        pattern = "/(.*)?";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "widgets_yandex_ru";
                                                          ranges = get_str_var("default_ranges");
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          headers = {
                                                            delete = "accept-encoding";
                                                            create = {
                                                              Host = "yastatic.net";
                                                            }; -- create
                                                            response_headers = {
                                                              delete = "timing-allow-origin|cache-control|access-control-allow-origin";
                                                              create_func = {
                                                                Expires = "time:+4m";
                                                              }; -- create_func
                                                              create = {
                                                                ["Cache-Control"] = "public, max-age=240";
                                                                ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                              }; -- create
                                                              rewrite = {
                                                                actions = {
                                                                  {
                                                                    global = false;
                                                                    literal = false;
                                                                    regexp = "/(.*)";
                                                                    case_insensitive = false;
                                                                    rewrite = "/widgets-old/%1";
                                                                  };
                                                                }; -- actions
                                                                shared = {
                                                                  uuid = "yastatic_net_s3_widgets-old";
                                                                }; -- shared
                                                              }; -- rewrite
                                                            }; -- response_headers
                                                          }; -- headers
                                                        }; -- report
                                                      }; -- widgets_yandex_ru
                                                      default = {
                                                        
                                                        shared = {
                                                          uuid = "7101341086594050669";
                                                          report = {
                                                            uuid = "all_default";
                                                            ranges = get_str_var("default_ranges");
                                                            just_storage = false;
                                                            disable_robotness = true;
                                                            disable_sslness = true;
                                                            events = {
                                                              stats = "report";
                                                            }; -- events
                                                            headers = {
                                                              create = {
                                                                Host = "yastatic-testing.s3.yandex.net";
                                                              }; -- create
                                                              response_headers = {
                                                                create_func = {
                                                                  Expires = "time:+600s";
                                                                }; -- create_func
                                                                create = {
                                                                  ["Access-Control-Allow-Origin"] = "*";
                                                                  ["Cache-Control"] = "public, max-age=600";
                                                                  ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                                  ["Timing-Allow-Origin"] = "*";
                                                                }; -- create
                                                                shared = {
                                                                  uuid = "2096342896149338041";
                                                                  response_headers = {
                                                                    create = {
                                                                      ["Cache-Control"] = "public, max-age=600";
                                                                    }; -- create
                                                                    shared = {
                                                                      uuid = "1547776764857163274";
                                                                      headers = {
                                                                        delete = "authorization";
                                                                        shared = {
                                                                          uuid = "4957618399187796178";
                                                                        }; -- shared
                                                                      }; -- headers
                                                                    }; -- shared
                                                                  }; -- response_headers
                                                                }; -- shared
                                                              }; -- response_headers
                                                            }; -- headers
                                                          }; -- report
                                                        }; -- shared
                                                      }; -- default
                                                    }; -- regexp_path
                                                  }; -- widgets_yandex_ru
                                                  img_encyc_yandex_net = {
                                                    priority = 14;
                                                    match_or = {
                                                      {
                                                        match_fsm = {
                                                          header = {
                                                            name = "Host";
                                                            value = "img\\.encyc\\.yandex\\.net";
                                                          }; -- header
                                                          case_insensitive = true;
                                                          surround = false;
                                                        }; -- match_fsm
                                                      };
                                                      {
                                                        match_fsm = {
                                                          header = {
                                                            name = "Host";
                                                            value = "img\\.encyc\\.(rcstatic|betastatic|prestatic)\\.yandex\\.(ru|net)";
                                                          }; -- header
                                                          case_insensitive = true;
                                                          surround = false;
                                                        }; -- match_fsm
                                                      };
                                                    }; -- match_or
                                                    rewrite = {
                                                      actions = {
                                                        {
                                                          global = false;
                                                          literal = false;
                                                          case_insensitive = false;
                                                          rewrite = "/articles_ng/%2";
                                                          regexp = "^/articles_ng/(articles_ng/)+(.*)$";
                                                        };
                                                        {
                                                          global = false;
                                                          literal = false;
                                                          case_insensitive = false;
                                                          regexp = "^/articles_ng/pharma/(.*)$";
                                                          rewrite = "/articles_generated/pharma/%1";
                                                        };
                                                      }; -- actions
                                                      regexp_path = {
                                                        all_root_redir = {
                                                          priority = 10;
                                                          pattern = "(/)?";
                                                          case_insensitive = true;
                                                          shared = {
                                                            uuid = "4050231810825788227";
                                                          }; -- shared
                                                        }; -- all_root_redir
                                                        all_errors_table = {
                                                          priority = 9;
                                                          pattern = "/errors_table/(.*)";
                                                          case_insensitive = true;
                                                          shared = {
                                                            uuid = "8384648238129770771";
                                                          }; -- shared
                                                        }; -- all_errors_table
                                                        all_favicon_ico = {
                                                          priority = 8;
                                                          pattern = "/favicon.ico(.*)";
                                                          case_insensitive = true;
                                                          shared = {
                                                            uuid = "264806882395022933";
                                                          }; -- shared
                                                        }; -- all_favicon_ico
                                                        all_google_verification = {
                                                          priority = 7;
                                                          pattern = "/google(.*)";
                                                          case_insensitive = true;
                                                          shared = {
                                                            uuid = "758824134262716168";
                                                          }; -- shared
                                                        }; -- all_google_verification
                                                        all_nearest_js = {
                                                          priority = 6;
                                                          pattern = "/nearest.js(.*)";
                                                          case_insensitive = true;
                                                          shared = {
                                                            uuid = "2837673959647856177";
                                                          }; -- shared
                                                        }; -- all_nearest_js
                                                        ["all_robots-txt"] = {
                                                          priority = 5;
                                                          pattern = "/robots.txt.*";
                                                          case_insensitive = true;
                                                          shared = {
                                                            uuid = "7592105171323000633";
                                                          }; -- shared
                                                        }; -- ["all_robots-txt"]
                                                        all_ssle_gif = {
                                                          priority = 4;
                                                          pattern = "/_ssle.gif(.*)";
                                                          case_insensitive = true;
                                                          shared = {
                                                            uuid = "6807314109941869051";
                                                          }; -- shared
                                                        }; -- all_ssle_gif
                                                        ["all_yandex-apps-api"] = {
                                                          priority = 3;
                                                          pattern = ".*/yandex-apps-api/__webview-intercepted/_api.js.*";
                                                          case_insensitive = true;
                                                          shared = {
                                                            uuid = "5657162669462195568";
                                                          }; -- shared
                                                        }; -- ["all_yandex-apps-api"]
                                                        img_encyc_yandex_net = {
                                                          priority = 2;
                                                          pattern = "/(.*)?";
                                                          case_insensitive = true;
                                                          report = {
                                                            uuid = "img_encyc_yandex_net";
                                                            ranges = get_str_var("default_ranges");
                                                            just_storage = false;
                                                            disable_robotness = true;
                                                            disable_sslness = true;
                                                            events = {
                                                              stats = "report";
                                                            }; -- events
                                                            response_headers = {
                                                              delete = "access-control-allow-origin|timing-allow-origin|cache-control|expires";
                                                              create = {
                                                                ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                              }; -- create
                                                              headers = {
                                                                create = {
                                                                  Host = "yastatic.net";
                                                                }; -- create
                                                                rewrite = {
                                                                  actions = {
                                                                    {
                                                                      global = false;
                                                                      literal = false;
                                                                      regexp = "/(.*)";
                                                                      rewrite = "/encyc/%1";
                                                                      case_insensitive = false;
                                                                    };
                                                                  }; -- actions
                                                                  shared = {
                                                                    uuid = "yastatic_net_s3_encyc";
                                                                  }; -- shared
                                                                }; -- rewrite
                                                              }; -- headers
                                                            }; -- response_headers
                                                          }; -- report
                                                        }; -- img_encyc_yandex_net
                                                        default = {
                                                          
                                                          shared = {
                                                            uuid = "7101341086594050669";
                                                          }; -- shared
                                                        }; -- default
                                                      }; -- regexp_path
                                                    }; -- rewrite
                                                  }; -- img_encyc_yandex_net
                                                  subbotnik_yastatic_net = {
                                                    priority = 13;
                                                    match_or = {
                                                      {
                                                        match_fsm = {
                                                          header = {
                                                            name = "Host";
                                                            value = "subbotnik\\.yandex\\.st";
                                                          }; -- header
                                                          case_insensitive = true;
                                                          surround = false;
                                                        }; -- match_fsm
                                                      };
                                                      {
                                                        match_fsm = {
                                                          header = {
                                                            name = "Host";
                                                            value = "subbotnik\\.yastatic\\.net";
                                                          }; -- header
                                                          case_insensitive = true;
                                                          surround = false;
                                                        }; -- match_fsm
                                                      };
                                                      {
                                                        match_fsm = {
                                                          header = {
                                                            name = "Host";
                                                            value = "subbotnik\\.([a-zA-Z0-9]+)\\.yandex\\.ru";
                                                          }; -- header
                                                          case_insensitive = true;
                                                          surround = false;
                                                        }; -- match_fsm
                                                      };
                                                    }; -- match_or
                                                    regexp_path = {
                                                      all_root_redir = {
                                                        priority = 10;
                                                        pattern = "(/)?";
                                                        case_insensitive = true;
                                                        shared = {
                                                          uuid = "4050231810825788227";
                                                        }; -- shared
                                                      }; -- all_root_redir
                                                      all_errors_table = {
                                                        priority = 9;
                                                        pattern = "/errors_table/(.*)";
                                                        case_insensitive = true;
                                                        shared = {
                                                          uuid = "8384648238129770771";
                                                        }; -- shared
                                                      }; -- all_errors_table
                                                      all_favicon_ico = {
                                                        priority = 8;
                                                        pattern = "/favicon.ico(.*)";
                                                        case_insensitive = true;
                                                        shared = {
                                                          uuid = "264806882395022933";
                                                        }; -- shared
                                                      }; -- all_favicon_ico
                                                      all_google_verification = {
                                                        priority = 7;
                                                        pattern = "/google(.*)";
                                                        case_insensitive = true;
                                                        shared = {
                                                          uuid = "758824134262716168";
                                                        }; -- shared
                                                      }; -- all_google_verification
                                                      all_nearest_js = {
                                                        priority = 6;
                                                        pattern = "/nearest.js(.*)";
                                                        case_insensitive = true;
                                                        shared = {
                                                          uuid = "2837673959647856177";
                                                        }; -- shared
                                                      }; -- all_nearest_js
                                                      ["all_robots-txt"] = {
                                                        priority = 5;
                                                        pattern = "/robots.txt.*";
                                                        case_insensitive = true;
                                                        shared = {
                                                          uuid = "7592105171323000633";
                                                        }; -- shared
                                                      }; -- ["all_robots-txt"]
                                                      all_ssle_gif = {
                                                        priority = 4;
                                                        pattern = "/_ssle.gif(.*)";
                                                        case_insensitive = true;
                                                        shared = {
                                                          uuid = "6807314109941869051";
                                                        }; -- shared
                                                      }; -- all_ssle_gif
                                                      ["all_yandex-apps-api"] = {
                                                        priority = 3;
                                                        pattern = ".*/yandex-apps-api/__webview-intercepted/_api.js.*";
                                                        case_insensitive = true;
                                                        shared = {
                                                          uuid = "5657162669462195568";
                                                        }; -- shared
                                                      }; -- ["all_yandex-apps-api"]
                                                      subbotnik_yastatic_net = {
                                                        priority = 2;
                                                        pattern = "(/.*)?";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "subbotnik_yastatic_net";
                                                          ranges = get_str_var("default_ranges");
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          shared = {
                                                            uuid = "subbotnik_yastatic_net";
                                                            headers = {
                                                              create = {
                                                                Host = "yastatic.s3.yandex.net";
                                                              }; -- create
                                                              rewrite = {
                                                                actions = {
                                                                  {
                                                                    global = false;
                                                                    literal = false;
                                                                    case_insensitive = false;
                                                                    rewrite = "%1/index.html";
                                                                    regexp = "^(.+)/(\\?.*)?$";
                                                                  };
                                                                  {
                                                                    global = false;
                                                                    literal = false;
                                                                    regexp = "/(.*)";
                                                                    case_insensitive = false;
                                                                    rewrite = "/old-subbotnik/%1";
                                                                  };
                                                                }; -- actions
                                                                response_headers = {
                                                                  delete = "timing-allow-origin|access-control-allow-origin";
                                                                  create_func = {
                                                                    Expires = "time:+216009s";
                                                                  }; -- create_func
                                                                  create = {
                                                                    ["Cache-Control"] = "public, max-age=216013";
                                                                    ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                                  }; -- create
                                                                  shared = {
                                                                    uuid = "subbotnik_yastatic_net_common";
                                                                    shared = {
                                                                      uuid = "177686509217163545";
                                                                    }; -- shared
                                                                  }; -- shared
                                                                }; -- response_headers
                                                              }; -- rewrite
                                                            }; -- headers
                                                          }; -- shared
                                                        }; -- report
                                                      }; -- subbotnik_yastatic_net
                                                      default = {
                                                        
                                                        shared = {
                                                          uuid = "7101341086594050669";
                                                        }; -- shared
                                                      }; -- default
                                                    }; -- regexp_path
                                                  }; -- subbotnik_yastatic_net
                                                  static_kp_yandex_net = {
                                                    priority = 12;
                                                    match_or = {
                                                      {
                                                        match_fsm = {
                                                          header = {
                                                            name = "Host";
                                                            value = "static\\.kp\\.yandex\\.net";
                                                          }; -- header
                                                          case_insensitive = true;
                                                          surround = false;
                                                        }; -- match_fsm
                                                      };
                                                      {
                                                        match_fsm = {
                                                          header = {
                                                            name = "Host";
                                                            value = "betastatic\\.kp\\.yandex\\.net";
                                                          }; -- header
                                                          case_insensitive = true;
                                                          surround = false;
                                                        }; -- match_fsm
                                                      };
                                                      {
                                                        match_fsm = {
                                                          header = {
                                                            name = "Host";
                                                            value = "videopartner\\.kinopoisk\\.ru";
                                                          }; -- header
                                                          case_insensitive = true;
                                                          surround = false;
                                                        }; -- match_fsm
                                                      };
                                                      {
                                                        match_fsm = {
                                                          header = {
                                                            name = "Host";
                                                            value = "kinopoisk\\..*";
                                                          }; -- header
                                                          case_insensitive = true;
                                                          surround = false;
                                                        }; -- match_fsm
                                                      };
                                                    }; -- match_or
                                                    regexp_path = {
                                                      ["static_kp_yandex_net_crossdomain-xml"] = {
                                                        priority = 13;
                                                        pattern = "/crossdomain-xml(/.*)?";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "static_kp_yandex_net_crossdomain-xml";
                                                          ranges = get_str_var("default_ranges");
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          shared = {
                                                            uuid = "static_kp_yandex_net_crossdomain-xml";
                                                            headers = {
                                                              create = {
                                                                Host = "yastatic.s3.yandex.net";
                                                              }; -- create
                                                              response_headers = {
                                                                delete = "cache-control|access-control-allow-origin|strict-transport-security|timing-allow-origin|expires";
                                                                create = {
                                                                  ["Access-Control-Allow-Origin"] = "*";
                                                                  ["Cache-Control"] = "public";
                                                                }; -- create
                                                                shared = {
                                                                  uuid = "1781853103362096270";
                                                                  shared = {
                                                                    uuid = "yastatic_net_s3_crossdomain-xml";
                                                                  }; -- shared
                                                                }; -- shared
                                                              }; -- response_headers
                                                            }; -- headers
                                                          }; -- shared
                                                        }; -- report
                                                      }; -- ["static_kp_yandex_net_crossdomain-xml"]
                                                      static_kp_yandex_net_swf = {
                                                        priority = 12;
                                                        pattern = "/swf/(cinemaplayer|cinemaplayer-ext)(/.*)?";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "static_kp_yandex_net_swf";
                                                          ranges = get_str_var("default_ranges");
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          shared = {
                                                            uuid = "static_kp_yandex_net_swf";
                                                            headers = {
                                                              create = {
                                                                Host = "yastatic.s3.yandex.net";
                                                              }; -- create
                                                              response_headers = {
                                                                create = {
                                                                  ["Access-Control-Allow-Origin"] = "*";
                                                                  ["Cache-Control"] = "public, max-age=216013";
                                                                }; -- create
                                                                shared = {
                                                                  uuid = "static_kp_yandex_net_swf_common";
                                                                  shared = {
                                                                    uuid = "177686509217163545";
                                                                  }; -- shared
                                                                }; -- shared
                                                              }; -- response_headers
                                                            }; -- headers
                                                          }; -- shared
                                                        }; -- report
                                                      }; -- static_kp_yandex_net_swf
                                                      all_root_redir = {
                                                        priority = 11;
                                                        pattern = "(/)?";
                                                        case_insensitive = true;
                                                        shared = {
                                                          uuid = "4050231810825788227";
                                                        }; -- shared
                                                      }; -- all_root_redir
                                                      ["static_kp_yandex_net_google-conversion"] = {
                                                        priority = 10;
                                                        pattern = "/google-conversion.html(.*)";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "static_kp_yandex_net_google-conversion";
                                                          ranges = get_str_var("default_ranges");
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          response_headers = {
                                                            create = {
                                                              ["Access-Control-Allow-Origin"] = "*";
                                                              ["Cache-Control"] = "public";
                                                              ["Content-Type"] = "text/html";
                                                              Etag = "09250269e2e0a3699d65a72aa3eb350e";
                                                            }; -- create
                                                            errordocument = {
                                                              status = 200;
                                                              force_conn_close = false;
                                                              base64 = "PCFET0NUWVBFIGh0bWw+CjxodG1sIGxhbmc9ImVuIj4KPGhlYWQ+CiAgICA8bWV0YSBjaGFyc2V0PSJVVEYtOCI+CiAgICA8dGl0bGU+0JrQuNC90L7Qv9C+0LjRgdC6PC90aXRsZT4KPC9oZWFkPgo8Ym9keT4KICAgIDwhLS0gR29vZ2xlIENvZGUgZm9yICYjMTA0NDsmIzEwODA7JiMxMDg1OyYjMTA3MjsmIzEwODQ7JiMxMDgwOyYjMTA5NTsmIzEwNzc7JiMxMDg5OyYjMTA4MjsmIzEwODA7JiMxMDgxOyBDb252ZXJzaW9uIFBhZ2UgLS0+CiAgICA8c2NyaXB0IHR5cGU9InRleHQvamF2YXNjcmlwdCI+CiAgICAvKiA8IVtDREFUQVsgKi8KICAgICAgICB2YXIgZ29vZ2xlX2NvbnZlcnNpb25faWQgPSA5NDQ0MTM5MTI7CiAgICAgICAgdmFyIGdvb2dsZV9jb252ZXJzaW9uX2xhbmd1YWdlID0gImVuIjsKICAgICAgICB2YXIgZ29vZ2xlX2NvbnZlcnNpb25fZm9ybWF0ID0gIjMiOwogICAgICAgIHZhciBnb29nbGVfY29udmVyc2lvbl9jb2xvciA9ICJmZmZmZmYiOwogICAgICAgIHZhciBnb29nbGVfY29udmVyc2lvbl9sYWJlbCA9ICJfU1lOQ01YbnkyUVEyTG1xd2dNIjsKICAgICAgICB2YXIgZ29vZ2xlX3JlbWFya2V0aW5nX29ubHkgPSBmYWxzZTsKICAgIC8qIF1dPiAqLwogICAgPC9zY3JpcHQ+CiAgICA8c2NyaXB0IHR5cGU9InRleHQvamF2YXNjcmlwdCIgc3JjPSIvL3d3dy5nb29nbGVhZHNlcnZpY2VzLmNvbS9wYWdlYWQvY29udmVyc2lvbi5qcyI+PC9zY3JpcHQ+CiAgICA8bm9zY3JpcHQ+CiAgICAgICAgPGRpdiBzdHlsZT0iZGlzcGxheTppbmxpbmU7Ij4KICAgICAgICAgICAgPGltZyBoZWlnaHQ9IjEiIHdpZHRoPSIxIiBzdHlsZT0iYm9yZGVyLXN0eWxlOm5vbmU7IiBhbHQ9IiIgc3JjPSIvL3d3dy5nb29nbGVhZHNlcnZpY2VzLmNvbS9wYWdlYWQvY29udmVyc2lvbi85NDQ0MTM5MTIvP2xhYmVsPV9TWU5DTVhueTJRUTJMbXF3Z00mYW1wO2d1aWQ9T04mYW1wO3NjcmlwdD0wIi8+CiAgICAgICAgPC9kaXY+CiAgICA8L25vc2NyaXB0Pgo8L2JvZHk+CjwvaHRtbD4K";
                                                            }; -- errordocument
                                                          }; -- response_headers
                                                        }; -- report
                                                      }; -- ["static_kp_yandex_net_google-conversion"]
                                                      all_errors_table = {
                                                        priority = 9;
                                                        pattern = "/errors_table/(.*)";
                                                        case_insensitive = true;
                                                        shared = {
                                                          uuid = "8384648238129770771";
                                                        }; -- shared
                                                      }; -- all_errors_table
                                                      all_favicon_ico = {
                                                        priority = 8;
                                                        pattern = "/favicon.ico(.*)";
                                                        case_insensitive = true;
                                                        shared = {
                                                          uuid = "264806882395022933";
                                                        }; -- shared
                                                      }; -- all_favicon_ico
                                                      all_google_verification = {
                                                        priority = 7;
                                                        pattern = "/google(.*)";
                                                        case_insensitive = true;
                                                        shared = {
                                                          uuid = "758824134262716168";
                                                        }; -- shared
                                                      }; -- all_google_verification
                                                      all_nearest_js = {
                                                        priority = 6;
                                                        pattern = "/nearest.js(.*)";
                                                        case_insensitive = true;
                                                        shared = {
                                                          uuid = "2837673959647856177";
                                                        }; -- shared
                                                      }; -- all_nearest_js
                                                      ["all_robots-txt"] = {
                                                        priority = 5;
                                                        pattern = "/robots.txt.*";
                                                        case_insensitive = true;
                                                        shared = {
                                                          uuid = "7592105171323000633";
                                                        }; -- shared
                                                      }; -- ["all_robots-txt"]
                                                      all_ssle_gif = {
                                                        priority = 4;
                                                        pattern = "/_ssle.gif(.*)";
                                                        case_insensitive = true;
                                                        shared = {
                                                          uuid = "6807314109941869051";
                                                        }; -- shared
                                                      }; -- all_ssle_gif
                                                      ["all_yandex-apps-api"] = {
                                                        priority = 3;
                                                        pattern = ".*/yandex-apps-api/__webview-intercepted/_api.js.*";
                                                        case_insensitive = true;
                                                        shared = {
                                                          uuid = "5657162669462195568";
                                                        }; -- shared
                                                      }; -- ["all_yandex-apps-api"]
                                                      static_kp_yandex_net = {
                                                        priority = 2;
                                                        pattern = "(/.*)?";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "static_kp_yandex_net";
                                                          ranges = get_str_var("default_ranges");
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          shared = {
                                                            uuid = "static_kp_yandex_net";
                                                            headers = {
                                                              create = {
                                                                Host = "yastatic.s3.yandex.net";
                                                              }; -- create
                                                              rewrite = {
                                                                actions = {
                                                                  {
                                                                    global = false;
                                                                    literal = false;
                                                                    regexp = "/(.*)";
                                                                    case_insensitive = false;
                                                                    rewrite = "/yandex-kinopoisk-providers-popup-www-static/%1";
                                                                  };
                                                                }; -- actions
                                                                response_headers = {
                                                                  create = {
                                                                    ["Access-Control-Allow-Origin"] = "*";
                                                                    ["Cache-Control"] = "public";
                                                                  }; -- create
                                                                  shared = {
                                                                    uuid = "static_kp_yandex_net_common";
                                                                    shared = {
                                                                      uuid = "177686509217163545";
                                                                    }; -- shared
                                                                  }; -- shared
                                                                }; -- response_headers
                                                              }; -- rewrite
                                                            }; -- headers
                                                          }; -- shared
                                                        }; -- report
                                                      }; -- static_kp_yandex_net
                                                      default = {
                                                        
                                                        shared = {
                                                          uuid = "7101341086594050669";
                                                        }; -- shared
                                                      }; -- default
                                                    }; -- regexp_path
                                                  }; -- static_kp_yandex_net
                                                  site_yandex_net = {
                                                    priority = 11;
                                                    match_fsm = {
                                                      header = {
                                                        name = "Host";
                                                        value = "site\\.yandex\\.net";
                                                      }; -- header
                                                      case_insensitive = true;
                                                      surround = false;
                                                    }; -- match_fsm
                                                    regexp_path = {
                                                      all_root_redir = {
                                                        priority = 10;
                                                        pattern = "(/)?";
                                                        case_insensitive = true;
                                                        shared = {
                                                          uuid = "4050231810825788227";
                                                        }; -- shared
                                                      }; -- all_root_redir
                                                      all_errors_table = {
                                                        priority = 9;
                                                        pattern = "/errors_table/(.*)";
                                                        case_insensitive = true;
                                                        shared = {
                                                          uuid = "8384648238129770771";
                                                        }; -- shared
                                                      }; -- all_errors_table
                                                      all_favicon_ico = {
                                                        priority = 8;
                                                        pattern = "/favicon.ico(.*)";
                                                        case_insensitive = true;
                                                        shared = {
                                                          uuid = "264806882395022933";
                                                        }; -- shared
                                                      }; -- all_favicon_ico
                                                      all_google_verification = {
                                                        priority = 7;
                                                        pattern = "/google(.*)";
                                                        case_insensitive = true;
                                                        shared = {
                                                          uuid = "758824134262716168";
                                                        }; -- shared
                                                      }; -- all_google_verification
                                                      all_nearest_js = {
                                                        priority = 6;
                                                        pattern = "/nearest.js(.*)";
                                                        case_insensitive = true;
                                                        shared = {
                                                          uuid = "2837673959647856177";
                                                        }; -- shared
                                                      }; -- all_nearest_js
                                                      ["all_robots-txt"] = {
                                                        priority = 5;
                                                        pattern = "/robots.txt.*";
                                                        case_insensitive = true;
                                                        shared = {
                                                          uuid = "7592105171323000633";
                                                        }; -- shared
                                                      }; -- ["all_robots-txt"]
                                                      all_ssle_gif = {
                                                        priority = 4;
                                                        pattern = "/_ssle.gif(.*)";
                                                        case_insensitive = true;
                                                        shared = {
                                                          uuid = "6807314109941869051";
                                                        }; -- shared
                                                      }; -- all_ssle_gif
                                                      ["all_yandex-apps-api"] = {
                                                        priority = 3;
                                                        pattern = ".*/yandex-apps-api/__webview-intercepted/_api.js.*";
                                                        case_insensitive = true;
                                                        shared = {
                                                          uuid = "5657162669462195568";
                                                        }; -- shared
                                                      }; -- ["all_yandex-apps-api"]
                                                      site_yandex_net = {
                                                        priority = 2;
                                                        pattern = "/(.*)?";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "site_yandex_net";
                                                          ranges = get_str_var("default_ranges");
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          headers = {
                                                            create = {
                                                              Host = "yastatic.net";
                                                            }; -- create
                                                            regexp_path = {
                                                              v20 = {
                                                                priority = 5;
                                                                pattern = "/v2.0(.*)";
                                                                case_insensitive = true;
                                                                rewrite = {
                                                                  actions = {
                                                                    {
                                                                      global = false;
                                                                      literal = false;
                                                                      regexp = "/(.*)";
                                                                      case_insensitive = false;
                                                                      rewrite = "/s3/webmaster/siteform/%1";
                                                                    };
                                                                  }; -- actions
                                                                  shared = {
                                                                    uuid = "yastatic_net_s3_webmaster";
                                                                  }; -- shared
                                                                }; -- rewrite
                                                              }; -- v20
                                                              i = {
                                                                priority = 4;
                                                                pattern = "/i(.*)";
                                                                case_insensitive = true;
                                                                shared = {
                                                                  uuid = "2504696701831615202";
                                                                  response_headers = {
                                                                    delete = "cache-control|access-control-allow-origin|timing-allow-origin|expires";
                                                                    create = {
                                                                      ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                                    }; -- create
                                                                    shared = {
                                                                      uuid = "3634392930332335740";
                                                                      shared = {
                                                                        uuid = "site_yandex_net_common";
                                                                      }; -- shared
                                                                    }; -- shared
                                                                  }; -- response_headers
                                                                }; -- shared
                                                              }; -- i
                                                              js = {
                                                                priority = 3;
                                                                pattern = "/js(.*)";
                                                                case_insensitive = true;
                                                                shared = {
                                                                  uuid = "2504696701831615202";
                                                                }; -- shared
                                                              }; -- js
                                                              load = {
                                                                priority = 2;
                                                                pattern = "/load(.*)";
                                                                case_insensitive = true;
                                                                response_headers = {
                                                                  delete = "access-control-allow-origin|timing-allow-origin|strict-transport-security";
                                                                  create = {
                                                                    ["Cache-Control"] = "no-cache, must-revalidate";
                                                                    Expires = "Mon, 26 Jul 1997 05:00:00 GMT";
                                                                  }; -- create
                                                                  shared = {
                                                                    uuid = "3634392930332335740";
                                                                  }; -- shared
                                                                }; -- response_headers
                                                              }; -- load
                                                              default = {
                                                                shared = {
                                                                  uuid = "site_yandex_net_common";
                                                                  rewrite = {
                                                                    actions = {
                                                                      {
                                                                        global = false;
                                                                        literal = false;
                                                                        regexp = "/(.*)";
                                                                        rewrite = "/site/%1";
                                                                        case_insensitive = false;
                                                                      };
                                                                    }; -- actions
                                                                    shared = {
                                                                      uuid = "yastatic_net_s3_site_v2";
                                                                    }; -- shared
                                                                  }; -- rewrite
                                                                }; -- shared
                                                              }; -- default
                                                            }; -- regexp_path
                                                          }; -- headers
                                                        }; -- report
                                                      }; -- site_yandex_net
                                                      default = {
                                                        
                                                        shared = {
                                                          uuid = "7101341086594050669";
                                                        }; -- shared
                                                      }; -- default
                                                    }; -- regexp_path
                                                  }; -- site_yandex_net
                                                  cards2_static_yandex_net = {
                                                    priority = 10;
                                                    match_fsm = {
                                                      header = {
                                                        name = "Host";
                                                        value = "cards2-static\\.yandex\\.net";
                                                      }; -- header
                                                      case_insensitive = true;
                                                      surround = false;
                                                    }; -- match_fsm
                                                    regexp_path = {
                                                      all_root_redir = {
                                                        priority = 10;
                                                        pattern = "(/)?";
                                                        case_insensitive = true;
                                                        shared = {
                                                          uuid = "4050231810825788227";
                                                        }; -- shared
                                                      }; -- all_root_redir
                                                      all_errors_table = {
                                                        priority = 9;
                                                        pattern = "/errors_table/(.*)";
                                                        case_insensitive = true;
                                                        shared = {
                                                          uuid = "8384648238129770771";
                                                        }; -- shared
                                                      }; -- all_errors_table
                                                      all_favicon_ico = {
                                                        priority = 8;
                                                        pattern = "/favicon.ico(.*)";
                                                        case_insensitive = true;
                                                        shared = {
                                                          uuid = "264806882395022933";
                                                        }; -- shared
                                                      }; -- all_favicon_ico
                                                      all_google_verification = {
                                                        priority = 7;
                                                        pattern = "/google(.*)";
                                                        case_insensitive = true;
                                                        shared = {
                                                          uuid = "758824134262716168";
                                                        }; -- shared
                                                      }; -- all_google_verification
                                                      all_nearest_js = {
                                                        priority = 6;
                                                        pattern = "/nearest.js(.*)";
                                                        case_insensitive = true;
                                                        shared = {
                                                          uuid = "2837673959647856177";
                                                        }; -- shared
                                                      }; -- all_nearest_js
                                                      ["all_robots-txt"] = {
                                                        priority = 5;
                                                        pattern = "/robots.txt.*";
                                                        case_insensitive = true;
                                                        shared = {
                                                          uuid = "7592105171323000633";
                                                        }; -- shared
                                                      }; -- ["all_robots-txt"]
                                                      all_ssle_gif = {
                                                        priority = 4;
                                                        pattern = "/_ssle.gif(.*)";
                                                        case_insensitive = true;
                                                        shared = {
                                                          uuid = "6807314109941869051";
                                                        }; -- shared
                                                      }; -- all_ssle_gif
                                                      ["all_yandex-apps-api"] = {
                                                        priority = 3;
                                                        pattern = ".*/yandex-apps-api/__webview-intercepted/_api.js.*";
                                                        case_insensitive = true;
                                                        shared = {
                                                          uuid = "5657162669462195568";
                                                        }; -- shared
                                                      }; -- ["all_yandex-apps-api"]
                                                      cards2_static_yandex_net = {
                                                        priority = 2;
                                                        pattern = "(/.*)?";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "cards2_static_yandex_net";
                                                          ranges = get_str_var("default_ranges");
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          shared = {
                                                            uuid = "cards2_static_yandex_net";
                                                            response_headers = {
                                                              delete = "cache-control|timing-allow-origin|access-control-allow-origin|expires";
                                                              create = {
                                                                ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                              }; -- create
                                                              headers = {
                                                                create = {
                                                                  Host = "yastatic.s3.yandex.net";
                                                                }; -- create
                                                                rewrite = {
                                                                  actions = {
                                                                    {
                                                                      global = false;
                                                                      literal = false;
                                                                      regexp = "/(.*)";
                                                                      case_insensitive = false;
                                                                      rewrite = "/corba-cards/%1";
                                                                    };
                                                                  }; -- actions
                                                                  shared = {
                                                                    uuid = "cards2_static_yandex_net_common";
                                                                    headers = {
                                                                      delete = "authorization|accept-encoding";
                                                                      shared = {
                                                                        uuid = "8416769305831316651";
                                                                      }; -- shared
                                                                    }; -- headers
                                                                  }; -- shared
                                                                }; -- rewrite
                                                              }; -- headers
                                                            }; -- response_headers
                                                          }; -- shared
                                                        }; -- report
                                                      }; -- cards2_static_yandex_net
                                                      default = {
                                                        
                                                        shared = {
                                                          uuid = "7101341086594050669";
                                                        }; -- shared
                                                      }; -- default
                                                    }; -- regexp_path
                                                  }; -- cards2_static_yandex_net
                                                  default_avatars_yandex_net = {
                                                    priority = 9;
                                                    match_or = {
                                                      {
                                                        match_fsm = {
                                                          header = {
                                                            name = "Host";
                                                            value = "default\\.avatars(\\.rcstatic\\.|\\.betastatic\\.|\\.prestatic\\.|\\.)yandex\\.(ru|net)";
                                                          }; -- header
                                                          case_insensitive = true;
                                                          surround = false;
                                                        }; -- match_fsm
                                                      };
                                                      {
                                                        match_fsm = {
                                                          header = {
                                                            name = "Host";
                                                            value = "avatars\\.static\\.([a-zA-Z]+\\.)?yandex\\.net";
                                                          }; -- header
                                                          case_insensitive = true;
                                                          surround = false;
                                                        }; -- match_fsm
                                                      };
                                                      {
                                                        match_fsm = {
                                                          header = {
                                                            name = "Host";
                                                            value = "avatars\\.yandex\\.net";
                                                          }; -- header
                                                          case_insensitive = true;
                                                          surround = false;
                                                        }; -- match_fsm
                                                      };
                                                    }; -- match_or
                                                    regexp_path = {
                                                      all_root_redir = {
                                                        priority = 10;
                                                        pattern = "(/)?";
                                                        case_insensitive = true;
                                                        shared = {
                                                          uuid = "4050231810825788227";
                                                        }; -- shared
                                                      }; -- all_root_redir
                                                      all_errors_table = {
                                                        priority = 9;
                                                        pattern = "/errors_table/(.*)";
                                                        case_insensitive = true;
                                                        shared = {
                                                          uuid = "8384648238129770771";
                                                        }; -- shared
                                                      }; -- all_errors_table
                                                      all_favicon_ico = {
                                                        priority = 8;
                                                        pattern = "/favicon.ico(.*)";
                                                        case_insensitive = true;
                                                        shared = {
                                                          uuid = "264806882395022933";
                                                        }; -- shared
                                                      }; -- all_favicon_ico
                                                      all_google_verification = {
                                                        priority = 7;
                                                        pattern = "/google(.*)";
                                                        case_insensitive = true;
                                                        shared = {
                                                          uuid = "758824134262716168";
                                                        }; -- shared
                                                      }; -- all_google_verification
                                                      all_nearest_js = {
                                                        priority = 6;
                                                        pattern = "/nearest.js(.*)";
                                                        case_insensitive = true;
                                                        shared = {
                                                          uuid = "2837673959647856177";
                                                        }; -- shared
                                                      }; -- all_nearest_js
                                                      ["all_robots-txt"] = {
                                                        priority = 5;
                                                        pattern = "/robots.txt.*";
                                                        case_insensitive = true;
                                                        shared = {
                                                          uuid = "7592105171323000633";
                                                        }; -- shared
                                                      }; -- ["all_robots-txt"]
                                                      all_ssle_gif = {
                                                        priority = 4;
                                                        pattern = "/_ssle.gif(.*)";
                                                        case_insensitive = true;
                                                        shared = {
                                                          uuid = "6807314109941869051";
                                                        }; -- shared
                                                      }; -- all_ssle_gif
                                                      ["all_yandex-apps-api"] = {
                                                        priority = 3;
                                                        pattern = ".*/yandex-apps-api/__webview-intercepted/_api.js.*";
                                                        case_insensitive = true;
                                                        shared = {
                                                          uuid = "5657162669462195568";
                                                        }; -- shared
                                                      }; -- ["all_yandex-apps-api"]
                                                      default_avatars_yandex_net = {
                                                        priority = 2;
                                                        pattern = "(/.*)?";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "default_avatars_yandex_net";
                                                          ranges = get_str_var("default_ranges");
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          shared = {
                                                            uuid = "default_avatars_yandex_net";
                                                            headers = {
                                                              create = {
                                                                Host = "yastatic.net";
                                                              }; -- create
                                                              rewrite = {
                                                                actions = {
                                                                  {
                                                                    global = false;
                                                                    literal = false;
                                                                    rewrite = "%1/%2.png";
                                                                    case_insensitive = false;
                                                                    regexp = "^(.+)/([^\\?\\.]+)(\\?.*)?$";
                                                                  };
                                                                  {
                                                                    global = false;
                                                                    literal = false;
                                                                    regexp = "/(.*)";
                                                                    case_insensitive = false;
                                                                    rewrite = "/iso-avatars/%1";
                                                                  };
                                                                }; -- actions
                                                                response_headers = {
                                                                  delete = "timing-allow-origin|access-control-allow-origin|cache-control|expires";
                                                                  create = {
                                                                    ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                                  }; -- create
                                                                  shared = {
                                                                    uuid = "yastatic_net_s3_iso-avatars";
                                                                  }; -- shared
                                                                }; -- response_headers
                                                              }; -- rewrite
                                                            }; -- headers
                                                          }; -- shared
                                                        }; -- report
                                                      }; -- default_avatars_yandex_net
                                                      default = {
                                                        
                                                        shared = {
                                                          uuid = "7101341086594050669";
                                                        }; -- shared
                                                      }; -- default
                                                    }; -- regexp_path
                                                  }; -- default_avatars_yandex_net
                                                  ["img-css_friends_yandex_net"] = {
                                                    priority = 8;
                                                    match_or = {
                                                      {
                                                        match_fsm = {
                                                          header = {
                                                            name = "Host";
                                                            value = "img-css\\.friends\\.yandex\\.net";
                                                          }; -- header
                                                          case_insensitive = true;
                                                          surround = false;
                                                        }; -- match_fsm
                                                      };
                                                      {
                                                        match_fsm = {
                                                          header = {
                                                            name = "Host";
                                                            value = "img-css\\.friends\\.([a-zA-Z0-9]+)\\.yandex\\.(ru|net)";
                                                          }; -- header
                                                          case_insensitive = true;
                                                          surround = false;
                                                        }; -- match_fsm
                                                      };
                                                    }; -- match_or
                                                    regexp_path = {
                                                      all_root_redir = {
                                                        priority = 11;
                                                        pattern = "(/)?";
                                                        case_insensitive = true;
                                                        shared = {
                                                          uuid = "4050231810825788227";
                                                        }; -- shared
                                                      }; -- all_root_redir
                                                      ["img-css_friends_yandex_net_img-css-friends"] = {
                                                        priority = 10;
                                                        pattern = "/(.+)";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "img-css_friends_yandex_net_img-css-friends";
                                                          ranges = get_str_var("default_ranges");
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          shared = {
                                                            uuid = "img-css_friends_yandex_net_img-css-friends";
                                                            headers = {
                                                              delete = "accept-encoding";
                                                              create = {
                                                                Host = "yastatic.net";
                                                              }; -- create
                                                              rewrite = {
                                                                actions = {
                                                                  {
                                                                    global = false;
                                                                    literal = false;
                                                                    regexp = "/(.*)";
                                                                    case_insensitive = false;
                                                                    rewrite = "/img-css-friends/%1";
                                                                  };
                                                                }; -- actions
                                                                response_headers = {
                                                                  delete = "timing-allow-origin|cache-control|access-control-allow-origin";
                                                                  create_func = {
                                                                    Expires = "time:+6m";
                                                                  }; -- create_func
                                                                  create = {
                                                                    ["Cache-Control"] = "public, max-age=360";
                                                                    ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                                  }; -- create
                                                                  shared = {
                                                                    uuid = "2060916621982072321";
                                                                  }; -- shared
                                                                }; -- response_headers
                                                              }; -- rewrite
                                                            }; -- headers
                                                          }; -- shared
                                                        }; -- report
                                                      }; -- ["img-css_friends_yandex_net_img-css-friends"]
                                                      all_errors_table = {
                                                        priority = 9;
                                                        pattern = "/errors_table/(.*)";
                                                        case_insensitive = true;
                                                        shared = {
                                                          uuid = "8384648238129770771";
                                                        }; -- shared
                                                      }; -- all_errors_table
                                                      all_favicon_ico = {
                                                        priority = 8;
                                                        pattern = "/favicon.ico(.*)";
                                                        case_insensitive = true;
                                                        shared = {
                                                          uuid = "264806882395022933";
                                                        }; -- shared
                                                      }; -- all_favicon_ico
                                                      all_google_verification = {
                                                        priority = 7;
                                                        pattern = "/google(.*)";
                                                        case_insensitive = true;
                                                        shared = {
                                                          uuid = "758824134262716168";
                                                        }; -- shared
                                                      }; -- all_google_verification
                                                      all_nearest_js = {
                                                        priority = 6;
                                                        pattern = "/nearest.js(.*)";
                                                        case_insensitive = true;
                                                        shared = {
                                                          uuid = "2837673959647856177";
                                                        }; -- shared
                                                      }; -- all_nearest_js
                                                      ["all_robots-txt"] = {
                                                        priority = 5;
                                                        pattern = "/robots.txt.*";
                                                        case_insensitive = true;
                                                        shared = {
                                                          uuid = "7592105171323000633";
                                                        }; -- shared
                                                      }; -- ["all_robots-txt"]
                                                      all_ssle_gif = {
                                                        priority = 4;
                                                        pattern = "/_ssle.gif(.*)";
                                                        case_insensitive = true;
                                                        shared = {
                                                          uuid = "6807314109941869051";
                                                        }; -- shared
                                                      }; -- all_ssle_gif
                                                      ["all_yandex-apps-api"] = {
                                                        priority = 3;
                                                        pattern = ".*/yandex-apps-api/__webview-intercepted/_api.js.*";
                                                        case_insensitive = true;
                                                        shared = {
                                                          uuid = "5657162669462195568";
                                                        }; -- shared
                                                      }; -- ["all_yandex-apps-api"]
                                                      ["img-css_friends_yandex_net_root"] = {
                                                        priority = 2;
                                                        pattern = "/";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "img-css_friends_yandex_net_root";
                                                          ranges = get_str_var("default_ranges");
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          shared = {
                                                            uuid = "img-css_friends_yandex_net_root";
                                                            errordocument = {
                                                              status = 403;
                                                              force_conn_close = false;
                                                            }; -- errordocument
                                                          }; -- shared
                                                        }; -- report
                                                      }; -- ["img-css_friends_yandex_net_root"]
                                                      default = {
                                                        
                                                        shared = {
                                                          uuid = "7101341086594050669";
                                                        }; -- shared
                                                      }; -- default
                                                    }; -- regexp_path
                                                  }; -- ["img-css_friends_yandex_net"]
                                                  swf_static_yandex_net = {
                                                    priority = 7;
                                                    match_or = {
                                                      {
                                                        match_fsm = {
                                                          header = {
                                                            name = "Host";
                                                            value = "nginx_proxy\\.yandex\\.st";
                                                          }; -- header
                                                          case_insensitive = true;
                                                          surround = false;
                                                        }; -- match_fsm
                                                      };
                                                      {
                                                        match_fsm = {
                                                          header = {
                                                            name = "Host";
                                                            value = "nginx_proxy\\.yastatic\\.net";
                                                          }; -- header
                                                          case_insensitive = true;
                                                          surround = false;
                                                        }; -- match_fsm
                                                      };
                                                      {
                                                        match_fsm = {
                                                          header = {
                                                            name = "Host";
                                                            value = "flash\\.dev\\.yandex\\.net";
                                                          }; -- header
                                                          case_insensitive = true;
                                                          surround = false;
                                                        }; -- match_fsm
                                                      };
                                                      {
                                                        match_fsm = {
                                                          header = {
                                                            name = "Host";
                                                            value = "static\\.music\\.yandex\\.net";
                                                          }; -- header
                                                          case_insensitive = true;
                                                          surround = false;
                                                        }; -- match_fsm
                                                      };
                                                      {
                                                        match_fsm = {
                                                          header = {
                                                            name = "Host";
                                                            value = "audio\\.lingvo\\.yandex\\.net";
                                                          }; -- header
                                                          case_insensitive = true;
                                                          surround = false;
                                                        }; -- match_fsm
                                                      };
                                                      {
                                                        match_fsm = {
                                                          header = {
                                                            name = "Host";
                                                            value = "audio\\.lingvo\\.([a-zA-Z0-9\\-]+)\\.yandex\\.(ru|net)";
                                                          }; -- header
                                                          case_insensitive = true;
                                                          surround = false;
                                                        }; -- match_fsm
                                                      };
                                                      {
                                                        match_fsm = {
                                                          header = {
                                                            name = "Host";
                                                            value = "verdict\\.(pre|beta|rc)?static\\.yandex\\.net";
                                                          }; -- header
                                                          case_insensitive = true;
                                                          surround = false;
                                                        }; -- match_fsm
                                                      };
                                                      {
                                                        match_fsm = {
                                                          header = {
                                                            name = "Host";
                                                            value = "swf\\.([a-zA-Z0-9]+\\.)?(yandex\\.st|yastatic\\.net)";
                                                          }; -- header
                                                          case_insensitive = true;
                                                          surround = false;
                                                        }; -- match_fsm
                                                      };
                                                      {
                                                        match_fsm = {
                                                          header = {
                                                            name = "Host";
                                                            value = "swf\\.static\\.([a-zA-Z0-9]+\\.)?yandex\\.net";
                                                          }; -- header
                                                          case_insensitive = true;
                                                          surround = false;
                                                        }; -- match_fsm
                                                      };
                                                    }; -- match_or
                                                    regexp = {
                                                      swf_static_yandex_net = {
                                                        priority = 3;
                                                        match_and = {
                                                          {
                                                            match_fsm = {
                                                              header = {
                                                                name = "Host";
                                                                value = "swf\\.static\\.yandex\\.net";
                                                              }; -- header
                                                              case_insensitive = true;
                                                              surround = false;
                                                            }; -- match_fsm
                                                          };
                                                          {
                                                            match_not = {
                                                              match_fsm = {
                                                                path = "/crossdomain(.*)?";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- match_not
                                                          };
                                                        }; -- match_and
                                                        rewrite = {
                                                          actions = {
                                                            {
                                                              global = false;
                                                              literal = false;
                                                              regexp = "/(.*)";
                                                              rewrite = "/swf/%1";
                                                              case_insensitive = false;
                                                            };
                                                          }; -- actions
                                                          shared = {
                                                            uuid = "278394290461159114";
                                                            shared = {
                                                              uuid = "swf_static_yandex_net_shared";
                                                            }; -- shared
                                                          }; -- shared
                                                        }; -- rewrite
                                                      }; -- swf_static_yandex_net
                                                      audio_lingvo_yandex_net = {
                                                        priority = 2;
                                                        match_and = {
                                                          {
                                                            match_fsm = {
                                                              header = {
                                                                name = "Host";
                                                                value = "audio\\.lingvo\\.yandex\\.net";
                                                              }; -- header
                                                              case_insensitive = true;
                                                              surround = false;
                                                            }; -- match_fsm
                                                          };
                                                          {
                                                            match_not = {
                                                              match_fsm = {
                                                                path = "/crossdomain(.*)?";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- match_not
                                                          };
                                                        }; -- match_and
                                                        rewrite = {
                                                          actions = {
                                                            {
                                                              global = false;
                                                              literal = false;
                                                              regexp = "/(.*)";
                                                              case_insensitive = false;
                                                              rewrite = "/yandex-slovari-lingvo-player6-swf/%1";
                                                            };
                                                          }; -- actions
                                                          shared = {
                                                            uuid = "278394290461159114";
                                                          }; -- shared
                                                        }; -- rewrite
                                                      }; -- audio_lingvo_yandex_net
                                                      default = {
                                                        priority = 1;
                                                        shared = {
                                                          uuid = "swf_static_yandex_net_shared";
                                                          regexp_path = {
                                                            all_root_redir = {
                                                              priority = 12;
                                                              pattern = "(/)?";
                                                              case_insensitive = true;
                                                              shared = {
                                                                uuid = "4050231810825788227";
                                                              }; -- shared
                                                            }; -- all_root_redir
                                                            all_errors_table = {
                                                              priority = 11;
                                                              pattern = "/errors_table/(.*)";
                                                              case_insensitive = true;
                                                              shared = {
                                                                uuid = "8384648238129770771";
                                                              }; -- shared
                                                            }; -- all_errors_table
                                                            all_favicon_ico = {
                                                              priority = 10;
                                                              pattern = "/favicon.ico(.*)";
                                                              case_insensitive = true;
                                                              shared = {
                                                                uuid = "264806882395022933";
                                                              }; -- shared
                                                            }; -- all_favicon_ico
                                                            all_google_verification = {
                                                              priority = 9;
                                                              pattern = "/google(.*)";
                                                              case_insensitive = true;
                                                              shared = {
                                                                uuid = "758824134262716168";
                                                              }; -- shared
                                                            }; -- all_google_verification
                                                            all_nearest_js = {
                                                              priority = 8;
                                                              pattern = "/nearest.js(.*)";
                                                              case_insensitive = true;
                                                              shared = {
                                                                uuid = "2837673959647856177";
                                                              }; -- shared
                                                            }; -- all_nearest_js
                                                            ["all_robots-txt"] = {
                                                              priority = 7;
                                                              pattern = "/robots.txt.*";
                                                              case_insensitive = true;
                                                              shared = {
                                                                uuid = "7592105171323000633";
                                                              }; -- shared
                                                            }; -- ["all_robots-txt"]
                                                            all_ssle_gif = {
                                                              priority = 6;
                                                              pattern = "/_ssle.gif(.*)";
                                                              case_insensitive = true;
                                                              shared = {
                                                                uuid = "6807314109941869051";
                                                              }; -- shared
                                                            }; -- all_ssle_gif
                                                            ["all_yandex-apps-api"] = {
                                                              priority = 5;
                                                              pattern = ".*/yandex-apps-api/__webview-intercepted/_api.js.*";
                                                              case_insensitive = true;
                                                              shared = {
                                                                uuid = "5657162669462195568";
                                                              }; -- shared
                                                            }; -- ["all_yandex-apps-api"]
                                                            ["swf_static_yandex_net_s3_crossdomain-xml"] = {
                                                              priority = 4;
                                                              pattern = "/crossdomain-xml(/.*)?";
                                                              case_insensitive = true;
                                                              report = {
                                                                uuid = "swf_static_yandex_net_s3_crossdomain-xml";
                                                                ranges = get_str_var("default_ranges");
                                                                just_storage = false;
                                                                disable_robotness = true;
                                                                disable_sslness = true;
                                                                events = {
                                                                  stats = "report";
                                                                }; -- events
                                                                shared = {
                                                                  uuid = "swf_static_yandex_net_s3_crossdomain-xml";
                                                                  headers = {
                                                                    create = {
                                                                      Host = "yastatic.s3.yandex.net";
                                                                    }; -- create
                                                                    response_headers = {
                                                                      delete = "cache-control|access-control-allow-origin|strict-transport-security|timing-allow-origin|expires";
                                                                      create_func = {
                                                                        Expires = "time:+1h";
                                                                      }; -- create_func
                                                                      create = {
                                                                        ["Cache-Control"] = "public, max-age=216013";
                                                                      }; -- create
                                                                      shared = {
                                                                        uuid = "1781853103362096270";
                                                                      }; -- shared
                                                                    }; -- response_headers
                                                                  }; -- headers
                                                                }; -- shared
                                                              }; -- report
                                                            }; -- ["swf_static_yandex_net_s3_crossdomain-xml"]
                                                            swf_static_yandex_net_s3_swf = {
                                                              priority = 3;
                                                              pattern = "/swf(/.*)?";
                                                              case_insensitive = true;
                                                              report = {
                                                                uuid = "swf_static_yandex_net_s3_swf";
                                                                ranges = get_str_var("default_ranges");
                                                                just_storage = false;
                                                                disable_robotness = true;
                                                                disable_sslness = true;
                                                                events = {
                                                                  stats = "report";
                                                                }; -- events
                                                                shared = {
                                                                  uuid = "swf_static_yandex_net_s3_swf";
                                                                  headers = {
                                                                    create = {
                                                                      Host = "yastatic.s3.yandex.net";
                                                                    }; -- create
                                                                    response_headers = {
                                                                      delete = "cache-control|access-control-allow-origin|strict-transport-security|timing-allow-origin|expires";
                                                                      create_func = {
                                                                        Expires = "time:+216001s";
                                                                      }; -- create_func
                                                                      create = {
                                                                        ["Cache-Control"] = "public, max-age=216013";
                                                                      }; -- create
                                                                      shared = {
                                                                        uuid = "2060916621982072321";
                                                                      }; -- shared
                                                                    }; -- response_headers
                                                                  }; -- headers
                                                                }; -- shared
                                                              }; -- report
                                                            }; -- swf_static_yandex_net_s3_swf
                                                            ["swf_static_yandex_net_s3_yandex-slovari-lingvo-player6-swf"] = {
                                                              priority = 2;
                                                              pattern = "/yandex-slovari-lingvo-player6-swf(/.*)?";
                                                              case_insensitive = true;
                                                              report = {
                                                                uuid = "swf_static_yandex_net_s3_yandex-slovari-lingvo-player6-swf";
                                                                ranges = get_str_var("default_ranges");
                                                                just_storage = false;
                                                                disable_robotness = true;
                                                                disable_sslness = true;
                                                                events = {
                                                                  stats = "report";
                                                                }; -- events
                                                                shared = {
                                                                  uuid = "swf_static_yandex_net_s3_yandex-slovari-lingvo-player6-swf";
                                                                  headers = {
                                                                    create = {
                                                                      Host = "yastatic.s3.yandex.net";
                                                                    }; -- create
                                                                    response_headers = {
                                                                      delete = "cache-control|access-control-allow-origin|strict-transport-security|timing-allow-origin|expires";
                                                                      create_func = {
                                                                        Expires = "time:+216009s";
                                                                      }; -- create_func
                                                                      shared = {
                                                                        uuid = "yastatic_net_s3_yandex-slovari-lingvo-player6-swf";
                                                                      }; -- shared
                                                                    }; -- response_headers
                                                                  }; -- headers
                                                                }; -- shared
                                                              }; -- report
                                                            }; -- ["swf_static_yandex_net_s3_yandex-slovari-lingvo-player6-swf"]
                                                            default = {
                                                              
                                                              shared = {
                                                                uuid = "7101341086594050669";
                                                              }; -- shared
                                                            }; -- default
                                                          }; -- regexp_path
                                                        }; -- shared
                                                      }; -- default
                                                    }; -- regexp
                                                  }; -- swf_static_yandex_net
                                                  static_rasp_yandex_net = {
                                                    priority = 6;
                                                    match_or = {
                                                      {
                                                        match_fsm = {
                                                          header = {
                                                            name = "Host";
                                                            value = "static\\.rasp\\.yandex\\.(net|ru|ua|kz)";
                                                          }; -- header
                                                          case_insensitive = true;
                                                          surround = false;
                                                        }; -- match_fsm
                                                      };
                                                      {
                                                        match_fsm = {
                                                          header = {
                                                            name = "Host";
                                                            value = "static\\.rasp\\.([a-zA-Z0-9]+)\\.yandex\\.(net|ru|ua|kz)";
                                                          }; -- header
                                                          case_insensitive = true;
                                                          surround = false;
                                                        }; -- match_fsm
                                                      };
                                                    }; -- match_or
                                                    rewrite = {
                                                      actions = {
                                                        {
                                                          global = false;
                                                          rewrite = "%1";
                                                          literal = false;
                                                          case_insensitive = false;
                                                          regexp = "^/[\\d.]+(/data/.*)$";
                                                        };
                                                        {
                                                          global = false;
                                                          rewrite = "%1";
                                                          literal = false;
                                                          case_insensitive = false;
                                                          regexp = "^/[\\d.]+(/apicc/.*)$";
                                                        };
                                                      }; -- actions
                                                      regexp_path = {
                                                        all_root_redir = {
                                                          priority = 11;
                                                          pattern = "(/)?";
                                                          case_insensitive = true;
                                                          shared = {
                                                            uuid = "4050231810825788227";
                                                          }; -- shared
                                                        }; -- all_root_redir
                                                        static_rasp_yandex_net_admin = {
                                                          priority = 10;
                                                          pattern = "/admin(.*)?";
                                                          case_insensitive = true;
                                                          report = {
                                                            uuid = "static_rasp_yandex_net_admin";
                                                            ranges = get_str_var("default_ranges");
                                                            just_storage = false;
                                                            disable_robotness = true;
                                                            disable_sslness = true;
                                                            events = {
                                                              stats = "report";
                                                            }; -- events
                                                            response_headers = {
                                                              create = {
                                                                Location = "http://www.yandex.ru/";
                                                              }; -- create
                                                              errordocument = {
                                                                status = 302;
                                                                force_conn_close = false;
                                                              }; -- errordocument
                                                            }; -- response_headers
                                                          }; -- report
                                                        }; -- static_rasp_yandex_net_admin
                                                        all_errors_table = {
                                                          priority = 9;
                                                          pattern = "/errors_table/(.*)";
                                                          case_insensitive = true;
                                                          shared = {
                                                            uuid = "8384648238129770771";
                                                          }; -- shared
                                                        }; -- all_errors_table
                                                        all_favicon_ico = {
                                                          priority = 8;
                                                          pattern = "/favicon.ico(.*)";
                                                          case_insensitive = true;
                                                          shared = {
                                                            uuid = "264806882395022933";
                                                          }; -- shared
                                                        }; -- all_favicon_ico
                                                        all_google_verification = {
                                                          priority = 7;
                                                          pattern = "/google(.*)";
                                                          case_insensitive = true;
                                                          shared = {
                                                            uuid = "758824134262716168";
                                                          }; -- shared
                                                        }; -- all_google_verification
                                                        all_nearest_js = {
                                                          priority = 6;
                                                          pattern = "/nearest.js(.*)";
                                                          case_insensitive = true;
                                                          shared = {
                                                            uuid = "2837673959647856177";
                                                          }; -- shared
                                                        }; -- all_nearest_js
                                                        ["all_robots-txt"] = {
                                                          priority = 5;
                                                          pattern = "/robots.txt.*";
                                                          case_insensitive = true;
                                                          shared = {
                                                            uuid = "7592105171323000633";
                                                          }; -- shared
                                                        }; -- ["all_robots-txt"]
                                                        all_ssle_gif = {
                                                          priority = 4;
                                                          pattern = "/_ssle.gif(.*)";
                                                          case_insensitive = true;
                                                          shared = {
                                                            uuid = "6807314109941869051";
                                                          }; -- shared
                                                        }; -- all_ssle_gif
                                                        ["all_yandex-apps-api"] = {
                                                          priority = 3;
                                                          pattern = ".*/yandex-apps-api/__webview-intercepted/_api.js.*";
                                                          case_insensitive = true;
                                                          shared = {
                                                            uuid = "5657162669462195568";
                                                          }; -- shared
                                                        }; -- ["all_yandex-apps-api"]
                                                        static_rasp_yandex_net_data = {
                                                          priority = 2;
                                                          pattern = "/data(/.*)?";
                                                          case_insensitive = true;
                                                          report = {
                                                            uuid = "static_rasp_yandex_net_data";
                                                            ranges = get_str_var("default_ranges");
                                                            just_storage = false;
                                                            disable_robotness = true;
                                                            disable_sslness = true;
                                                            events = {
                                                              stats = "report";
                                                            }; -- events
                                                            response_headers = {
                                                              delete = "timing-allow-origin|access-control-allow-origin|strict-transport-security|expires";
                                                              create_func = {
                                                                Expires = "time:+1h";
                                                              }; -- create_func
                                                              create = {
                                                                ["Cache-Control"] = "max-age=3600";
                                                                ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                              }; -- create
                                                              headers = {
                                                                delete = "accept-encoding";
                                                                create = {
                                                                  Host = "yastatic.net";
                                                                }; -- create
                                                                rewrite = {
                                                                  actions = {
                                                                    {
                                                                      global = false;
                                                                      literal = false;
                                                                      regexp = "/(.*)";
                                                                      case_insensitive = false;
                                                                      rewrite = "/rasp/media/%1";
                                                                    };
                                                                  }; -- actions
                                                                  shared = {
                                                                    uuid = "2060916621982072321";
                                                                  }; -- shared
                                                                }; -- rewrite
                                                              }; -- headers
                                                            }; -- response_headers
                                                          }; -- report
                                                        }; -- static_rasp_yandex_net_data
                                                        default = {
                                                          
                                                          shared = {
                                                            uuid = "7101341086594050669";
                                                          }; -- shared
                                                        }; -- default
                                                      }; -- regexp_path
                                                    }; -- rewrite
                                                  }; -- static_rasp_yandex_net
                                                  static_yandex_net = {
                                                    priority = 5;
                                                    match_or = {
                                                      {
                                                        match_fsm = {
                                                          header = {
                                                            name = "Host";
                                                            value = "static\\.yandex\\.net";
                                                          }; -- header
                                                          case_insensitive = true;
                                                          surround = false;
                                                        }; -- match_fsm
                                                      };
                                                      {
                                                        match_fsm = {
                                                          header = {
                                                            name = "Host";
                                                            value = "static\\.([a-zA-Z0-9]+)\\.yandex.net";
                                                          }; -- header
                                                          case_insensitive = true;
                                                          surround = false;
                                                        }; -- match_fsm
                                                      };
                                                    }; -- match_or
                                                    regexp_path = {
                                                      all_root_redir = {
                                                        priority = 15;
                                                        pattern = "(/)?";
                                                        case_insensitive = true;
                                                        shared = {
                                                          uuid = "4050231810825788227";
                                                        }; -- shared
                                                      }; -- all_root_redir
                                                      all_errors_table = {
                                                        priority = 14;
                                                        pattern = "/errors_table/(.*)";
                                                        case_insensitive = true;
                                                        shared = {
                                                          uuid = "8384648238129770771";
                                                        }; -- shared
                                                      }; -- all_errors_table
                                                      all_favicon_ico = {
                                                        priority = 13;
                                                        pattern = "/favicon.ico(.*)";
                                                        case_insensitive = true;
                                                        shared = {
                                                          uuid = "264806882395022933";
                                                        }; -- shared
                                                      }; -- all_favicon_ico
                                                      all_google_verification = {
                                                        priority = 12;
                                                        pattern = "/google(.*)";
                                                        case_insensitive = true;
                                                        shared = {
                                                          uuid = "758824134262716168";
                                                        }; -- shared
                                                      }; -- all_google_verification
                                                      all_nearest_js = {
                                                        priority = 11;
                                                        pattern = "/nearest.js(.*)";
                                                        case_insensitive = true;
                                                        shared = {
                                                          uuid = "2837673959647856177";
                                                        }; -- shared
                                                      }; -- all_nearest_js
                                                      ["all_robots-txt"] = {
                                                        priority = 10;
                                                        pattern = "/robots.txt.*";
                                                        case_insensitive = true;
                                                        shared = {
                                                          uuid = "7592105171323000633";
                                                        }; -- shared
                                                      }; -- ["all_robots-txt"]
                                                      all_ssle_gif = {
                                                        priority = 9;
                                                        pattern = "/_ssle.gif(.*)";
                                                        case_insensitive = true;
                                                        shared = {
                                                          uuid = "6807314109941869051";
                                                        }; -- shared
                                                      }; -- all_ssle_gif
                                                      ["all_yandex-apps-api"] = {
                                                        priority = 8;
                                                        pattern = ".*/yandex-apps-api/__webview-intercepted/_api.js.*";
                                                        case_insensitive = true;
                                                        shared = {
                                                          uuid = "5657162669462195568";
                                                        }; -- shared
                                                      }; -- ["all_yandex-apps-api"]
                                                      static_yandex_net_s3_adtunedc = {
                                                        priority = 7;
                                                        pattern = "/(adtune|dc|mooa|reflowmeter|saas-widget|staff-card|tv|yanalytics|yobject|browser-updater)(/.*)?";
                                                        case_insensitive = true;
                                                        rewrite = {
                                                          actions = {
                                                            {
                                                              global = false;
                                                              literal = false;
                                                              rewrite = "%1/%2%3";
                                                              case_insensitive = false;
                                                              regexp = "^(/.*)?/v-[^/a-zA-Z]+/(.*)(\\?.*)?$";
                                                            };
                                                          }; -- actions
                                                          report = {
                                                            uuid = "static_yandex_net_s3_adtunedc";
                                                            ranges = get_str_var("default_ranges");
                                                            matcher_map = {
                                                              adtune = {
                                                                match_fsm = {
                                                                  path = "/adtune.*";
                                                                  case_insensitive = true;
                                                                  surround = false;
                                                                }; -- match_fsm
                                                              }; -- adtune
                                                              dc = {
                                                                match_fsm = {
                                                                  path = "/dc.*";
                                                                  case_insensitive = true;
                                                                  surround = false;
                                                                }; -- match_fsm
                                                              }; -- dc
                                                              mooa = {
                                                                match_fsm = {
                                                                  path = "/mooa.*";
                                                                  case_insensitive = true;
                                                                  surround = false;
                                                                }; -- match_fsm
                                                              }; -- mooa
                                                              reflowmeter = {
                                                                match_fsm = {
                                                                  path = "/reflowmeter.*";
                                                                  case_insensitive = true;
                                                                  surround = false;
                                                                }; -- match_fsm
                                                              }; -- reflowmeter
                                                              ["saas-widget"] = {
                                                                match_fsm = {
                                                                  path = "/saas-widget.*";
                                                                  case_insensitive = true;
                                                                  surround = false;
                                                                }; -- match_fsm
                                                              }; -- ["saas-widget"]
                                                              ["staff-card"] = {
                                                                match_fsm = {
                                                                  path = "/staff-card.*";
                                                                  case_insensitive = true;
                                                                  surround = false;
                                                                }; -- match_fsm
                                                              }; -- ["staff-card"]
                                                              tv = {
                                                                match_fsm = {
                                                                  path = "/tv.*";
                                                                  case_insensitive = true;
                                                                  surround = false;
                                                                }; -- match_fsm
                                                              }; -- tv
                                                              yanalytics = {
                                                                match_fsm = {
                                                                  path = "/yanalytics.*";
                                                                  case_insensitive = true;
                                                                  surround = false;
                                                                }; -- match_fsm
                                                              }; -- yanalytics
                                                              yobject = {
                                                                match_fsm = {
                                                                  path = "/yobject.*";
                                                                  case_insensitive = true;
                                                                  surround = false;
                                                                }; -- match_fsm
                                                              }; -- yobject
                                                              ["browser-updater"] = {
                                                                match_fsm = {
                                                                  path = "/browser-updater.*";
                                                                  case_insensitive = true;
                                                                  surround = false;
                                                                }; -- match_fsm
                                                              }; -- ["browser-updater"]
                                                            }; -- matcher_map
                                                            just_storage = false;
                                                            disable_robotness = true;
                                                            disable_sslness = true;
                                                            events = {
                                                              stats = "report";
                                                            }; -- events
                                                            shared = {
                                                              uuid = "static_yandex_net_s3_adtunedc";
                                                              response_headers = {
                                                                delete = "cache-control|access-control-allow-origin|strict-transport-security|timing-allow-origin|expires";
                                                                create = {
                                                                  ["Access-Control-Allow-Origin"] = "*";
                                                                  ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                                }; -- create
                                                                headers = {
                                                                  create = {
                                                                    Host = "yastatic.s3.yandex.net";
                                                                  }; -- create
                                                                  shared = {
                                                                    uuid = "static_yandex_net_s3_adtunedc_common";
                                                                    shared = {
                                                                      uuid = "177686509217163545";
                                                                    }; -- shared
                                                                  }; -- shared
                                                                }; -- headers
                                                              }; -- response_headers
                                                            }; -- shared
                                                          }; -- report
                                                        }; -- rewrite
                                                      }; -- static_yandex_net_s3_adtunedc
                                                      static_yandex_net_s3_checkoutkassa = {
                                                        priority = 6;
                                                        pattern = "/(checkout|kassa)(/.*)?";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "static_yandex_net_s3_checkoutkassa";
                                                          ranges = get_str_var("default_ranges");
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          shared = {
                                                            uuid = "static_yandex_net_s3_checkoutkassa";
                                                            headers = {
                                                              create = {
                                                                Host = "yastatic.s3.yandex.net";
                                                              }; -- create
                                                              rewrite = {
                                                                actions = {
                                                                  {
                                                                    global = false;
                                                                    rewrite = "%1";
                                                                    literal = false;
                                                                    case_insensitive = false;
                                                                    regexp = "([^\\?]+)(.*)";
                                                                  };
                                                                  {
                                                                    global = false;
                                                                    literal = false;
                                                                    case_insensitive = false;
                                                                    rewrite = "%1/%2/index.js";
                                                                    regexp = "^(.+/)([^/\\.]+)$";
                                                                  };
                                                                  {
                                                                    global = false;
                                                                    literal = false;
                                                                    rewrite = "%1/index.js";
                                                                    case_insensitive = false;
                                                                    regexp = "^(.+)/(\\?.*)?$";
                                                                  };
                                                                }; -- actions
                                                                response_headers = {
                                                                  delete = "cache-control|access-control-allow-origin|strict-transport-security|timing-allow-origin|expires";
                                                                  create = {
                                                                    ["Access-Control-Allow-Origin"] = "*";
                                                                    ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                                  }; -- create
                                                                  shared = {
                                                                    uuid = "static_yandex_net_s3_checkoutkassa_common";
                                                                    shared = {
                                                                      uuid = "177686509217163545";
                                                                    }; -- shared
                                                                  }; -- shared
                                                                }; -- response_headers
                                                              }; -- rewrite
                                                            }; -- headers
                                                          }; -- shared
                                                        }; -- report
                                                      }; -- static_yandex_net_s3_checkoutkassa
                                                      ["static_yandex_net_s3_crossdomain-xml"] = {
                                                        priority = 5;
                                                        pattern = "/crossdomain-xml(/.*)?";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "static_yandex_net_s3_crossdomain-xml";
                                                          ranges = get_str_var("default_ranges");
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          shared = {
                                                            uuid = "static_yandex_net_s3_crossdomain-xml";
                                                            headers = {
                                                              create = {
                                                                Host = "yastatic.s3.yandex.net";
                                                              }; -- create
                                                              response_headers = {
                                                                delete = "cache-control|access-control-allow-origin|strict-transport-security|timing-allow-origin";
                                                                create = {
                                                                  ["Cache-Control"] = "max-age=3600";
                                                                }; -- create
                                                                shared = {
                                                                  uuid = "1781853103362096270";
                                                                }; -- shared
                                                              }; -- response_headers
                                                            }; -- headers
                                                          }; -- shared
                                                        }; -- report
                                                      }; -- ["static_yandex_net_s3_crossdomain-xml"]
                                                      ["static_yandex_net_s3_expert_front-maps-static"] = {
                                                        priority = 4;
                                                        pattern = "/s3/(expert|front-maps-static|vertis-frontend|lyceum|lyceum-admission|home-static|sendbernar|auth2|distribution|logoaas|bro-bg-store|lpc|beamlight|district|e7n|dealer|festival-static|ugc|home|yablogs-wysiwyg|twenty|edadeal-public-static|zen-lib|kinopoisk-desktop-www-static|contest|vda|for-media-terminal|for-media-terminal-numbers|for-media-terminal-compare|for-media-mediajams|kinopoisk-frontend|cult-marathon|tv-frontend|new-year-2018|quasar-ui|anytask|time|gnc|translate|trbro|e-pace|for-media-specprojects|locdoc|talents|yaplus-test|montserrat|rasp|taxi-front|maps-promo|afisha-frontend|meduza|ydo|ydo-test|zen-pubs-static|subscriptions|messenger-static|pay|direct-dna|staff-card|plcn|plcn-static|mapsapi-v3|home-beta|vh-static|travel-indexer|media-platform|afisha-tickets-frontend|chat|development|passport-auth-customs|pandora|fintech-icons|magic-qr|fintech|passport-static|zen-misc|math-schbk-static|test-stories|kinopoisk-stories|music-stories|edu|sarah|edadeal-push-public)(/.*)";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "static_yandex_net_s3_expert_front-maps-static";
                                                          ranges = get_str_var("default_ranges");
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          shared = {
                                                            uuid = "static_yandex_net_s3_expert_front-maps-static";
                                                            rewrite = {
                                                              actions = {
                                                                {
                                                                  global = false;
                                                                  literal = false;
                                                                  rewrite = "%1/%2%3";
                                                                  case_insensitive = false;
                                                                  regexp = "^(/.*)?/v-[^/a-zA-Z]+/(.*)(\\?.*)?$";
                                                                };
                                                                {
                                                                  global = false;
                                                                  literal = false;
                                                                  rewrite = "/%2";
                                                                  case_insensitive = false;
                                                                  regexp = "/s3/([A-Za-z0-9\\-_]+)/(.*)";
                                                                };
                                                                {
                                                                  global = false;
                                                                  literal = false;
                                                                  regexp = "(.*)";
                                                                  rewrite = "%{url}";
                                                                  header_name = "Host";
                                                                  case_insensitive = false;
                                                                };
                                                              }; -- actions
                                                              rewrite = {
                                                                actions = {
                                                                  {
                                                                    global = false;
                                                                    literal = false;
                                                                    header_name = "Host";
                                                                    case_insensitive = false;
                                                                    rewrite = "%1.s3.yandex.net";
                                                                    regexp = "/s3/([A-Za-z0-9\\-_]+)/(.*)";
                                                                  };
                                                                }; -- actions
                                                                response_headers = {
                                                                  delete = "cache-control|access-control-allow-origin|strict-transport-security|timing-allow-origin|expires";
                                                                  create = {
                                                                    ["Access-Control-Allow-Origin"] = "*";
                                                                    ["Cache-Control"] = "public, max-age=31556952";
                                                                    ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                                  }; -- create
                                                                  shared = {
                                                                    uuid = "static_yandex_net_s3_expert_front-maps-static_common";
                                                                    shared = {
                                                                      uuid = "1547776764857163274";
                                                                    }; -- shared
                                                                  }; -- shared
                                                                }; -- response_headers
                                                              }; -- rewrite
                                                            }; -- rewrite
                                                          }; -- shared
                                                        }; -- report
                                                      }; -- ["static_yandex_net_s3_expert_front-maps-static"]
                                                      static_yandex_net_s3_market_export = {
                                                        priority = 3;
                                                        pattern = "/market-export(/.*)?";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "static_yandex_net_s3_market_export";
                                                          ranges = get_str_var("default_ranges");
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          shared = {
                                                            uuid = "static_yandex_net_s3_market_export";
                                                            response_headers = {
                                                              delete = "cache-control|access-control-allow-origin|strict-transport-security|timing-allow-origin|expires";
                                                              create_func = {
                                                                Expires = "time:+216001s";
                                                              }; -- create_func
                                                              create = {
                                                                ["Access-Control-Allow-Origin"] = "*";
                                                                ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                              }; -- create
                                                              shared = {
                                                                uuid = "yastatic_net_s3_market_export";
                                                              }; -- shared
                                                            }; -- response_headers
                                                          }; -- shared
                                                        }; -- report
                                                      }; -- static_yandex_net_s3_market_export
                                                      upstream_ok = {
                                                        priority = 2;
                                                        pattern = "/ok.html(.*)";
                                                        case_insensitive = true;
                                                        shared = {
                                                          uuid = "2565190060538431584";
                                                          report = {
                                                            uuid = "requests_to_upstream_ok";
                                                            ranges = get_str_var("default_ranges");
                                                            just_storage = false;
                                                            disable_robotness = true;
                                                            disable_sslness = true;
                                                            events = {
                                                              stats = "report";
                                                            }; -- events
                                                            shared = {
                                                              uuid = "3873313709847761065";
                                                              balancer2 = {
                                                                unique_policy = {};
                                                                attempts = 1;
                                                                rr = {
                                                                  weights_file = "./controls/l7_noc_check";
                                                                  return_503 = {
                                                                    weight = 1.000;
                                                                    errordocument = {
                                                                      status = 503;
                                                                      content = "echo NO";
                                                                      force_conn_close = false;
                                                                    }; -- errordocument
                                                                  }; -- return_503
                                                                  return_200 = {
                                                                    weight = -1.000;
                                                                    errordocument = {
                                                                      status = 200;
                                                                      content = "echo ok";
                                                                      force_conn_close = false;
                                                                    }; -- errordocument
                                                                  }; -- return_200
                                                                  return_200_weighted = {
                                                                    weight = -1.000;
                                                                    active_check_reply = {
                                                                      default_weight = 1;
                                                                      use_header = true;
                                                                      use_body = true;
                                                                      use_dynamic_weight = false;
                                                                      weight_file = "./controls/l7_noc_check_weight";
                                                                    }; -- active_check_reply
                                                                  }; -- return_200_weighted
                                                                }; -- rr
                                                              }; -- balancer2
                                                            }; -- shared
                                                          }; -- report
                                                        }; -- shared
                                                      }; -- upstream_ok
                                                      default = {
                                                        
                                                        shared = {
                                                          uuid = "7101341086594050669";
                                                        }; -- shared
                                                      }; -- default
                                                    }; -- regexp_path
                                                  }; -- static_yandex_net
                                                  rk_yandex_ru = {
                                                    priority = 4;
                                                    match_or = {
                                                      {
                                                        match_fsm = {
                                                          header = {
                                                            name = "Host";
                                                            value = "(www\\.rk|rk)\\.yandex\\.ru";
                                                          }; -- header
                                                          case_insensitive = true;
                                                          surround = false;
                                                        }; -- match_fsm
                                                      };
                                                      {
                                                        match_fsm = {
                                                          header = {
                                                            name = "Host";
                                                            value = "(www\\.)?rk\\.[a-z0-9-]+\\.yandex\\.net";
                                                          }; -- header
                                                          case_insensitive = true;
                                                          surround = false;
                                                        }; -- match_fsm
                                                      };
                                                    }; -- match_or
                                                    report = {
                                                      uuid = "rk_yandex_ru";
                                                      ranges = get_str_var("default_ranges");
                                                      just_storage = false;
                                                      disable_robotness = true;
                                                      disable_sslness = true;
                                                      events = {
                                                        stats = "report";
                                                      }; -- events
                                                      response_headers = {
                                                        create = {
                                                          Location = "https://www.yandex.ru/";
                                                        }; -- create
                                                        errordocument = {
                                                          status = 302;
                                                          force_conn_close = false;
                                                        }; -- errordocument
                                                      }; -- response_headers
                                                    }; -- report
                                                  }; -- rk_yandex_ru
                                                  love_yandex_ru = {
                                                    priority = 3;
                                                    match_or = {
                                                      {
                                                        match_fsm = {
                                                          header = {
                                                            name = "Host";
                                                            value = "(www\\.)?(heart|liebe|amour|amore|amor|love)\\.yandex\\.ru";
                                                          }; -- header
                                                          case_insensitive = true;
                                                          surround = false;
                                                        }; -- match_fsm
                                                      };
                                                      {
                                                        match_fsm = {
                                                          header = {
                                                            name = "Host";
                                                            value = "love\\.yandex\\.ru";
                                                          }; -- header
                                                          case_insensitive = true;
                                                          surround = false;
                                                        }; -- match_fsm
                                                      };
                                                    }; -- match_or
                                                    report = {
                                                      uuid = "love_yandex_ru";
                                                      ranges = get_str_var("default_ranges");
                                                      just_storage = false;
                                                      disable_robotness = true;
                                                      disable_sslness = true;
                                                      events = {
                                                        stats = "report";
                                                      }; -- events
                                                      headers = {
                                                        create = {
                                                          Location = "https://cards.yandex.ru";
                                                        }; -- create
                                                        rewrite = {
                                                          actions = {
                                                            {
                                                              global = false;
                                                              literal = false;
                                                              regexp = "(.*)";
                                                              rewrite = "%1%{url}";
                                                              case_insensitive = false;
                                                              header_name = "Location";
                                                            };
                                                          }; -- actions
                                                          headers_forwarder = {
                                                            actions = {
                                                              {
                                                                request_header = "Location";
                                                                response_header = "Location";
                                                                erase_from_request = false;
                                                                erase_from_response = false;
                                                                weak = false;
                                                              };
                                                            }; -- actions
                                                            errordocument = {
                                                              status = 301;
                                                              force_conn_close = false;
                                                            }; -- errordocument
                                                          }; -- headers_forwarder
                                                        }; -- rewrite
                                                      }; -- headers
                                                    }; -- report
                                                  }; -- love_yandex_ru
                                                  main = {
                                                    priority = 2;
                                                    match_or = {
                                                      {
                                                        match_fsm = {
                                                          header = {
                                                            name = "Host";
                                                            value = "yandex\\.st";
                                                          }; -- header
                                                          case_insensitive = true;
                                                          surround = false;
                                                        }; -- match_fsm
                                                      };
                                                      {
                                                        match_fsm = {
                                                          header = {
                                                            name = "Host";
                                                            value = "(.*)\\.yandex\\.st";
                                                          }; -- header
                                                          case_insensitive = true;
                                                          surround = false;
                                                        }; -- match_fsm
                                                      };
                                                      {
                                                        match_fsm = {
                                                          header = {
                                                            name = "Host";
                                                            value = "static\\.yandex\\.sx";
                                                          }; -- header
                                                          case_insensitive = true;
                                                          surround = false;
                                                        }; -- match_fsm
                                                      };
                                                      {
                                                        match_fsm = {
                                                          header = {
                                                            name = "Host";
                                                            value = "yastatic\\.net";
                                                          }; -- header
                                                          case_insensitive = true;
                                                          surround = false;
                                                        }; -- match_fsm
                                                      };
                                                      {
                                                        match_fsm = {
                                                          header = {
                                                            name = "Host";
                                                            value = "(.*)\\.yastatic\\.net";
                                                          }; -- header
                                                          case_insensitive = true;
                                                          surround = false;
                                                        }; -- match_fsm
                                                      };
                                                      {
                                                        match_fsm = {
                                                          header = {
                                                            name = "Host";
                                                            value = "failover\\.static\\.yandex\\.net";
                                                          }; -- header
                                                          case_insensitive = true;
                                                          surround = false;
                                                        }; -- match_fsm
                                                      };
                                                      {
                                                        match_fsm = {
                                                          header = {
                                                            name = "Host";
                                                            value = "[a-z0-9-]*-rr-templates\\.hamster\\.yandex\\.[a-z]{1,10}(\\.[a-z]{1,10})?";
                                                          }; -- header
                                                          case_insensitive = true;
                                                          surround = false;
                                                        }; -- match_fsm
                                                      };
                                                      {
                                                        match_fsm = {
                                                          header = {
                                                            name = "Host";
                                                            value = "(www\\.)?yandex\\.([[a-zA-Z0-9\\.]+)";
                                                          }; -- header
                                                          case_insensitive = true;
                                                          surround = false;
                                                        }; -- match_fsm
                                                      };
                                                    }; -- match_or
                                                    regexp_path = {
                                                      ["awacs-balancer-health-check"] = {
                                                        priority = 125;
                                                        pattern = "/awacs-balancer-health-check";
                                                        case_insensitive = true;
                                                        shared = {
                                                          uuid = "3081253662260106040";
                                                          report = {
                                                            uuid = "requests_to_awacs-balancer-health-check";
                                                            ranges = get_str_var("default_ranges");
                                                            just_storage = false;
                                                            disable_robotness = true;
                                                            disable_sslness = true;
                                                            events = {
                                                              stats = "report";
                                                            }; -- events
                                                            errordocument = {
                                                              status = 200;
                                                              force_conn_close = false;
                                                            }; -- errordocument
                                                          }; -- report
                                                        }; -- shared
                                                      }; -- ["awacs-balancer-health-check"]
                                                      ["yastatic_net_kinopoisk-frontend_ott"] = {
                                                        priority = 124;
                                                        pattern = "/s3/kinopoisk-frontend/ott/ever-green(/.*)?";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "yastatic_net_kinopoisk-frontend_ott";
                                                          ranges = get_str_var("default_ranges");
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          shared = {
                                                            uuid = "yastatic_net_kinopoisk-frontend_ott";
                                                            headers = {
                                                              create = {
                                                                Host = "kinopoisk-frontend.s3.yandex.net";
                                                              }; -- create
                                                              rewrite = {
                                                                actions = {
                                                                  {
                                                                    global = false;
                                                                    literal = false;
                                                                    case_insensitive = false;
                                                                    rewrite = "/ott/ever-green/%1";
                                                                    regexp = "/s3/kinopoisk-frontend/ott/ever-green/(.*)";
                                                                  };
                                                                }; -- actions
                                                                response_headers = {
                                                                  create_func = {
                                                                    Expires = "time:+3h";
                                                                  }; -- create_func
                                                                  create = {
                                                                    ["Access-Control-Allow-Origin"] = "*";
                                                                    ["Cache-Control"] = "public, max-age=3600";
                                                                    ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                                    ["Timing-Allow-Origin"] = "*";
                                                                  }; -- create
                                                                  shared = {
                                                                    uuid = "yastatic_net_kinopoisk-frontend_ott_common";
                                                                    shared = {
                                                                      uuid = "4957618399187796178";
                                                                    }; -- shared
                                                                  }; -- shared
                                                                }; -- response_headers
                                                              }; -- rewrite
                                                            }; -- headers
                                                          }; -- shared
                                                        }; -- report
                                                      }; -- ["yastatic_net_kinopoisk-frontend_ott"]
                                                      ["yastatic_net_s3_browser-updater"] = {
                                                        priority = 123;
                                                        pattern = "/browser-updater(/.*)?";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "yastatic_net_s3_browser-updater";
                                                          ranges = get_str_var("default_ranges");
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          shared = {
                                                            uuid = "yastatic_net_s3_browser-updater";
                                                            headers = {
                                                              create = {
                                                                Host = "distribution.s3.yandex.net";
                                                              }; -- create
                                                              rewrite = {
                                                                actions = {
                                                                  {
                                                                    global = false;
                                                                    literal = false;
                                                                    case_insensitive = false;
                                                                    regexp = "/browser-updater/(.*)";
                                                                    rewrite = "/soft/browser-updater-react/prod/%1";
                                                                  };
                                                                }; -- actions
                                                                response_headers = {
                                                                  create_func = {
                                                                    Expires = "time:+216006s";
                                                                  }; -- create_func
                                                                  create = {
                                                                    ["Access-Control-Allow-Origin"] = "*";
                                                                    ["Cache-Control"] = "public, max-age=216009";
                                                                    ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                                    ["Timing-Allow-Origin"] = "*";
                                                                  }; -- create
                                                                  shared = {
                                                                    uuid = "yastatic_net_s3_browser-updater_common";
                                                                    shared = {
                                                                      uuid = "177686509217163545";
                                                                    }; -- shared
                                                                  }; -- shared
                                                                }; -- response_headers
                                                              }; -- rewrite
                                                            }; -- headers
                                                          }; -- shared
                                                        }; -- report
                                                      }; -- ["yastatic_net_s3_browser-updater"]
                                                      yastatic_net_s3_elements_slice = {
                                                        priority = 122;
                                                        pattern = "/elements/slice(.*)?";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "yastatic_net_s3_elements_slice";
                                                          ranges = get_str_var("default_ranges");
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          shared = {
                                                            uuid = "yastatic_net_s3_elements_slice";
                                                            headers = {
                                                              create = {
                                                                Host = "yastatic.s3.yandex.net";
                                                              }; -- create
                                                              response_headers = {
                                                                create_func = {
                                                                  Expires = "time:+216006s";
                                                                }; -- create_func
                                                                create = {
                                                                  ["Access-Control-Allow-Origin"] = "*";
                                                                  ["Cache-Control"] = "public, max-age=216013";
                                                                  ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                                  ["Timing-Allow-Origin"] = "*";
                                                                }; -- create
                                                                shared = {
                                                                  uuid = "yastatic_net_s3_elements_slice_common";
                                                                  shared = {
                                                                    uuid = "177686509217163545";
                                                                  }; -- shared
                                                                }; -- shared
                                                              }; -- response_headers
                                                            }; -- headers
                                                          }; -- shared
                                                        }; -- report
                                                      }; -- yastatic_net_s3_elements_slice
                                                      yastatic_net_s3_s2s_ = {
                                                        priority = 121;
                                                        pattern = "/s2s/_/(.*)";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "yastatic_net_s3_s2s_";
                                                          ranges = get_str_var("default_ranges");
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          shared = {
                                                            uuid = "yastatic_net_s3_s2s_";
                                                            headers = {
                                                              create = {
                                                                Host = "yastatic.s3.yandex.net";
                                                              }; -- create
                                                              response_headers = {
                                                                create_func = {
                                                                  Expires = "time:+12h";
                                                                }; -- create_func
                                                                create = {
                                                                  ["Access-Control-Allow-Origin"] = "*";
                                                                  ["Cache-Control"] = "public, max-age=216013";
                                                                  ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                                  ["Timing-Allow-Origin"] = "*";
                                                                }; -- create
                                                                shared = {
                                                                  uuid = "yastatic_net_s3_s2s__common";
                                                                  shared = {
                                                                    uuid = "177686509217163545";
                                                                  }; -- shared
                                                                }; -- shared
                                                              }; -- response_headers
                                                            }; -- headers
                                                          }; -- shared
                                                        }; -- report
                                                      }; -- yastatic_net_s3_s2s_
                                                      yastatic_net_s3_wwwmorda = {
                                                        priority = 120;
                                                        pattern = "/(www|morda)/_(/.*)?";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "yastatic_net_s3_wwwmorda";
                                                          ranges = get_str_var("default_ranges");
                                                          matcher_map = {
                                                            www = {
                                                              match_fsm = {
                                                                path = "/www.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- www
                                                            morda = {
                                                              match_fsm = {
                                                                path = "/morda.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- morda
                                                          }; -- matcher_map
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          response_headers = {
                                                            delete = "aw_info|aw_info2";
                                                            create = {
                                                              ["Access-Control-Allow-Origin"] = "*";
                                                              ["Cache-Control"] = "public, immutable";
                                                              ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                              ["Timing-Allow-Origin"] = "*";
                                                            }; -- create
                                                            headers = {
                                                              create = {
                                                                Host = "yastatic.s3.yandex.net";
                                                              }; -- create
                                                              regexp = {
                                                                br_section = {
                                                                  priority = 3;
                                                                  match_and = {
                                                                    {
                                                                      match_fsm = {
                                                                        path = ".*(\\.js|\\.css|\\.svg)";
                                                                        case_insensitive = true;
                                                                        surround = false;
                                                                      }; -- match_fsm
                                                                    };
                                                                    {
                                                                      match_fsm = {
                                                                        header = {
                                                                          name = "accept-encoding";
                                                                          value = "(.*,\\s*|)br(\\s*;\\s*q\\s*=\\s*(1|0\\.0*[1-9]).*|\\s*,.*|)";
                                                                        }; -- header
                                                                        case_insensitive = true;
                                                                        surround = false;
                                                                      }; -- match_fsm
                                                                    };
                                                                  }; -- match_and
                                                                  rewrite = {
                                                                    actions = {
                                                                      {
                                                                        global = false;
                                                                        literal = false;
                                                                        rewrite = "%1.br";
                                                                        case_insensitive = false;
                                                                        regexp = "([^\\?]+)(.*)";
                                                                      };
                                                                    }; -- actions
                                                                    response_headers = {
                                                                      create = {
                                                                        ["Content-Encoding"] = "br";
                                                                      }; -- create
                                                                      shared = {
                                                                        uuid = "8726835379700365534";
                                                                        shared = {
                                                                          uuid = "yastatic_net_s3_wwwmorda_common";
                                                                        }; -- shared
                                                                      }; -- shared
                                                                    }; -- response_headers
                                                                  }; -- rewrite
                                                                }; -- br_section
                                                                gzip_section = {
                                                                  priority = 2;
                                                                  match_and = {
                                                                    {
                                                                      match_fsm = {
                                                                        path = ".*(\\.js|\\.css|\\.svg)";
                                                                        case_insensitive = true;
                                                                        surround = false;
                                                                      }; -- match_fsm
                                                                    };
                                                                    {
                                                                      match_fsm = {
                                                                        header = {
                                                                          name = "accept-encoding";
                                                                          value = "(.*,\\s*|)gzip(\\s*;\\s*q\\s*=\\s*(1|0\\.0*[1-9]).*|\\s*,.*|)";
                                                                        }; -- header
                                                                        case_insensitive = true;
                                                                        surround = false;
                                                                      }; -- match_fsm
                                                                    };
                                                                  }; -- match_and
                                                                  rewrite = {
                                                                    actions = {
                                                                      {
                                                                        global = false;
                                                                        literal = false;
                                                                        rewrite = "%1.gz";
                                                                        case_insensitive = false;
                                                                        regexp = "([^\\?]+)(.*)";
                                                                      };
                                                                    }; -- actions
                                                                    response_headers = {
                                                                      create = {
                                                                        ["Content-Encoding"] = "gzip";
                                                                      }; -- create
                                                                      shared = {
                                                                        uuid = "8726835379700365534";
                                                                      }; -- shared
                                                                    }; -- response_headers
                                                                  }; -- rewrite
                                                                }; -- gzip_section
                                                                default = {
                                                                  priority = 1;
                                                                  shared = {
                                                                    uuid = "yastatic_net_s3_wwwmorda_common";
                                                                    headers = {
                                                                      delete = "authorization|accept-encoding";
                                                                      response_headers = {
                                                                        create = {
                                                                          ["Cache-Control"] = "public, max-age=216013";
                                                                        }; -- create
                                                                        shared = {
                                                                          uuid = "yastatic_s3_cryprox_test_shared";
                                                                        }; -- shared
                                                                      }; -- response_headers
                                                                    }; -- headers
                                                                  }; -- shared
                                                                }; -- default
                                                              }; -- regexp
                                                            }; -- headers
                                                          }; -- response_headers
                                                        }; -- report
                                                      }; -- yastatic_net_s3_wwwmorda
                                                      all_root_redir = {
                                                        priority = 119;
                                                        pattern = "(/)?";
                                                        case_insensitive = true;
                                                        shared = {
                                                          uuid = "4050231810825788227";
                                                        }; -- shared
                                                      }; -- all_root_redir
                                                      ["yastatic_net_pcode-media-vpaid-motion-js"] = {
                                                        priority = 118;
                                                        pattern = "/pcode/media/vpaid-motion.js(/.*)?";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "yastatic_net_pcode-media-vpaid-motion-js";
                                                          ranges = get_str_var("default_ranges");
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          shared = {
                                                            uuid = "yastatic_net_pcode-media-vpaid-motion-js";
                                                            response_headers = {
                                                              create_func = {
                                                                Expires = "time:+1203s";
                                                              }; -- create_func
                                                              create = {
                                                                ["Access-Control-Allow-Origin"] = "*";
                                                                ["Cache-Control"] = "public, max-age=1204";
                                                                ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                                ["Timing-Allow-Origin"] = "*";
                                                              }; -- create
                                                              headers = {
                                                                create = {
                                                                  Host = "playerweb.s3.yandex.net";
                                                                  PCODE = "testing";
                                                                }; -- create
                                                                regexp = {
                                                                  ["1percent"] = {
                                                                    priority = 5;
                                                                    match_fsm = {
                                                                      header = {
                                                                        name = "PCODE";
                                                                        value = "1percent";
                                                                      }; -- header
                                                                      case_insensitive = true;
                                                                      surround = false;
                                                                    }; -- match_fsm
                                                                    rewrite = {
                                                                      actions = {
                                                                        {
                                                                          global = false;
                                                                          literal = false;
                                                                          regexp = "(.*)";
                                                                          case_insensitive = false;
                                                                          rewrite = "/adsdkjs-loaders/1percent/vpaid-motion.js";
                                                                        };
                                                                      }; -- actions
                                                                      shared = {
                                                                        uuid = "yastatic_net_pcode-media-vpaid-motion-js_percent";
                                                                        regexp = {
                                                                          br_section = {
                                                                            priority = 3;
                                                                            match_and = {
                                                                              {
                                                                                match_fsm = {
                                                                                  path = ".*(\\.js|\\.jpg|\\.png|\\.html)";
                                                                                  case_insensitive = true;
                                                                                  surround = false;
                                                                                }; -- match_fsm
                                                                              };
                                                                              {
                                                                                match_fsm = {
                                                                                  header = {
                                                                                    name = "accept-encoding";
                                                                                    value = "(.*,\\s*|)br(\\s*;\\s*q\\s*=\\s*(1|0\\.0*[1-9]).*|\\s*,.*|)";
                                                                                  }; -- header
                                                                                  case_insensitive = true;
                                                                                  surround = false;
                                                                                }; -- match_fsm
                                                                              };
                                                                            }; -- match_and
                                                                            rewrite = {
                                                                              actions = {
                                                                                {
                                                                                  global = false;
                                                                                  literal = false;
                                                                                  rewrite = "%1.br";
                                                                                  case_insensitive = false;
                                                                                  regexp = "([^\\?]+)(.*)";
                                                                                };
                                                                              }; -- actions
                                                                              response_headers_if = {
                                                                                matcher = {
                                                                                  match_response_codes = {
                                                                                    codes = { 200; 204; 206; };
                                                                                  }; -- match_response_codes
                                                                                }; -- matcher
                                                                                create_header = {
                                                                                  ["Content-Encoding"] = "br";
                                                                                }; -- create_header
                                                                                shared = {
                                                                                  uuid = "2796982106720052145";
                                                                                  shared = {
                                                                                    uuid = "yastatic_net_pcode-media-vpaid-motion-js_common";
                                                                                  }; -- shared
                                                                                }; -- shared
                                                                              }; -- response_headers_if
                                                                            }; -- rewrite
                                                                          }; -- br_section
                                                                          gzip_section = {
                                                                            priority = 2;
                                                                            match_and = {
                                                                              {
                                                                                match_fsm = {
                                                                                  path = ".*(\\.js|\\.jpg|\\.png|\\.html)";
                                                                                  case_insensitive = true;
                                                                                  surround = false;
                                                                                }; -- match_fsm
                                                                              };
                                                                              {
                                                                                match_fsm = {
                                                                                  header = {
                                                                                    name = "accept-encoding";
                                                                                    value = "(.*,\\s*|)gzip(\\s*;\\s*q\\s*=\\s*(1|0\\.0*[1-9]).*|\\s*,.*|)";
                                                                                  }; -- header
                                                                                  case_insensitive = true;
                                                                                  surround = false;
                                                                                }; -- match_fsm
                                                                              };
                                                                            }; -- match_and
                                                                            rewrite = {
                                                                              actions = {
                                                                                {
                                                                                  global = false;
                                                                                  literal = false;
                                                                                  rewrite = "%1.gz";
                                                                                  case_insensitive = false;
                                                                                  regexp = "([^\\?]+)(.*)";
                                                                                };
                                                                              }; -- actions
                                                                              response_headers_if = {
                                                                                matcher = {
                                                                                  match_response_codes = {
                                                                                    codes = { 200; 204; 206; };
                                                                                  }; -- match_response_codes
                                                                                }; -- matcher
                                                                                create_header = {
                                                                                  ["Content-Encoding"] = "gzip";
                                                                                }; -- create_header
                                                                                shared = {
                                                                                  uuid = "2796982106720052145";
                                                                                }; -- shared
                                                                              }; -- response_headers_if
                                                                            }; -- rewrite
                                                                          }; -- gzip_section
                                                                          default = {
                                                                            priority = 1;
                                                                            shared = {
                                                                              uuid = "yastatic_net_pcode-media-vpaid-motion-js_common";
                                                                              shared = {
                                                                                uuid = "4278682503402935169";
                                                                              }; -- shared
                                                                            }; -- shared
                                                                          }; -- default
                                                                        }; -- regexp
                                                                      }; -- shared
                                                                    }; -- rewrite
                                                                  }; -- ["1percent"]
                                                                  ["5percent"] = {
                                                                    priority = 4;
                                                                    match_fsm = {
                                                                      header = {
                                                                        name = "PCODE";
                                                                        value = "5percent";
                                                                      }; -- header
                                                                      case_insensitive = true;
                                                                      surround = false;
                                                                    }; -- match_fsm
                                                                    rewrite = {
                                                                      actions = {
                                                                        {
                                                                          global = false;
                                                                          literal = false;
                                                                          regexp = "/pcode/(.*)";
                                                                          case_insensitive = false;
                                                                          rewrite = "/adsdkjs-loaders/5percent/vpaid-motion.js";
                                                                        };
                                                                      }; -- actions
                                                                      shared = {
                                                                        uuid = "2707563578546919102";
                                                                        shared = {
                                                                          uuid = "yastatic_net_pcode-media-vpaid-motion-js_percent";
                                                                        }; -- shared
                                                                      }; -- shared
                                                                    }; -- rewrite
                                                                  }; -- ["5percent"]
                                                                  ["20percent"] = {
                                                                    priority = 3;
                                                                    match_fsm = {
                                                                      header = {
                                                                        name = "PCODE";
                                                                        value = "20percent";
                                                                      }; -- header
                                                                      case_insensitive = true;
                                                                      surround = false;
                                                                    }; -- match_fsm
                                                                    rewrite = {
                                                                      actions = {
                                                                        {
                                                                          global = false;
                                                                          literal = false;
                                                                          regexp = "(.*)";
                                                                          case_insensitive = false;
                                                                          rewrite = "/adsdkjs-loaders/20percent/vpaid-motion.js";
                                                                        };
                                                                      }; -- actions
                                                                      shared = {
                                                                        uuid = "2707563578546919102";
                                                                      }; -- shared
                                                                    }; -- rewrite
                                                                  }; -- ["20percent"]
                                                                  testing = {
                                                                    priority = 2;
                                                                    match_fsm = {
                                                                      header = {
                                                                        name = "PCODE";
                                                                        value = "testing";
                                                                      }; -- header
                                                                      case_insensitive = true;
                                                                      surround = false;
                                                                    }; -- match_fsm
                                                                    rewrite = {
                                                                      actions = {
                                                                        {
                                                                          global = false;
                                                                          literal = false;
                                                                          regexp = "(.*)";
                                                                          case_insensitive = false;
                                                                          rewrite = "/adsdkjs-loaders/testing/vpaid-motion.js";
                                                                        };
                                                                      }; -- actions
                                                                      shared = {
                                                                        uuid = "2707563578546919102";
                                                                      }; -- shared
                                                                    }; -- rewrite
                                                                  }; -- testing
                                                                  default = {
                                                                    priority = 1;
                                                                    rewrite = {
                                                                      actions = {
                                                                        {
                                                                          global = false;
                                                                          literal = false;
                                                                          regexp = "(.*)";
                                                                          case_insensitive = false;
                                                                          rewrite = "/adsdkjs-loaders/100percent/vpaid-motion.js";
                                                                        };
                                                                      }; -- actions
                                                                      shared = {
                                                                        uuid = "2707563578546919102";
                                                                      }; -- shared
                                                                    }; -- rewrite
                                                                  }; -- default
                                                                }; -- regexp
                                                              }; -- headers
                                                            }; -- response_headers
                                                          }; -- shared
                                                        }; -- report
                                                      }; -- ["yastatic_net_pcode-media-vpaid-motion-js"]
                                                      yastatic_net_qloud_q_crowdtest = {
                                                        priority = 117;
                                                        pattern = "/q/crowdtest(/.*)?";
                                                        case_insensitive = true;
                                                        rewrite = {
                                                          actions = {
                                                            {
                                                              global = false;
                                                              literal = false;
                                                              rewrite = "%1/%2%3";
                                                              case_insensitive = false;
                                                              regexp = "^(/.*)?/v-[^/a-zA-Z]+/(.*)(\\?.*)?$";
                                                            };
                                                          }; -- actions
                                                          report = {
                                                            uuid = "yastatic_net_qloud_q_crowdtest";
                                                            ranges = get_str_var("default_ranges");
                                                            just_storage = false;
                                                            disable_robotness = true;
                                                            disable_sslness = true;
                                                            events = {
                                                              stats = "report";
                                                            }; -- events
                                                            shared = {
                                                              uuid = "yastatic_net_qloud_q_crowdtest";
                                                              response_headers = {
                                                                create_func = {
                                                                  Expires = "time:+1201s";
                                                                }; -- create_func
                                                                create = {
                                                                  ["Access-Control-Allow-Origin"] = "*";
                                                                  ["Cache-Control"] = "public, max-age=1213";
                                                                  ["Timing-Allow-Origin"] = "*";
                                                                }; -- create
                                                                headers = {
                                                                  create = {
                                                                    Host = "yastatic.net";
                                                                    ["Y-Traffic-Source"] = "msk-yastatic.net";
                                                                  }; -- create
                                                                  balancer2 = {
                                                                    simple_policy = {};
                                                                    attempts = 5;
                                                                    rr = {
                                                                      unpack(gen_proxy_backends({
                                                                        { "cdn-router.stable.qloud-b.yandex.net"; 80; 1.000; "2a02:6b8:0:3400:0:2e5:1:803d"; };
                                                                      }, {
                                                                        resolve_timeout = "10ms";
                                                                        connect_timeout = "50ms";
                                                                        backend_timeout = "5s";
                                                                        fail_on_5xx = true;
                                                                        http_backend = true;
                                                                        buffering = false;
                                                                        keepalive_count = 1;
                                                                        need_resolve = true;
                                                                        keepalive_timeout = "60s";
                                                                      }))
                                                                    }; -- rr
                                                                    on_status_code = {
                                                                      ["404"] = {
                                                                        errordocument = {
                                                                          status = 200;
                                                                          force_conn_close = false;
                                                                          content = "Workaround for /q/crowdtest";
                                                                        }; -- errordocument
                                                                      }; -- ["404"]
                                                                    }; -- on_status_code
                                                                  }; -- balancer2
                                                                }; -- headers
                                                              }; -- response_headers
                                                            }; -- shared
                                                          }; -- report
                                                        }; -- rewrite
                                                      }; -- yastatic_net_qloud_q_crowdtest
                                                      ["yastatic_net_s3_q_rsya-tag-users"] = {
                                                        priority = 116;
                                                        pattern = "/q/set/s/rsya-tag-users/bundle.js(.*)";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "yastatic_net_s3_q_rsya-tag-users";
                                                          ranges = get_str_var("default_ranges");
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          shared = {
                                                            uuid = "yastatic_net_s3_q_rsya-tag-users";
                                                            headers = {
                                                              create = {
                                                                Host = "yastatic.net";
                                                              }; -- create
                                                              rewrite = {
                                                                actions = {
                                                                  {
                                                                    global = false;
                                                                    literal = false;
                                                                    case_insensitive = false;
                                                                    regexp = "/q/set/s/rsya-tag-users/bundle.js";
                                                                    rewrite = "/s3/distribution/rsya-tag-users/_/bundle.js";
                                                                  };
                                                                }; -- actions
                                                                response_headers = {
                                                                  create_func = {
                                                                    Expires = "time:+216001s";
                                                                  }; -- create_func
                                                                  create = {
                                                                    ["Access-Control-Allow-Origin"] = "*";
                                                                    ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                                    ["Timing-Allow-Origin"] = "*";
                                                                  }; -- create
                                                                  shared = {
                                                                    uuid = "yastatic_net_s3_expert_front-maps-static";
                                                                  }; -- shared
                                                                }; -- response_headers
                                                              }; -- rewrite
                                                            }; -- headers
                                                          }; -- shared
                                                        }; -- report
                                                      }; -- ["yastatic_net_s3_q_rsya-tag-users"]
                                                      ["yastatic_net_s3_safeframe-bundles_protected"] = {
                                                        priority = 115;
                                                        pattern = "/safeframe-bundles/[0-9]+\\.[0-9]+/[0-9]+-[0-9]+-[0-9]+/protected(/.*)?";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "yastatic_net_s3_safeframe-bundles_protected";
                                                          ranges = get_str_var("default_ranges");
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          shared = {
                                                            uuid = "yastatic_net_s3_safeframe-bundles_protected";
                                                            headers = {
                                                              create = {
                                                                Host = "pcode.s3.yandex.net";
                                                              }; -- create
                                                              rewrite = {
                                                                actions = {
                                                                  {
                                                                    global = false;
                                                                    literal = false;
                                                                    case_insensitive = false;
                                                                    rewrite = "/safeframe/%1";
                                                                    regexp = "/safeframe-bundles/(.*)";
                                                                  };
                                                                }; -- actions
                                                                response_headers_if = {
                                                                  matcher = {
                                                                    match_response_codes = {
                                                                      codes = { 200; 204; 206; };
                                                                    }; -- match_response_codes
                                                                  }; -- matcher
                                                                  create_header = {
                                                                    ["Content-Security-Policy"] = "default-src 'none'; media-src storage.mds.yandex.net storage.mdst.yandex.net; img-src 'self' *.yandex.ru *.yandex.kz *.yandex.ua storage.mds.yandex.net storage.mdst.yandex.net mc.yandex.ru an.yandex.ru data:; script-src 'unsafe-inline' 'unsafe-eval' 'self' *.yandex.ru *.yandex.kz *.yandex.ua storage.mds.yandex.net storage.mdst.yandex.net an.yandex.ru mc.yandex.ru yastatic.net; child-src 'none'; frame-src https://yandex.ru https://an.yandex.ru; connect-src storage.mds.yandex.net storage.mdst.yandex.net mc.yandex.ru yandex.ru; style-src 'unsafe-inline' 'self' *.yandex.ru *.yandex.kz *.yandex.ua mc.yandex.ru storage.mds.yandex.net storage.mdst.yandex.net; font-src 'self' *.yandex.ru *.yandex.kz *.yandex.ua storage.mds.yandex.net storage.mdst.yandex.net data:;";
                                                                  }; -- create_header
                                                                  response_headers = {
                                                                    create_func = {
                                                                      Expires = "time:+216001s";
                                                                    }; -- create_func
                                                                    create = {
                                                                      ["Access-Control-Allow-Origin"] = "*";
                                                                      ["Cache-Control"] = "public, max-age=216013";
                                                                      ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                                      ["Timing-Allow-Origin"] = "*";
                                                                    }; -- create
                                                                    regexp = {
                                                                      br_section = {
                                                                        priority = 3;
                                                                        match_and = {
                                                                          {
                                                                            match_fsm = {
                                                                              path = ".*(\\.js|\\.html)";
                                                                              case_insensitive = true;
                                                                              surround = false;
                                                                            }; -- match_fsm
                                                                          };
                                                                          {
                                                                            match_fsm = {
                                                                              header = {
                                                                                name = "accept-encoding";
                                                                                value = "(.*,\\s*|)br(\\s*;\\s*q\\s*=\\s*(1|0\\.0*[1-9]).*|\\s*,.*|)";
                                                                              }; -- header
                                                                              case_insensitive = true;
                                                                              surround = false;
                                                                            }; -- match_fsm
                                                                          };
                                                                        }; -- match_and
                                                                        rewrite = {
                                                                          actions = {
                                                                            {
                                                                              global = false;
                                                                              literal = false;
                                                                              rewrite = "%1.br";
                                                                              case_insensitive = false;
                                                                              regexp = "([^\\?]+)(.*)";
                                                                            };
                                                                          }; -- actions
                                                                          response_headers = {
                                                                            create = {
                                                                              ["Content-Encoding"] = "br";
                                                                            }; -- create
                                                                            shared = {
                                                                              uuid = "2730955027787824306";
                                                                              shared = {
                                                                                uuid = "yastatic_net_s3_safeframe-bundles_protected_common";
                                                                              }; -- shared
                                                                            }; -- shared
                                                                          }; -- response_headers
                                                                        }; -- rewrite
                                                                      }; -- br_section
                                                                      gzip_section = {
                                                                        priority = 2;
                                                                        match_and = {
                                                                          {
                                                                            match_fsm = {
                                                                              path = ".*(\\.js|\\.html)";
                                                                              case_insensitive = true;
                                                                              surround = false;
                                                                            }; -- match_fsm
                                                                          };
                                                                          {
                                                                            match_fsm = {
                                                                              header = {
                                                                                name = "accept-encoding";
                                                                                value = "(.*,\\s*|)gzip(\\s*;\\s*q\\s*=\\s*(1|0\\.0*[1-9]).*|\\s*,.*|)";
                                                                              }; -- header
                                                                              case_insensitive = true;
                                                                              surround = false;
                                                                            }; -- match_fsm
                                                                          };
                                                                        }; -- match_and
                                                                        rewrite = {
                                                                          actions = {
                                                                            {
                                                                              global = false;
                                                                              literal = false;
                                                                              rewrite = "%1.gz";
                                                                              case_insensitive = false;
                                                                              regexp = "([^\\?]+)(.*)";
                                                                            };
                                                                          }; -- actions
                                                                          response_headers = {
                                                                            create = {
                                                                              ["Content-Encoding"] = "gzip";
                                                                            }; -- create
                                                                            shared = {
                                                                              uuid = "2730955027787824306";
                                                                            }; -- shared
                                                                          }; -- response_headers
                                                                        }; -- rewrite
                                                                      }; -- gzip_section
                                                                      default = {
                                                                        priority = 1;
                                                                        shared = {
                                                                          uuid = "yastatic_net_s3_safeframe-bundles_protected_common";
                                                                          shared = {
                                                                            uuid = "2679703888242934312";
                                                                          }; -- shared
                                                                        }; -- shared
                                                                      }; -- default
                                                                    }; -- regexp
                                                                  }; -- response_headers
                                                                }; -- response_headers_if
                                                              }; -- rewrite
                                                            }; -- headers
                                                          }; -- shared
                                                        }; -- report
                                                      }; -- ["yastatic_net_s3_safeframe-bundles_protected"]
                                                      yastatic_net_s3_share_share = {
                                                        priority = 114;
                                                        pattern = "/share/(_)?share\\.(.*)?";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "yastatic_net_s3_share_share";
                                                          ranges = get_str_var("default_ranges");
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          shared = {
                                                            uuid = "yastatic_net_s3_share_share";
                                                            headers = {
                                                              create = {
                                                                Host = "yastatic.s3.yandex.net";
                                                              }; -- create
                                                              response_headers = {
                                                                create_func = {
                                                                  Expires = "time:+216006s";
                                                                }; -- create_func
                                                                create = {
                                                                  ["Access-Control-Allow-Origin"] = "*";
                                                                  ["Cache-Control"] = "public, max-age=216013";
                                                                  ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                                  ["Timing-Allow-Origin"] = "*";
                                                                }; -- create
                                                                shared = {
                                                                  uuid = "yastatic_net_s3_share_share_common";
                                                                  shared = {
                                                                    uuid = "177686509217163545";
                                                                  }; -- shared
                                                                }; -- shared
                                                              }; -- response_headers
                                                            }; -- headers
                                                          }; -- shared
                                                        }; -- report
                                                      }; -- yastatic_net_s3_share_share
                                                      yastatic_net_s3_sovetnik_dash = {
                                                        priority = 113;
                                                        pattern = "/sovetnik/_(/.*)?";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "yastatic_net_s3_sovetnik_dash";
                                                          ranges = get_str_var("default_ranges");
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          shared = {
                                                            uuid = "yastatic_net_s3_sovetnik_dash";
                                                            headers = {
                                                              create = {
                                                                Host = "yastatic.s3.yandex.net";
                                                              }; -- create
                                                              response_headers = {
                                                                create_func = {
                                                                  Expires = "time:+12h";
                                                                }; -- create_func
                                                                create = {
                                                                  ["Access-Control-Allow-Origin"] = "*";
                                                                  ["Cache-Control"] = "public, max-age=43200";
                                                                  ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                                  ["Timing-Allow-Origin"] = "*";
                                                                }; -- create
                                                                regexp = {
                                                                  br_section = {
                                                                    priority = 3;
                                                                    match_fsm = {
                                                                      header = {
                                                                        name = "accept-encoding";
                                                                        value = "(.*,\\s*|)br(\\s*;\\s*q\\s*=\\s*(1|0\\.0*[1-9]).*|\\s*,.*|)";
                                                                      }; -- header
                                                                      case_insensitive = true;
                                                                      surround = false;
                                                                    }; -- match_fsm
                                                                    shared = {
                                                                      uuid = "1289107120567057744";
                                                                      rewrite = {
                                                                        actions = {
                                                                          {
                                                                            global = false;
                                                                            literal = false;
                                                                            rewrite = "%1.gz";
                                                                            case_insensitive = false;
                                                                            regexp = "([^\\?]+)(.*)";
                                                                          };
                                                                        }; -- actions
                                                                        response_headers = {
                                                                          create = {
                                                                            ["Content-Encoding"] = "gzip";
                                                                          }; -- create
                                                                          shared = {
                                                                            uuid = "yastatic_net_s3_sovetnik_dash_common";
                                                                          }; -- shared
                                                                        }; -- response_headers
                                                                      }; -- rewrite
                                                                    }; -- shared
                                                                  }; -- br_section
                                                                  gzip_section = {
                                                                    priority = 2;
                                                                    match_fsm = {
                                                                      header = {
                                                                        name = "accept-encoding";
                                                                        value = "(.*,\\s*|)gzip(\\s*;\\s*q\\s*=\\s*(1|0\\.0*[1-9]).*|\\s*,.*|)";
                                                                      }; -- header
                                                                      case_insensitive = true;
                                                                      surround = false;
                                                                    }; -- match_fsm
                                                                    shared = {
                                                                      uuid = "1289107120567057744";
                                                                    }; -- shared
                                                                  }; -- gzip_section
                                                                  default = {
                                                                    priority = 1;
                                                                    shared = {
                                                                      uuid = "yastatic_net_s3_sovetnik_dash_common";
                                                                      shared = {
                                                                        uuid = "2679703888242934312";
                                                                        headers = {
                                                                          delete = "authorization|accept-encoding";
                                                                          response_headers = {
                                                                            delete = "content-encoding";
                                                                            create = {
                                                                              ["Cache-Control"] = "public, max-age=216013";
                                                                            }; -- create
                                                                            shared = {
                                                                              uuid = "4957618399187796178";
                                                                            }; -- shared
                                                                          }; -- response_headers
                                                                        }; -- headers
                                                                      }; -- shared
                                                                    }; -- shared
                                                                  }; -- default
                                                                }; -- regexp
                                                              }; -- response_headers
                                                            }; -- headers
                                                          }; -- shared
                                                        }; -- report
                                                      }; -- yastatic_net_s3_sovetnik_dash
                                                      ["yastatic_net_s3_yandex-video-player-iframe-api-bundles_protected"] = {
                                                        priority = 112;
                                                        pattern = "/yandex-video-player-iframe-api-bundles/[0-9]+\\.[0-9]+-[0-9]+/(protected\\.html|tv1\\.html)(.*)?";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "yastatic_net_s3_yandex-video-player-iframe-api-bundles_protected";
                                                          ranges = get_str_var("default_ranges");
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          shared = {
                                                            uuid = "yastatic_net_s3_yandex-video-player-iframe-api-bundles_protected";
                                                            headers = {
                                                              create = {
                                                                Host = "playerweb.s3.yandex.net";
                                                              }; -- create
                                                              rewrite = {
                                                                actions = {
                                                                  {
                                                                    global = false;
                                                                    literal = false;
                                                                    case_insensitive = false;
                                                                    rewrite = "%1/index.html";
                                                                    regexp = "^(.+)/(\\?.*)?$";
                                                                  };
                                                                  {
                                                                    global = false;
                                                                    literal = false;
                                                                    rewrite = "/bundles/%1";
                                                                    case_insensitive = false;
                                                                    regexp = "/yandex-video-player-iframe-api-bundles/(.*)";
                                                                  };
                                                                }; -- actions
                                                                response_headers_if = {
                                                                  matcher = {
                                                                    match_response_codes = {
                                                                      codes = { 200; 204; 206; 301; 302; 304; };
                                                                    }; -- match_response_codes
                                                                  }; -- matcher
                                                                  create_header = {
                                                                    ["Content-Security-Policy"] = "frame-ancestors file: yandex.ru *.yandex.ru yandex.by *.yandex.by yandex.kz *.yandex.kz yandex.ua *.yandex.ua yandex.com *.yandex.com yandex.com.tr *.yandex.com.tr yandex.uz *.yandex.uz yandex.com.ge *.yandex.com.ge yandex.az *.yandex.az yandex.co.am *.yandex.com.am yandex.co.il *.yandex.co.il yandex.kg *.yandex.kg yandex.lv *.yandex.lv yandex.lt *.yandex.lt yandex.md *.yandex.md yandex.tj *.yandex.tj yandex.tm *.yandex.tm yandex.fr *.yandex.fr yandex.ee *.yandex.ee yandex-team.ru *.yandex-team.ru kinopoisk.ru *.kinopoisk.ru yastatic.net *.yastatic.net yadi.sk *.yadi.sk disk.yandex.ru disk.yandex.com disk.yandex.com.tr disk.yandex.kz disk.yandex.ua disk.yandex.by disk.yandex.az disk.yandex.com.am disk.yandex.com.ge disk.yandex.co.il disk.yandex.kg disk.yandex.lt disk.yandex.lv disk.yandex.md disk.yandex.tj disk.yandex.tm disk.yandex.uz disk.yandex.fr disk.yandex.ee *.iframe-toloka.com iframe-toloka.com yandex.net *.yandex.net yandexsport.ru *.yandexsport.ru yandexsport.by *.yandexsport.by yandexsport.kz *.yandexsport.kz yandexsport.uz *.yandexsport.uz;";
                                                                  }; -- create_header
                                                                  response_headers = {
                                                                    delete = "content-security-policy|x-consumed-content-encoding";
                                                                    create_func = {
                                                                      Expires = "time:+216001s";
                                                                    }; -- create_func
                                                                    create = {
                                                                      ["Access-Control-Allow-Origin"] = "*";
                                                                      ["Cache-Control"] = "public, max-age=216013";
                                                                      ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                                      ["Timing-Allow-Origin"] = "*";
                                                                    }; -- create
                                                                    regexp = {
                                                                      br_section = {
                                                                        priority = 3;
                                                                        match_fsm = {
                                                                          header = {
                                                                            name = "accept-encoding";
                                                                            value = "(.*,\\s*|)br(\\s*;\\s*q\\s*=\\s*(1|0\\.0*[1-9]).*|\\s*,.*|)";
                                                                          }; -- header
                                                                          case_insensitive = true;
                                                                          surround = false;
                                                                        }; -- match_fsm
                                                                        rewrite = {
                                                                          actions = {
                                                                            {
                                                                              global = false;
                                                                              literal = false;
                                                                              rewrite = "%1.br";
                                                                              case_insensitive = false;
                                                                              regexp = "([^\\?]+)(.*)";
                                                                            };
                                                                          }; -- actions
                                                                          response_headers = {
                                                                            create = {
                                                                              ["Content-Encoding"] = "br";
                                                                            }; -- create
                                                                            shared = {
                                                                              uuid = "6774811069849216980";
                                                                              shared = {
                                                                                uuid = "yastatic_net_s3_yandex-video-player-iframe-api-bundles_protected_common";
                                                                              }; -- shared
                                                                            }; -- shared
                                                                          }; -- response_headers
                                                                        }; -- rewrite
                                                                      }; -- br_section
                                                                      gzip_section = {
                                                                        priority = 2;
                                                                        match_fsm = {
                                                                          header = {
                                                                            name = "accept-encoding";
                                                                            value = "(.*,\\s*|)gzip(\\s*;\\s*q\\s*=\\s*(1|0\\.0*[1-9]).*|\\s*,.*|)";
                                                                          }; -- header
                                                                          case_insensitive = true;
                                                                          surround = false;
                                                                        }; -- match_fsm
                                                                        rewrite = {
                                                                          actions = {
                                                                            {
                                                                              global = false;
                                                                              literal = false;
                                                                              rewrite = "%1.gz";
                                                                              case_insensitive = false;
                                                                              regexp = "([^\\?]+)(.*)";
                                                                            };
                                                                          }; -- actions
                                                                          response_headers = {
                                                                            create = {
                                                                              ["Content-Encoding"] = "gzip";
                                                                            }; -- create
                                                                            shared = {
                                                                              uuid = "6774811069849216980";
                                                                            }; -- shared
                                                                          }; -- response_headers
                                                                        }; -- rewrite
                                                                      }; -- gzip_section
                                                                      default = {
                                                                        priority = 1;
                                                                        shared = {
                                                                          uuid = "yastatic_net_s3_yandex-video-player-iframe-api-bundles_protected_common";
                                                                          shared = {
                                                                            uuid = "2679703888242934312";
                                                                          }; -- shared
                                                                        }; -- shared
                                                                      }; -- default
                                                                    }; -- regexp
                                                                  }; -- response_headers
                                                                }; -- response_headers_if
                                                              }; -- rewrite
                                                            }; -- headers
                                                          }; -- shared
                                                        }; -- report
                                                      }; -- ["yastatic_net_s3_yandex-video-player-iframe-api-bundles_protected"]
                                                      ["yastatic_net_s3_yandex-video-player-iframe-api_protected"] = {
                                                        priority = 111;
                                                        pattern = "/yandex-video-player-iframe-api/(protected\\.html|tv1\\.html)(.*)?";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "yastatic_net_s3_yandex-video-player-iframe-api_protected";
                                                          ranges = get_str_var("default_ranges");
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          shared = {
                                                            uuid = "yastatic_net_s3_yandex-video-player-iframe-api_protected";
                                                            headers = {
                                                              create = {
                                                                Host = "playerweb.s3.yandex.net";
                                                              }; -- create
                                                              rewrite = {
                                                                actions = {
                                                                  {
                                                                    global = false;
                                                                    literal = false;
                                                                    case_insensitive = false;
                                                                    rewrite = "%1/index.html";
                                                                    regexp = "^(.+)/(\\?.*)?$";
                                                                  };
                                                                }; -- actions
                                                                rewrite = {
                                                                  actions = {
                                                                    {
                                                                      global = false;
                                                                      literal = false;
                                                                      case_insensitive = false;
                                                                      rewrite = "/player-loaders/testing/%1";
                                                                      regexp = "/yandex-video-player-iframe-api/(.*)";
                                                                    };
                                                                  }; -- actions
                                                                  response_headers_if = {
                                                                    matcher = {
                                                                      match_response_codes = {
                                                                        codes = { 200; 204; 206; };
                                                                      }; -- match_response_codes
                                                                    }; -- matcher
                                                                    create_header = {
                                                                      ["Content-Security-Policy"] = "frame-ancestors file: yandex.ru *.yandex.ru yandex.by *.yandex.by yandex.kz *.yandex.kz yandex.ua *.yandex.ua yandex.com *.yandex.com yandex.com.tr *.yandex.com.tr yandex.uz *.yandex.uz yandex.com.ge *.yandex.com.ge yandex.az *.yandex.az yandex.co.am *.yandex.com.am yandex.co.il *.yandex.co.il yandex.kg *.yandex.kg yandex.lv *.yandex.lv yandex.lt *.yandex.lt yandex.md *.yandex.md yandex.tj *.yandex.tj yandex.tm *.yandex.tm yandex.fr *.yandex.fr yandex.ee *.yandex.ee yandex-team.ru *.yandex-team.ru kinopoisk.ru *.kinopoisk.ru yadi.sk *.yadi.sk disk.yandex.ru disk.yandex.com disk.yandex.com.tr disk.yandex.kz disk.yandex.ua disk.yandex.by disk.yandex.az disk.yandex.com.am disk.yandex.com.ge disk.yandex.co.il disk.yandex.kg disk.yandex.lt disk.yandex.lv disk.yandex.md disk.yandex.tj disk.yandex.tm disk.yandex.uz disk.yandex.fr disk.yandex.ee iframe-toloka.com;";
                                                                    }; -- create_header
                                                                    response_headers = {
                                                                      create_func = {
                                                                        Expires = "time:+216001s";
                                                                      }; -- create_func
                                                                      create = {
                                                                        ["Access-Control-Allow-Origin"] = "*";
                                                                        ["Cache-Control"] = "public";
                                                                        ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                                        ["Timing-Allow-Origin"] = "*";
                                                                      }; -- create
                                                                      regexp = {
                                                                        br_section = {
                                                                          priority = 3;
                                                                          match_and = {
                                                                            {
                                                                              match_fsm = {
                                                                                path = ".*(\\.js|\\.jpg|\\.png|\\.html)";
                                                                                case_insensitive = true;
                                                                                surround = false;
                                                                              }; -- match_fsm
                                                                            };
                                                                            {
                                                                              match_fsm = {
                                                                                header = {
                                                                                  name = "accept-encoding";
                                                                                  value = "(.*,\\s*|)br(\\s*;\\s*q\\s*=\\s*(1|0\\.0*[1-9]).*|\\s*,.*|)";
                                                                                }; -- header
                                                                                case_insensitive = true;
                                                                                surround = false;
                                                                              }; -- match_fsm
                                                                            };
                                                                          }; -- match_and
                                                                          rewrite = {
                                                                            actions = {
                                                                              {
                                                                                global = false;
                                                                                literal = false;
                                                                                rewrite = "%1.br";
                                                                                case_insensitive = false;
                                                                                regexp = "([^\\?]+)(.*)";
                                                                              };
                                                                            }; -- actions
                                                                            response_headers = {
                                                                              create = {
                                                                                ["Content-Encoding"] = "br";
                                                                              }; -- create
                                                                              shared = {
                                                                                uuid = "5890782228928187280";
                                                                                shared = {
                                                                                  uuid = "yastatic_net_s3_yandex-video-player-iframe-api_protected_common";
                                                                                }; -- shared
                                                                              }; -- shared
                                                                            }; -- response_headers
                                                                          }; -- rewrite
                                                                        }; -- br_section
                                                                        gzip_section = {
                                                                          priority = 2;
                                                                          match_and = {
                                                                            {
                                                                              match_fsm = {
                                                                                path = ".*(\\.js|\\.jpg|\\.png|\\.html)";
                                                                                case_insensitive = true;
                                                                                surround = false;
                                                                              }; -- match_fsm
                                                                            };
                                                                            {
                                                                              match_fsm = {
                                                                                header = {
                                                                                  name = "accept-encoding";
                                                                                  value = "(.*,\\s*|)gzip(\\s*;\\s*q\\s*=\\s*(1|0\\.0*[1-9]).*|\\s*,.*|)";
                                                                                }; -- header
                                                                                case_insensitive = true;
                                                                                surround = false;
                                                                              }; -- match_fsm
                                                                            };
                                                                          }; -- match_and
                                                                          rewrite = {
                                                                            actions = {
                                                                              {
                                                                                global = false;
                                                                                literal = false;
                                                                                rewrite = "%1.gz";
                                                                                case_insensitive = false;
                                                                                regexp = "([^\\?]+)(.*)";
                                                                              };
                                                                            }; -- actions
                                                                            response_headers = {
                                                                              create = {
                                                                                ["Content-Encoding"] = "gzip";
                                                                              }; -- create
                                                                              shared = {
                                                                                uuid = "5890782228928187280";
                                                                              }; -- shared
                                                                            }; -- response_headers
                                                                          }; -- rewrite
                                                                        }; -- gzip_section
                                                                        default = {
                                                                          priority = 1;
                                                                          shared = {
                                                                            uuid = "yastatic_net_s3_yandex-video-player-iframe-api_protected_common";
                                                                            shared = {
                                                                              uuid = "4278682503402935169";
                                                                            }; -- shared
                                                                          }; -- shared
                                                                        }; -- default
                                                                      }; -- regexp
                                                                    }; -- response_headers
                                                                  }; -- response_headers_if
                                                                }; -- rewrite
                                                              }; -- rewrite
                                                            }; -- headers
                                                          }; -- shared
                                                        }; -- report
                                                      }; -- ["yastatic_net_s3_yandex-video-player-iframe-api_protected"]
                                                      ["yastatic_net_yandex-video-player-iframe-api-bundles-stable_protected"] = {
                                                        priority = 110;
                                                        pattern = "/yandex-video-player-iframe-api-bundles-stable/[0-9]+.[0-9]+-[0-9]+/(protected.html|tv1.html)";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "yastatic_net_yandex-video-player-iframe-api-bundles-stable_protected";
                                                          ranges = get_str_var("default_ranges");
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          headers = {
                                                            create = {
                                                              ["X-AAB-PartnerToken"] = get_str_env_var("AWACS_AAB_VIDEO_TOKEN");
                                                              ["X-Forwarded-Proto"] = "https";
                                                              ["X-Strm-Antiadblock"] = get_str_env_var("AWACS_STRM_VIDEO_TOKEN");
                                                            }; -- create
                                                            response_headers_if = {
                                                              matcher = {
                                                                match_response_codes = {
                                                                  codes = { 200; 204; 206; 301; 302; 304; };
                                                                }; -- match_response_codes
                                                              }; -- matcher
                                                              create_header = {
                                                                ["Content-Security-Policy"] = "frame-ancestors file: yandex.ru *.yandex.ru yandex.by *.yandex.by yandex.kz *.yandex.kz yandex.ua *.yandex.ua yandex.com *.yandex.com yandex.com.tr *.yandex.com.tr yandex.uz *.yandex.uz yandex.com.ge *.yandex.com.ge yandex.az *.yandex.az yandex.co.am *.yandex.com.am yandex.co.il *.yandex.co.il yandex.kg *.yandex.kg yandex.lv *.yandex.lv yandex.lt *.yandex.lt yandex.md *.yandex.md yandex.tj *.yandex.tj yandex.tm *.yandex.tm yandex.fr *.yandex.fr yandex.ee *.yandex.ee yandex-team.ru *.yandex-team.ru kinopoisk.ru *.kinopoisk.ru yastatic.net *.yastatic.net yadi.sk *.yadi.sk disk.yandex.ru disk.yandex.com disk.yandex.com.tr disk.yandex.kz disk.yandex.ua disk.yandex.by disk.yandex.az disk.yandex.com.am disk.yandex.com.ge disk.yandex.co.il disk.yandex.kg disk.yandex.lt disk.yandex.lv disk.yandex.md disk.yandex.tj disk.yandex.tm disk.yandex.uz disk.yandex.fr disk.yandex.ee iframe-toloka.com yandex.net *.yandex.net yandexsport.ru *.yandexsport.ru yandexsport.by *.yandexsport.by yandexsport.kz *.yandexsport.kz yandexsport.uz *.yandexsport.uz;";
                                                              }; -- create_header
                                                              response_headers = {
                                                                delete = "content-security-policy|x-consumed-content-encoding";
                                                                create_func = {
                                                                  Expires = "time:+1h";
                                                                }; -- create_func
                                                                create = {
                                                                  ["Access-Control-Allow-Origin"] = "*";
                                                                  ["Cache-Control"] = "public, max-age=216013";
                                                                  ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                                  ["Timing-Allow-Origin"] = "*";
                                                                }; -- create
                                                                shared = {
                                                                  uuid = "1803122284702860095";
                                                                }; -- shared
                                                              }; -- response_headers
                                                            }; -- response_headers_if
                                                          }; -- headers
                                                        }; -- report
                                                      }; -- ["yastatic_net_yandex-video-player-iframe-api-bundles-stable_protected"]
                                                      all_errors_table = {
                                                        priority = 109;
                                                        pattern = "/errors_table/(.*)";
                                                        case_insensitive = true;
                                                        shared = {
                                                          uuid = "8384648238129770771";
                                                        }; -- shared
                                                      }; -- all_errors_table
                                                      all_favicon_ico = {
                                                        priority = 108;
                                                        pattern = "/favicon.ico(.*)";
                                                        case_insensitive = true;
                                                        shared = {
                                                          uuid = "264806882395022933";
                                                        }; -- shared
                                                      }; -- all_favicon_ico
                                                      all_google_verification = {
                                                        priority = 107;
                                                        pattern = "/google(.*)";
                                                        case_insensitive = true;
                                                        shared = {
                                                          uuid = "758824134262716168";
                                                        }; -- shared
                                                      }; -- all_google_verification
                                                      all_nearest_js = {
                                                        priority = 106;
                                                        pattern = "/nearest.js(.*)";
                                                        case_insensitive = true;
                                                        shared = {
                                                          uuid = "2837673959647856177";
                                                        }; -- shared
                                                      }; -- all_nearest_js
                                                      ["all_robots-txt"] = {
                                                        priority = 105;
                                                        pattern = "/robots.txt.*";
                                                        case_insensitive = true;
                                                        shared = {
                                                          uuid = "7592105171323000633";
                                                        }; -- shared
                                                      }; -- ["all_robots-txt"]
                                                      all_ssle_gif = {
                                                        priority = 104;
                                                        pattern = "/_ssle.gif(.*)";
                                                        case_insensitive = true;
                                                        shared = {
                                                          uuid = "6807314109941869051";
                                                        }; -- shared
                                                      }; -- all_ssle_gif
                                                      ["all_yandex-apps-api"] = {
                                                        priority = 103;
                                                        pattern = ".*/yandex-apps-api/__webview-intercepted/_api.js.*";
                                                        case_insensitive = true;
                                                        shared = {
                                                          uuid = "5657162669462195568";
                                                        }; -- shared
                                                      }; -- ["all_yandex-apps-api"]
                                                      pki_validation = {
                                                        priority = 102;
                                                        pattern = "/.well-known/pki-validation(.*)";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "pki_validation";
                                                          ranges = get_str_var("default_ranges");
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          errordocument = {
                                                            status = 200;
                                                            force_conn_close = false;
                                                            content = "/rJtUXXaDdzxHJCc4rxIcNZgGrKiHmLYQV+JtIb6s5w=";
                                                          }; -- errordocument
                                                        }; -- report
                                                      }; -- pki_validation
                                                      shared_sections = {
                                                        priority = 101;
                                                        pattern = "/637c2054cfdbcdaf43f9227014b8940d";
                                                        case_insensitive = true;
                                                        balancer2 = {
                                                          unique_policy = {};
                                                          attempts = 1;
                                                          rr = {
                                                            {
                                                              weight = -1.000;
                                                              shared = {
                                                                uuid = "options_verb_section";
                                                                headers = {
                                                                  create = {
                                                                    ["Access-Control-Allow-Headers"] = "Keep-Alive,User-Agent,X-Requested-With,If-Modified-Since,Cache-Control,Content-Type";
                                                                    ["Access-Control-Allow-Methods"] = "GET, OPTIONS";
                                                                    ["Access-Control-Allow-Origin"] = "*";
                                                                    ["Content-Length"] = "0";
                                                                    ["Content-Type"] = "text/plain charset=UTF-8";
                                                                  }; -- create
                                                                  errordocument = {
                                                                    status = 200;
                                                                    force_conn_close = false;
                                                                  }; -- errordocument
                                                                }; -- headers
                                                              }; -- shared
                                                            };
                                                            {
                                                              weight = -1.000;
                                                              shared = {
                                                                uuid = "yastatic_s3_shared";
                                                                report = {
                                                                  uuid = "s3_report";
                                                                  ranges = get_str_var("default_ranges");
                                                                  just_storage = false;
                                                                  disable_robotness = true;
                                                                  disable_sslness = true;
                                                                  events = {
                                                                    stats = "report";
                                                                  }; -- events
                                                                  balancer2 = {
                                                                    simple_policy = {};
                                                                    attempts = 5;
                                                                    rr = {
                                                                      unpack(gen_proxy_backends({
                                                                        { "yastatic.s3.yandex.net"; 80; 1.000; "2a02:6b8::2:158"; };
                                                                      }, {
                                                                        resolve_timeout = "10ms";
                                                                        connect_timeout = "50ms";
                                                                        backend_timeout = "60s";
                                                                        fail_on_5xx = true;
                                                                        http_backend = true;
                                                                        buffering = false;
                                                                        keepalive_count = 1;
                                                                        need_resolve = false;
                                                                        keepalive_timeout = "180s";
                                                                      }))
                                                                    }; -- rr
                                                                  }; -- balancer2
                                                                }; -- report
                                                              }; -- shared
                                                            };
                                                            {
                                                              weight = -1.000;
                                                              shared = {
                                                                uuid = "yastatic_s3_cached_shared";
                                                                report = {
                                                                  uuid = "s3_cached_report";
                                                                  ranges = get_str_var("default_ranges");
                                                                  just_storage = false;
                                                                  disable_robotness = true;
                                                                  disable_sslness = true;
                                                                  events = {
                                                                    stats = "report";
                                                                  }; -- events
                                                                  response_headers = {
                                                                    delete = "Connection";
                                                                    log_headers = {
                                                                      name_re = "Host";
                                                                      balancer2 = {
                                                                        unique_policy = {};
                                                                        attempts = 1;
                                                                        rr = {
                                                                          weights_file = "./controls/macache";
                                                                          with_macache = {
                                                                            weight = -1.000;
                                                                            report = {
                                                                              uuid = "total_request_with_macache";
                                                                              ranges = get_str_var("default_ranges");
                                                                              just_storage = false;
                                                                              disable_robotness = true;
                                                                              disable_sslness = true;
                                                                              events = {
                                                                                stats = "report";
                                                                              }; -- events
                                                                              cache2 = {
                                                                                cache_ttl = "600s";
                                                                                shard_number = 10;
                                                                                balancer2 = {
                                                                                  simple_policy = {};
                                                                                  attempts = 1;
                                                                                  rr = {
                                                                                    unpack(gen_proxy_backends({
                                                                                      { "yastatic.s3.yandex.net"; 80; 1.000; "2a02:6b8::2:158"; };
                                                                                    }, {
                                                                                      resolve_timeout = "10ms";
                                                                                      connect_timeout = "50ms";
                                                                                      backend_timeout = "60s";
                                                                                      fail_on_5xx = true;
                                                                                      http_backend = true;
                                                                                      buffering = false;
                                                                                      keepalive_count = 1;
                                                                                      need_resolve = false;
                                                                                      keepalive_timeout = "180s";
                                                                                    }))
                                                                                  }; -- rr
                                                                                  on_error = {
                                                                                    errordocument = {
                                                                                      status = 503;
                                                                                      force_conn_close = false;
                                                                                    }; -- errordocument
                                                                                  }; -- on_error
                                                                                  on_status_code = {
                                                                                    ["404"] = {
                                                                                      errordocument = {
                                                                                        status = 404;
                                                                                        content = "Not Found";
                                                                                        force_conn_close = false;
                                                                                      }; -- errordocument
                                                                                    }; -- ["404"]
                                                                                  }; -- on_status_code
                                                                                }; -- balancer2
                                                                              }; -- cache2
                                                                            }; -- report
                                                                          }; -- with_macache
                                                                          without_macache = {
                                                                            weight = 1.000;
                                                                            report = {
                                                                              uuid = "total_request_with_old_cache";
                                                                              ranges = get_str_var("default_ranges");
                                                                              just_storage = false;
                                                                              disable_robotness = true;
                                                                              disable_sslness = true;
                                                                              events = {
                                                                                stats = "report";
                                                                              }; -- events
                                                                              balancer2 = {
                                                                                simple_policy = {};
                                                                                attempts = 1;
                                                                                rr = {
                                                                                  unpack(gen_proxy_backends({
                                                                                    { "localhost"; 8888; 1.000; "::1"; };
                                                                                  }, {
                                                                                    resolve_timeout = "10ms";
                                                                                    connect_timeout = "50ms";
                                                                                    backend_timeout = "60s";
                                                                                    fail_on_5xx = true;
                                                                                    http_backend = true;
                                                                                    buffering = false;
                                                                                    keepalive_count = 5;
                                                                                    need_resolve = false;
                                                                                    keepalive_timeout = "180s";
                                                                                  }))
                                                                                }; -- rr
                                                                                on_error = {
                                                                                  errordocument = {
                                                                                    status = 503;
                                                                                    force_conn_close = false;
                                                                                  }; -- errordocument
                                                                                }; -- on_error
                                                                                on_status_code = {
                                                                                  ["404"] = {
                                                                                    errordocument = {
                                                                                      status = 404;
                                                                                      content = "Not Found";
                                                                                      force_conn_close = false;
                                                                                    }; -- errordocument
                                                                                  }; -- ["404"]
                                                                                }; -- on_status_code
                                                                              }; -- balancer2
                                                                            }; -- report
                                                                          }; -- without_macache
                                                                        }; -- rr
                                                                      }; -- balancer2
                                                                    }; -- log_headers
                                                                  }; -- response_headers
                                                                }; -- report
                                                              }; -- shared
                                                            };
                                                            {
                                                              weight = -1.000;
                                                              shared = {
                                                                uuid = "yastatic_s3_mdst_shared";
                                                                report = {
                                                                  uuid = "s3_mdst_report";
                                                                  ranges = get_str_var("default_ranges");
                                                                  just_storage = false;
                                                                  disable_robotness = true;
                                                                  disable_sslness = true;
                                                                  events = {
                                                                    stats = "report";
                                                                  }; -- events
                                                                  response_headers = {
                                                                    delete = "Connection";
                                                                    balancer2 = {
                                                                      simple_policy = {};
                                                                      attempts = 1;
                                                                      rr = {
                                                                        unpack(gen_proxy_backends({
                                                                          { "s3.mdst.yandex.net"; 80; 1.000; "2a02:6b8:0:3400::40f"; };
                                                                        }, {
                                                                          resolve_timeout = "10ms";
                                                                          connect_timeout = "50ms";
                                                                          backend_timeout = "60s";
                                                                          fail_on_5xx = true;
                                                                          http_backend = true;
                                                                          buffering = false;
                                                                          keepalive_count = 5;
                                                                          need_resolve = false;
                                                                          keepalive_timeout = "180s";
                                                                        }))
                                                                      }; -- rr
                                                                      on_error = {
                                                                        errordocument = {
                                                                          status = 503;
                                                                          force_conn_close = false;
                                                                        }; -- errordocument
                                                                      }; -- on_error
                                                                      on_status_code = {
                                                                        ["404"] = {
                                                                          errordocument = {
                                                                            status = 404;
                                                                            content = "Not Found";
                                                                            force_conn_close = false;
                                                                          }; -- errordocument
                                                                        }; -- ["404"]
                                                                      }; -- on_status_code
                                                                    }; -- balancer2
                                                                  }; -- response_headers
                                                                }; -- report
                                                              }; -- shared
                                                            };
                                                            {
                                                              weight = -1.000;
                                                              shared = {
                                                                uuid = "yastatic_s3_cryprox_shared";
                                                                response_headers = {
                                                                  delete = "Connection";
                                                                  balancer2 = {
                                                                    simple_policy = {};
                                                                    attempts = 1;
                                                                    rr = {
                                                                      unpack(gen_proxy_backends({
                                                                        { "localhost"; 8888; 1.000; "::1"; };
                                                                      }, {
                                                                        resolve_timeout = "10ms";
                                                                        connect_timeout = "50ms";
                                                                        backend_timeout = "60s";
                                                                        fail_on_5xx = true;
                                                                        http_backend = true;
                                                                        buffering = false;
                                                                        keepalive_count = 1;
                                                                        need_resolve = false;
                                                                        keepalive_timeout = "180s";
                                                                      }))
                                                                    }; -- rr
                                                                    on_status_code = {
                                                                      ["400"] = {
                                                                        shared = {
                                                                          uuid = "cryprox_on_status_shared";
                                                                          response_headers = {
                                                                            create_func = {
                                                                              ["Last-Modified"] = "time:+1ms";
                                                                            }; -- create_func
                                                                            headers = {
                                                                              create = {
                                                                                Host = "yastatic.net";
                                                                                ["X-AAB-PartnerToken"] = get_str_env_var("AWACS_AAB_TOKEN");
                                                                                ["X-Forwarded-Proto"] = "https";
                                                                              }; -- create
                                                                              balancer2 = {
                                                                                simple_policy = {};
                                                                                attempts = 5;
                                                                                rr = {
                                                                                  unpack(gen_proxy_backends({
                                                                                    { "cryprox.yandex.net"; 80; 1.000; "2a02:6b8::402"; };
                                                                                  }, {
                                                                                    resolve_timeout = "10ms";
                                                                                    connect_timeout = "50ms";
                                                                                    backend_timeout = "60s";
                                                                                    fail_on_5xx = true;
                                                                                    http_backend = true;
                                                                                    buffering = false;
                                                                                    keepalive_count = 1;
                                                                                    need_resolve = true;
                                                                                    keepalive_timeout = "180s";
                                                                                  }))
                                                                                }; -- rr
                                                                                on_error = {
                                                                                  errordocument = {
                                                                                    status = 503;
                                                                                    force_conn_close = false;
                                                                                  }; -- errordocument
                                                                                }; -- on_error
                                                                              }; -- balancer2
                                                                            }; -- headers
                                                                          }; -- response_headers
                                                                        }; -- shared
                                                                      }; -- ["400"]
                                                                      ["404"] = {
                                                                        shared = {
                                                                          uuid = "cryprox_on_status_shared";
                                                                        }; -- shared
                                                                      }; -- ["404"]
                                                                    }; -- on_status_code
                                                                  }; -- balancer2
                                                                }; -- response_headers
                                                              }; -- shared
                                                            };
                                                            {
                                                              weight = -1.000;
                                                              shared = {
                                                                uuid = "yastatic_s3_cryprox_test_shared";
                                                                response_headers = {
                                                                  delete = "Connection";
                                                                  balancer2 = {
                                                                    simple_policy = {};
                                                                    attempts = 1;
                                                                    rr = {
                                                                      unpack(gen_proxy_backends({
                                                                        { "localhost"; 8888; 1.000; "::1"; };
                                                                      }, {
                                                                        resolve_timeout = "10ms";
                                                                        connect_timeout = "50ms";
                                                                        backend_timeout = "60s";
                                                                        fail_on_5xx = true;
                                                                        http_backend = true;
                                                                        buffering = false;
                                                                        keepalive_count = 1;
                                                                        need_resolve = false;
                                                                        keepalive_timeout = "180s";
                                                                      }))
                                                                    }; -- rr
                                                                    on_status_code = {
                                                                      ["400"] = {
                                                                        shared = {
                                                                          uuid = "cryprox_test_on_status_shared";
                                                                          response_headers = {
                                                                            create_func = {
                                                                              ["Last-Modified"] = "time:+1ms";
                                                                            }; -- create_func
                                                                            headers = {
                                                                              create = {
                                                                                Host = "yastatic.net";
                                                                                ["X-AAB-PartnerToken"] = get_str_env_var("AWACS_AAB_TOKEN");
                                                                                ["X-Forwarded-Proto"] = "https";
                                                                              }; -- create
                                                                              balancer2 = {
                                                                                simple_policy = {};
                                                                                attempts = 5;
                                                                                rr = {
                                                                                  unpack(gen_proxy_backends({
                                                                                    { "cryprox-test.yandex.net"; 80; 1.000; "2a02:6b8::197"; };
                                                                                  }, {
                                                                                    resolve_timeout = "10ms";
                                                                                    connect_timeout = "50ms";
                                                                                    backend_timeout = "60s";
                                                                                    fail_on_5xx = true;
                                                                                    http_backend = true;
                                                                                    buffering = false;
                                                                                    keepalive_count = 1;
                                                                                    need_resolve = true;
                                                                                    keepalive_timeout = "180s";
                                                                                  }))
                                                                                }; -- rr
                                                                                on_error = {
                                                                                  errordocument = {
                                                                                    status = 503;
                                                                                    force_conn_close = false;
                                                                                  }; -- errordocument
                                                                                }; -- on_error
                                                                              }; -- balancer2
                                                                            }; -- headers
                                                                          }; -- response_headers
                                                                        }; -- shared
                                                                      }; -- ["400"]
                                                                      ["404"] = {
                                                                        shared = {
                                                                          uuid = "cryprox_test_on_status_shared";
                                                                        }; -- shared
                                                                      }; -- ["404"]
                                                                    }; -- on_status_code
                                                                  }; -- balancer2
                                                                }; -- response_headers
                                                              }; -- shared
                                                            };
                                                            {
                                                              weight = 1.000;
                                                              errordocument = {
                                                                status = 404;
                                                                force_conn_close = false;
                                                              }; -- errordocument
                                                            };
                                                          }; -- rr
                                                        }; -- balancer2
                                                      }; -- shared_sections
                                                      upstream_ok = {
                                                        priority = 100;
                                                        pattern = "/ok.html(.*)";
                                                        case_insensitive = true;
                                                        shared = {
                                                          uuid = "2565190060538431584";
                                                        }; -- shared
                                                      }; -- upstream_ok
                                                      yastatic_net_angular = {
                                                        priority = 99;
                                                        pattern = "/angularjs(/.*)?";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "yastatic_net_angular";
                                                          ranges = get_str_var("default_ranges");
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          headers = {
                                                            create = {
                                                              Location = "https://ajax.googleapis.com/ajax/libs";
                                                            }; -- create
                                                            rewrite = {
                                                              actions = {
                                                                {
                                                                  global = false;
                                                                  literal = false;
                                                                  regexp = "(.*)";
                                                                  rewrite = "%1%{url}";
                                                                  case_insensitive = false;
                                                                  header_name = "Location";
                                                                };
                                                              }; -- actions
                                                              headers_forwarder = {
                                                                actions = {
                                                                  {
                                                                    request_header = "Location";
                                                                    response_header = "Location";
                                                                    erase_from_request = false;
                                                                    erase_from_response = false;
                                                                    weak = false;
                                                                  };
                                                                }; -- actions
                                                                errordocument = {
                                                                  status = 302;
                                                                  force_conn_close = false;
                                                                }; -- errordocument
                                                              }; -- headers_forwarder
                                                            }; -- rewrite
                                                          }; -- headers
                                                        }; -- report
                                                      }; -- yastatic_net_angular
                                                      yastatic_net_comments = {
                                                        priority = 98;
                                                        pattern = "/comments(/.*)?";
                                                        case_insensitive = true;
                                                        rewrite = {
                                                          actions = {
                                                            {
                                                              global = false;
                                                              literal = false;
                                                              rewrite = "/%1";
                                                              case_insensitive = false;
                                                              regexp = "/comments/(.*)";
                                                            };
                                                          }; -- actions
                                                          report = {
                                                            uuid = "yastatic_net_comments";
                                                            ranges = get_str_var("default_ranges");
                                                            just_storage = false;
                                                            disable_robotness = true;
                                                            disable_sslness = true;
                                                            events = {
                                                              stats = "report";
                                                            }; -- events
                                                            shared = {
                                                              uuid = "yastatic_net_comments";
                                                              response_headers = {
                                                                create = {
                                                                  ["Access-Control-Allow-Origin"] = "*";
                                                                  ["Timing-Allow-Origin"] = "*";
                                                                }; -- create
                                                                headers = {
                                                                  create = {
                                                                    Host = "yastatic.net";
                                                                    ["Y-Traffic-Source"] = "msk-yastatic.net";
                                                                  }; -- create
                                                                  balancer2 = {
                                                                    simple_policy = {};
                                                                    attempts = 1;
                                                                    sd = {
                                                                      endpoint_sets = {
                                                                        {
                                                                          cluster_name = "vla";
                                                                          endpoint_set_id = "cmnt-loader-alpha";
                                                                        };
                                                                        {
                                                                          cluster_name = "sas";
                                                                          endpoint_set_id = "cmnt-loader-alpha";
                                                                        };
                                                                        {
                                                                          cluster_name = "man";
                                                                          endpoint_set_id = "cmnt-loader-alpha";
                                                                        };
                                                                      }; -- endpoint_sets
                                                                      proxy_options = {
                                                                        resolve_timeout = "10ms";
                                                                        connect_timeout = "50ms";
                                                                        backend_timeout = "60s";
                                                                        fail_on_5xx = true;
                                                                        http_backend = true;
                                                                        buffering = false;
                                                                        keepalive_count = 5;
                                                                        need_resolve = false;
                                                                        keepalive_timeout = "180s";
                                                                      }; -- proxy_options
                                                                      rr = {};
                                                                    }; -- sd
                                                                    on_error = {
                                                                      errordocument = {
                                                                        status = 503;
                                                                        force_conn_close = false;
                                                                      }; -- errordocument
                                                                    }; -- on_error
                                                                    on_status_code = {
                                                                      ["404"] = {
                                                                        errordocument = {
                                                                          status = 404;
                                                                          content = "Not Found";
                                                                          force_conn_close = false;
                                                                        }; -- errordocument
                                                                      }; -- ["404"]
                                                                    }; -- on_status_code
                                                                  }; -- balancer2
                                                                }; -- headers
                                                              }; -- response_headers
                                                            }; -- shared
                                                          }; -- report
                                                        }; -- rewrite
                                                      }; -- yastatic_net_comments
                                                      yastatic_net_qloud_q = {
                                                        priority = 97;
                                                        pattern = "/q(/.*)?";
                                                        case_insensitive = true;
                                                        rewrite = {
                                                          actions = {
                                                            {
                                                              global = false;
                                                              literal = false;
                                                              rewrite = "%1/%2%3";
                                                              case_insensitive = false;
                                                              regexp = "^(/.*)?/v-[^/a-zA-Z]+/(.*)(\\?.*)?$";
                                                            };
                                                          }; -- actions
                                                          report = {
                                                            uuid = "yastatic_net_qloud_q";
                                                            ranges = get_str_var("default_ranges");
                                                            just_storage = false;
                                                            disable_robotness = true;
                                                            disable_sslness = true;
                                                            events = {
                                                              stats = "report";
                                                            }; -- events
                                                            shared = {
                                                              uuid = "yastatic_net_qloud_q";
                                                              response_headers = {
                                                                create_func = {
                                                                  Expires = "time:+216001s";
                                                                }; -- create_func
                                                                create = {
                                                                  ["Access-Control-Allow-Origin"] = "*";
                                                                  ["Cache-Control"] = "public, max-age=216013";
                                                                  ["Timing-Allow-Origin"] = "*";
                                                                }; -- create
                                                                headers = {
                                                                  create = {
                                                                    Host = "yastatic.net";
                                                                    ["Y-Traffic-Source"] = "msk-yastatic.net";
                                                                  }; -- create
                                                                  balancer2 = {
                                                                    simple_policy = {};
                                                                    attempts = 5;
                                                                    rr = {
                                                                      unpack(gen_proxy_backends({
                                                                        { "router-dev.qloud.yandex.net"; 80; 1.000; "2a02:6b8:0:3400::4:51"; };
                                                                      }, {
                                                                        resolve_timeout = "10ms";
                                                                        connect_timeout = "50ms";
                                                                        backend_timeout = "5s";
                                                                        fail_on_5xx = true;
                                                                        http_backend = true;
                                                                        buffering = false;
                                                                        keepalive_count = 1;
                                                                        need_resolve = true;
                                                                        keepalive_timeout = "60s";
                                                                      }))
                                                                    }; -- rr
                                                                  }; -- balancer2
                                                                }; -- headers
                                                              }; -- response_headers
                                                            }; -- shared
                                                          }; -- report
                                                        }; -- rewrite
                                                      }; -- yastatic_net_qloud_q
                                                      yastatic_net_qloud_yastatic_q = {
                                                        priority = 96;
                                                        pattern = "/yastatic/q(/.*)?";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "yastatic_net_qloud_yastatic_q";
                                                          ranges = get_str_var("default_ranges");
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          shared = {
                                                            uuid = "yastatic_net_qloud_yastatic_q";
                                                            rewrite = {
                                                              actions = {
                                                                {
                                                                  global = false;
                                                                  literal = false;
                                                                  rewrite = "/%1";
                                                                  case_insensitive = false;
                                                                  regexp = "^/yastatic/(.*)$";
                                                                };
                                                              }; -- actions
                                                              headers = {
                                                                create = {
                                                                  Host = "yastatic.net";
                                                                  ["Y-Traffic-Source"] = "msk-yastatic.net";
                                                                }; -- create
                                                                balancer2 = {
                                                                  simple_policy = {};
                                                                  attempts = 5;
                                                                  rr = {
                                                                    unpack(gen_proxy_backends({
                                                                      { "ext-router.qloud.yandex.net"; 80; 1.000; "2a02:6b8:0:3400::4:67"; };
                                                                    }, {
                                                                      resolve_timeout = "10ms";
                                                                      connect_timeout = "50ms";
                                                                      backend_timeout = "5s";
                                                                      fail_on_5xx = true;
                                                                      http_backend = true;
                                                                      buffering = false;
                                                                      keepalive_count = 1;
                                                                      need_resolve = true;
                                                                      keepalive_timeout = "60s";
                                                                    }))
                                                                  }; -- rr
                                                                }; -- balancer2
                                                              }; -- headers
                                                            }; -- rewrite
                                                          }; -- shared
                                                        }; -- report
                                                      }; -- yastatic_net_qloud_yastatic_q
                                                      ["yastatic_net_s3_aab-pub"] = {
                                                        priority = 95;
                                                        pattern = "/aab-pub(/.*)?";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "yastatic_net_s3_aab-pub";
                                                          ranges = get_str_var("default_ranges");
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          shared = {
                                                            uuid = "yastatic_net_s3_aab-pub";
                                                            response_headers = {
                                                              create_func = {
                                                                Expires = "time:+216001s";
                                                              }; -- create_func
                                                              create = {
                                                                ["Access-Control-Allow-Origin"] = "*";
                                                                ["Cache-Control"] = "public, max-age=216013";
                                                                ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                                ["Timing-Allow-Origin"] = "*";
                                                              }; -- create
                                                              headers = {
                                                                create = {
                                                                  Host = "aab-pub.s3.yandex.net";
                                                                }; -- create
                                                                rewrite = {
                                                                  actions = {
                                                                    {
                                                                      global = false;
                                                                      literal = false;
                                                                      rewrite = "/%1";
                                                                      case_insensitive = false;
                                                                      regexp = "/aab-pub/(.*)";
                                                                    };
                                                                  }; -- actions
                                                                  regexp = {
                                                                    br_section = {
                                                                      priority = 3;
                                                                      match_fsm = {
                                                                        header = {
                                                                          name = "accept-encoding";
                                                                          value = "(.*,\\s*|)br(\\s*;\\s*q\\s*=\\s*(1|0\\.0*[1-9]).*|\\s*,.*|)";
                                                                        }; -- header
                                                                        case_insensitive = true;
                                                                        surround = false;
                                                                      }; -- match_fsm
                                                                      rewrite = {
                                                                        actions = {
                                                                          {
                                                                            global = false;
                                                                            literal = false;
                                                                            rewrite = "%1.br";
                                                                            case_insensitive = false;
                                                                            regexp = "([^\\?]+)(.*)";
                                                                          };
                                                                        }; -- actions
                                                                        response_headers = {
                                                                          create = {
                                                                            ["Content-Encoding"] = "br";
                                                                          }; -- create
                                                                          shared = {
                                                                            uuid = "4527020035774959381";
                                                                            shared = {
                                                                              uuid = "yastatic_net_s3_aab-pub_common";
                                                                            }; -- shared
                                                                          }; -- shared
                                                                        }; -- response_headers
                                                                      }; -- rewrite
                                                                    }; -- br_section
                                                                    gzip_section = {
                                                                      priority = 2;
                                                                      match_fsm = {
                                                                        header = {
                                                                          name = "accept-encoding";
                                                                          value = "(.*,\\s*|)gzip(\\s*;\\s*q\\s*=\\s*(1|0\\.0*[1-9]).*|\\s*,.*|)";
                                                                        }; -- header
                                                                        case_insensitive = true;
                                                                        surround = false;
                                                                      }; -- match_fsm
                                                                      rewrite = {
                                                                        actions = {
                                                                          {
                                                                            global = false;
                                                                            literal = false;
                                                                            rewrite = "%1.gz";
                                                                            case_insensitive = false;
                                                                            regexp = "([^\\?]+)(.*)";
                                                                          };
                                                                        }; -- actions
                                                                        response_headers = {
                                                                          create = {
                                                                            ["Content-Encoding"] = "gzip";
                                                                          }; -- create
                                                                          shared = {
                                                                            uuid = "4527020035774959381";
                                                                          }; -- shared
                                                                        }; -- response_headers
                                                                      }; -- rewrite
                                                                    }; -- gzip_section
                                                                    default = {
                                                                      priority = 1;
                                                                      shared = {
                                                                        uuid = "yastatic_net_s3_aab-pub_common";
                                                                        shared = {
                                                                          uuid = "2679703888242934312";
                                                                        }; -- shared
                                                                      }; -- shared
                                                                    }; -- default
                                                                  }; -- regexp
                                                                }; -- rewrite
                                                              }; -- headers
                                                            }; -- response_headers
                                                          }; -- shared
                                                        }; -- report
                                                      }; -- ["yastatic_net_s3_aab-pub"]
                                                      ["yastatic_net_s3_addappter-partners"] = {
                                                        priority = 94;
                                                        pattern = "/s3/addappter-partners(/.*)?";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "yastatic_net_s3_addappter-partners";
                                                          ranges = get_str_var("default_ranges");
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          shared = {
                                                            uuid = "yastatic_net_s3_addappter-partners";
                                                            headers = {
                                                              create = {
                                                                Host = "addappter-partners.s3.yandex.net";
                                                              }; -- create
                                                              response_headers = {
                                                                create = {
                                                                  ["Access-Control-Allow-Origin"] = "*";
                                                                  ["Cache-Control"] = "public, max-age=216013";
                                                                  ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                                  ["Timing-Allow-Origin"] = "*";
                                                                }; -- create
                                                                regexp = {
                                                                  br_section = {
                                                                    priority = 3;
                                                                    match_and = {
                                                                      {
                                                                        match_fsm = {
                                                                          path = ".*(\\.js|\\.css|\\.woff|\\.gif|\\.png|\\.jpg|\\.svg|\\.ico)";
                                                                          case_insensitive = true;
                                                                          surround = false;
                                                                        }; -- match_fsm
                                                                      };
                                                                      {
                                                                        match_fsm = {
                                                                          header = {
                                                                            name = "accept-encoding";
                                                                            value = "(.*,\\s*|)br(\\s*;\\s*q\\s*=\\s*(1|0\\.0*[1-9]).*|\\s*,.*|)";
                                                                          }; -- header
                                                                          case_insensitive = true;
                                                                          surround = false;
                                                                        }; -- match_fsm
                                                                      };
                                                                    }; -- match_and
                                                                    rewrite = {
                                                                      actions = {
                                                                        {
                                                                          global = false;
                                                                          literal = false;
                                                                          rewrite = "%1.br";
                                                                          case_insensitive = false;
                                                                          regexp = "([^\\?]+)(.*)";
                                                                        };
                                                                      }; -- actions
                                                                      response_headers = {
                                                                        create = {
                                                                          ["Content-Encoding"] = "br";
                                                                        }; -- create
                                                                        shared = {
                                                                          uuid = "6358170829433598293";
                                                                          shared = {
                                                                            uuid = "yastatic_net_s3_addappter-partners_common";
                                                                          }; -- shared
                                                                        }; -- shared
                                                                      }; -- response_headers
                                                                    }; -- rewrite
                                                                  }; -- br_section
                                                                  gzip_section = {
                                                                    priority = 2;
                                                                    match_and = {
                                                                      {
                                                                        match_fsm = {
                                                                          path = ".*(\\.js|\\.css|\\.woff|\\.gif|\\.png|\\.jpg|\\.svg|\\.ico)";
                                                                          case_insensitive = true;
                                                                          surround = false;
                                                                        }; -- match_fsm
                                                                      };
                                                                      {
                                                                        match_fsm = {
                                                                          header = {
                                                                            name = "accept-encoding";
                                                                            value = "(.*,\\s*|)gzip(\\s*;\\s*q\\s*=\\s*(1|0\\.0*[1-9]).*|\\s*,.*|)";
                                                                          }; -- header
                                                                          case_insensitive = true;
                                                                          surround = false;
                                                                        }; -- match_fsm
                                                                      };
                                                                    }; -- match_and
                                                                    rewrite = {
                                                                      actions = {
                                                                        {
                                                                          global = false;
                                                                          literal = false;
                                                                          rewrite = "%1.gz";
                                                                          case_insensitive = false;
                                                                          regexp = "([^\\?]+)(.*)";
                                                                        };
                                                                      }; -- actions
                                                                      response_headers = {
                                                                        create = {
                                                                          ["Content-Encoding"] = "gzip";
                                                                        }; -- create
                                                                        shared = {
                                                                          uuid = "6358170829433598293";
                                                                        }; -- shared
                                                                      }; -- response_headers
                                                                    }; -- rewrite
                                                                  }; -- gzip_section
                                                                  default = {
                                                                    priority = 1;
                                                                    shared = {
                                                                      uuid = "yastatic_net_s3_addappter-partners_common";
                                                                      shared = {
                                                                        uuid = "4278682503402935169";
                                                                        headers = {
                                                                          delete = "authorization|accept-encoding";
                                                                          response_headers = {
                                                                            delete = "content-encoding";
                                                                            shared = {
                                                                              uuid = "4957618399187796178";
                                                                            }; -- shared
                                                                          }; -- response_headers
                                                                        }; -- headers
                                                                      }; -- shared
                                                                    }; -- shared
                                                                  }; -- default
                                                                }; -- regexp
                                                              }; -- response_headers
                                                            }; -- headers
                                                          }; -- shared
                                                        }; -- report
                                                      }; -- ["yastatic_net_s3_addappter-partners"]
                                                      ["yastatic_net_s3_avia-frontend"] = {
                                                        priority = 93;
                                                        pattern = "/s3/avia-frontend(/.*)?";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "yastatic_net_s3_avia-frontend";
                                                          ranges = get_str_var("default_ranges");
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          shared = {
                                                            uuid = "yastatic_net_s3_avia-frontend";
                                                            headers = {
                                                              delete = "authorization";
                                                              create = {
                                                                Host = "avia-frontend.s3.yandex.net";
                                                              }; -- create
                                                              rewrite = {
                                                                actions = {
                                                                  {
                                                                    global = false;
                                                                    literal = false;
                                                                    rewrite = "/%1";
                                                                    case_insensitive = false;
                                                                    regexp = "/s3/avia-frontend/(.*)";
                                                                  };
                                                                }; -- actions
                                                                response_headers = {
                                                                  create_func = {
                                                                    Expires = "time:+216001s";
                                                                  }; -- create_func
                                                                  create = {
                                                                    ["Access-Control-Allow-Origin"] = "*";
                                                                    ["Cache-Control"] = "public, max-age=216013";
                                                                    ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                                    ["Timing-Allow-Origin"] = "*";
                                                                  }; -- create
                                                                  regexp = {
                                                                    br_section = {
                                                                      priority = 3;
                                                                      match_and = {
                                                                        {
                                                                          match_not = {
                                                                            match_fsm = {
                                                                              path = ".*(\\.png)";
                                                                              case_insensitive = true;
                                                                              surround = false;
                                                                            }; -- match_fsm
                                                                          }; -- match_not
                                                                        };
                                                                        {
                                                                          match_fsm = {
                                                                            header = {
                                                                              name = "accept-encoding";
                                                                              value = "(.*,\\s*|)br(\\s*;\\s*q\\s*=\\s*(1|0\\.0*[1-9]).*|\\s*,.*|)";
                                                                            }; -- header
                                                                            case_insensitive = true;
                                                                            surround = false;
                                                                          }; -- match_fsm
                                                                        };
                                                                      }; -- match_and
                                                                      rewrite = {
                                                                        actions = {
                                                                          {
                                                                            global = false;
                                                                            literal = false;
                                                                            rewrite = "%1.br";
                                                                            case_insensitive = false;
                                                                            regexp = "([^\\?]+)(.*)";
                                                                          };
                                                                        }; -- actions
                                                                        response_headers_if = {
                                                                          matcher = {
                                                                            match_response_codes = {
                                                                              codes = { 200; 204; 206; };
                                                                            }; -- match_response_codes
                                                                          }; -- matcher
                                                                          create_header = {
                                                                            ["Content-Encoding"] = "br";
                                                                          }; -- create_header
                                                                          shared = {
                                                                            uuid = "6405024891875179291";
                                                                            shared = {
                                                                              uuid = "yastatic_net_s3_avia-frontend_common";
                                                                            }; -- shared
                                                                          }; -- shared
                                                                        }; -- response_headers_if
                                                                      }; -- rewrite
                                                                    }; -- br_section
                                                                    gzip_section = {
                                                                      priority = 2;
                                                                      match_and = {
                                                                        {
                                                                          match_not = {
                                                                            match_fsm = {
                                                                              path = ".*(\\.png)";
                                                                              case_insensitive = true;
                                                                              surround = false;
                                                                            }; -- match_fsm
                                                                          }; -- match_not
                                                                        };
                                                                        {
                                                                          match_fsm = {
                                                                            header = {
                                                                              name = "accept-encoding";
                                                                              value = "(.*,\\s*|)gzip(\\s*;\\s*q\\s*=\\s*(1|0\\.0*[1-9]).*|\\s*,.*|)";
                                                                            }; -- header
                                                                            case_insensitive = true;
                                                                            surround = false;
                                                                          }; -- match_fsm
                                                                        };
                                                                      }; -- match_and
                                                                      rewrite = {
                                                                        actions = {
                                                                          {
                                                                            global = false;
                                                                            literal = false;
                                                                            rewrite = "%1.gz";
                                                                            case_insensitive = false;
                                                                            regexp = "([^\\?]+)(.*)";
                                                                          };
                                                                        }; -- actions
                                                                        response_headers_if = {
                                                                          matcher = {
                                                                            match_response_codes = {
                                                                              codes = { 200; 204; 206; };
                                                                            }; -- match_response_codes
                                                                          }; -- matcher
                                                                          create_header = {
                                                                            ["Content-Encoding"] = "gzip";
                                                                          }; -- create_header
                                                                          shared = {
                                                                            uuid = "6405024891875179291";
                                                                          }; -- shared
                                                                        }; -- response_headers_if
                                                                      }; -- rewrite
                                                                    }; -- gzip_section
                                                                    default = {
                                                                      priority = 1;
                                                                      shared = {
                                                                        uuid = "yastatic_net_s3_avia-frontend_common";
                                                                        shared = {
                                                                          uuid = "2679703888242934312";
                                                                        }; -- shared
                                                                      }; -- shared
                                                                    }; -- default
                                                                  }; -- regexp
                                                                }; -- response_headers
                                                              }; -- rewrite
                                                            }; -- headers
                                                          }; -- shared
                                                        }; -- report
                                                      }; -- ["yastatic_net_s3_avia-frontend"]
                                                      ["yastatic_net_s3_awaps-ad-sdk-js"] = {
                                                        priority = 92;
                                                        pattern = "/awaps-ad-sdk-js/(.*)?";
                                                        case_insensitive = true;
                                                        rewrite = {
                                                          actions = {
                                                            {
                                                              global = false;
                                                              literal = false;
                                                              rewrite = "%1/%2%3";
                                                              case_insensitive = false;
                                                              regexp = "^(/.*)?/v-[^/a-zA-Z]+/(.*)(\\?.*)?$";
                                                            };
                                                          }; -- actions
                                                          report = {
                                                            uuid = "yastatic_net_s3_awaps-ad-sdk-js";
                                                            ranges = get_str_var("default_ranges");
                                                            just_storage = false;
                                                            disable_robotness = true;
                                                            disable_sslness = true;
                                                            events = {
                                                              stats = "report";
                                                            }; -- events
                                                            shared = {
                                                              uuid = "yastatic_net_s3_awaps-ad-sdk-js";
                                                              response_headers = {
                                                                create_func = {
                                                                  Expires = "time:+3600s";
                                                                }; -- create_func
                                                                create = {
                                                                  ["Access-Control-Allow-Origin"] = "*";
                                                                  ["Cache-Control"] = "public, max-age=3600";
                                                                  ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                                  ["Timing-Allow-Origin"] = "*";
                                                                }; -- create
                                                                headers = {
                                                                  create = {
                                                                    Host = "playerweb.s3.yandex.net";
                                                                    PCODE = "testing";
                                                                  }; -- create
                                                                  regexp = {
                                                                    ["1percent"] = {
                                                                      priority = 5;
                                                                      match_fsm = {
                                                                        header = {
                                                                          name = "PCODE";
                                                                          value = "1percent";
                                                                        }; -- header
                                                                        case_insensitive = true;
                                                                        surround = false;
                                                                      }; -- match_fsm
                                                                      rewrite = {
                                                                        actions = {
                                                                          {
                                                                            global = false;
                                                                            literal = false;
                                                                            case_insensitive = false;
                                                                            regexp = "/awaps-ad-sdk-js/1_0/(.*)";
                                                                            rewrite = "/adsdkjs-loaders/1percent/%1";
                                                                          };
                                                                        }; -- actions
                                                                        shared = {
                                                                          uuid = "yastatic_net_s3_awaps-ad-sdk-js_percent";
                                                                          regexp = {
                                                                            br_section = {
                                                                              priority = 3;
                                                                              match_fsm = {
                                                                                header = {
                                                                                  name = "accept-encoding";
                                                                                  value = "(.*,\\s*|)br(\\s*;\\s*q\\s*=\\s*(1|0\\.0*[1-9]).*|\\s*,.*|)";
                                                                                }; -- header
                                                                                case_insensitive = true;
                                                                                surround = false;
                                                                              }; -- match_fsm
                                                                              rewrite = {
                                                                                actions = {
                                                                                  {
                                                                                    global = false;
                                                                                    literal = false;
                                                                                    rewrite = "%1.br";
                                                                                    case_insensitive = false;
                                                                                    regexp = "([^\\?]+)(.*)";
                                                                                  };
                                                                                }; -- actions
                                                                                response_headers = {
                                                                                  create = {
                                                                                    ["Content-Encoding"] = "br";
                                                                                  }; -- create
                                                                                  shared = {
                                                                                    uuid = "4685718898395332326";
                                                                                    shared = {
                                                                                      uuid = "yastatic_net_s3_awaps-ad-sdk-js_common";
                                                                                    }; -- shared
                                                                                  }; -- shared
                                                                                }; -- response_headers
                                                                              }; -- rewrite
                                                                            }; -- br_section
                                                                            gzip_section = {
                                                                              priority = 2;
                                                                              match_fsm = {
                                                                                header = {
                                                                                  name = "accept-encoding";
                                                                                  value = "(.*,\\s*|)gzip(\\s*;\\s*q\\s*=\\s*(1|0\\.0*[1-9]).*|\\s*,.*|)";
                                                                                }; -- header
                                                                                case_insensitive = true;
                                                                                surround = false;
                                                                              }; -- match_fsm
                                                                              rewrite = {
                                                                                actions = {
                                                                                  {
                                                                                    global = false;
                                                                                    literal = false;
                                                                                    rewrite = "%1.gz";
                                                                                    case_insensitive = false;
                                                                                    regexp = "([^\\?]+)(.*)";
                                                                                  };
                                                                                }; -- actions
                                                                                response_headers = {
                                                                                  create = {
                                                                                    ["Content-Encoding"] = "gzip";
                                                                                  }; -- create
                                                                                  shared = {
                                                                                    uuid = "4685718898395332326";
                                                                                  }; -- shared
                                                                                }; -- response_headers
                                                                              }; -- rewrite
                                                                            }; -- gzip_section
                                                                            default = {
                                                                              priority = 1;
                                                                              shared = {
                                                                                uuid = "yastatic_net_s3_awaps-ad-sdk-js_common";
                                                                                shared = {
                                                                                  uuid = "4278682503402935169";
                                                                                }; -- shared
                                                                              }; -- shared
                                                                            }; -- default
                                                                          }; -- regexp
                                                                        }; -- shared
                                                                      }; -- rewrite
                                                                    }; -- ["1percent"]
                                                                    ["5percent"] = {
                                                                      priority = 4;
                                                                      match_fsm = {
                                                                        header = {
                                                                          name = "PCODE";
                                                                          value = "5percent";
                                                                        }; -- header
                                                                        case_insensitive = true;
                                                                        surround = false;
                                                                      }; -- match_fsm
                                                                      rewrite = {
                                                                        actions = {
                                                                          {
                                                                            global = false;
                                                                            literal = false;
                                                                            case_insensitive = false;
                                                                            regexp = "/awaps-ad-sdk-js/1_0/(.*)";
                                                                            rewrite = "/adsdkjs-loaders/5percent/%1";
                                                                          };
                                                                        }; -- actions
                                                                        shared = {
                                                                          uuid = "2496573283010734057";
                                                                          shared = {
                                                                            uuid = "yastatic_net_s3_awaps-ad-sdk-js_percent";
                                                                          }; -- shared
                                                                        }; -- shared
                                                                      }; -- rewrite
                                                                    }; -- ["5percent"]
                                                                    ["20percent"] = {
                                                                      priority = 3;
                                                                      match_fsm = {
                                                                        header = {
                                                                          name = "PCODE";
                                                                          value = "20percent";
                                                                        }; -- header
                                                                        case_insensitive = true;
                                                                        surround = false;
                                                                      }; -- match_fsm
                                                                      rewrite = {
                                                                        actions = {
                                                                          {
                                                                            global = false;
                                                                            literal = false;
                                                                            case_insensitive = false;
                                                                            regexp = "/awaps-ad-sdk-js/1_0/(.*)";
                                                                            rewrite = "/adsdkjs-loaders/20percent/%1";
                                                                          };
                                                                        }; -- actions
                                                                        shared = {
                                                                          uuid = "2496573283010734057";
                                                                        }; -- shared
                                                                      }; -- rewrite
                                                                    }; -- ["20percent"]
                                                                    testing = {
                                                                      priority = 2;
                                                                      match_fsm = {
                                                                        header = {
                                                                          name = "PCODE";
                                                                          value = "testing";
                                                                        }; -- header
                                                                        case_insensitive = true;
                                                                        surround = false;
                                                                      }; -- match_fsm
                                                                      rewrite = {
                                                                        actions = {
                                                                          {
                                                                            global = false;
                                                                            literal = false;
                                                                            case_insensitive = false;
                                                                            regexp = "/awaps-ad-sdk-js/1_0/(.*)";
                                                                            rewrite = "/adsdkjs-loaders/testing/%1";
                                                                          };
                                                                        }; -- actions
                                                                        shared = {
                                                                          uuid = "2496573283010734057";
                                                                        }; -- shared
                                                                      }; -- rewrite
                                                                    }; -- testing
                                                                    default = {
                                                                      priority = 1;
                                                                      rewrite = {
                                                                        actions = {
                                                                          {
                                                                            global = false;
                                                                            literal = false;
                                                                            case_insensitive = false;
                                                                            regexp = "/awaps-ad-sdk-js/1_0/(.*)";
                                                                            rewrite = "/adsdkjs-loaders/100percent/%1";
                                                                          };
                                                                        }; -- actions
                                                                        shared = {
                                                                          uuid = "2496573283010734057";
                                                                        }; -- shared
                                                                      }; -- rewrite
                                                                    }; -- default
                                                                  }; -- regexp
                                                                }; -- headers
                                                              }; -- response_headers
                                                            }; -- shared
                                                          }; -- report
                                                        }; -- rewrite
                                                      }; -- ["yastatic_net_s3_awaps-ad-sdk-js"]
                                                      ["yastatic_net_s3_awaps-ad-sdk-js-bundles"] = {
                                                        priority = 91;
                                                        pattern = "/awaps-ad-sdk-js-bundles/(.*)?";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "yastatic_net_s3_awaps-ad-sdk-js-bundles";
                                                          ranges = get_str_var("default_ranges");
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          shared = {
                                                            uuid = "yastatic_net_s3_awaps-ad-sdk-js-bundles";
                                                            errordocument = {
                                                              status = 404;
                                                              force_conn_close = false;
                                                            }; -- errordocument
                                                          }; -- shared
                                                        }; -- report
                                                      }; -- ["yastatic_net_s3_awaps-ad-sdk-js-bundles"]
                                                      ["yastatic_net_s3_bem-xjst"] = {
                                                        priority = 90;
                                                        pattern = "/bem-xjst(/.*)?";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "yastatic_net_s3_bem-xjst";
                                                          ranges = get_str_var("default_ranges");
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          shared = {
                                                            uuid = "yastatic_net_s3_bem-xjst";
                                                            headers = {
                                                              create = {
                                                                Host = "yastatic.s3.yandex.net";
                                                              }; -- create
                                                              response_headers = {
                                                                create_func = {
                                                                  Expires = "time:+216001s";
                                                                }; -- create_func
                                                                create = {
                                                                  ["Access-Control-Allow-Origin"] = "*";
                                                                  ["Cache-Control"] = "public, max-age=216013";
                                                                  ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                                  ["Timing-Allow-Origin"] = "*";
                                                                }; -- create
                                                                regexp = {
                                                                  br_section = {
                                                                    priority = 3;
                                                                    match_fsm = {
                                                                      header = {
                                                                        name = "accept-encoding";
                                                                        value = "(.*,\\s*|)br(\\s*;\\s*q\\s*=\\s*(1|0\\.0*[1-9]).*|\\s*,.*|)";
                                                                      }; -- header
                                                                      case_insensitive = true;
                                                                      surround = false;
                                                                    }; -- match_fsm
                                                                    rewrite = {
                                                                      actions = {
                                                                        {
                                                                          global = false;
                                                                          literal = false;
                                                                          rewrite = "%1.br";
                                                                          case_insensitive = false;
                                                                          regexp = "([^\\?]+)(.*)";
                                                                        };
                                                                      }; -- actions
                                                                      response_headers = {
                                                                        create = {
                                                                          ["Content-Encoding"] = "br";
                                                                        }; -- create
                                                                        shared = {
                                                                          uuid = "9028002047544623832";
                                                                          shared = {
                                                                            uuid = "yastatic_net_s3_bem-xjst_common";
                                                                          }; -- shared
                                                                        }; -- shared
                                                                      }; -- response_headers
                                                                    }; -- rewrite
                                                                  }; -- br_section
                                                                  gzip_section = {
                                                                    priority = 2;
                                                                    match_fsm = {
                                                                      header = {
                                                                        name = "accept-encoding";
                                                                        value = "(.*,\\s*|)gzip(\\s*;\\s*q\\s*=\\s*(1|0\\.0*[1-9]).*|\\s*,.*|)";
                                                                      }; -- header
                                                                      case_insensitive = true;
                                                                      surround = false;
                                                                    }; -- match_fsm
                                                                    rewrite = {
                                                                      actions = {
                                                                        {
                                                                          global = false;
                                                                          literal = false;
                                                                          rewrite = "%1.gz";
                                                                          case_insensitive = false;
                                                                          regexp = "([^\\?]+)(.*)";
                                                                        };
                                                                      }; -- actions
                                                                      response_headers = {
                                                                        create = {
                                                                          ["Content-Encoding"] = "gzip";
                                                                        }; -- create
                                                                        shared = {
                                                                          uuid = "9028002047544623832";
                                                                        }; -- shared
                                                                      }; -- response_headers
                                                                    }; -- rewrite
                                                                  }; -- gzip_section
                                                                  default = {
                                                                    priority = 1;
                                                                    shared = {
                                                                      uuid = "yastatic_net_s3_bem-xjst_common";
                                                                      shared = {
                                                                        uuid = "2679703888242934312";
                                                                      }; -- shared
                                                                    }; -- shared
                                                                  }; -- default
                                                                }; -- regexp
                                                              }; -- response_headers
                                                            }; -- headers
                                                          }; -- shared
                                                        }; -- report
                                                      }; -- ["yastatic_net_s3_bem-xjst"]
                                                      yastatic_net_s3_chatstatic = {
                                                        priority = 89;
                                                        pattern = "/s3/chat-static(/.*)?";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "yastatic_net_s3_chatstatic";
                                                          ranges = get_str_var("default_ranges");
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          shared = {
                                                            uuid = "yastatic_net_s3_chatstatic";
                                                            headers = {
                                                              create = {
                                                                Host = "chat-static.s3.yandex.net";
                                                              }; -- create
                                                              response_headers = {
                                                                create_func = {
                                                                  Expires = "time:+216001s";
                                                                }; -- create_func
                                                                create = {
                                                                  ["Access-Control-Allow-Origin"] = "*";
                                                                  ["Cache-Control"] = "public, immutable, max-age=216013";
                                                                  ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                                  ["Timing-Allow-Origin"] = "*";
                                                                }; -- create
                                                                rewrite = {
                                                                  actions = {
                                                                    {
                                                                      global = false;
                                                                      rewrite = "%1";
                                                                      literal = false;
                                                                      case_insensitive = false;
                                                                      regexp = "/s3/chat-static(/.*)";
                                                                    };
                                                                  }; -- actions
                                                                  regexp = {
                                                                    br_section = {
                                                                      priority = 3;
                                                                      match_and = {
                                                                        {
                                                                          match_not = {
                                                                            match_fsm = {
                                                                              path = ".*(\\.png)";
                                                                              case_insensitive = true;
                                                                              surround = false;
                                                                            }; -- match_fsm
                                                                          }; -- match_not
                                                                        };
                                                                        {
                                                                          match_fsm = {
                                                                            header = {
                                                                              name = "accept-encoding";
                                                                              value = "(.*,\\s*|)br(\\s*;\\s*q\\s*=\\s*(1|0\\.0*[1-9]).*|\\s*,.*|)";
                                                                            }; -- header
                                                                            case_insensitive = true;
                                                                            surround = false;
                                                                          }; -- match_fsm
                                                                        };
                                                                      }; -- match_and
                                                                      rewrite = {
                                                                        actions = {
                                                                          {
                                                                            global = false;
                                                                            literal = false;
                                                                            rewrite = "%1.br";
                                                                            case_insensitive = false;
                                                                            regexp = "([^\\?]+)(.*)";
                                                                          };
                                                                        }; -- actions
                                                                        response_headers = {
                                                                          create = {
                                                                            ["Content-Encoding"] = "br";
                                                                          }; -- create
                                                                          shared = {
                                                                            uuid = "9080910428170172208";
                                                                            shared = {
                                                                              uuid = "yastatic_net_s3_chatstatic_common";
                                                                            }; -- shared
                                                                          }; -- shared
                                                                        }; -- response_headers
                                                                      }; -- rewrite
                                                                    }; -- br_section
                                                                    gzip_section = {
                                                                      priority = 2;
                                                                      match_and = {
                                                                        {
                                                                          match_not = {
                                                                            match_fsm = {
                                                                              path = ".*(\\.png)";
                                                                              case_insensitive = true;
                                                                              surround = false;
                                                                            }; -- match_fsm
                                                                          }; -- match_not
                                                                        };
                                                                        {
                                                                          match_fsm = {
                                                                            header = {
                                                                              name = "accept-encoding";
                                                                              value = "(.*,\\s*|)gzip(\\s*;\\s*q\\s*=\\s*(1|0\\.0*[1-9]).*|\\s*,.*|)";
                                                                            }; -- header
                                                                            case_insensitive = true;
                                                                            surround = false;
                                                                          }; -- match_fsm
                                                                        };
                                                                      }; -- match_and
                                                                      rewrite = {
                                                                        actions = {
                                                                          {
                                                                            global = false;
                                                                            literal = false;
                                                                            rewrite = "%1.gz";
                                                                            case_insensitive = false;
                                                                            regexp = "([^\\?]+)(.*)";
                                                                          };
                                                                        }; -- actions
                                                                        response_headers = {
                                                                          create = {
                                                                            ["Content-Encoding"] = "gzip";
                                                                          }; -- create
                                                                          shared = {
                                                                            uuid = "9080910428170172208";
                                                                          }; -- shared
                                                                        }; -- response_headers
                                                                      }; -- rewrite
                                                                    }; -- gzip_section
                                                                    default = {
                                                                      priority = 1;
                                                                      shared = {
                                                                        uuid = "yastatic_net_s3_chatstatic_common";
                                                                        shared = {
                                                                          uuid = "2679703888242934312";
                                                                        }; -- shared
                                                                      }; -- shared
                                                                    }; -- default
                                                                  }; -- regexp
                                                                }; -- rewrite
                                                              }; -- response_headers
                                                            }; -- headers
                                                          }; -- shared
                                                        }; -- report
                                                      }; -- yastatic_net_s3_chatstatic
                                                      yastatic_net_s3_chatstatic_yastatic = {
                                                        priority = 88;
                                                        pattern = "/yastatic/s3/chat-static(/.*)?";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "yastatic_net_s3_chatstatic_yastatic";
                                                          ranges = get_str_var("default_ranges");
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          response_headers = {
                                                            create_func = {
                                                              Expires = "time:+216001s";
                                                            }; -- create_func
                                                            create = {
                                                              ["Access-Control-Allow-Origin"] = "*";
                                                              ["Cache-Control"] = "public, immutable, max-age=216013";
                                                              ["Service-Worker-Allowed"] = "/";
                                                              ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                              ["Timing-Allow-Origin"] = "*";
                                                            }; -- create
                                                            rewrite = {
                                                              actions = {
                                                                {
                                                                  global = false;
                                                                  literal = false;
                                                                  case_insensitive = false;
                                                                  rewrite = "/s3/chat-static/%1";
                                                                  regexp = "/yastatic/s3/chat-static/(.*)";
                                                                };
                                                              }; -- actions
                                                              shared = {
                                                                uuid = "yastatic_net_s3_chatstatic";
                                                              }; -- shared
                                                            }; -- rewrite
                                                          }; -- response_headers
                                                        }; -- report
                                                      }; -- yastatic_net_s3_chatstatic_yastatic
                                                      yastatic_net_s3_cmnt = {
                                                        priority = 87;
                                                        pattern = "/s3/(cmnt|comments)(/.*)?";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "yastatic_net_s3_cmnt";
                                                          ranges = get_str_var("default_ranges");
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          shared = {
                                                            uuid = "yastatic_net_s3_cmnt";
                                                            rewrite = {
                                                              actions = {
                                                                {
                                                                  global = false;
                                                                  literal = false;
                                                                  rewrite = "/%2";
                                                                  case_insensitive = false;
                                                                  regexp = "/s3/(cmnt|comments)/(.*)";
                                                                };
                                                              }; -- actions
                                                              headers = {
                                                                create = {
                                                                  Host = "cmnt.s3.yandex.net";
                                                                }; -- create
                                                                regexp = {
                                                                  not_packed = {
                                                                    priority = 4;
                                                                    match_fsm = {
                                                                      path = ".*(\\.png|\\.jpg|\\.map)";
                                                                      case_insensitive = true;
                                                                      surround = false;
                                                                    }; -- match_fsm
                                                                    shared = {
                                                                      uuid = "4343095370204584376";
                                                                      shared = {
                                                                        uuid = "yastatic_net_s3_cmnt_common";
                                                                      }; -- shared
                                                                    }; -- shared
                                                                  }; -- not_packed
                                                                  br_section = {
                                                                    priority = 3;
                                                                    match_fsm = {
                                                                      header = {
                                                                        name = "accept-encoding";
                                                                        value = "(.*,\\s*|)br(\\s*;\\s*q\\s*=\\s*(1|0\\.0*[1-9]).*|\\s*,.*|)";
                                                                      }; -- header
                                                                      case_insensitive = true;
                                                                      surround = false;
                                                                    }; -- match_fsm
                                                                    rewrite = {
                                                                      actions = {
                                                                        {
                                                                          global = false;
                                                                          literal = false;
                                                                          rewrite = "%1.br";
                                                                          case_insensitive = false;
                                                                          regexp = "([^\\?]+)(.*)";
                                                                        };
                                                                      }; -- actions
                                                                      response_headers_if = {
                                                                        matcher = {
                                                                          match_response_codes = {
                                                                            codes = { 200; 204; 206; };
                                                                          }; -- match_response_codes
                                                                        }; -- matcher
                                                                        create_header = {
                                                                          ["Content-Encoding"] = "br";
                                                                        }; -- create_header
                                                                        shared = {
                                                                          uuid = "4343095370204584376";
                                                                        }; -- shared
                                                                      }; -- response_headers_if
                                                                    }; -- rewrite
                                                                  }; -- br_section
                                                                  gzip_section = {
                                                                    priority = 2;
                                                                    match_fsm = {
                                                                      header = {
                                                                        name = "accept-encoding";
                                                                        value = "(.*,\\s*|)gzip(\\s*;\\s*q\\s*=\\s*(1|0\\.0*[1-9]).*|\\s*,.*|)";
                                                                      }; -- header
                                                                      case_insensitive = true;
                                                                      surround = false;
                                                                    }; -- match_fsm
                                                                    rewrite = {
                                                                      actions = {
                                                                        {
                                                                          global = false;
                                                                          literal = false;
                                                                          rewrite = "%1.gz";
                                                                          case_insensitive = false;
                                                                          regexp = "([^\\?]+)(.*)";
                                                                        };
                                                                      }; -- actions
                                                                      response_headers_if = {
                                                                        matcher = {
                                                                          match_response_codes = {
                                                                            codes = { 200; 204; 206; };
                                                                          }; -- match_response_codes
                                                                        }; -- matcher
                                                                        create_header = {
                                                                          ["Content-Encoding"] = "gzip";
                                                                        }; -- create_header
                                                                        shared = {
                                                                          uuid = "4343095370204584376";
                                                                        }; -- shared
                                                                      }; -- response_headers_if
                                                                    }; -- rewrite
                                                                  }; -- gzip_section
                                                                  default = {
                                                                    priority = 1;
                                                                    shared = {
                                                                      uuid = "yastatic_net_s3_cmnt_common";
                                                                      headers = {
                                                                        delete = "Accept-Encoding|Authorization";
                                                                        response_headers = {
                                                                          delete = "Content-Encoding";
                                                                          create_func = {
                                                                            Expires = "time:+216001s";
                                                                          }; -- create_func
                                                                          create = {
                                                                            ["Access-Control-Allow-Origin"] = "*";
                                                                            ["Cache-Control"] = "public, max-age=216013";
                                                                            ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                                            ["Timing-Allow-Origin"] = "*";
                                                                          }; -- create
                                                                          headers_forwarder = {
                                                                            actions = {
                                                                              {
                                                                                request_header = "X-Request-Id";
                                                                                response_header = "X-Request-Id";
                                                                                erase_from_request = false;
                                                                                erase_from_response = false;
                                                                                weak = false;
                                                                              };
                                                                            }; -- actions
                                                                            shared = {
                                                                              uuid = "4957618399187796178";
                                                                            }; -- shared
                                                                          }; -- headers_forwarder
                                                                        }; -- response_headers
                                                                      }; -- headers
                                                                    }; -- shared
                                                                  }; -- default
                                                                }; -- regexp
                                                              }; -- headers
                                                            }; -- rewrite
                                                          }; -- shared
                                                        }; -- report
                                                      }; -- yastatic_net_s3_cmnt
                                                      yastatic_net_s3_collections = {
                                                        priority = 86;
                                                        pattern = "/collections(/.*)?";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "yastatic_net_s3_collections";
                                                          ranges = get_str_var("default_ranges");
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          shared = {
                                                            uuid = "yastatic_net_s3_collections";
                                                            headers = {
                                                              create = {
                                                                Host = "yastatic.s3.yandex.net";
                                                              }; -- create
                                                              response_headers = {
                                                                create_func = {
                                                                  Expires = "time:+216001s";
                                                                }; -- create_func
                                                                create = {
                                                                  ["Access-Control-Allow-Origin"] = "*";
                                                                  ["Cache-Control"] = "public, immutable, max-age=216013";
                                                                  ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                                  ["Timing-Allow-Origin"] = "*";
                                                                }; -- create
                                                                regexp = {
                                                                  br_section = {
                                                                    priority = 3;
                                                                    match_and = {
                                                                      {
                                                                        match_fsm = {
                                                                          path = ".*(\\.js|\\.css|\\.woff|\\.gif|\\.png|\\.jpg|\\.svg|\\.ico)";
                                                                          case_insensitive = true;
                                                                          surround = false;
                                                                        }; -- match_fsm
                                                                      };
                                                                      {
                                                                        match_fsm = {
                                                                          header = {
                                                                            name = "accept-encoding";
                                                                            value = "(.*,\\s*|)br(\\s*;\\s*q\\s*=\\s*(1|0\\.0*[1-9]).*|\\s*,.*|)";
                                                                          }; -- header
                                                                          case_insensitive = true;
                                                                          surround = false;
                                                                        }; -- match_fsm
                                                                      };
                                                                    }; -- match_and
                                                                    rewrite = {
                                                                      actions = {
                                                                        {
                                                                          global = false;
                                                                          literal = false;
                                                                          rewrite = "%1.br";
                                                                          case_insensitive = false;
                                                                          regexp = "([^\\?]+)(.*)";
                                                                        };
                                                                      }; -- actions
                                                                      response_headers = {
                                                                        create = {
                                                                          ["Content-Encoding"] = "br";
                                                                        }; -- create
                                                                        shared = {
                                                                          uuid = "3274977486389626536";
                                                                          shared = {
                                                                            uuid = "yastatic_net_s3_collections_common";
                                                                          }; -- shared
                                                                        }; -- shared
                                                                      }; -- response_headers
                                                                    }; -- rewrite
                                                                  }; -- br_section
                                                                  gzip_section = {
                                                                    priority = 2;
                                                                    match_and = {
                                                                      {
                                                                        match_fsm = {
                                                                          path = ".*(\\.js|\\.css|\\.woff|\\.gif|\\.png|\\.jpg|\\.svg|\\.ico)";
                                                                          case_insensitive = true;
                                                                          surround = false;
                                                                        }; -- match_fsm
                                                                      };
                                                                      {
                                                                        match_fsm = {
                                                                          header = {
                                                                            name = "accept-encoding";
                                                                            value = "(.*,\\s*|)gzip(\\s*;\\s*q\\s*=\\s*(1|0\\.0*[1-9]).*|\\s*,.*|)";
                                                                          }; -- header
                                                                          case_insensitive = true;
                                                                          surround = false;
                                                                        }; -- match_fsm
                                                                      };
                                                                    }; -- match_and
                                                                    rewrite = {
                                                                      actions = {
                                                                        {
                                                                          global = false;
                                                                          literal = false;
                                                                          rewrite = "%1.gz";
                                                                          case_insensitive = false;
                                                                          regexp = "([^\\?]+)(.*)";
                                                                        };
                                                                      }; -- actions
                                                                      response_headers = {
                                                                        create = {
                                                                          ["Content-Encoding"] = "gzip";
                                                                        }; -- create
                                                                        shared = {
                                                                          uuid = "3274977486389626536";
                                                                        }; -- shared
                                                                      }; -- response_headers
                                                                    }; -- rewrite
                                                                  }; -- gzip_section
                                                                  default = {
                                                                    priority = 1;
                                                                    shared = {
                                                                      uuid = "yastatic_net_s3_collections_common";
                                                                      shared = {
                                                                        uuid = "2679703888242934312";
                                                                      }; -- shared
                                                                    }; -- shared
                                                                  }; -- default
                                                                }; -- regexp
                                                              }; -- response_headers
                                                            }; -- headers
                                                          }; -- shared
                                                        }; -- report
                                                      }; -- yastatic_net_s3_collections
                                                      ["yastatic_net_s3_crossdomain-xml"] = {
                                                        priority = 85;
                                                        pattern = "/crossdomain-xml(/.*)?";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "yastatic_net_s3_crossdomain-xml";
                                                          ranges = get_str_var("default_ranges");
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          shared = {
                                                            uuid = "yastatic_net_s3_crossdomain-xml";
                                                            headers = {
                                                              create = {
                                                                Host = "yastatic.s3.yandex.net";
                                                              }; -- create
                                                              response_headers = {
                                                                delete = "access-control-allow-origin";
                                                                create_func = {
                                                                  Expires = "time:+1h";
                                                                }; -- create_func
                                                                create = {
                                                                  ["Access-Control-Allow-Origin"] = "*";
                                                                  ["Cache-Control"] = "public, max-age=3600";
                                                                  ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                                  ["Timing-Allow-Origin"] = "*";
                                                                }; -- create
                                                                shared = {
                                                                  uuid = "4957618399187796178";
                                                                  shared = {
                                                                    uuid = "yastatic_s3_cached_shared";
                                                                  }; -- shared
                                                                }; -- shared
                                                              }; -- response_headers
                                                            }; -- headers
                                                          }; -- shared
                                                        }; -- report
                                                      }; -- ["yastatic_net_s3_crossdomain-xml"]
                                                      yastatic_net_s3_daas_stripeatom = {
                                                        priority = 84;
                                                        pattern = "/daas/(stripe\\.html|atom\\.js)(/.*)?";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "yastatic_net_s3_daas_stripeatom";
                                                          ranges = get_str_var("default_ranges");
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          shared = {
                                                            uuid = "yastatic_net_s3_daas_stripeatom";
                                                            headers = {
                                                              create = {
                                                                Host = "yastatic.s3.yandex.net";
                                                              }; -- create
                                                              response_headers = {
                                                                create_func = {
                                                                  Expires = "time:+3h";
                                                                }; -- create_func
                                                                create = {
                                                                  ["Access-Control-Allow-Origin"] = "*";
                                                                  ["Cache-Control"] = "public, max-age=10800";
                                                                  ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                                  ["Timing-Allow-Origin"] = "*";
                                                                }; -- create
                                                                shared = {
                                                                  uuid = "yastatic_net_s3_daas_stripeatom_common";
                                                                  shared = {
                                                                    uuid = "177686509217163545";
                                                                  }; -- shared
                                                                }; -- shared
                                                              }; -- response_headers
                                                            }; -- headers
                                                          }; -- shared
                                                        }; -- report
                                                      }; -- yastatic_net_s3_daas_stripeatom
                                                      yastatic_net_s3_dialogs = {
                                                        priority = 83;
                                                        pattern = "/s3/dialogs(/.*)?";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "yastatic_net_s3_dialogs";
                                                          ranges = get_str_var("default_ranges");
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          shared = {
                                                            uuid = "yastatic_net_s3_dialogs";
                                                            headers = {
                                                              create = {
                                                                Host = "dialogs.s3.yandex.net";
                                                              }; -- create
                                                              rewrite = {
                                                                actions = {
                                                                  {
                                                                    global = false;
                                                                    literal = false;
                                                                    rewrite = "/%1";
                                                                    case_insensitive = false;
                                                                    regexp = "/s3/dialogs/(.*)";
                                                                  };
                                                                }; -- actions
                                                                response_headers = {
                                                                  create_func = {
                                                                    Expires = "time:+216001s";
                                                                  }; -- create_func
                                                                  create = {
                                                                    ["Access-Control-Allow-Origin"] = "*";
                                                                    ["Cache-Control"] = "public, max-age=216013";
                                                                    ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                                    ["Timing-Allow-Origin"] = "*";
                                                                  }; -- create
                                                                  regexp = {
                                                                    br_section = {
                                                                      priority = 3;
                                                                      match_and = {
                                                                        {
                                                                          match_fsm = {
                                                                            path = ".*(\\.js|\\.css)";
                                                                            case_insensitive = true;
                                                                            surround = false;
                                                                          }; -- match_fsm
                                                                        };
                                                                        {
                                                                          match_fsm = {
                                                                            header = {
                                                                              name = "accept-encoding";
                                                                              value = "(.*,\\s*|)br(\\s*;\\s*q\\s*=\\s*(1|0\\.0*[1-9]).*|\\s*,.*|)";
                                                                            }; -- header
                                                                            case_insensitive = true;
                                                                            surround = false;
                                                                          }; -- match_fsm
                                                                        };
                                                                      }; -- match_and
                                                                      rewrite = {
                                                                        actions = {
                                                                          {
                                                                            global = false;
                                                                            literal = false;
                                                                            rewrite = "%1.br";
                                                                            case_insensitive = false;
                                                                            regexp = "([^\\?]+)(.*)";
                                                                          };
                                                                        }; -- actions
                                                                        response_headers = {
                                                                          create = {
                                                                            ["Content-Encoding"] = "br";
                                                                          }; -- create
                                                                          shared = {
                                                                            uuid = "2636490632165987352";
                                                                            shared = {
                                                                              uuid = "yastatic_net_s3_dialogs_common";
                                                                            }; -- shared
                                                                          }; -- shared
                                                                        }; -- response_headers
                                                                      }; -- rewrite
                                                                    }; -- br_section
                                                                    gzip_section = {
                                                                      priority = 2;
                                                                      match_and = {
                                                                        {
                                                                          match_fsm = {
                                                                            path = ".*(\\.js|\\.css)";
                                                                            case_insensitive = true;
                                                                            surround = false;
                                                                          }; -- match_fsm
                                                                        };
                                                                        {
                                                                          match_fsm = {
                                                                            header = {
                                                                              name = "accept-encoding";
                                                                              value = "(.*,\\s*|)gzip(\\s*;\\s*q\\s*=\\s*(1|0\\.0*[1-9]).*|\\s*,.*|)";
                                                                            }; -- header
                                                                            case_insensitive = true;
                                                                            surround = false;
                                                                          }; -- match_fsm
                                                                        };
                                                                      }; -- match_and
                                                                      rewrite = {
                                                                        actions = {
                                                                          {
                                                                            global = false;
                                                                            literal = false;
                                                                            rewrite = "%1.gz";
                                                                            case_insensitive = false;
                                                                            regexp = "([^\\?]+)(.*)";
                                                                          };
                                                                        }; -- actions
                                                                        response_headers = {
                                                                          create = {
                                                                            ["Content-Encoding"] = "gzip";
                                                                          }; -- create
                                                                          shared = {
                                                                            uuid = "2636490632165987352";
                                                                          }; -- shared
                                                                        }; -- response_headers
                                                                      }; -- rewrite
                                                                    }; -- gzip_section
                                                                    default = {
                                                                      priority = 1;
                                                                      shared = {
                                                                        uuid = "yastatic_net_s3_dialogs_common";
                                                                        shared = {
                                                                          uuid = "2679703888242934312";
                                                                        }; -- shared
                                                                      }; -- shared
                                                                    }; -- default
                                                                  }; -- regexp
                                                                }; -- response_headers
                                                              }; -- rewrite
                                                            }; -- headers
                                                          }; -- shared
                                                        }; -- report
                                                      }; -- yastatic_net_s3_dialogs
                                                      yastatic_net_s3_disk_clientemails = {
                                                        priority = 82;
                                                        pattern = "/disk/(client|emails|public3|public|album|api|auth|editor|search-app|tv|widget-save|www|_)(/.*)?";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "yastatic_net_s3_disk_clientemails";
                                                          ranges = get_str_var("default_ranges");
                                                          matcher_map = {
                                                            client = {
                                                              match_fsm = {
                                                                path = "/disk/client.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- client
                                                            emails = {
                                                              match_fsm = {
                                                                path = "/disk/emails.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- emails
                                                            public3 = {
                                                              match_fsm = {
                                                                path = "/disk/public3.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- public3
                                                            public = {
                                                              match_fsm = {
                                                                path = "/disk/public.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- public
                                                            album = {
                                                              match_fsm = {
                                                                path = "/disk/album.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- album
                                                            api = {
                                                              match_fsm = {
                                                                path = "/disk/api.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- api
                                                            auth = {
                                                              match_fsm = {
                                                                path = "/disk/auth.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- auth
                                                            editor = {
                                                              match_fsm = {
                                                                path = "/disk/editor.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- editor
                                                            ["search-app"] = {
                                                              match_fsm = {
                                                                path = "/disk/search-app.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- ["search-app"]
                                                            tv = {
                                                              match_fsm = {
                                                                path = "/disk/tv.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- tv
                                                            ["widget-save"] = {
                                                              match_fsm = {
                                                                path = "/disk/widget-save.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- ["widget-save"]
                                                            www = {
                                                              match_fsm = {
                                                                path = "/disk/www.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- www
                                                            dash = {
                                                              match_fsm = {
                                                                path = "/disk/_.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- dash
                                                          }; -- matcher_map
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          shared = {
                                                            uuid = "yastatic_net_s3_disk_clientemails";
                                                            headers = {
                                                              create = {
                                                                Host = "yastatic.s3.yandex.net";
                                                              }; -- create
                                                              response_headers = {
                                                                create_func = {
                                                                  Expires = "time:+216001s";
                                                                }; -- create_func
                                                                create = {
                                                                  ["Access-Control-Allow-Origin"] = "*";
                                                                  ["Cache-Control"] = "public, max-age=216013";
                                                                  ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                                  ["Timing-Allow-Origin"] = "*";
                                                                }; -- create
                                                                shared = {
                                                                  uuid = "yastatic_net_s3_disk_clientemails_common";
                                                                  shared = {
                                                                    uuid = "177686509217163545";
                                                                  }; -- shared
                                                                }; -- shared
                                                              }; -- response_headers
                                                            }; -- headers
                                                          }; -- shared
                                                        }; -- report
                                                      }; -- yastatic_net_s3_disk_clientemails
                                                      yastatic_net_s3_editor = {
                                                        priority = 81;
                                                        pattern = "/s3/editor(/.*)?";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "yastatic_net_s3_editor";
                                                          ranges = get_str_var("default_ranges");
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          shared = {
                                                            uuid = "yastatic_net_s3_editor";
                                                            headers = {
                                                              create = {
                                                                Host = "editor.s3.yandex.net";
                                                              }; -- create
                                                              rewrite = {
                                                                actions = {
                                                                  {
                                                                    global = false;
                                                                    rewrite = "%1";
                                                                    literal = false;
                                                                    case_insensitive = false;
                                                                    regexp = "/s3/editor(/.*)";
                                                                  };
                                                                }; -- actions
                                                                response_headers = {
                                                                  create_func = {
                                                                    Expires = "time:+1h";
                                                                  }; -- create_func
                                                                  create = {
                                                                    ["Cache-Control"] = "max-age=31536000";
                                                                  }; -- create
                                                                  regexp = {
                                                                    br_section = {
                                                                      priority = 3;
                                                                      match_and = {
                                                                        {
                                                                          match_fsm = {
                                                                            path = ".*(\\.js|\\.css|\\.svg)";
                                                                            case_insensitive = true;
                                                                            surround = false;
                                                                          }; -- match_fsm
                                                                        };
                                                                        {
                                                                          match_fsm = {
                                                                            header = {
                                                                              name = "accept-encoding";
                                                                              value = "(.*,\\s*|)br(\\s*;\\s*q\\s*=\\s*(1|0\\.0*[1-9]).*|\\s*,.*|)";
                                                                            }; -- header
                                                                            case_insensitive = true;
                                                                            surround = false;
                                                                          }; -- match_fsm
                                                                        };
                                                                      }; -- match_and
                                                                      rewrite = {
                                                                        actions = {
                                                                          {
                                                                            global = false;
                                                                            literal = false;
                                                                            rewrite = "%1.br";
                                                                            case_insensitive = false;
                                                                            regexp = "([^\\?]+)(.*)";
                                                                          };
                                                                        }; -- actions
                                                                        response_headers_if = {
                                                                          matcher = {
                                                                            match_response_codes = {
                                                                              codes = { 200; 204; 206; };
                                                                            }; -- match_response_codes
                                                                          }; -- matcher
                                                                          create_header = {
                                                                            ["Content-Encoding"] = "br";
                                                                          }; -- create_header
                                                                          shared = {
                                                                            uuid = "2133441058756742989";
                                                                            shared = {
                                                                              uuid = "yastatic_net_s3_editor_common";
                                                                            }; -- shared
                                                                          }; -- shared
                                                                        }; -- response_headers_if
                                                                      }; -- rewrite
                                                                    }; -- br_section
                                                                    gzip_section = {
                                                                      priority = 2;
                                                                      match_and = {
                                                                        {
                                                                          match_fsm = {
                                                                            path = ".*(\\.js|\\.css|\\.svg)";
                                                                            case_insensitive = true;
                                                                            surround = false;
                                                                          }; -- match_fsm
                                                                        };
                                                                        {
                                                                          match_fsm = {
                                                                            header = {
                                                                              name = "accept-encoding";
                                                                              value = "(.*,\\s*|)gzip(\\s*;\\s*q\\s*=\\s*(1|0\\.0*[1-9]).*|\\s*,.*|)";
                                                                            }; -- header
                                                                            case_insensitive = true;
                                                                            surround = false;
                                                                          }; -- match_fsm
                                                                        };
                                                                      }; -- match_and
                                                                      rewrite = {
                                                                        actions = {
                                                                          {
                                                                            global = false;
                                                                            literal = false;
                                                                            rewrite = "%1.gz";
                                                                            case_insensitive = false;
                                                                            regexp = "([^\\?]+)(.*)";
                                                                          };
                                                                        }; -- actions
                                                                        response_headers_if = {
                                                                          matcher = {
                                                                            match_response_codes = {
                                                                              codes = { 200; 204; 206; };
                                                                            }; -- match_response_codes
                                                                          }; -- matcher
                                                                          create_header = {
                                                                            ["Content-Encoding"] = "gzip";
                                                                          }; -- create_header
                                                                          shared = {
                                                                            uuid = "2133441058756742989";
                                                                          }; -- shared
                                                                        }; -- response_headers_if
                                                                      }; -- rewrite
                                                                    }; -- gzip_section
                                                                    default = {
                                                                      priority = 1;
                                                                      shared = {
                                                                        uuid = "yastatic_net_s3_editor_common";
                                                                        shared = {
                                                                          uuid = "4278682503402935169";
                                                                        }; -- shared
                                                                      }; -- shared
                                                                    }; -- default
                                                                  }; -- regexp
                                                                }; -- response_headers
                                                              }; -- rewrite
                                                            }; -- headers
                                                          }; -- shared
                                                        }; -- report
                                                      }; -- yastatic_net_s3_editor
                                                      yastatic_net_s3_encyc = {
                                                        priority = 80;
                                                        pattern = "/encyc(/.*)?";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "yastatic_net_s3_encyc";
                                                          ranges = get_str_var("default_ranges");
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          shared = {
                                                            uuid = "yastatic_net_s3_encyc";
                                                            headers = {
                                                              delete = "authorization|accept-encoding";
                                                              create = {
                                                                Host = "yastatic.s3.yandex.net";
                                                              }; -- create
                                                              rewrite = {
                                                                actions = {
                                                                  {
                                                                    global = false;
                                                                    literal = false;
                                                                    regexp = "/encyc/(.*)";
                                                                    case_insensitive = false;
                                                                    rewrite = "/iso-encyc/%1";
                                                                  };
                                                                }; -- actions
                                                                response_headers = {
                                                                  create = {
                                                                    ["Access-Control-Allow-Origin"] = "*";
                                                                    ["Cache-Control"] = "public";
                                                                    ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                                    ["Timing-Allow-Origin"] = "*";
                                                                  }; -- create
                                                                  regexp = {
                                                                    br_section = {
                                                                      priority = 3;
                                                                      match_and = {
                                                                        {
                                                                          match_fsm = {
                                                                            path = ".*(\\.js|\\.css|\\.svg)";
                                                                            case_insensitive = true;
                                                                            surround = false;
                                                                          }; -- match_fsm
                                                                        };
                                                                        {
                                                                          match_fsm = {
                                                                            header = {
                                                                              name = "accept-encoding";
                                                                              value = "(.*,\\s*|)br(\\s*;\\s*q\\s*=\\s*(1|0\\.0*[1-9]).*|\\s*,.*|)";
                                                                            }; -- header
                                                                            case_insensitive = true;
                                                                            surround = false;
                                                                          }; -- match_fsm
                                                                        };
                                                                      }; -- match_and
                                                                      rewrite = {
                                                                        actions = {
                                                                          {
                                                                            global = false;
                                                                            literal = false;
                                                                            rewrite = "%1.br";
                                                                            case_insensitive = false;
                                                                            regexp = "([^\\?]+)(.*)";
                                                                          };
                                                                        }; -- actions
                                                                        response_headers = {
                                                                          create = {
                                                                            ["Content-Encoding"] = "br";
                                                                          }; -- create
                                                                          shared = {
                                                                            uuid = "3184167801411265191";
                                                                            shared = {
                                                                              uuid = "yastatic_net_s3_encyc_common";
                                                                            }; -- shared
                                                                          }; -- shared
                                                                        }; -- response_headers
                                                                      }; -- rewrite
                                                                    }; -- br_section
                                                                    gzip_section = {
                                                                      priority = 2;
                                                                      match_and = {
                                                                        {
                                                                          match_fsm = {
                                                                            path = ".*(\\.js|\\.css|\\.svg)";
                                                                            case_insensitive = true;
                                                                            surround = false;
                                                                          }; -- match_fsm
                                                                        };
                                                                        {
                                                                          match_fsm = {
                                                                            header = {
                                                                              name = "accept-encoding";
                                                                              value = "(.*,\\s*|)gzip(\\s*;\\s*q\\s*=\\s*(1|0\\.0*[1-9]).*|\\s*,.*|)";
                                                                            }; -- header
                                                                            case_insensitive = true;
                                                                            surround = false;
                                                                          }; -- match_fsm
                                                                        };
                                                                      }; -- match_and
                                                                      rewrite = {
                                                                        actions = {
                                                                          {
                                                                            global = false;
                                                                            literal = false;
                                                                            rewrite = "%1.gz";
                                                                            case_insensitive = false;
                                                                            regexp = "([^\\?]+)(.*)";
                                                                          };
                                                                        }; -- actions
                                                                        response_headers = {
                                                                          create = {
                                                                            ["Content-Encoding"] = "gzip";
                                                                          }; -- create
                                                                          shared = {
                                                                            uuid = "3184167801411265191";
                                                                          }; -- shared
                                                                        }; -- response_headers
                                                                      }; -- rewrite
                                                                    }; -- gzip_section
                                                                    default = {
                                                                      priority = 1;
                                                                      shared = {
                                                                        uuid = "yastatic_net_s3_encyc_common";
                                                                        headers = {
                                                                          delete = "authorization|accept-encoding";
                                                                          response_headers = {
                                                                            delete = "content-encoding";
                                                                            create = {
                                                                              ["Cache-Control"] = "public, max-age=216013";
                                                                            }; -- create
                                                                            regexp = {
                                                                              xml = {
                                                                                priority = 2;
                                                                                match_fsm = {
                                                                                  path = ".*(\\.xml|\\.htm|\\.html)";
                                                                                  case_insensitive = true;
                                                                                  surround = false;
                                                                                }; -- match_fsm
                                                                                response_headers_if = {
                                                                                  matcher = {
                                                                                    match_response_codes = {
                                                                                      codes = { 200; 204; 206; };
                                                                                    }; -- match_response_codes
                                                                                  }; -- matcher
                                                                                  create_header = {
                                                                                    ["Content-Type"] = "application/xml";
                                                                                  }; -- create_header
                                                                                  shared = {
                                                                                    uuid = "yastatic_net_s3_encyc_common_xml";
                                                                                    shared = {
                                                                                      uuid = "4957618399187796178";
                                                                                    }; -- shared
                                                                                  }; -- shared
                                                                                }; -- response_headers_if
                                                                              }; -- xml
                                                                              default = {
                                                                                priority = 1;
                                                                                shared = {
                                                                                  uuid = "yastatic_net_s3_encyc_common_xml";
                                                                                }; -- shared
                                                                              }; -- default
                                                                            }; -- regexp
                                                                          }; -- response_headers
                                                                        }; -- headers
                                                                      }; -- shared
                                                                    }; -- default
                                                                  }; -- regexp
                                                                }; -- response_headers
                                                              }; -- rewrite
                                                            }; -- headers
                                                          }; -- shared
                                                        }; -- report
                                                      }; -- yastatic_net_s3_encyc
                                                      yastatic_net_s3_euler = {
                                                        priority = 79;
                                                        pattern = "/s3/euler(/.*)?";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "yastatic_net_s3_euler";
                                                          ranges = get_str_var("default_ranges");
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          shared = {
                                                            uuid = "yastatic_net_s3_euler";
                                                            headers = {
                                                              create = {
                                                                Host = "euler.s3.yandex.net";
                                                              }; -- create
                                                              rewrite = {
                                                                actions = {
                                                                  {
                                                                    global = false;
                                                                    rewrite = "%1";
                                                                    literal = false;
                                                                    case_insensitive = false;
                                                                    regexp = "/s3/euler(.*)";
                                                                  };
                                                                }; -- actions
                                                                response_headers = {
                                                                  create_func = {
                                                                    Expires = "time:+216001s";
                                                                  }; -- create_func
                                                                  create = {
                                                                    ["Access-Control-Allow-Origin"] = "*";
                                                                    ["Cache-Control"] = "public, immutable, max-age=216013";
                                                                    ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                                    ["Timing-Allow-Origin"] = "*";
                                                                  }; -- create
                                                                  regexp = {
                                                                    br_section = {
                                                                      priority = 3;
                                                                      match_and = {
                                                                        {
                                                                          match_fsm = {
                                                                            path = ".*(\\.js|\\.css|\\.svg)";
                                                                            case_insensitive = true;
                                                                            surround = false;
                                                                          }; -- match_fsm
                                                                        };
                                                                        {
                                                                          match_fsm = {
                                                                            header = {
                                                                              name = "accept-encoding";
                                                                              value = "(.*,\\s*|)br(\\s*;\\s*q\\s*=\\s*(1|0\\.0*[1-9]).*|\\s*,.*|)";
                                                                            }; -- header
                                                                            case_insensitive = true;
                                                                            surround = false;
                                                                          }; -- match_fsm
                                                                        };
                                                                      }; -- match_and
                                                                      rewrite = {
                                                                        actions = {
                                                                          {
                                                                            global = false;
                                                                            literal = false;
                                                                            rewrite = "%1.br";
                                                                            case_insensitive = false;
                                                                            regexp = "([^\\?]+)(.*)";
                                                                          };
                                                                        }; -- actions
                                                                        response_headers_if = {
                                                                          matcher = {
                                                                            match_response_codes = {
                                                                              codes = { 200; 204; 206; };
                                                                            }; -- match_response_codes
                                                                          }; -- matcher
                                                                          create_header = {
                                                                            ["Content-Encoding"] = "br";
                                                                          }; -- create_header
                                                                          shared = {
                                                                            uuid = "2590385924780551794";
                                                                            shared = {
                                                                              uuid = "yastatic_net_s3_euler_common";
                                                                            }; -- shared
                                                                          }; -- shared
                                                                        }; -- response_headers_if
                                                                      }; -- rewrite
                                                                    }; -- br_section
                                                                    gzip_section = {
                                                                      priority = 2;
                                                                      match_and = {
                                                                        {
                                                                          match_fsm = {
                                                                            path = ".*(\\.js|\\.css|\\.svg)";
                                                                            case_insensitive = true;
                                                                            surround = false;
                                                                          }; -- match_fsm
                                                                        };
                                                                        {
                                                                          match_fsm = {
                                                                            header = {
                                                                              name = "accept-encoding";
                                                                              value = "(.*,\\s*|)gzip(\\s*;\\s*q\\s*=\\s*(1|0\\.0*[1-9]).*|\\s*,.*|)";
                                                                            }; -- header
                                                                            case_insensitive = true;
                                                                            surround = false;
                                                                          }; -- match_fsm
                                                                        };
                                                                      }; -- match_and
                                                                      rewrite = {
                                                                        actions = {
                                                                          {
                                                                            global = false;
                                                                            literal = false;
                                                                            rewrite = "%1.gz";
                                                                            case_insensitive = false;
                                                                            regexp = "([^\\?]+)(.*)";
                                                                          };
                                                                        }; -- actions
                                                                        response_headers_if = {
                                                                          matcher = {
                                                                            match_response_codes = {
                                                                              codes = { 200; 204; 206; };
                                                                            }; -- match_response_codes
                                                                          }; -- matcher
                                                                          create_header = {
                                                                            ["Content-Encoding"] = "gzip";
                                                                          }; -- create_header
                                                                          shared = {
                                                                            uuid = "2590385924780551794";
                                                                          }; -- shared
                                                                        }; -- response_headers_if
                                                                      }; -- rewrite
                                                                    }; -- gzip_section
                                                                    default = {
                                                                      priority = 1;
                                                                      shared = {
                                                                        uuid = "yastatic_net_s3_euler_common";
                                                                        shared = {
                                                                          uuid = "2679703888242934312";
                                                                        }; -- shared
                                                                      }; -- shared
                                                                    }; -- default
                                                                  }; -- regexp
                                                                }; -- response_headers
                                                              }; -- rewrite
                                                            }; -- headers
                                                          }; -- shared
                                                        }; -- report
                                                      }; -- yastatic_net_s3_euler
                                                      yastatic_net_s3_events = {
                                                        priority = 78;
                                                        pattern = "/s3/events(/.*)?";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "yastatic_net_s3_events";
                                                          ranges = get_str_var("default_ranges");
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          shared = {
                                                            uuid = "yastatic_net_s3_events";
                                                            headers = {
                                                              create = {
                                                                Host = "events.s3.yandex.net";
                                                              }; -- create
                                                              rewrite = {
                                                                actions = {
                                                                  {
                                                                    global = false;
                                                                    literal = false;
                                                                    rewrite = "/%1";
                                                                    case_insensitive = false;
                                                                    regexp = "/s3/events/(.*)";
                                                                  };
                                                                }; -- actions
                                                                response_headers = {
                                                                  create_func = {
                                                                    Expires = "time:+216001s";
                                                                  }; -- create_func
                                                                  create = {
                                                                    ["Access-Control-Allow-Origin"] = "*";
                                                                    ["Cache-Control"] = "public, max-age=216013";
                                                                    ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                                    ["Timing-Allow-Origin"] = "*";
                                                                  }; -- create
                                                                  regexp = {
                                                                    br_section = {
                                                                      priority = 3;
                                                                      match_fsm = {
                                                                        header = {
                                                                          name = "accept-encoding";
                                                                          value = "(.*,\\s*|)br(\\s*;\\s*q\\s*=\\s*(1|0\\.0*[1-9]).*|\\s*,.*|)";
                                                                        }; -- header
                                                                        case_insensitive = true;
                                                                        surround = false;
                                                                      }; -- match_fsm
                                                                      rewrite = {
                                                                        actions = {
                                                                          {
                                                                            global = false;
                                                                            literal = false;
                                                                            rewrite = "%1.br";
                                                                            case_insensitive = false;
                                                                            regexp = "([^\\?]+)(.*)";
                                                                          };
                                                                        }; -- actions
                                                                        response_headers = {
                                                                          create = {
                                                                            ["Content-Encoding"] = "br";
                                                                          }; -- create
                                                                          shared = {
                                                                            uuid = "2784549325661685211";
                                                                            shared = {
                                                                              uuid = "yastatic_net_s3_events_common";
                                                                            }; -- shared
                                                                          }; -- shared
                                                                        }; -- response_headers
                                                                      }; -- rewrite
                                                                    }; -- br_section
                                                                    gzip_section = {
                                                                      priority = 2;
                                                                      match_fsm = {
                                                                        header = {
                                                                          name = "accept-encoding";
                                                                          value = "(.*,\\s*|)gzip(\\s*;\\s*q\\s*=\\s*(1|0\\.0*[1-9]).*|\\s*,.*|)";
                                                                        }; -- header
                                                                        case_insensitive = true;
                                                                        surround = false;
                                                                      }; -- match_fsm
                                                                      rewrite = {
                                                                        actions = {
                                                                          {
                                                                            global = false;
                                                                            literal = false;
                                                                            rewrite = "%1.gz";
                                                                            case_insensitive = false;
                                                                            regexp = "([^\\?]+)(.*)";
                                                                          };
                                                                        }; -- actions
                                                                        response_headers = {
                                                                          create = {
                                                                            ["Content-Encoding"] = "gzip";
                                                                          }; -- create
                                                                          shared = {
                                                                            uuid = "2784549325661685211";
                                                                          }; -- shared
                                                                        }; -- response_headers
                                                                      }; -- rewrite
                                                                    }; -- gzip_section
                                                                    default = {
                                                                      priority = 1;
                                                                      shared = {
                                                                        uuid = "yastatic_net_s3_events_common";
                                                                        shared = {
                                                                          uuid = "2679703888242934312";
                                                                        }; -- shared
                                                                      }; -- shared
                                                                    }; -- default
                                                                  }; -- regexp
                                                                }; -- response_headers
                                                              }; -- rewrite
                                                            }; -- headers
                                                          }; -- shared
                                                        }; -- report
                                                      }; -- yastatic_net_s3_events
                                                      ["yastatic_net_s3_expert_front-maps-static"] = {
                                                        priority = 77;
                                                        pattern = "/s3/(expert|front-maps-static|vertis-frontend|lyceum|lyceum-admission|home-static|sendbernar|auth2|distribution|logoaas|bro-bg-store|lpc|beamlight|district|e7n|dealer|festival-static|ugc|home|yablogs-wysiwyg|twenty|edadeal-public-static|zen-lib|kinopoisk-desktop-www-static|contest|vda|for-media-terminal|for-media-terminal-numbers|for-media-terminal-compare|for-media-mediajams|kinopoisk-frontend|cult-marathon|tv-frontend|new-year-2018|quasar-ui|anytask|time|gnc|translate|trbro|e-pace|for-media-specprojects|locdoc|talents|yaplus-test|montserrat|rasp|taxi-front|maps-promo|afisha-frontend|meduza|ydo|ydo-test|zen-pubs-static|subscriptions|messenger-static|pay|direct-dna|staff-card|plcn|plcn-static|mapsapi-v3|home-beta|vh-static|travel-indexer|media-platform|afisha-tickets-frontend|chat|development|passport-auth-customs|pandora|fintech-icons|magic-qr|fintech|passport-static|ether-beta|ether-static|zen-misc|math-schbk-static|test-stories|kinopoisk-stories|music-stories|edu|sarah|edadeal-push-public)/(.*)?";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "yastatic_net_s3_expert_front-maps-static";
                                                          ranges = get_str_var("default_ranges");
                                                          matcher_map = {
                                                            expert = {
                                                              match_fsm = {
                                                                path = "/s3/expert.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- expert
                                                            ["front-maps-static"] = {
                                                              match_fsm = {
                                                                path = "/s3/front-maps-static.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- ["front-maps-static"]
                                                            ["vertis-frontend"] = {
                                                              match_fsm = {
                                                                path = "/s3/vertis-frontend.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- ["vertis-frontend"]
                                                            lyceum = {
                                                              match_fsm = {
                                                                path = "/s3/lyceum.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- lyceum
                                                            ["lyceum-admission"] = {
                                                              match_fsm = {
                                                                path = "/s3/lyceum-admission.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- ["lyceum-admission"]
                                                            ["home-static"] = {
                                                              match_fsm = {
                                                                path = "/s3/home-static.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- ["home-static"]
                                                            sendbernar = {
                                                              match_fsm = {
                                                                path = "/s3/sendbernar.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- sendbernar
                                                            auth2 = {
                                                              match_fsm = {
                                                                path = "/s3/auth2.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- auth2
                                                            distribution = {
                                                              match_fsm = {
                                                                path = "/s3/distribution.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- distribution
                                                            logoaas = {
                                                              match_fsm = {
                                                                path = "/s3/logoaas.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- logoaas
                                                            ["bro-bg-store"] = {
                                                              match_fsm = {
                                                                path = "/s3/bro-bg-store.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- ["bro-bg-store"]
                                                            lpc = {
                                                              match_fsm = {
                                                                path = "/s3/lpc.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- lpc
                                                            beamlight = {
                                                              match_fsm = {
                                                                path = "/s3/beamlight.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- beamlight
                                                            district = {
                                                              match_fsm = {
                                                                path = "/s3/district.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- district
                                                            e7n = {
                                                              match_fsm = {
                                                                path = "/s3/e7n.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- e7n
                                                            dealer = {
                                                              match_fsm = {
                                                                path = "/s3/dealer.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- dealer
                                                            ["festival-static"] = {
                                                              match_fsm = {
                                                                path = "/s3/festival-static.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- ["festival-static"]
                                                            ugc = {
                                                              match_fsm = {
                                                                path = "/s3/ugc.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- ugc
                                                            home = {
                                                              match_fsm = {
                                                                path = "/s3/home.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- home
                                                            ["yablogs-wysiwyg"] = {
                                                              match_fsm = {
                                                                path = "/s3/yablogs-wysiwyg.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- ["yablogs-wysiwyg"]
                                                            twenty = {
                                                              match_fsm = {
                                                                path = "/s3/twenty.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- twenty
                                                            ["edadeal-public-static"] = {
                                                              match_fsm = {
                                                                path = "/s3/edadeal-public-static.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- ["edadeal-public-static"]
                                                            ["zen-lib"] = {
                                                              match_fsm = {
                                                                path = "/s3/zen-lib.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- ["zen-lib"]
                                                            ["kinopoisk-desktop-www-static"] = {
                                                              match_fsm = {
                                                                path = "/s3/kinopoisk-desktop-www-static.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- ["kinopoisk-desktop-www-static"]
                                                            contest = {
                                                              match_fsm = {
                                                                path = "/s3/contest.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- contest
                                                            vda = {
                                                              match_fsm = {
                                                                path = "/s3/vda.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- vda
                                                            ["for-media-terminal"] = {
                                                              match_fsm = {
                                                                path = "/s3/for-media-terminal.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- ["for-media-terminal"]
                                                            ["for-media-terminal-numbers"] = {
                                                              match_fsm = {
                                                                path = "/s3/for-media-terminal-numbers.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- ["for-media-terminal-numbers"]
                                                            ["for-media-terminal-compare"] = {
                                                              match_fsm = {
                                                                path = "/s3/for-media-terminal-compare.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- ["for-media-terminal-compare"]
                                                            ["for-media-mediajams"] = {
                                                              match_fsm = {
                                                                path = "/s3/for-media-mediajams.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- ["for-media-mediajams"]
                                                            ["kinopoisk-frontend"] = {
                                                              match_fsm = {
                                                                path = "/s3/kinopoisk-frontend.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- ["kinopoisk-frontend"]
                                                            ["cult-marathon"] = {
                                                              match_fsm = {
                                                                path = "/s3/cult-marathon.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- ["cult-marathon"]
                                                            ["tv-frontend"] = {
                                                              match_fsm = {
                                                                path = "/s3/tv-frontend.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- ["tv-frontend"]
                                                            ["new-year-2018"] = {
                                                              match_fsm = {
                                                                path = "/s3/new-year-2018.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- ["new-year-2018"]
                                                            ["quasar-ui"] = {
                                                              match_fsm = {
                                                                path = "/s3/quasar-ui.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- ["quasar-ui"]
                                                            anytask = {
                                                              match_fsm = {
                                                                path = "/s3/anytask.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- anytask
                                                            time = {
                                                              match_fsm = {
                                                                path = "/s3/time.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- time
                                                            gnc = {
                                                              match_fsm = {
                                                                path = "/s3/gnc.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- gnc
                                                            translate = {
                                                              match_fsm = {
                                                                path = "/s3/translate.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- translate
                                                            trbro = {
                                                              match_fsm = {
                                                                path = "/s3/trbro.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- trbro
                                                            ["e-pace"] = {
                                                              match_fsm = {
                                                                path = "/s3/e-pace.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- ["e-pace"]
                                                            ["for-media-specprojects"] = {
                                                              match_fsm = {
                                                                path = "/s3/for-media-specprojects.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- ["for-media-specprojects"]
                                                            locdoc = {
                                                              match_fsm = {
                                                                path = "/s3/locdoc.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- locdoc
                                                            talents = {
                                                              match_fsm = {
                                                                path = "/s3/talents.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- talents
                                                            ["yaplus-test"] = {
                                                              match_fsm = {
                                                                path = "/s3/yaplus-test.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- ["yaplus-test"]
                                                            montserrat = {
                                                              match_fsm = {
                                                                path = "/s3/montserrat.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- montserrat
                                                            rasp = {
                                                              match_fsm = {
                                                                path = "/s3/rasp.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- rasp
                                                            ["taxi-front"] = {
                                                              match_fsm = {
                                                                path = "/s3/taxi-front.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- ["taxi-front"]
                                                            ["maps-promo"] = {
                                                              match_fsm = {
                                                                path = "/s3/maps-promo.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- ["maps-promo"]
                                                            ["afisha-frontend"] = {
                                                              match_fsm = {
                                                                path = "/s3/afisha-frontend.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- ["afisha-frontend"]
                                                            meduza = {
                                                              match_fsm = {
                                                                path = "/s3/meduza.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- meduza
                                                            ydo = {
                                                              match_fsm = {
                                                                path = "/s3/ydo.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- ydo
                                                            ["ydo-test"] = {
                                                              match_fsm = {
                                                                path = "/s3/ydo-test.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- ["ydo-test"]
                                                            ["zen-pubs-static"] = {
                                                              match_fsm = {
                                                                path = "/s3/zen-pubs-static.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- ["zen-pubs-static"]
                                                            subscriptions = {
                                                              match_fsm = {
                                                                path = "/s3/subscriptions.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- subscriptions
                                                            ["messenger-static"] = {
                                                              match_fsm = {
                                                                path = "/s3/messenger-static.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- ["messenger-static"]
                                                            pay = {
                                                              match_fsm = {
                                                                path = "/s3/pay.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- pay
                                                            ["direct-dna"] = {
                                                              match_fsm = {
                                                                path = "/s3/direct-dna.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- ["direct-dna"]
                                                            ["staff-card"] = {
                                                              match_fsm = {
                                                                path = "/s3/staff-card.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- ["staff-card"]
                                                            plcn = {
                                                              match_fsm = {
                                                                path = "/s3/plcn.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- plcn
                                                            ["plcn-static"] = {
                                                              match_fsm = {
                                                                path = "/s3/plcn-static.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- ["plcn-static"]
                                                            ["mapsapi-v3"] = {
                                                              match_fsm = {
                                                                path = "/s3/mapsapi-v3.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- ["mapsapi-v3"]
                                                            ["home-beta"] = {
                                                              match_fsm = {
                                                                path = "/s3/home-beta.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- ["home-beta"]
                                                            ["vh-static"] = {
                                                              match_fsm = {
                                                                path = "/s3/vh-static.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- ["vh-static"]
                                                            ["travel-indexer"] = {
                                                              match_fsm = {
                                                                path = "/s3/travel-indexer.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- ["travel-indexer"]
                                                            ["media-platform"] = {
                                                              match_fsm = {
                                                                path = "/s3/media-platform.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- ["media-platform"]
                                                            ["afisha-tickets-frontend"] = {
                                                              match_fsm = {
                                                                path = "/s3/afisha-tickets-frontend.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- ["afisha-tickets-frontend"]
                                                            chat = {
                                                              match_fsm = {
                                                                path = "/s3/chat.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- chat
                                                            development = {
                                                              match_fsm = {
                                                                path = "/s3/development.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- development
                                                            ["passport-auth-customs"] = {
                                                              match_fsm = {
                                                                path = "/s3/passport-auth-customs.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- ["passport-auth-customs"]
                                                            pandora = {
                                                              match_fsm = {
                                                                path = "/s3/pandora.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- pandora
                                                            ["fintech-icons"] = {
                                                              match_fsm = {
                                                                path = "/s3/fintech-icons.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- ["fintech-icons"]
                                                            ["magic-qr"] = {
                                                              match_fsm = {
                                                                path = "/s3/magic-qr.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- ["magic-qr"]
                                                            fintech = {
                                                              match_fsm = {
                                                                path = "/s3/fintech.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- fintech
                                                            ["passport-static"] = {
                                                              match_fsm = {
                                                                path = "/s3/passport-static.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- ["passport-static"]
                                                            ["zen-misc"] = {
                                                              match_fsm = {
                                                                path = "/s3/zen-misc.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- ["zen-misc"]
                                                            ["math-schbk-static"] = {
                                                              match_fsm = {
                                                                path = "/s3/math-schbk-static.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- ["math-schbk-static"]
                                                            ["test-stories"] = {
                                                              match_fsm = {
                                                                path = "/s3/test-stories.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- ["test-stories"]
                                                            ["kinopoisk-stories"] = {
                                                              match_fsm = {
                                                                path = "/s3/kinopoisk-stories.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- ["kinopoisk-stories"]
                                                            ["music-stories"] = {
                                                              match_fsm = {
                                                                path = "/s3/music-stories.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- ["music-stories"]
                                                            edu = {
                                                              match_fsm = {
                                                                path = "/s3/edu.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- edu
                                                            sarah = {
                                                              match_fsm = {
                                                                path = "/s3/sarah.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- sarah
                                                            ["edadeal-push-public"] = {
                                                              match_fsm = {
                                                                path = "/s3/edadeal-push-public.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- ["edadeal-push-public"]
                                                          }; -- matcher_map
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          shared = {
                                                            uuid = "yastatic_net_s3_expert_front-maps-static";
                                                            rewrite = {
                                                              actions = {
                                                                {
                                                                  global = false;
                                                                  literal = false;
                                                                  rewrite = "%1/%2%3";
                                                                  case_insensitive = false;
                                                                  regexp = "^(/.*)?/v-[^/a-zA-Z]+/(.*)(\\?.*)?$";
                                                                };
                                                                {
                                                                  global = false;
                                                                  literal = false;
                                                                  rewrite = "/%2";
                                                                  case_insensitive = false;
                                                                  regexp = "/s3/([A-Za-z0-9\\-_]+)/(.*)";
                                                                };
                                                                {
                                                                  global = false;
                                                                  literal = false;
                                                                  regexp = "(.*)";
                                                                  rewrite = "%{url}";
                                                                  header_name = "Host";
                                                                  case_insensitive = false;
                                                                };
                                                              }; -- actions
                                                              rewrite = {
                                                                actions = {
                                                                  {
                                                                    global = false;
                                                                    literal = false;
                                                                    header_name = "Host";
                                                                    case_insensitive = false;
                                                                    rewrite = "%1.s3.yandex.net";
                                                                    regexp = "/s3/([A-Za-z0-9\\-_]+)/(.*)";
                                                                  };
                                                                }; -- actions
                                                                response_headers = {
                                                                  create_func = {
                                                                    Expires = "time:+31556952s";
                                                                  }; -- create_func
                                                                  create = {
                                                                    ["Access-Control-Allow-Origin"] = "*";
                                                                    ["Cache-Control"] = "public, max-age=31556952";
                                                                    ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                                    ["Timing-Allow-Origin"] = "*";
                                                                  }; -- create
                                                                  shared = {
                                                                    uuid = "yastatic_net_s3_expert_front-maps-static_common";
                                                                    shared = {
                                                                      uuid = "1547776764857163274";
                                                                    }; -- shared
                                                                  }; -- shared
                                                                }; -- response_headers
                                                              }; -- rewrite
                                                            }; -- rewrite
                                                          }; -- shared
                                                        }; -- report
                                                      }; -- ["yastatic_net_s3_expert_front-maps-static"]
                                                      yastatic_net_s3_fijistatic = {
                                                        priority = 76;
                                                        pattern = "/s3/fiji-static(/.*)?";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "yastatic_net_s3_fijistatic";
                                                          ranges = get_str_var("default_ranges");
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          shared = {
                                                            uuid = "yastatic_net_s3_fijistatic";
                                                            headers = {
                                                              create = {
                                                                Host = "fiji-static.s3.yandex.net";
                                                              }; -- create
                                                              response_headers = {
                                                                create_func = {
                                                                  Expires = "time:+216001s";
                                                                }; -- create_func
                                                                create = {
                                                                  ["Access-Control-Allow-Origin"] = "*";
                                                                  ["Cache-Control"] = "public, immutable, max-age=216013";
                                                                  ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                                  ["Timing-Allow-Origin"] = "*";
                                                                }; -- create
                                                                rewrite = {
                                                                  actions = {
                                                                    {
                                                                      global = false;
                                                                      literal = false;
                                                                      rewrite = "%1/%2%3";
                                                                      case_insensitive = false;
                                                                      regexp = "^(/.*)?/v-[^/a-zA-Z]+/(.*)(\\?.*)?$";
                                                                    };
                                                                    {
                                                                      global = false;
                                                                      rewrite = "%1";
                                                                      literal = false;
                                                                      case_insensitive = false;
                                                                      regexp = "/s3/fiji-static(/.*)";
                                                                    };
                                                                  }; -- actions
                                                                  regexp = {
                                                                    br_section = {
                                                                      priority = 3;
                                                                      match_and = {
                                                                        {
                                                                          match_not = {
                                                                            match_fsm = {
                                                                              path = ".*(\\.png)";
                                                                              case_insensitive = true;
                                                                              surround = false;
                                                                            }; -- match_fsm
                                                                          }; -- match_not
                                                                        };
                                                                        {
                                                                          match_fsm = {
                                                                            header = {
                                                                              name = "accept-encoding";
                                                                              value = "(.*,\\s*|)br(\\s*;\\s*q\\s*=\\s*(1|0\\.0*[1-9]).*|\\s*,.*|)";
                                                                            }; -- header
                                                                            case_insensitive = true;
                                                                            surround = false;
                                                                          }; -- match_fsm
                                                                        };
                                                                      }; -- match_and
                                                                      rewrite = {
                                                                        actions = {
                                                                          {
                                                                            global = false;
                                                                            literal = false;
                                                                            rewrite = "%1.br";
                                                                            case_insensitive = false;
                                                                            regexp = "([^\\?]+)(.*)";
                                                                          };
                                                                        }; -- actions
                                                                        response_headers_if = {
                                                                          matcher = {
                                                                            match_response_codes = {
                                                                              codes = { 200; 204; 206; };
                                                                            }; -- match_response_codes
                                                                          }; -- matcher
                                                                          create_header = {
                                                                            ["Content-Encoding"] = "br";
                                                                          }; -- create_header
                                                                          shared = {
                                                                            uuid = "5301790162786672874";
                                                                            shared = {
                                                                              uuid = "yastatic_net_s3_fijistatic_common";
                                                                            }; -- shared
                                                                          }; -- shared
                                                                        }; -- response_headers_if
                                                                      }; -- rewrite
                                                                    }; -- br_section
                                                                    gzip_section = {
                                                                      priority = 2;
                                                                      match_and = {
                                                                        {
                                                                          match_not = {
                                                                            match_fsm = {
                                                                              path = ".*(\\.png)";
                                                                              case_insensitive = true;
                                                                              surround = false;
                                                                            }; -- match_fsm
                                                                          }; -- match_not
                                                                        };
                                                                        {
                                                                          match_fsm = {
                                                                            header = {
                                                                              name = "accept-encoding";
                                                                              value = "(.*,\\s*|)gzip(\\s*;\\s*q\\s*=\\s*(1|0\\.0*[1-9]).*|\\s*,.*|)";
                                                                            }; -- header
                                                                            case_insensitive = true;
                                                                            surround = false;
                                                                          }; -- match_fsm
                                                                        };
                                                                      }; -- match_and
                                                                      rewrite = {
                                                                        actions = {
                                                                          {
                                                                            global = false;
                                                                            literal = false;
                                                                            rewrite = "%1.gz";
                                                                            case_insensitive = false;
                                                                            regexp = "([^\\?]+)(.*)";
                                                                          };
                                                                        }; -- actions
                                                                        response_headers_if = {
                                                                          matcher = {
                                                                            match_response_codes = {
                                                                              codes = { 200; 204; 206; };
                                                                            }; -- match_response_codes
                                                                          }; -- matcher
                                                                          create_header = {
                                                                            ["Content-Encoding"] = "gzip";
                                                                          }; -- create_header
                                                                          shared = {
                                                                            uuid = "5301790162786672874";
                                                                          }; -- shared
                                                                        }; -- response_headers_if
                                                                      }; -- rewrite
                                                                    }; -- gzip_section
                                                                    default = {
                                                                      priority = 1;
                                                                      shared = {
                                                                        uuid = "yastatic_net_s3_fijistatic_common";
                                                                        shared = {
                                                                          uuid = "2679703888242934312";
                                                                        }; -- shared
                                                                      }; -- shared
                                                                    }; -- default
                                                                  }; -- regexp
                                                                }; -- rewrite
                                                              }; -- response_headers
                                                            }; -- headers
                                                          }; -- shared
                                                        }; -- report
                                                      }; -- yastatic_net_s3_fijistatic
                                                      yastatic_net_s3_fijistatic_yastatic = {
                                                        priority = 75;
                                                        pattern = "/yastatic/s3/fiji-static(/.*)?";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "yastatic_net_s3_fijistatic_yastatic";
                                                          ranges = get_str_var("default_ranges");
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          response_headers = {
                                                            create_func = {
                                                              Expires = "time:+216001s";
                                                            }; -- create_func
                                                            create = {
                                                              ["Access-Control-Allow-Origin"] = "*";
                                                              ["Cache-Control"] = "public, immutable, max-age=216013";
                                                              ["Service-Worker-Allowed"] = "/";
                                                              ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                              ["Timing-Allow-Origin"] = "*";
                                                            }; -- create
                                                            rewrite = {
                                                              actions = {
                                                                {
                                                                  global = false;
                                                                  literal = false;
                                                                  case_insensitive = false;
                                                                  rewrite = "/s3/fiji-static/%1";
                                                                  regexp = "/yastatic/s3/fiji-static/(.*)";
                                                                };
                                                              }; -- actions
                                                              shared = {
                                                                uuid = "yastatic_net_s3_fijistatic";
                                                              }; -- shared
                                                            }; -- rewrite
                                                          }; -- response_headers
                                                        }; -- report
                                                      }; -- yastatic_net_s3_fijistatic_yastatic
                                                      yastatic_net_s3_forgetmenot = {
                                                        priority = 74;
                                                        pattern = "/(forgetmenot)(/.*)?";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "yastatic_net_s3_forgetmenot";
                                                          ranges = get_str_var("default_ranges");
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          shared = {
                                                            uuid = "yastatic_net_s3_forgetmenot";
                                                            headers = {
                                                              create = {
                                                                Host = "yastatic.s3.yandex.net";
                                                              }; -- create
                                                              response_headers = {
                                                                create_func = {
                                                                  Expires = "time:+216006s";
                                                                }; -- create_func
                                                                create = {
                                                                  ["Access-Control-Allow-Origin"] = "*";
                                                                  ["Cache-Control"] = "public, max-age=216009";
                                                                  ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                                  ["Timing-Allow-Origin"] = "*";
                                                                }; -- create
                                                                shared = {
                                                                  uuid = "yastatic_net_s3_forgetmenot_common";
                                                                  shared = {
                                                                    uuid = "177686509217163545";
                                                                  }; -- shared
                                                                }; -- shared
                                                              }; -- response_headers
                                                            }; -- headers
                                                          }; -- shared
                                                        }; -- report
                                                      }; -- yastatic_net_s3_forgetmenot
                                                      yastatic_net_s3_frontend = {
                                                        priority = 73;
                                                        pattern = "/s3/frontend(/.*)?";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "yastatic_net_s3_frontend";
                                                          ranges = get_str_var("default_ranges");
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          shared = {
                                                            uuid = "yastatic_net_s3_frontend";
                                                            headers = {
                                                              create = {
                                                                Host = "frontend-test.s3.yandex.net";
                                                              }; -- create
                                                              rewrite = {
                                                                actions = {
                                                                  {
                                                                    global = false;
                                                                    literal = false;
                                                                    rewrite = "/%1";
                                                                    case_insensitive = false;
                                                                    regexp = "/s3/frontend/(.*)";
                                                                  };
                                                                }; -- actions
                                                                response_headers = {
                                                                  create_func = {
                                                                    Expires = "time:+216001s";
                                                                  }; -- create_func
                                                                  create = {
                                                                    ["Access-Control-Allow-Origin"] = "*";
                                                                    ["Cache-Control"] = "public, immutable, max-age=216013";
                                                                    ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                                    ["Timing-Allow-Origin"] = "*";
                                                                  }; -- create
                                                                  regexp = {
                                                                    br_section = {
                                                                      priority = 3;
                                                                      match_and = {
                                                                        {
                                                                          match_not = {
                                                                            match_fsm = {
                                                                              path = ".*(\\.png|\\.jpg|\\.jpeg)";
                                                                              case_insensitive = true;
                                                                              surround = false;
                                                                            }; -- match_fsm
                                                                          }; -- match_not
                                                                        };
                                                                        {
                                                                          match_fsm = {
                                                                            header = {
                                                                              name = "accept-encoding";
                                                                              value = "(.*,\\s*|)br(\\s*;\\s*q\\s*=\\s*(1|0\\.0*[1-9]).*|\\s*,.*|)";
                                                                            }; -- header
                                                                            case_insensitive = true;
                                                                            surround = false;
                                                                          }; -- match_fsm
                                                                        };
                                                                      }; -- match_and
                                                                      rewrite = {
                                                                        actions = {
                                                                          {
                                                                            global = false;
                                                                            literal = false;
                                                                            rewrite = "%1.br";
                                                                            case_insensitive = false;
                                                                            regexp = "([^\\?]+)(.*)";
                                                                          };
                                                                        }; -- actions
                                                                        response_headers = {
                                                                          create = {
                                                                            ["Content-Encoding"] = "br";
                                                                          }; -- create
                                                                          shared = {
                                                                            uuid = "1140731050593042102";
                                                                            shared = {
                                                                              uuid = "yastatic_net_s3_frontend_common";
                                                                            }; -- shared
                                                                          }; -- shared
                                                                        }; -- response_headers
                                                                      }; -- rewrite
                                                                    }; -- br_section
                                                                    gzip_section = {
                                                                      priority = 2;
                                                                      match_and = {
                                                                        {
                                                                          match_not = {
                                                                            match_fsm = {
                                                                              path = ".*(\\.png|\\.jpg|\\.jpeg)";
                                                                              case_insensitive = true;
                                                                              surround = false;
                                                                            }; -- match_fsm
                                                                          }; -- match_not
                                                                        };
                                                                        {
                                                                          match_fsm = {
                                                                            header = {
                                                                              name = "accept-encoding";
                                                                              value = "(.*,\\s*|)gzip(\\s*;\\s*q\\s*=\\s*(1|0\\.0*[1-9]).*|\\s*,.*|)";
                                                                            }; -- header
                                                                            case_insensitive = true;
                                                                            surround = false;
                                                                          }; -- match_fsm
                                                                        };
                                                                      }; -- match_and
                                                                      rewrite = {
                                                                        actions = {
                                                                          {
                                                                            global = false;
                                                                            literal = false;
                                                                            rewrite = "%1.gz";
                                                                            case_insensitive = false;
                                                                            regexp = "([^\\?]+)(.*)";
                                                                          };
                                                                        }; -- actions
                                                                        response_headers = {
                                                                          create = {
                                                                            ["Content-Encoding"] = "gzip";
                                                                          }; -- create
                                                                          shared = {
                                                                            uuid = "1140731050593042102";
                                                                          }; -- shared
                                                                        }; -- response_headers
                                                                      }; -- rewrite
                                                                    }; -- gzip_section
                                                                    default = {
                                                                      priority = 1;
                                                                      shared = {
                                                                        uuid = "yastatic_net_s3_frontend_common";
                                                                        shared = {
                                                                          uuid = "2679703888242934312";
                                                                        }; -- shared
                                                                      }; -- shared
                                                                    }; -- default
                                                                  }; -- regexp
                                                                }; -- response_headers
                                                              }; -- rewrite
                                                            }; -- headers
                                                          }; -- shared
                                                        }; -- report
                                                      }; -- yastatic_net_s3_frontend
                                                      ["yastatic_net_s3_granny-static"] = {
                                                        priority = 72;
                                                        pattern = "/s3/granny-static(/.*)?";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "yastatic_net_s3_granny-static";
                                                          ranges = get_str_var("default_ranges");
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          shared = {
                                                            uuid = "yastatic_net_s3_granny-static";
                                                            headers = {
                                                              create = {
                                                                Host = "granny-static.s3.yandex.net";
                                                              }; -- create
                                                              rewrite = {
                                                                actions = {
                                                                  {
                                                                    global = false;
                                                                    literal = false;
                                                                    rewrite = "/%1";
                                                                    case_insensitive = false;
                                                                    regexp = "/s3/granny-static/(.*)";
                                                                  };
                                                                }; -- actions
                                                                response_headers = {
                                                                  create_func = {
                                                                    Expires = "time:+216001s";
                                                                  }; -- create_func
                                                                  create = {
                                                                    ["Access-Control-Allow-Origin"] = "*";
                                                                    ["Cache-Control"] = "public, max-age=216013";
                                                                    ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                                    ["Timing-Allow-Origin"] = "*";
                                                                  }; -- create
                                                                  regexp = {
                                                                    br_section = {
                                                                      priority = 3;
                                                                      match_and = {
                                                                        {
                                                                          match_fsm = {
                                                                            path = ".*(\\.js|\\.css|\\.svg)";
                                                                            case_insensitive = true;
                                                                            surround = false;
                                                                          }; -- match_fsm
                                                                        };
                                                                        {
                                                                          match_fsm = {
                                                                            header = {
                                                                              name = "accept-encoding";
                                                                              value = "(.*,\\s*|)br(\\s*;\\s*q\\s*=\\s*(1|0\\.0*[1-9]).*|\\s*,.*|)";
                                                                            }; -- header
                                                                            case_insensitive = true;
                                                                            surround = false;
                                                                          }; -- match_fsm
                                                                        };
                                                                      }; -- match_and
                                                                      rewrite = {
                                                                        actions = {
                                                                          {
                                                                            global = false;
                                                                            literal = false;
                                                                            rewrite = "%1.br";
                                                                            case_insensitive = false;
                                                                            regexp = "([^\\?]+)(.*)";
                                                                          };
                                                                        }; -- actions
                                                                        response_headers = {
                                                                          create = {
                                                                            ["Content-Encoding"] = "br";
                                                                          }; -- create
                                                                          shared = {
                                                                            uuid = "2680177206631893529";
                                                                            shared = {
                                                                              uuid = "yastatic_net_s3_granny-static_common";
                                                                            }; -- shared
                                                                          }; -- shared
                                                                        }; -- response_headers
                                                                      }; -- rewrite
                                                                    }; -- br_section
                                                                    gzip_section = {
                                                                      priority = 2;
                                                                      match_and = {
                                                                        {
                                                                          match_fsm = {
                                                                            path = ".*(\\.js|\\.css|\\.svg)";
                                                                            case_insensitive = true;
                                                                            surround = false;
                                                                          }; -- match_fsm
                                                                        };
                                                                        {
                                                                          match_fsm = {
                                                                            header = {
                                                                              name = "accept-encoding";
                                                                              value = "(.*,\\s*|)gzip(\\s*;\\s*q\\s*=\\s*(1|0\\.0*[1-9]).*|\\s*,.*|)";
                                                                            }; -- header
                                                                            case_insensitive = true;
                                                                            surround = false;
                                                                          }; -- match_fsm
                                                                        };
                                                                      }; -- match_and
                                                                      rewrite = {
                                                                        actions = {
                                                                          {
                                                                            global = false;
                                                                            literal = false;
                                                                            rewrite = "%1.gz";
                                                                            case_insensitive = false;
                                                                            regexp = "([^\\?]+)(.*)";
                                                                          };
                                                                        }; -- actions
                                                                        response_headers = {
                                                                          create = {
                                                                            ["Content-Encoding"] = "gzip";
                                                                          }; -- create
                                                                          shared = {
                                                                            uuid = "2680177206631893529";
                                                                          }; -- shared
                                                                        }; -- response_headers
                                                                      }; -- rewrite
                                                                    }; -- gzip_section
                                                                    default = {
                                                                      priority = 1;
                                                                      shared = {
                                                                        uuid = "yastatic_net_s3_granny-static_common";
                                                                        shared = {
                                                                          uuid = "2679703888242934312";
                                                                        }; -- shared
                                                                      }; -- shared
                                                                    }; -- default
                                                                  }; -- regexp
                                                                }; -- response_headers
                                                              }; -- rewrite
                                                            }; -- headers
                                                          }; -- shared
                                                        }; -- report
                                                      }; -- ["yastatic_net_s3_granny-static"]
                                                      yastatic_net_s3_grannyvideo_yastatic = {
                                                        priority = 71;
                                                        pattern = "/yastatic/(granny|video3)/(.*)?";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "yastatic_net_s3_grannyvideo_yastatic";
                                                          ranges = get_str_var("default_ranges");
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          response_headers = {
                                                            create_func = {
                                                              Expires = "time:+216001s";
                                                            }; -- create_func
                                                            create = {
                                                              ["Access-Control-Allow-Origin"] = "*";
                                                              ["Cache-Control"] = "public";
                                                              ["Service-Worker-Allowed"] = "/";
                                                              ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                              ["Timing-Allow-Origin"] = "*";
                                                            }; -- create
                                                            rewrite = {
                                                              actions = {
                                                                {
                                                                  global = false;
                                                                  literal = false;
                                                                  rewrite = "/%1";
                                                                  case_insensitive = false;
                                                                  regexp = "yastatic/(.*)";
                                                                };
                                                              }; -- actions
                                                              shared = {
                                                                uuid = "2060916621982072321";
                                                                shared = {
                                                                  uuid = "yastatic_net_s3_yandex-shad2-www";
                                                                }; -- shared
                                                              }; -- shared
                                                            }; -- rewrite
                                                          }; -- response_headers
                                                        }; -- report
                                                      }; -- yastatic_net_s3_grannyvideo_yastatic
                                                      yastatic_net_s3_islands = {
                                                        priority = 70;
                                                        pattern = "/islands(/.*)?";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "yastatic_net_s3_islands";
                                                          ranges = get_str_var("default_ranges");
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          shared = {
                                                            uuid = "yastatic_net_s3_islands";
                                                            headers = {
                                                              create = {
                                                                Host = "islands.s3.yandex.net";
                                                              }; -- create
                                                              rewrite = {
                                                                actions = {
                                                                  {
                                                                    global = false;
                                                                    literal = false;
                                                                    rewrite = "/%1";
                                                                    case_insensitive = false;
                                                                    regexp = "/islands/(.*)";
                                                                  };
                                                                }; -- actions
                                                                response_headers = {
                                                                  create_func = {
                                                                    Expires = "time:+216001s";
                                                                  }; -- create_func
                                                                  create = {
                                                                    ["Access-Control-Allow-Origin"] = "*";
                                                                    ["Cache-Control"] = "public, max-age=216013";
                                                                    ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                                    ["Timing-Allow-Origin"] = "*";
                                                                  }; -- create
                                                                  regexp = {
                                                                    br_section = {
                                                                      priority = 3;
                                                                      match_and = {
                                                                        {
                                                                          match_not = {
                                                                            match_fsm = {
                                                                              path = ".*(\\.png)";
                                                                              case_insensitive = true;
                                                                              surround = false;
                                                                            }; -- match_fsm
                                                                          }; -- match_not
                                                                        };
                                                                        {
                                                                          match_fsm = {
                                                                            header = {
                                                                              name = "accept-encoding";
                                                                              value = "(.*,\\s*|)br(\\s*;\\s*q\\s*=\\s*(1|0\\.0*[1-9]).*|\\s*,.*|)";
                                                                            }; -- header
                                                                            case_insensitive = true;
                                                                            surround = false;
                                                                          }; -- match_fsm
                                                                        };
                                                                      }; -- match_and
                                                                      rewrite = {
                                                                        actions = {
                                                                          {
                                                                            global = false;
                                                                            literal = false;
                                                                            rewrite = "%1.br";
                                                                            case_insensitive = false;
                                                                            regexp = "([^\\?]+)(.*)";
                                                                          };
                                                                        }; -- actions
                                                                        response_headers = {
                                                                          create = {
                                                                            ["Content-Encoding"] = "br";
                                                                          }; -- create
                                                                          shared = {
                                                                            uuid = "5461266481702107201";
                                                                            shared = {
                                                                              uuid = "yastatic_net_s3_islands_common";
                                                                            }; -- shared
                                                                          }; -- shared
                                                                        }; -- response_headers
                                                                      }; -- rewrite
                                                                    }; -- br_section
                                                                    gzip_section = {
                                                                      priority = 2;
                                                                      match_and = {
                                                                        {
                                                                          match_not = {
                                                                            match_fsm = {
                                                                              path = ".*(\\.png)";
                                                                              case_insensitive = true;
                                                                              surround = false;
                                                                            }; -- match_fsm
                                                                          }; -- match_not
                                                                        };
                                                                        {
                                                                          match_fsm = {
                                                                            header = {
                                                                              name = "accept-encoding";
                                                                              value = "(.*,\\s*|)gzip(\\s*;\\s*q\\s*=\\s*(1|0\\.0*[1-9]).*|\\s*,.*|)";
                                                                            }; -- header
                                                                            case_insensitive = true;
                                                                            surround = false;
                                                                          }; -- match_fsm
                                                                        };
                                                                      }; -- match_and
                                                                      rewrite = {
                                                                        actions = {
                                                                          {
                                                                            global = false;
                                                                            literal = false;
                                                                            rewrite = "%1.gz";
                                                                            case_insensitive = false;
                                                                            regexp = "([^\\?]+)(.*)";
                                                                          };
                                                                        }; -- actions
                                                                        response_headers = {
                                                                          create = {
                                                                            ["Content-Encoding"] = "gzip";
                                                                          }; -- create
                                                                          shared = {
                                                                            uuid = "5461266481702107201";
                                                                          }; -- shared
                                                                        }; -- response_headers
                                                                      }; -- rewrite
                                                                    }; -- gzip_section
                                                                    default = {
                                                                      priority = 1;
                                                                      shared = {
                                                                        uuid = "yastatic_net_s3_islands_common";
                                                                        shared = {
                                                                          uuid = "2679703888242934312";
                                                                        }; -- shared
                                                                      }; -- shared
                                                                    }; -- default
                                                                  }; -- regexp
                                                                }; -- response_headers
                                                              }; -- rewrite
                                                            }; -- headers
                                                          }; -- shared
                                                        }; -- report
                                                      }; -- yastatic_net_s3_islands
                                                      ["yastatic_net_s3_iso-avatars"] = {
                                                        priority = 69;
                                                        pattern = "/iso-avatars(/.*)?";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "yastatic_net_s3_iso-avatars";
                                                          ranges = get_str_var("default_ranges");
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          shared = {
                                                            uuid = "yastatic_net_s3_iso-avatars";
                                                            headers = {
                                                              delete = "authorization|accept-encoding";
                                                              create = {
                                                                Host = "yastatic.s3.yandex.net";
                                                              }; -- create
                                                              response_headers = {
                                                                create_func = {
                                                                  Expires = "time:+216001s";
                                                                }; -- create_func
                                                                create = {
                                                                  ["Access-Control-Allow-Origin"] = "*";
                                                                  ["Cache-Control"] = "public, max-age=216013";
                                                                  ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                                  ["Timing-Allow-Origin"] = "*";
                                                                }; -- create
                                                                regexp = {
                                                                  br_section = {
                                                                    priority = 3;
                                                                    match_and = {
                                                                      {
                                                                        match_fsm = {
                                                                          path = ".*(\\.js|\\.css|\\.svg)";
                                                                          case_insensitive = true;
                                                                          surround = false;
                                                                        }; -- match_fsm
                                                                      };
                                                                      {
                                                                        match_fsm = {
                                                                          header = {
                                                                            name = "accept-encoding";
                                                                            value = "(.*,\\s*|)br(\\s*;\\s*q\\s*=\\s*(1|0\\.0*[1-9]).*|\\s*,.*|)";
                                                                          }; -- header
                                                                          case_insensitive = true;
                                                                          surround = false;
                                                                        }; -- match_fsm
                                                                      };
                                                                    }; -- match_and
                                                                    rewrite = {
                                                                      actions = {
                                                                        {
                                                                          global = false;
                                                                          literal = false;
                                                                          regexp = "(/.*)";
                                                                          rewrite = "%1.br";
                                                                          case_insensitive = false;
                                                                        };
                                                                      }; -- actions
                                                                      response_headers_if = {
                                                                        matcher = {
                                                                          match_response_codes = {
                                                                            codes = { 200; 204; 206; };
                                                                          }; -- match_response_codes
                                                                        }; -- matcher
                                                                        create_header = {
                                                                          ["Content-Encoding"] = "br";
                                                                        }; -- create_header
                                                                        shared = {
                                                                          uuid = "4168001056613851239";
                                                                          shared = {
                                                                            uuid = "yastatic_net_s3_iso-avatars_common";
                                                                          }; -- shared
                                                                        }; -- shared
                                                                      }; -- response_headers_if
                                                                    }; -- rewrite
                                                                  }; -- br_section
                                                                  gzip_section = {
                                                                    priority = 2;
                                                                    match_and = {
                                                                      {
                                                                        match_fsm = {
                                                                          path = ".*(\\.js|\\.css|\\.svg)";
                                                                          case_insensitive = true;
                                                                          surround = false;
                                                                        }; -- match_fsm
                                                                      };
                                                                      {
                                                                        match_fsm = {
                                                                          header = {
                                                                            name = "accept-encoding";
                                                                            value = "(.*,\\s*|)gzip(\\s*;\\s*q\\s*=\\s*(1|0\\.0*[1-9]).*|\\s*,.*|)";
                                                                          }; -- header
                                                                          case_insensitive = true;
                                                                          surround = false;
                                                                        }; -- match_fsm
                                                                      };
                                                                    }; -- match_and
                                                                    rewrite = {
                                                                      actions = {
                                                                        {
                                                                          global = false;
                                                                          literal = false;
                                                                          regexp = "(/.*)";
                                                                          rewrite = "%1.gz";
                                                                          case_insensitive = false;
                                                                        };
                                                                      }; -- actions
                                                                      response_headers_if = {
                                                                        matcher = {
                                                                          match_response_codes = {
                                                                            codes = { 200; 204; 206; };
                                                                          }; -- match_response_codes
                                                                        }; -- matcher
                                                                        create_header = {
                                                                          ["Content-Encoding"] = "gzip";
                                                                        }; -- create_header
                                                                        shared = {
                                                                          uuid = "4168001056613851239";
                                                                        }; -- shared
                                                                      }; -- response_headers_if
                                                                    }; -- rewrite
                                                                  }; -- gzip_section
                                                                  default = {
                                                                    priority = 1;
                                                                    shared = {
                                                                      uuid = "yastatic_net_s3_iso-avatars_common";
                                                                      shared = {
                                                                        uuid = "2679703888242934312";
                                                                      }; -- shared
                                                                    }; -- shared
                                                                  }; -- default
                                                                }; -- regexp
                                                              }; -- response_headers
                                                            }; -- headers
                                                          }; -- shared
                                                        }; -- report
                                                      }; -- ["yastatic_net_s3_iso-avatars"]
                                                      yastatic_net_s3_jquery = {
                                                        priority = 68;
                                                        pattern = "/jquery(/.*)?";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "yastatic_net_s3_jquery";
                                                          ranges = get_str_var("default_ranges");
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          headers = {
                                                            create = {
                                                              Host = "yastatic.s3.yandex.net";
                                                            }; -- create
                                                            response_headers = {
                                                              create_func = {
                                                                Expires = "time:+216001s";
                                                              }; -- create_func
                                                              regexp = {
                                                                br_section = {
                                                                  priority = 3;
                                                                  match_fsm = {
                                                                    header = {
                                                                      name = "accept-encoding";
                                                                      value = "(.*,\\s*|)br(\\s*;\\s*q\\s*=\\s*(1|0\\.0*[1-9]).*|\\s*,.*|)";
                                                                    }; -- header
                                                                    case_insensitive = true;
                                                                    surround = false;
                                                                  }; -- match_fsm
                                                                  rewrite = {
                                                                    actions = {
                                                                      {
                                                                        global = false;
                                                                        literal = false;
                                                                        rewrite = "%1.br";
                                                                        case_insensitive = false;
                                                                        regexp = "([^\\?]+)(.*)";
                                                                      };
                                                                    }; -- actions
                                                                    response_headers = {
                                                                      create = {
                                                                        ["Content-Encoding"] = "br";
                                                                      }; -- create
                                                                      shared = {
                                                                        uuid = "1093234229082448910";
                                                                        shared = {
                                                                          uuid = "yastatic_net_s3_jquery_common";
                                                                        }; -- shared
                                                                      }; -- shared
                                                                    }; -- response_headers
                                                                  }; -- rewrite
                                                                }; -- br_section
                                                                gzip_section = {
                                                                  priority = 2;
                                                                  match_fsm = {
                                                                    header = {
                                                                      name = "accept-encoding";
                                                                      value = "(.*,\\s*|)gzip(\\s*;\\s*q\\s*=\\s*(1|0\\.0*[1-9]).*|\\s*,.*|)";
                                                                    }; -- header
                                                                    case_insensitive = true;
                                                                    surround = false;
                                                                  }; -- match_fsm
                                                                  rewrite = {
                                                                    actions = {
                                                                      {
                                                                        global = false;
                                                                        literal = false;
                                                                        rewrite = "%1.gz";
                                                                        case_insensitive = false;
                                                                        regexp = "([^\\?]+)(.*)";
                                                                      };
                                                                    }; -- actions
                                                                    response_headers = {
                                                                      create = {
                                                                        ["Content-Encoding"] = "gzip";
                                                                      }; -- create
                                                                      shared = {
                                                                        uuid = "1093234229082448910";
                                                                      }; -- shared
                                                                    }; -- response_headers
                                                                  }; -- rewrite
                                                                }; -- gzip_section
                                                                default = {
                                                                  priority = 1;
                                                                  shared = {
                                                                    uuid = "yastatic_net_s3_jquery_common";
                                                                    headers = {
                                                                      delete = "accept-encoding|authorization";
                                                                      response_headers = {
                                                                        delete = "content-encoding";
                                                                        create = {
                                                                          ["Access-Control-Allow-Origin"] = "*";
                                                                          ["Cache-Control"] = "public, max-age=216013";
                                                                          ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                                          ["Timing-Allow-Origin"] = "*";
                                                                        }; -- create
                                                                        shared = {
                                                                          uuid = "4957618399187796178";
                                                                        }; -- shared
                                                                      }; -- response_headers
                                                                    }; -- headers
                                                                  }; -- shared
                                                                }; -- default
                                                              }; -- regexp
                                                            }; -- response_headers
                                                          }; -- headers
                                                        }; -- report
                                                      }; -- yastatic_net_s3_jquery
                                                      yastatic_net_s3_jslibs_loader = {
                                                        priority = 67;
                                                        pattern = "/jslibs/loader\\.js(.*)?";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "yastatic_net_s3_jslibs_loader";
                                                          ranges = get_str_var("default_ranges");
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          shared = {
                                                            uuid = "yastatic_net_s3_jslibs_loader";
                                                            headers = {
                                                              create = {
                                                                Host = "yastatic.s3.yandex.net";
                                                              }; -- create
                                                              response_headers = {
                                                                create_func = {
                                                                  Expires = "time:+216006s";
                                                                }; -- create_func
                                                                create = {
                                                                  ["Access-Control-Allow-Origin"] = "*";
                                                                  ["Cache-Control"] = "public, max-age=216009";
                                                                  ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                                  ["Timing-Allow-Origin"] = "*";
                                                                }; -- create
                                                                shared = {
                                                                  uuid = "yastatic_net_s3_jslibs_loader_common";
                                                                  shared = {
                                                                    uuid = "177686509217163545";
                                                                  }; -- shared
                                                                }; -- shared
                                                              }; -- response_headers
                                                            }; -- headers
                                                          }; -- shared
                                                        }; -- report
                                                      }; -- yastatic_net_s3_jslibs_loader
                                                      yastatic_net_s3_lingvo_xdxf = {
                                                        priority = 66;
                                                        pattern = "/lingvo_xdxf(/.*)?";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "yastatic_net_s3_lingvo_xdxf";
                                                          ranges = get_str_var("default_ranges");
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          shared = {
                                                            uuid = "yastatic_net_s3_lingvo_xdxf";
                                                            response_headers = {
                                                              create = {
                                                                ["Access-Control-Allow-Origin"] = "*";
                                                                ["Cache-Control"] = "public";
                                                                ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                                ["Timing-Allow-Origin"] = "*";
                                                              }; -- create
                                                              headers = {
                                                                create = {
                                                                  Host = "yastatic.s3.yandex.net";
                                                                }; -- create
                                                                rewrite = {
                                                                  actions = {
                                                                    {
                                                                      global = false;
                                                                      literal = false;
                                                                      case_insensitive = false;
                                                                      regexp = "^/lingvo_xdxf/(.*)$";
                                                                      rewrite = "/iso-lingvo_xdxf/%1";
                                                                    };
                                                                  }; -- actions
                                                                  shared = {
                                                                    uuid = "yastatic_net_s3_lingvo_xdxf_common";
                                                                    shared = {
                                                                      uuid = "177686509217163545";
                                                                    }; -- shared
                                                                  }; -- shared
                                                                }; -- rewrite
                                                              }; -- headers
                                                            }; -- response_headers
                                                          }; -- shared
                                                        }; -- report
                                                      }; -- yastatic_net_s3_lingvo_xdxf
                                                      yastatic_net_s3_lingvo_xml = {
                                                        priority = 65;
                                                        pattern = "/lingvo_xml(/.*)?";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "yastatic_net_s3_lingvo_xml";
                                                          ranges = get_str_var("default_ranges");
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          shared = {
                                                            uuid = "yastatic_net_s3_lingvo_xml";
                                                            response_headers = {
                                                              create = {
                                                                ["Access-Control-Allow-Origin"] = "*";
                                                                ["Cache-Control"] = "public";
                                                                ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                                ["Timing-Allow-Origin"] = "*";
                                                              }; -- create
                                                              headers = {
                                                                create = {
                                                                  Host = "yastatic.s3.yandex.net";
                                                                }; -- create
                                                                rewrite = {
                                                                  actions = {
                                                                    {
                                                                      global = false;
                                                                      literal = false;
                                                                      case_insensitive = false;
                                                                      rewrite = "/iso-lingvo_xml/%1";
                                                                      regexp = "^/lingvo_xml/([^\\?]+)(.*)$";
                                                                    };
                                                                  }; -- actions
                                                                  regexp = {
                                                                    xml = {
                                                                      priority = 2;
                                                                      match_fsm = {
                                                                        path = ".*(\\.xml|\\.htm|\\.html)";
                                                                        case_insensitive = true;
                                                                        surround = false;
                                                                      }; -- match_fsm
                                                                      response_headers_if = {
                                                                        matcher = {
                                                                          match_response_codes = {
                                                                            codes = { 200; 204; 206; };
                                                                          }; -- match_response_codes
                                                                        }; -- matcher
                                                                        create_header = {
                                                                          ["Content-Type"] = "application/xml";
                                                                        }; -- create_header
                                                                        shared = {
                                                                          uuid = "yastatic_net_s3_lingvo_xml_common";
                                                                          shared = {
                                                                            uuid = "1547776764857163274";
                                                                          }; -- shared
                                                                        }; -- shared
                                                                      }; -- response_headers_if
                                                                    }; -- xml
                                                                    default = {
                                                                      priority = 1;
                                                                      shared = {
                                                                        uuid = "yastatic_net_s3_lingvo_xml_common";
                                                                      }; -- shared
                                                                    }; -- default
                                                                  }; -- regexp
                                                                }; -- rewrite
                                                              }; -- headers
                                                            }; -- response_headers
                                                          }; -- shared
                                                        }; -- report
                                                      }; -- yastatic_net_s3_lingvo_xml
                                                      yastatic_net_s3_liza = {
                                                        priority = 64;
                                                        pattern = "/s3/liza(/.*)?";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "yastatic_net_s3_liza";
                                                          ranges = get_str_var("default_ranges");
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          shared = {
                                                            uuid = "yastatic_net_s3_liza";
                                                            headers = {
                                                              create = {
                                                                Host = "liza.s3.yandex.net";
                                                              }; -- create
                                                              rewrite = {
                                                                actions = {
                                                                  {
                                                                    global = false;
                                                                    rewrite = "%1";
                                                                    literal = false;
                                                                    case_insensitive = false;
                                                                    regexp = "/s3/liza(/.*)";
                                                                  };
                                                                }; -- actions
                                                                response_headers = {
                                                                  create_func = {
                                                                    Expires = "time:+216001s";
                                                                  }; -- create_func
                                                                  create = {
                                                                    ["Access-Control-Allow-Origin"] = "*";
                                                                    ["Cache-Control"] = "public, immutable, max-age=216013";
                                                                    ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                                    ["Timing-Allow-Origin"] = "*";
                                                                  }; -- create
                                                                  regexp = {
                                                                    br_section = {
                                                                      priority = 3;
                                                                      match_and = {
                                                                        {
                                                                          match_fsm = {
                                                                            path = ".*(\\.js|\\.css|\\.svg)";
                                                                            case_insensitive = true;
                                                                            surround = false;
                                                                          }; -- match_fsm
                                                                        };
                                                                        {
                                                                          match_fsm = {
                                                                            header = {
                                                                              name = "accept-encoding";
                                                                              value = "(.*,\\s*|)br(\\s*;\\s*q\\s*=\\s*(1|0\\.0*[1-9]).*|\\s*,.*|)";
                                                                            }; -- header
                                                                            case_insensitive = true;
                                                                            surround = false;
                                                                          }; -- match_fsm
                                                                        };
                                                                      }; -- match_and
                                                                      rewrite = {
                                                                        actions = {
                                                                          {
                                                                            global = false;
                                                                            literal = false;
                                                                            rewrite = "%1.br";
                                                                            case_insensitive = false;
                                                                            regexp = "([^\\?]+)(.*)";
                                                                          };
                                                                        }; -- actions
                                                                        response_headers = {
                                                                          create = {
                                                                            ["Content-Encoding"] = "br";
                                                                          }; -- create
                                                                          shared = {
                                                                            uuid = "8407010203626064324";
                                                                            shared = {
                                                                              uuid = "yastatic_net_s3_liza_common";
                                                                            }; -- shared
                                                                          }; -- shared
                                                                        }; -- response_headers
                                                                      }; -- rewrite
                                                                    }; -- br_section
                                                                    gzip_section = {
                                                                      priority = 2;
                                                                      match_and = {
                                                                        {
                                                                          match_fsm = {
                                                                            path = ".*(\\.js|\\.css|\\.svg)";
                                                                            case_insensitive = true;
                                                                            surround = false;
                                                                          }; -- match_fsm
                                                                        };
                                                                        {
                                                                          match_fsm = {
                                                                            header = {
                                                                              name = "accept-encoding";
                                                                              value = "(.*,\\s*|)gzip(\\s*;\\s*q\\s*=\\s*(1|0\\.0*[1-9]).*|\\s*,.*|)";
                                                                            }; -- header
                                                                            case_insensitive = true;
                                                                            surround = false;
                                                                          }; -- match_fsm
                                                                        };
                                                                      }; -- match_and
                                                                      rewrite = {
                                                                        actions = {
                                                                          {
                                                                            global = false;
                                                                            literal = false;
                                                                            rewrite = "%1.gz";
                                                                            case_insensitive = false;
                                                                            regexp = "([^\\?]+)(.*)";
                                                                          };
                                                                        }; -- actions
                                                                        response_headers = {
                                                                          create = {
                                                                            ["Content-Encoding"] = "gzip";
                                                                          }; -- create
                                                                          shared = {
                                                                            uuid = "8407010203626064324";
                                                                          }; -- shared
                                                                        }; -- response_headers
                                                                      }; -- rewrite
                                                                    }; -- gzip_section
                                                                    default = {
                                                                      priority = 1;
                                                                      shared = {
                                                                        uuid = "yastatic_net_s3_liza_common";
                                                                        shared = {
                                                                          uuid = "2679703888242934312";
                                                                        }; -- shared
                                                                      }; -- shared
                                                                    }; -- default
                                                                  }; -- regexp
                                                                }; -- response_headers
                                                              }; -- rewrite
                                                            }; -- headers
                                                          }; -- shared
                                                        }; -- report
                                                      }; -- yastatic_net_s3_liza
                                                      yastatic_net_s3_mail = {
                                                        priority = 63;
                                                        pattern = "/s3/mail(/.*)?";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "yastatic_net_s3_mail";
                                                          ranges = get_str_var("default_ranges");
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          shared = {
                                                            uuid = "yastatic_net_s3_mail";
                                                            headers = {
                                                              create = {
                                                                Host = "mail.s3.yandex.net";
                                                              }; -- create
                                                              rewrite = {
                                                                actions = {
                                                                  {
                                                                    global = false;
                                                                    literal = false;
                                                                    rewrite = "/%1";
                                                                    case_insensitive = false;
                                                                    regexp = "/s3/mail/(.*)";
                                                                  };
                                                                }; -- actions
                                                                response_headers = {
                                                                  create_func = {
                                                                    Expires = "time:+216001s";
                                                                  }; -- create_func
                                                                  create = {
                                                                    ["Access-Control-Allow-Origin"] = "*";
                                                                    ["Cache-Control"] = "public, immutable, max-age=216013";
                                                                    ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                                    ["Timing-Allow-Origin"] = "*";
                                                                  }; -- create
                                                                  shared = {
                                                                    uuid = "yastatic_net_s3_mail_common";
                                                                    shared = {
                                                                      uuid = "177686509217163545";
                                                                    }; -- shared
                                                                  }; -- shared
                                                                }; -- response_headers
                                                              }; -- rewrite
                                                            }; -- headers
                                                          }; -- shared
                                                        }; -- report
                                                      }; -- yastatic_net_s3_mail
                                                      yastatic_net_s3_mail_litetouch = {
                                                        priority = 62;
                                                        pattern = "/mail/(lite|touch|monograms|homer|morda-inbox|host-root2|postmaster|sms|pda2|promo-postmaster|neo2-themes|themes|collect|u2709|thememaster|forgetmenot|promo-newyear-2017|promo-valentine|daria-themes|promo-themes|lenta-block|todo|page-blocked|ranktable)(/.*)?";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "yastatic_net_s3_mail_litetouch";
                                                          ranges = get_str_var("default_ranges");
                                                          matcher_map = {
                                                            lite = {
                                                              match_fsm = {
                                                                path = "/mail/lite.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- lite
                                                            touch = {
                                                              match_fsm = {
                                                                path = "/mail/touch.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- touch
                                                            monograms = {
                                                              match_fsm = {
                                                                path = "/mail/monograms.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- monograms
                                                            homer = {
                                                              match_fsm = {
                                                                path = "/mail/homer.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- homer
                                                            ["morda-inbox"] = {
                                                              match_fsm = {
                                                                path = "/mail/morda-inbox.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- ["morda-inbox"]
                                                            ["host-root2"] = {
                                                              match_fsm = {
                                                                path = "/mail/host-root2.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- ["host-root2"]
                                                            postmaster = {
                                                              match_fsm = {
                                                                path = "/mail/postmaster.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- postmaster
                                                            sms = {
                                                              match_fsm = {
                                                                path = "/mail/sms.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- sms
                                                            pda2 = {
                                                              match_fsm = {
                                                                path = "/mail/pda2.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- pda2
                                                            ["promo-postmaster"] = {
                                                              match_fsm = {
                                                                path = "/mail/promo-postmaster.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- ["promo-postmaster"]
                                                            ["neo2-themes"] = {
                                                              match_fsm = {
                                                                path = "/mail/neo2-themes.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- ["neo2-themes"]
                                                            themes = {
                                                              match_fsm = {
                                                                path = "/mail/themes.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- themes
                                                            collect = {
                                                              match_fsm = {
                                                                path = "/mail/collect.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- collect
                                                            u2709 = {
                                                              match_fsm = {
                                                                path = "/mail/u2709.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- u2709
                                                            thememaster = {
                                                              match_fsm = {
                                                                path = "/mail/thememaster.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- thememaster
                                                            forgetmenot = {
                                                              match_fsm = {
                                                                path = "/mail/forgetmenot.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- forgetmenot
                                                            ["promo-newyear-2017"] = {
                                                              match_fsm = {
                                                                path = "/mail/promo-newyear-2017.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- ["promo-newyear-2017"]
                                                            ["promo-valentine"] = {
                                                              match_fsm = {
                                                                path = "/mail/promo-valentine.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- ["promo-valentine"]
                                                            ["daria-themes"] = {
                                                              match_fsm = {
                                                                path = "/mail/daria-themes.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- ["daria-themes"]
                                                            ["promo-themes"] = {
                                                              match_fsm = {
                                                                path = "/mail/promo-themes.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- ["promo-themes"]
                                                            ["lenta-block"] = {
                                                              match_fsm = {
                                                                path = "/mail/lenta-block.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- ["lenta-block"]
                                                            todo = {
                                                              match_fsm = {
                                                                path = "/mail/todo.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- todo
                                                            ["page-blocked"] = {
                                                              match_fsm = {
                                                                path = "/mail/page-blocked.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- ["page-blocked"]
                                                            ranktable = {
                                                              match_fsm = {
                                                                path = "/mail/ranktable.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- ranktable
                                                          }; -- matcher_map
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          shared = {
                                                            uuid = "yastatic_net_s3_mail_litetouch";
                                                            headers = {
                                                              create = {
                                                                Host = "yastatic.s3.yandex.net";
                                                              }; -- create
                                                              response_headers = {
                                                                create_func = {
                                                                  Expires = "time:+216001s";
                                                                }; -- create_func
                                                                create = {
                                                                  ["Access-Control-Allow-Origin"] = "*";
                                                                  ["Cache-Control"] = "public, max-age=216013";
                                                                  ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                                  ["Timing-Allow-Origin"] = "*";
                                                                }; -- create
                                                                shared = {
                                                                  uuid = "177686509217163545";
                                                                  headers = {
                                                                    delete = "authorization";
                                                                    shared = {
                                                                      uuid = "8416769305831316651";
                                                                      response_headers = {
                                                                        create = {
                                                                          ["Cache-Control"] = "public, max-age=216013";
                                                                        }; -- create
                                                                        shared = {
                                                                          uuid = "4957618399187796178";
                                                                        }; -- shared
                                                                      }; -- response_headers
                                                                    }; -- shared
                                                                  }; -- headers
                                                                }; -- shared
                                                              }; -- response_headers
                                                            }; -- headers
                                                          }; -- shared
                                                        }; -- report
                                                      }; -- yastatic_net_s3_mail_litetouch
                                                      yastatic_net_s3_mail_mailneo2 = {
                                                        priority = 61;
                                                        pattern = "/mail/(mail|neo2)(/.*)?";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "yastatic_net_s3_mail_mailneo2";
                                                          ranges = get_str_var("default_ranges");
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          shared = {
                                                            uuid = "yastatic_net_s3_mail_mailneo2";
                                                            headers = {
                                                              create = {
                                                                Host = "yastatic.s3.yandex.net";
                                                              }; -- create
                                                              response_headers = {
                                                                create_func = {
                                                                  Expires = "time:+216001s";
                                                                }; -- create_func
                                                                create = {
                                                                  ["Access-Control-Allow-Origin"] = "*";
                                                                  ["Cache-Control"] = "public, immutable, max-age=216013";
                                                                  ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                                  ["Timing-Allow-Origin"] = "*";
                                                                }; -- create
                                                                shared = {
                                                                  uuid = "177686509217163545";
                                                                }; -- shared
                                                              }; -- response_headers
                                                            }; -- headers
                                                          }; -- shared
                                                        }; -- report
                                                      }; -- yastatic_net_s3_mail_mailneo2
                                                      yastatic_net_s3_mail_socialavatars = {
                                                        priority = 60;
                                                        pattern = "/mail/socialavatars(/.*)?";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "yastatic_net_s3_mail_socialavatars";
                                                          ranges = get_str_var("default_ranges");
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          shared = {
                                                            uuid = "yastatic_net_s3_mail_socialavatars";
                                                            headers = {
                                                              create = {
                                                                Host = "yastatic-testing.s3.yandex.net";
                                                              }; -- create
                                                              response_headers = {
                                                                create = {
                                                                  ["Access-Control-Allow-Origin"] = "*";
                                                                  ["Cache-Control"] = "public";
                                                                  ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                                  ["Timing-Allow-Origin"] = "*";
                                                                }; -- create
                                                                shared = {
                                                                  uuid = "yastatic_net_s3_mail_socialavatars_common";
                                                                  shared = {
                                                                    uuid = "1547776764857163274";
                                                                  }; -- shared
                                                                }; -- shared
                                                              }; -- response_headers
                                                            }; -- headers
                                                          }; -- shared
                                                        }; -- report
                                                      }; -- yastatic_net_s3_mail_socialavatars
                                                      yastatic_net_s3_mail_themes = {
                                                        priority = 59;
                                                        pattern = "/mail/(_|_themes)(/.*)?";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "yastatic_net_s3_mail_themes";
                                                          ranges = get_str_var("default_ranges");
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          shared = {
                                                            uuid = "yastatic_net_s3_mail_themes";
                                                            headers = {
                                                              create = {
                                                                Host = "yastatic.s3.yandex.net";
                                                              }; -- create
                                                              response_headers = {
                                                                create_func = {
                                                                  Expires = "time:+216001s";
                                                                }; -- create_func
                                                                create = {
                                                                  ["Access-Control-Allow-Origin"] = "*";
                                                                  ["Cache-Control"] = "public, immutable, max-age=216013";
                                                                  ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                                  ["Timing-Allow-Origin"] = "*";
                                                                }; -- create
                                                                regexp = {
                                                                  br_section = {
                                                                    priority = 3;
                                                                    match_and = {
                                                                      {
                                                                        match_fsm = {
                                                                          path = ".*(\\.js|\\.css|\\.svg)";
                                                                          case_insensitive = true;
                                                                          surround = false;
                                                                        }; -- match_fsm
                                                                      };
                                                                      {
                                                                        match_fsm = {
                                                                          header = {
                                                                            name = "accept-encoding";
                                                                            value = "(.*,\\s*|)br(\\s*;\\s*q\\s*=\\s*(1|0\\.0*[1-9]).*|\\s*,.*|)";
                                                                          }; -- header
                                                                          case_insensitive = true;
                                                                          surround = false;
                                                                        }; -- match_fsm
                                                                      };
                                                                    }; -- match_and
                                                                    rewrite = {
                                                                      actions = {
                                                                        {
                                                                          global = false;
                                                                          literal = false;
                                                                          rewrite = "%1.br";
                                                                          case_insensitive = false;
                                                                          regexp = "([^\\?]+)(.*)";
                                                                        };
                                                                      }; -- actions
                                                                      response_headers_if = {
                                                                        matcher = {
                                                                          match_response_codes = {
                                                                            codes = { 200; 204; 206; };
                                                                          }; -- match_response_codes
                                                                        }; -- matcher
                                                                        create_header = {
                                                                          ["Content-Encoding"] = "br";
                                                                        }; -- create_header
                                                                        shared = {
                                                                          uuid = "5372925480439649417";
                                                                          shared = {
                                                                            uuid = "yastatic_net_s3_mail_themes_common";
                                                                          }; -- shared
                                                                        }; -- shared
                                                                      }; -- response_headers_if
                                                                    }; -- rewrite
                                                                  }; -- br_section
                                                                  gzip_section = {
                                                                    priority = 2;
                                                                    match_and = {
                                                                      {
                                                                        match_fsm = {
                                                                          path = ".*(\\.js|\\.css|\\.svg)";
                                                                          case_insensitive = true;
                                                                          surround = false;
                                                                        }; -- match_fsm
                                                                      };
                                                                      {
                                                                        match_fsm = {
                                                                          header = {
                                                                            name = "accept-encoding";
                                                                            value = "(.*,\\s*|)gzip(\\s*;\\s*q\\s*=\\s*(1|0\\.0*[1-9]).*|\\s*,.*|)";
                                                                          }; -- header
                                                                          case_insensitive = true;
                                                                          surround = false;
                                                                        }; -- match_fsm
                                                                      };
                                                                    }; -- match_and
                                                                    rewrite = {
                                                                      actions = {
                                                                        {
                                                                          global = false;
                                                                          literal = false;
                                                                          rewrite = "%1.gz";
                                                                          case_insensitive = false;
                                                                          regexp = "([^\\?]+)(.*)";
                                                                        };
                                                                      }; -- actions
                                                                      response_headers_if = {
                                                                        matcher = {
                                                                          match_response_codes = {
                                                                            codes = { 200; 204; 206; };
                                                                          }; -- match_response_codes
                                                                        }; -- matcher
                                                                        create_header = {
                                                                          ["Content-Encoding"] = "gzip";
                                                                        }; -- create_header
                                                                        shared = {
                                                                          uuid = "5372925480439649417";
                                                                        }; -- shared
                                                                      }; -- response_headers_if
                                                                    }; -- rewrite
                                                                  }; -- gzip_section
                                                                  default = {
                                                                    priority = 1;
                                                                    shared = {
                                                                      uuid = "yastatic_net_s3_mail_themes_common";
                                                                      shared = {
                                                                        uuid = "2679703888242934312";
                                                                      }; -- shared
                                                                    }; -- shared
                                                                  }; -- default
                                                                }; -- regexp
                                                              }; -- response_headers
                                                            }; -- headers
                                                          }; -- shared
                                                        }; -- report
                                                      }; -- yastatic_net_s3_mail_themes
                                                      ["yastatic_net_s3_mapsapi-jslibs"] = {
                                                        priority = 58;
                                                        pattern = "/s3/mapsapi-jslibs(/.*)?";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "yastatic_net_s3_mapsapi-jslibs";
                                                          ranges = get_str_var("default_ranges");
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          shared = {
                                                            uuid = "yastatic_net_s3_mapsapi-jslibs";
                                                            headers = {
                                                              create = {
                                                                Host = "mapsapi-jslibs.s3.yandex.net";
                                                              }; -- create
                                                              rewrite = {
                                                                actions = {
                                                                  {
                                                                    global = false;
                                                                    literal = false;
                                                                    rewrite = "/%1";
                                                                    case_insensitive = false;
                                                                    regexp = "/s3/mapsapi-jslibs/(.*)";
                                                                  };
                                                                }; -- actions
                                                                response_headers = {
                                                                  create_func = {
                                                                    Expires = "time:+216001s";
                                                                  }; -- create_func
                                                                  create = {
                                                                    ["Access-Control-Allow-Origin"] = "*";
                                                                    ["Cache-Control"] = "public, immutable, max-age=216013";
                                                                    ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                                    ["Timing-Allow-Origin"] = "*";
                                                                  }; -- create
                                                                  regexp = {
                                                                    br_section = {
                                                                      priority = 3;
                                                                      match_fsm = {
                                                                        header = {
                                                                          name = "accept-encoding";
                                                                          value = "(.*,\\s*|)br(\\s*;\\s*q\\s*=\\s*(1|0\\.0*[1-9]).*|\\s*,.*|)";
                                                                        }; -- header
                                                                        case_insensitive = true;
                                                                        surround = false;
                                                                      }; -- match_fsm
                                                                      rewrite = {
                                                                        actions = {
                                                                          {
                                                                            global = false;
                                                                            literal = false;
                                                                            rewrite = "%1.br";
                                                                            case_insensitive = false;
                                                                            regexp = "([^\\?]+)(.*)";
                                                                          };
                                                                        }; -- actions
                                                                        response_headers = {
                                                                          create = {
                                                                            ["Content-Encoding"] = "br";
                                                                          }; -- create
                                                                          shared = {
                                                                            uuid = "6763579655731480377";
                                                                            shared = {
                                                                              uuid = "yastatic_net_s3_mapsapi-jslibs_common";
                                                                            }; -- shared
                                                                          }; -- shared
                                                                        }; -- response_headers
                                                                      }; -- rewrite
                                                                    }; -- br_section
                                                                    gzip_section = {
                                                                      priority = 2;
                                                                      match_fsm = {
                                                                        header = {
                                                                          name = "accept-encoding";
                                                                          value = "(.*,\\s*|)gzip(\\s*;\\s*q\\s*=\\s*(1|0\\.0*[1-9]).*|\\s*,.*|)";
                                                                        }; -- header
                                                                        case_insensitive = true;
                                                                        surround = false;
                                                                      }; -- match_fsm
                                                                      rewrite = {
                                                                        actions = {
                                                                          {
                                                                            global = false;
                                                                            literal = false;
                                                                            rewrite = "%1.gz";
                                                                            case_insensitive = false;
                                                                            regexp = "([^\\?]+)(.*)";
                                                                          };
                                                                        }; -- actions
                                                                        response_headers = {
                                                                          create = {
                                                                            ["Content-Encoding"] = "gzip";
                                                                          }; -- create
                                                                          shared = {
                                                                            uuid = "6763579655731480377";
                                                                          }; -- shared
                                                                        }; -- response_headers
                                                                      }; -- rewrite
                                                                    }; -- gzip_section
                                                                    default = {
                                                                      priority = 1;
                                                                      shared = {
                                                                        uuid = "yastatic_net_s3_mapsapi-jslibs_common";
                                                                        shared = {
                                                                          uuid = "2679703888242934312";
                                                                        }; -- shared
                                                                      }; -- shared
                                                                    }; -- default
                                                                  }; -- regexp
                                                                }; -- response_headers
                                                              }; -- rewrite
                                                            }; -- headers
                                                          }; -- shared
                                                        }; -- report
                                                      }; -- ["yastatic_net_s3_mapsapi-jslibs"]
                                                      ["yastatic_net_s3_market-skubimarket-affiliate"] = {
                                                        priority = 57;
                                                        pattern = "/(market-skubi|market-affiliate|market-bluedesktop|market-bluetouch|market-touch|market-reddesktop|market-partner|market-vendors|market-analytics)(/.*)?";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "yastatic_net_s3_market-skubimarket-affiliate";
                                                          ranges = get_str_var("default_ranges");
                                                          matcher_map = {
                                                            ["market-skubi"] = {
                                                              match_fsm = {
                                                                path = "/market-skubi.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- ["market-skubi"]
                                                            ["market-affiliate"] = {
                                                              match_fsm = {
                                                                path = "/market-affiliate.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- ["market-affiliate"]
                                                            ["market-bluedesktop"] = {
                                                              match_fsm = {
                                                                path = "/market-bluedesktop.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- ["market-bluedesktop"]
                                                            ["market-bluetouch"] = {
                                                              match_fsm = {
                                                                path = "/market-bluetouch.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- ["market-bluetouch"]
                                                            ["market-touch"] = {
                                                              match_fsm = {
                                                                path = "/market-touch.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- ["market-touch"]
                                                            ["market-reddesktop"] = {
                                                              match_fsm = {
                                                                path = "/market-reddesktop.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- ["market-reddesktop"]
                                                            ["market-partner"] = {
                                                              match_fsm = {
                                                                path = "/market-partner.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- ["market-partner"]
                                                            ["market-vendors"] = {
                                                              match_fsm = {
                                                                path = "/market-vendors.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- ["market-vendors"]
                                                            ["market-analytics"] = {
                                                              match_fsm = {
                                                                path = "/market-analytics.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- ["market-analytics"]
                                                            doccenter = {
                                                              match_fsm = {
                                                                path = "/doccenter.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- doccenter
                                                          }; -- matcher_map
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          shared = {
                                                            uuid = "yastatic_net_s3_market-skubimarket-affiliate";
                                                            headers = {
                                                              create = {
                                                                Host = "yastatic-testing.s3.yandex.net";
                                                              }; -- create
                                                              response_headers = {
                                                                create_func = {
                                                                  Expires = "time:+1h";
                                                                }; -- create_func
                                                                create = {
                                                                  ["Access-Control-Allow-Origin"] = "*";
                                                                  ["Cache-Control"] = "public";
                                                                  ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                                  ["Timing-Allow-Origin"] = "*";
                                                                }; -- create
                                                                regexp = {
                                                                  br_section = {
                                                                    priority = 3;
                                                                    match_fsm = {
                                                                      header = {
                                                                        name = "accept-encoding";
                                                                        value = "(.*,\\s*|)br(\\s*;\\s*q\\s*=\\s*(1|0\\.0*[1-9]).*|\\s*,.*|)";
                                                                      }; -- header
                                                                      case_insensitive = true;
                                                                      surround = false;
                                                                    }; -- match_fsm
                                                                    shared = {
                                                                      uuid = "1943798333158700960";
                                                                      rewrite = {
                                                                        actions = {
                                                                          {
                                                                            global = false;
                                                                            literal = false;
                                                                            rewrite = "%1.gz";
                                                                            case_insensitive = false;
                                                                            regexp = "([^\\?]+)(.*)";
                                                                          };
                                                                        }; -- actions
                                                                        response_headers = {
                                                                          create = {
                                                                            ["Content-Encoding"] = "gzip";
                                                                          }; -- create
                                                                          shared = {
                                                                            uuid = "yastatic_net_s3_market-skubimarket-affiliate_common";
                                                                          }; -- shared
                                                                        }; -- response_headers
                                                                      }; -- rewrite
                                                                    }; -- shared
                                                                  }; -- br_section
                                                                  gzip_section = {
                                                                    priority = 2;
                                                                    match_fsm = {
                                                                      header = {
                                                                        name = "accept-encoding";
                                                                        value = "(.*,\\s*|)gzip(\\s*;\\s*q\\s*=\\s*(1|0\\.0*[1-9]).*|\\s*,.*|)";
                                                                      }; -- header
                                                                      case_insensitive = true;
                                                                      surround = false;
                                                                    }; -- match_fsm
                                                                    shared = {
                                                                      uuid = "1943798333158700960";
                                                                    }; -- shared
                                                                  }; -- gzip_section
                                                                  default = {
                                                                    priority = 1;
                                                                    shared = {
                                                                      uuid = "yastatic_net_s3_market-skubimarket-affiliate_common";
                                                                      shared = {
                                                                        uuid = "2679703888242934312";
                                                                      }; -- shared
                                                                    }; -- shared
                                                                  }; -- default
                                                                }; -- regexp
                                                              }; -- response_headers
                                                            }; -- headers
                                                          }; -- shared
                                                        }; -- report
                                                      }; -- ["yastatic_net_s3_market-skubimarket-affiliate"]
                                                      yastatic_net_s3_market_export = {
                                                        priority = 56;
                                                        pattern = "/market-export(/.*)?";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "yastatic_net_s3_market_export";
                                                          ranges = get_str_var("default_ranges");
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          shared = {
                                                            uuid = "yastatic_net_s3_market_export";
                                                            headers = {
                                                              create = {
                                                                Host = "yastatic.s3.yandex.net";
                                                              }; -- create
                                                              response_headers = {
                                                                create_func = {
                                                                  Expires = "time:+216001s";
                                                                }; -- create_func
                                                                create = {
                                                                  ["Access-Control-Allow-Origin"] = "*";
                                                                  ["Cache-Control"] = "public, max-age=216013";
                                                                  ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                                  ["Timing-Allow-Origin"] = "*";
                                                                }; -- create
                                                                regexp = {
                                                                  br_section = {
                                                                    priority = 3;
                                                                    match_fsm = {
                                                                      header = {
                                                                        name = "accept-encoding";
                                                                        value = "(.*,\\s*|)br(\\s*;\\s*q\\s*=\\s*(1|0\\.0*[1-9]).*|\\s*,.*|)";
                                                                      }; -- header
                                                                      case_insensitive = true;
                                                                      surround = false;
                                                                    }; -- match_fsm
                                                                    shared = {
                                                                      uuid = "1600030541624352053";
                                                                      rewrite = {
                                                                        actions = {
                                                                          {
                                                                            global = false;
                                                                            literal = false;
                                                                            rewrite = "%1.gz";
                                                                            case_insensitive = false;
                                                                            regexp = "([^\\?]+)(.*)";
                                                                          };
                                                                        }; -- actions
                                                                        response_headers = {
                                                                          create = {
                                                                            ["Content-Encoding"] = "gzip";
                                                                          }; -- create
                                                                          shared = {
                                                                            uuid = "yastatic_net_s3_market_export_common";
                                                                          }; -- shared
                                                                        }; -- response_headers
                                                                      }; -- rewrite
                                                                    }; -- shared
                                                                  }; -- br_section
                                                                  gzip_section = {
                                                                    priority = 2;
                                                                    match_fsm = {
                                                                      header = {
                                                                        name = "accept-encoding";
                                                                        value = "(.*,\\s*|)gzip(\\s*;\\s*q\\s*=\\s*(1|0\\.0*[1-9]).*|\\s*,.*|)";
                                                                      }; -- header
                                                                      case_insensitive = true;
                                                                      surround = false;
                                                                    }; -- match_fsm
                                                                    shared = {
                                                                      uuid = "1600030541624352053";
                                                                    }; -- shared
                                                                  }; -- gzip_section
                                                                  default = {
                                                                    priority = 1;
                                                                    shared = {
                                                                      uuid = "yastatic_net_s3_market_export_common";
                                                                      shared = {
                                                                        uuid = "2679703888242934312";
                                                                      }; -- shared
                                                                    }; -- shared
                                                                  }; -- default
                                                                }; -- regexp
                                                              }; -- response_headers
                                                            }; -- headers
                                                          }; -- shared
                                                        }; -- report
                                                      }; -- yastatic_net_s3_market_export
                                                      yastatic_net_s3_media_stories = {
                                                        priority = 55;
                                                        pattern = "/media-stories(/.*)?";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "yastatic_net_s3_media_stories";
                                                          ranges = get_str_var("default_ranges");
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          shared = {
                                                            uuid = "yastatic_net_s3_media_stories";
                                                            headers = {
                                                              delete = "authorization";
                                                              create = {
                                                                Host = "media-stories.s3.yandex.net";
                                                              }; -- create
                                                              rewrite = {
                                                                actions = {
                                                                  {
                                                                    global = false;
                                                                    literal = false;
                                                                    rewrite = "%1/%2%3";
                                                                    case_insensitive = false;
                                                                    regexp = "^(/.*)?/v-[^/a-zA-Z]+/(.*)(\\?.*)?$";
                                                                  };
                                                                  {
                                                                    global = false;
                                                                    literal = false;
                                                                    rewrite = "/%1";
                                                                    case_insensitive = false;
                                                                    regexp = "/media-stories/(.*)";
                                                                  };
                                                                }; -- actions
                                                                response_headers = {
                                                                  create_func = {
                                                                    Expires = "time:+1h";
                                                                  }; -- create_func
                                                                  create = {
                                                                    ["Access-Control-Allow-Origin"] = "*";
                                                                    ["Cache-Control"] = "public, max-age=31536000";
                                                                    ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                                    ["Timing-Allow-Origin"] = "*";
                                                                  }; -- create
                                                                  shared = {
                                                                    uuid = "4957618399187796178";
                                                                  }; -- shared
                                                                }; -- response_headers
                                                              }; -- rewrite
                                                            }; -- headers
                                                          }; -- shared
                                                        }; -- report
                                                      }; -- yastatic_net_s3_media_stories
                                                      ["yastatic_net_s3_metrika-static-watch"] = {
                                                        priority = 54;
                                                        pattern = "/metrika-static-watch(/.*)?";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "yastatic_net_s3_metrika-static-watch";
                                                          ranges = get_str_var("default_ranges");
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          shared = {
                                                            uuid = "yastatic_net_s3_metrika-static-watch";
                                                            headers = {
                                                              create = {
                                                                Host = "yastatic.s3.yandex.net";
                                                              }; -- create
                                                              response_headers = {
                                                                create_func = {
                                                                  Expires = "time:+2h";
                                                                }; -- create_func
                                                                create = {
                                                                  ["Access-Control-Allow-Origin"] = "*";
                                                                  ["Cache-Control"] = "public, max-age=7200";
                                                                  ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                                  ["Timing-Allow-Origin"] = "*";
                                                                }; -- create
                                                                shared = {
                                                                  uuid = "yastatic_net_s3_metrika-static-watch_common";
                                                                  shared = {
                                                                    uuid = "177686509217163545";
                                                                  }; -- shared
                                                                }; -- shared
                                                              }; -- response_headers
                                                            }; -- headers
                                                          }; -- shared
                                                        }; -- report
                                                      }; -- ["yastatic_net_s3_metrika-static-watch"]
                                                      yastatic_net_s3_metrikaadmetrika = {
                                                        priority = 53;
                                                        pattern = "/s3/(metrika|admetrika|appmetrica|audience|promo|radar|admetrica|sensor)(/.*)?";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "yastatic_net_s3_metrikaadmetrika";
                                                          ranges = get_str_var("default_ranges");
                                                          matcher_map = {
                                                            metrika = {
                                                              match_fsm = {
                                                                path = "/s3/metrika.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- metrika
                                                            admetrika = {
                                                              match_fsm = {
                                                                path = "/s3/admetrika.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- admetrika
                                                            appmetrica = {
                                                              match_fsm = {
                                                                path = "/s3/appmetrica.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- appmetrica
                                                            audience = {
                                                              match_fsm = {
                                                                path = "/s3/audience.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- audience
                                                            promo = {
                                                              match_fsm = {
                                                                path = "/s3/promo.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- promo
                                                            radar = {
                                                              match_fsm = {
                                                                path = "/s3/radar.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- radar
                                                            admetrica = {
                                                              match_fsm = {
                                                                path = "/s3/admetrica.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- admetrica
                                                            sensor = {
                                                              match_fsm = {
                                                                path = "/s3/sensor.*";
                                                                case_insensitive = true;
                                                                surround = false;
                                                              }; -- match_fsm
                                                            }; -- sensor
                                                          }; -- matcher_map
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          shared = {
                                                            uuid = "yastatic_net_s3_metrikaadmetrika";
                                                            rewrite = {
                                                              actions = {
                                                                {
                                                                  global = false;
                                                                  literal = false;
                                                                  rewrite = "/%2";
                                                                  case_insensitive = false;
                                                                  regexp = "/s3/([A-Za-z0-9\\-_]+)/(.*)";
                                                                };
                                                                {
                                                                  global = false;
                                                                  literal = false;
                                                                  regexp = "(.*)";
                                                                  rewrite = "%{url}";
                                                                  header_name = "Host";
                                                                  case_insensitive = false;
                                                                };
                                                              }; -- actions
                                                              rewrite = {
                                                                actions = {
                                                                  {
                                                                    global = false;
                                                                    literal = false;
                                                                    header_name = "Host";
                                                                    case_insensitive = false;
                                                                    rewrite = "%1.s3.yandex.net";
                                                                    regexp = "/s3/([A-Za-z0-9\\-_]+)/(.*)";
                                                                  };
                                                                }; -- actions
                                                                response_headers = {
                                                                  create_func = {
                                                                    Expires = "time:+216001s";
                                                                  }; -- create_func
                                                                  create = {
                                                                    ["Access-Control-Allow-Origin"] = "*";
                                                                    ["Cache-Control"] = "public, max-age=216013";
                                                                    ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                                    ["Timing-Allow-Origin"] = "*";
                                                                  }; -- create
                                                                  regexp = {
                                                                    br_section = {
                                                                      priority = 3;
                                                                      match_fsm = {
                                                                        header = {
                                                                          name = "accept-encoding";
                                                                          value = "(.*,\\.*|)br(\\.*;\\.*q\\.*=\\.*(1|0\\.0*[1-9]).*|\\.*,.*|)";
                                                                        }; -- header
                                                                        case_insensitive = true;
                                                                        surround = false;
                                                                      }; -- match_fsm
                                                                      rewrite = {
                                                                        actions = {
                                                                          {
                                                                            global = false;
                                                                            literal = false;
                                                                            rewrite = "%1.br";
                                                                            case_insensitive = false;
                                                                            regexp = "([^\\?]+)(.*)";
                                                                          };
                                                                        }; -- actions
                                                                        response_headers = {
                                                                          create = {
                                                                            ["Content-Encoding"] = "br";
                                                                          }; -- create
                                                                          shared = {
                                                                            uuid = "3998629150414663295";
                                                                            shared = {
                                                                              uuid = "yastatic_net_s3_metrikaadmetrika_common";
                                                                            }; -- shared
                                                                          }; -- shared
                                                                        }; -- response_headers
                                                                      }; -- rewrite
                                                                    }; -- br_section
                                                                    gzip_section = {
                                                                      priority = 2;
                                                                      match_fsm = {
                                                                        header = {
                                                                          name = "accept-encoding";
                                                                          value = "(.*,\\.*|)gzip(\\.*;\\.*q\\.*=\\.*(1|0\\.0*[1-9]).*|\\.*,.*|)";
                                                                        }; -- header
                                                                        case_insensitive = true;
                                                                        surround = false;
                                                                      }; -- match_fsm
                                                                      rewrite = {
                                                                        actions = {
                                                                          {
                                                                            global = false;
                                                                            literal = false;
                                                                            rewrite = "%1.gz";
                                                                            case_insensitive = false;
                                                                            regexp = "([^\\?]+)(.*)";
                                                                          };
                                                                        }; -- actions
                                                                        response_headers = {
                                                                          create = {
                                                                            ["Content-Encoding"] = "gzip";
                                                                          }; -- create
                                                                          shared = {
                                                                            uuid = "3998629150414663295";
                                                                          }; -- shared
                                                                        }; -- response_headers
                                                                      }; -- rewrite
                                                                    }; -- gzip_section
                                                                    default = {
                                                                      priority = 1;
                                                                      shared = {
                                                                        uuid = "yastatic_net_s3_metrikaadmetrika_common";
                                                                        shared = {
                                                                          uuid = "2679703888242934312";
                                                                        }; -- shared
                                                                      }; -- shared
                                                                    }; -- default
                                                                  }; -- regexp
                                                                }; -- response_headers
                                                              }; -- rewrite
                                                            }; -- rewrite
                                                          }; -- shared
                                                        }; -- report
                                                      }; -- yastatic_net_s3_metrikaadmetrika
                                                      yastatic_net_s3_mraid = {
                                                        priority = 52;
                                                        pattern = "/mraid(/.*)?";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "yastatic_net_s3_mraid";
                                                          ranges = get_str_var("default_ranges");
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          shared = {
                                                            uuid = "yastatic_net_s3_mraid";
                                                            headers = {
                                                              create = {
                                                                Host = "pcode.s3.yandex.net";
                                                              }; -- create
                                                              rewrite = {
                                                                actions = {
                                                                  {
                                                                    global = false;
                                                                    literal = false;
                                                                    regexp = "/mraid/(.*)";
                                                                    case_insensitive = false;
                                                                    rewrite = "/mraid/loaders/%1";
                                                                  };
                                                                }; -- actions
                                                                response_headers = {
                                                                  create_func = {
                                                                    Expires = "time:+1h";
                                                                  }; -- create_func
                                                                  create = {
                                                                    ["Access-Control-Allow-Origin"] = "*";
                                                                    ["Cache-Control"] = "public, max-age=3600";
                                                                    ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                                    ["Timing-Allow-Origin"] = "*";
                                                                  }; -- create
                                                                  regexp = {
                                                                    br_section = {
                                                                      priority = 3;
                                                                      match_and = {
                                                                        {
                                                                          match_fsm = {
                                                                            path = ".*(\\.js|\\.html|\\.json)";
                                                                            case_insensitive = true;
                                                                            surround = false;
                                                                          }; -- match_fsm
                                                                        };
                                                                        {
                                                                          match_fsm = {
                                                                            header = {
                                                                              name = "accept-encoding";
                                                                              value = "(.*,\\s*|)br(\\s*;\\s*q\\s*=\\s*(1|0\\.0*[1-9]).*|\\s*,.*|)";
                                                                            }; -- header
                                                                            case_insensitive = true;
                                                                            surround = false;
                                                                          }; -- match_fsm
                                                                        };
                                                                      }; -- match_and
                                                                      rewrite = {
                                                                        actions = {
                                                                          {
                                                                            global = false;
                                                                            literal = false;
                                                                            rewrite = "%1.br";
                                                                            case_insensitive = false;
                                                                            regexp = "([^\\?]+)(.*)";
                                                                          };
                                                                        }; -- actions
                                                                        response_headers_if = {
                                                                          matcher = {
                                                                            match_response_codes = {
                                                                              codes = { 200; 204; 206; };
                                                                            }; -- match_response_codes
                                                                          }; -- matcher
                                                                          create_header = {
                                                                            ["Content-Encoding"] = "br";
                                                                          }; -- create_header
                                                                          shared = {
                                                                            uuid = "6676293992429909460";
                                                                            shared = {
                                                                              uuid = "yastatic_net_s3_mraid_common";
                                                                            }; -- shared
                                                                          }; -- shared
                                                                        }; -- response_headers_if
                                                                      }; -- rewrite
                                                                    }; -- br_section
                                                                    gzip_section = {
                                                                      priority = 2;
                                                                      match_and = {
                                                                        {
                                                                          match_fsm = {
                                                                            path = ".*(\\.js|\\.html|\\.json)";
                                                                            case_insensitive = true;
                                                                            surround = false;
                                                                          }; -- match_fsm
                                                                        };
                                                                        {
                                                                          match_fsm = {
                                                                            header = {
                                                                              name = "accept-encoding";
                                                                              value = "(.*,\\s*|)gzip(\\s*;\\s*q\\s*=\\s*(1|0\\.0*[1-9]).*|\\s*,.*|)";
                                                                            }; -- header
                                                                            case_insensitive = true;
                                                                            surround = false;
                                                                          }; -- match_fsm
                                                                        };
                                                                      }; -- match_and
                                                                      rewrite = {
                                                                        actions = {
                                                                          {
                                                                            global = false;
                                                                            literal = false;
                                                                            rewrite = "%1.gz";
                                                                            case_insensitive = false;
                                                                            regexp = "([^\\?]+)(.*)";
                                                                          };
                                                                        }; -- actions
                                                                        response_headers_if = {
                                                                          matcher = {
                                                                            match_response_codes = {
                                                                              codes = { 200; 204; 206; };
                                                                            }; -- match_response_codes
                                                                          }; -- matcher
                                                                          create_header = {
                                                                            ["Content-Encoding"] = "gzip";
                                                                          }; -- create_header
                                                                          shared = {
                                                                            uuid = "6676293992429909460";
                                                                          }; -- shared
                                                                        }; -- response_headers_if
                                                                      }; -- rewrite
                                                                    }; -- gzip_section
                                                                    default = {
                                                                      priority = 1;
                                                                      shared = {
                                                                        uuid = "yastatic_net_s3_mraid_common";
                                                                        shared = {
                                                                          uuid = "2679703888242934312";
                                                                        }; -- shared
                                                                      }; -- shared
                                                                    }; -- default
                                                                  }; -- regexp
                                                                }; -- response_headers
                                                              }; -- rewrite
                                                            }; -- headers
                                                          }; -- shared
                                                        }; -- report
                                                      }; -- yastatic_net_s3_mraid
                                                      ["yastatic_net_s3_mraid-bundles"] = {
                                                        priority = 51;
                                                        pattern = "/mraid-bundles(/.*)?";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "yastatic_net_s3_mraid-bundles";
                                                          ranges = get_str_var("default_ranges");
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          shared = {
                                                            uuid = "yastatic_net_s3_mraid-bundles";
                                                            headers = {
                                                              create = {
                                                                Host = "pcode.s3.yandex.net";
                                                              }; -- create
                                                              rewrite = {
                                                                actions = {
                                                                  {
                                                                    global = false;
                                                                    literal = false;
                                                                    rewrite = "/mraid/%1";
                                                                    case_insensitive = false;
                                                                    regexp = "/mraid-bundles/(.*)";
                                                                  };
                                                                }; -- actions
                                                                response_headers = {
                                                                  create_func = {
                                                                    Expires = "time:+1h";
                                                                  }; -- create_func
                                                                  create = {
                                                                    ["Access-Control-Allow-Origin"] = "*";
                                                                    ["Cache-Control"] = "public, max-age=216013";
                                                                    ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                                    ["Timing-Allow-Origin"] = "*";
                                                                  }; -- create
                                                                  regexp = {
                                                                    br_section = {
                                                                      priority = 3;
                                                                      match_and = {
                                                                        {
                                                                          match_fsm = {
                                                                            path = ".*(\\.js|\\.html|\\.json)";
                                                                            case_insensitive = true;
                                                                            surround = false;
                                                                          }; -- match_fsm
                                                                        };
                                                                        {
                                                                          match_fsm = {
                                                                            header = {
                                                                              name = "accept-encoding";
                                                                              value = "(.*,\\s*|)br(\\s*;\\s*q\\s*=\\s*(1|0\\.0*[1-9]).*|\\s*,.*|)";
                                                                            }; -- header
                                                                            case_insensitive = true;
                                                                            surround = false;
                                                                          }; -- match_fsm
                                                                        };
                                                                      }; -- match_and
                                                                      rewrite = {
                                                                        actions = {
                                                                          {
                                                                            global = false;
                                                                            literal = false;
                                                                            rewrite = "%1.br";
                                                                            case_insensitive = false;
                                                                            regexp = "([^\\?]+)(.*)";
                                                                          };
                                                                        }; -- actions
                                                                        response_headers_if = {
                                                                          matcher = {
                                                                            match_response_codes = {
                                                                              codes = { 200; 204; 206; };
                                                                            }; -- match_response_codes
                                                                          }; -- matcher
                                                                          create_header = {
                                                                            ["Content-Encoding"] = "br";
                                                                          }; -- create_header
                                                                          shared = {
                                                                            uuid = "6152844572549434252";
                                                                            shared = {
                                                                              uuid = "yastatic_net_s3_mraid-bundles_common";
                                                                            }; -- shared
                                                                          }; -- shared
                                                                        }; -- response_headers_if
                                                                      }; -- rewrite
                                                                    }; -- br_section
                                                                    gzip_section = {
                                                                      priority = 2;
                                                                      match_and = {
                                                                        {
                                                                          match_fsm = {
                                                                            path = ".*(\\.js|\\.html|\\.json)";
                                                                            case_insensitive = true;
                                                                            surround = false;
                                                                          }; -- match_fsm
                                                                        };
                                                                        {
                                                                          match_fsm = {
                                                                            header = {
                                                                              name = "accept-encoding";
                                                                              value = "(.*,\\s*|)gzip(\\s*;\\s*q\\s*=\\s*(1|0\\.0*[1-9]).*|\\s*,.*|)";
                                                                            }; -- header
                                                                            case_insensitive = true;
                                                                            surround = false;
                                                                          }; -- match_fsm
                                                                        };
                                                                      }; -- match_and
                                                                      rewrite = {
                                                                        actions = {
                                                                          {
                                                                            global = false;
                                                                            literal = false;
                                                                            rewrite = "%1.gz";
                                                                            case_insensitive = false;
                                                                            regexp = "([^\\?]+)(.*)";
                                                                          };
                                                                        }; -- actions
                                                                        response_headers_if = {
                                                                          matcher = {
                                                                            match_response_codes = {
                                                                              codes = { 200; 204; 206; };
                                                                            }; -- match_response_codes
                                                                          }; -- matcher
                                                                          create_header = {
                                                                            ["Content-Encoding"] = "gzip";
                                                                          }; -- create_header
                                                                          shared = {
                                                                            uuid = "6152844572549434252";
                                                                          }; -- shared
                                                                        }; -- response_headers_if
                                                                      }; -- rewrite
                                                                    }; -- gzip_section
                                                                    default = {
                                                                      priority = 1;
                                                                      shared = {
                                                                        uuid = "yastatic_net_s3_mraid-bundles_common";
                                                                        shared = {
                                                                          uuid = "2679703888242934312";
                                                                        }; -- shared
                                                                      }; -- shared
                                                                    }; -- default
                                                                  }; -- regexp
                                                                }; -- response_headers
                                                              }; -- rewrite
                                                            }; -- headers
                                                          }; -- shared
                                                        }; -- report
                                                      }; -- ["yastatic_net_s3_mraid-bundles"]
                                                      ["yastatic_net_s3_nerpa-static"] = {
                                                        priority = 50;
                                                        pattern = "/s3/nerpa-static(/.*)?";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "yastatic_net_s3_nerpa-static";
                                                          ranges = get_str_var("default_ranges");
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          shared = {
                                                            uuid = "yastatic_net_s3_nerpa-static";
                                                            headers = {
                                                              create = {
                                                                Host = "nerpa-static.s3.yandex.net";
                                                              }; -- create
                                                              rewrite = {
                                                                actions = {
                                                                  {
                                                                    global = false;
                                                                    literal = false;
                                                                    rewrite = "/%1";
                                                                    case_insensitive = false;
                                                                    regexp = "/s3/nerpa-static/(.*)";
                                                                  };
                                                                }; -- actions
                                                                response_headers = {
                                                                  create_func = {
                                                                    Expires = "time:+216001s";
                                                                  }; -- create_func
                                                                  create = {
                                                                    ["Access-Control-Allow-Origin"] = "*";
                                                                    ["Cache-Control"] = "public, immutable, max-age=216013";
                                                                    ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                                    ["Timing-Allow-Origin"] = "*";
                                                                  }; -- create
                                                                  regexp = {
                                                                    br_section = {
                                                                      priority = 3;
                                                                      match_and = {
                                                                        {
                                                                          match_not = {
                                                                            match_fsm = {
                                                                              path = ".*(\\.png)";
                                                                              case_insensitive = true;
                                                                              surround = false;
                                                                            }; -- match_fsm
                                                                          }; -- match_not
                                                                        };
                                                                        {
                                                                          match_fsm = {
                                                                            header = {
                                                                              name = "accept-encoding";
                                                                              value = "(.*,\\s*|)br(\\s*;\\s*q\\s*=\\s*(1|0\\.0*[1-9]).*|\\s*,.*|)";
                                                                            }; -- header
                                                                            case_insensitive = true;
                                                                            surround = false;
                                                                          }; -- match_fsm
                                                                        };
                                                                      }; -- match_and
                                                                      rewrite = {
                                                                        actions = {
                                                                          {
                                                                            global = false;
                                                                            literal = false;
                                                                            rewrite = "%1.br";
                                                                            case_insensitive = false;
                                                                            regexp = "([^\\?]+)(.*)";
                                                                          };
                                                                        }; -- actions
                                                                        response_headers_if = {
                                                                          matcher = {
                                                                            match_response_codes = {
                                                                              codes = { 200; 204; 206; };
                                                                            }; -- match_response_codes
                                                                          }; -- matcher
                                                                          create_header = {
                                                                            ["Content-Encoding"] = "br";
                                                                          }; -- create_header
                                                                          shared = {
                                                                            uuid = "7985754759511015765";
                                                                            shared = {
                                                                              uuid = "yastatic_net_s3_nerpa-static_common";
                                                                            }; -- shared
                                                                          }; -- shared
                                                                        }; -- response_headers_if
                                                                      }; -- rewrite
                                                                    }; -- br_section
                                                                    gzip_section = {
                                                                      priority = 2;
                                                                      match_and = {
                                                                        {
                                                                          match_not = {
                                                                            match_fsm = {
                                                                              path = ".*(\\.png)";
                                                                              case_insensitive = true;
                                                                              surround = false;
                                                                            }; -- match_fsm
                                                                          }; -- match_not
                                                                        };
                                                                        {
                                                                          match_fsm = {
                                                                            header = {
                                                                              name = "accept-encoding";
                                                                              value = "(.*,\\s*|)gzip(\\s*;\\s*q\\s*=\\s*(1|0\\.0*[1-9]).*|\\s*,.*|)";
                                                                            }; -- header
                                                                            case_insensitive = true;
                                                                            surround = false;
                                                                          }; -- match_fsm
                                                                        };
                                                                      }; -- match_and
                                                                      rewrite = {
                                                                        actions = {
                                                                          {
                                                                            global = false;
                                                                            literal = false;
                                                                            rewrite = "%1.gz";
                                                                            case_insensitive = false;
                                                                            regexp = "([^\\?]+)(.*)";
                                                                          };
                                                                        }; -- actions
                                                                        response_headers_if = {
                                                                          matcher = {
                                                                            match_response_codes = {
                                                                              codes = { 200; 204; 206; };
                                                                            }; -- match_response_codes
                                                                          }; -- matcher
                                                                          create_header = {
                                                                            ["Content-Encoding"] = "gzip";
                                                                          }; -- create_header
                                                                          shared = {
                                                                            uuid = "7985754759511015765";
                                                                          }; -- shared
                                                                        }; -- response_headers_if
                                                                      }; -- rewrite
                                                                    }; -- gzip_section
                                                                    default = {
                                                                      priority = 1;
                                                                      shared = {
                                                                        uuid = "yastatic_net_s3_nerpa-static_common";
                                                                        shared = {
                                                                          uuid = "2679703888242934312";
                                                                        }; -- shared
                                                                      }; -- shared
                                                                    }; -- default
                                                                  }; -- regexp
                                                                }; -- response_headers
                                                              }; -- rewrite
                                                            }; -- headers
                                                          }; -- shared
                                                        }; -- report
                                                      }; -- ["yastatic_net_s3_nerpa-static"]
                                                      ["yastatic_net_s3_newsnews-touch-phone"] = {
                                                        priority = 49;
                                                        pattern = "/(news|news-touch-phone)(/.*)?";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "yastatic_net_s3_newsnews-touch-phone";
                                                          ranges = get_str_var("default_ranges");
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          shared = {
                                                            uuid = "yastatic_net_s3_newsnews-touch-phone";
                                                            headers = {
                                                              create = {
                                                                Host = "yastatic.s3.yandex.net";
                                                              }; -- create
                                                              response_headers = {
                                                                create_func = {
                                                                  Expires = "time:+216001s";
                                                                }; -- create_func
                                                                create = {
                                                                  ["Access-Control-Allow-Origin"] = "*";
                                                                  ["Cache-Control"] = "public, max-age=216013";
                                                                  ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                                  ["Timing-Allow-Origin"] = "*";
                                                                }; -- create
                                                                regexp = {
                                                                  br_section = {
                                                                    priority = 3;
                                                                    match_and = {
                                                                      {
                                                                        match_fsm = {
                                                                          path = ".*(\\.js|\\.css|\\.svg)";
                                                                          case_insensitive = true;
                                                                          surround = false;
                                                                        }; -- match_fsm
                                                                      };
                                                                      {
                                                                        match_fsm = {
                                                                          header = {
                                                                            name = "accept-encoding";
                                                                            value = "(.*,\\s*|)br(\\s*;\\s*q\\s*=\\s*(1|0\\.0*[1-9]).*|\\s*,.*|)";
                                                                          }; -- header
                                                                          case_insensitive = true;
                                                                          surround = false;
                                                                        }; -- match_fsm
                                                                      };
                                                                    }; -- match_and
                                                                    rewrite = {
                                                                      actions = {
                                                                        {
                                                                          global = false;
                                                                          literal = false;
                                                                          rewrite = "%1.br";
                                                                          case_insensitive = false;
                                                                          regexp = "([^\\?]+)(.*)";
                                                                        };
                                                                      }; -- actions
                                                                      response_headers = {
                                                                        create = {
                                                                          ["Content-Encoding"] = "br";
                                                                        }; -- create
                                                                        shared = {
                                                                          uuid = "5401623505495484279";
                                                                          shared = {
                                                                            uuid = "yastatic_net_s3_newsnews-touch-phone_common";
                                                                          }; -- shared
                                                                        }; -- shared
                                                                      }; -- response_headers
                                                                    }; -- rewrite
                                                                  }; -- br_section
                                                                  gzip_section = {
                                                                    priority = 2;
                                                                    match_and = {
                                                                      {
                                                                        match_fsm = {
                                                                          path = ".*(\\.js|\\.css|\\.svg)";
                                                                          case_insensitive = true;
                                                                          surround = false;
                                                                        }; -- match_fsm
                                                                      };
                                                                      {
                                                                        match_fsm = {
                                                                          header = {
                                                                            name = "accept-encoding";
                                                                            value = "(.*,\\s*|)gzip(\\s*;\\s*q\\s*=\\s*(1|0\\.0*[1-9]).*|\\s*,.*|)";
                                                                          }; -- header
                                                                          case_insensitive = true;
                                                                          surround = false;
                                                                        }; -- match_fsm
                                                                      };
                                                                    }; -- match_and
                                                                    rewrite = {
                                                                      actions = {
                                                                        {
                                                                          global = false;
                                                                          literal = false;
                                                                          rewrite = "%1.gz";
                                                                          case_insensitive = false;
                                                                          regexp = "([^\\?]+)(.*)";
                                                                        };
                                                                      }; -- actions
                                                                      response_headers = {
                                                                        create = {
                                                                          ["Content-Encoding"] = "gzip";
                                                                        }; -- create
                                                                        shared = {
                                                                          uuid = "5401623505495484279";
                                                                        }; -- shared
                                                                      }; -- response_headers
                                                                    }; -- rewrite
                                                                  }; -- gzip_section
                                                                  default = {
                                                                    priority = 1;
                                                                    shared = {
                                                                      uuid = "yastatic_net_s3_newsnews-touch-phone_common";
                                                                      shared = {
                                                                        uuid = "2679703888242934312";
                                                                      }; -- shared
                                                                    }; -- shared
                                                                  }; -- default
                                                                }; -- regexp
                                                              }; -- response_headers
                                                            }; -- headers
                                                          }; -- shared
                                                        }; -- report
                                                      }; -- ["yastatic_net_s3_newsnews-touch-phone"]
                                                      yastatic_net_s3_notes = {
                                                        priority = 48;
                                                        pattern = "/s3/notes(/.*)?";
                                                        case_insensitive = true;
                                                        report = {
                                                          uuid = "yastatic_net_s3_notes";
                                                          ranges = get_str_var("default_ranges");
                                                          just_storage = false;
                                                          disable_robotness = true;
                                                          disable_sslness = true;
                                                          events = {
                                                            stats = "report";
                                                          }; -- events
                                                          shared = {
                                                            uuid = "yastatic_net_s3_notes";
                                                            headers = {
                                                              create = {
                                                                Host = "notes.s3.yandex.net";
                                                              }; -- create
                                                              rewrite = {
                                                                actions = {
                                                                  {
                                                                    global = false;
                                                                    rewrite = "%1";
                                                                    literal = false;
                                                                    case_insensitive = false;
                                                                    regexp = "/s3/notes(/.*)";
                                                                  };
                                                                }; -- actions
                                                                response_headers = {
                                                                  create_func = {
                                                                    Expires = "time:+216001s";
                                                                  }; -- create_func
                                                                  create = {
                                                                    ["Access-Control-Allow-Origin"] = "*";
                                                                    ["Cache-Control"] = "public, max-age=216013";
                                                                    ["Strict-Transport-Security"] = "max-age=43200000; includeSubDomains;";
                                                                    ["Timing-Allow-Origin"] = "*";
                                                                  }; -- create
                                                                  regexp = {
                                                                    br_section = {
                                                                      priority = 3;
                                                                      match_and = {
                                                                        {
                                                                          match_fsm = {
                                                                            path = ".*(\\.js|\\.css|\\.svg)";
                                                                            case_insensitive = true;
                                                                            surround = false;
                                                                          }; -- match_fsm
                                                                        };
                                                                        {
                                                                          match_fsm = {
                                                                            header = {
                                                                              name = "accept-encoding";
                                                                              value = "(.*,\\s*|)br(\\s*;\\s*q\\s*=\\s*(1|0\\.0*[1-9]).*|\\s*,.*|)";
                                                                            }; -- header
                                                                            case_insensitive = true;
                                                                            surround = false;
                                                                          }; -- match_fsm
                                                                        };
                                                                      }; -- match_and
                                                                      rewrite = {
                                                                        actions = {
                                                                          {
                                                                            global = false;
                                                                            literal = false;
                                                                            rewrite = "%1.br";
                                                                            case_insensitive = false;
                                                                            regexp = "([^\\?]+)(.*)";
                                                                          };
                                                                        }; -- actions
                                                                        response_headers = {
                                                                          create = {
                                                                            ["Content-Encoding"] = "br";
                                                                          }; -- create
                                                                          shared = {
                                                                            uuid = "1697148942086054822";
                                                                            shared = {
                                                                              uuid = "yastatic_net_s3_notes_common";
                                                                            }; -- shared
                                                                          }; -- shared
                                                                        }; -- response_headers
                                                                      }; -- rewrite
                                                                    }; -- br_section
                                                                    gzip_section = {
                                                                      priority = 2;
                                                                      match_and = {
                                                                        {
                                                                          match_fsm = {
                                                                            path = ".*(\\.js|\\.css|\\.svg)";
                                                                            case_insensitive = true;
                                                                            surround = false;
                                                                          }; -- match_fsm
                                                                        };
                                                                        {
                                                                          match_fsm = {
                                                                            header = {
                                                                              name = "accept-encoding";
                                                                              value = "(.*,\\s*|)gzip(\\s*;\\s*q\\s*=\\s*(1|0\\.0*[1-9]).*|\\s*,.*|)";
                                                                            }; -- header
                                                                            case_insensitive = true;
                                                                            surround = false;
                                                                          }; -- match_fsm
                                                                        };
                                                                      }; -- match_and
                                                                      rewrite = {
                                                                        actions = {
                                                                          {
                                                                            global = false;
                                                                            literal = false;
                                                                            rewrite = "%1.gz";
                                                                            case_insensitive = false;
                                                                            regexp = "([^\\?]+)(.*)";
                                                                          };
                                                                        }; -- actions
                                                                        response_headers = {
                                                                          create = {
                                                                            ["Content-Encoding"] = "gzip";
                                                                          }; -- create
                                                                          shared = {
                                                                            uuid = "1697148942086054822";
                                                                          }; -- shared
                                                                        }; -- response_headers
                                                                      }; -- rewrite
                                                                    }; -- gzip_section
                                                                    default = {
                                                                      priority = 1;
                                                                      shared = {
                                           