default_ciphers = "kEECDH+AESGCM+AES128:kEECDH+AES128:kEECDH+AESGCM+AES256:kRSA+AESGCM+AES128:kRSA+AES128:RC4-SHA:DES-CBC3-SHA:!aNULL:!eNULL:!MD5:!EXPORT:!LOW:!SEED:!CAMELLIA:!IDEA:!PSK:!SRP:!SSLv2"


default_ranges = "1ms,4ms,7ms,11ms,17ms,26ms,39ms,58ms,87ms,131ms,197ms,296ms,444ms,666ms,1000ms,1500ms,2250ms,3375ms,5062ms,7593ms,11390ms,17085ms,30000ms,60000ms,150000ms"


function _call_func_providers(overridable_func_names)
  for _, func_name in pairs(overridable_func_names) do
    local func_provider_path = _G[func_name .. "_provider"]
    if func_provider_path ~= nil then
      local env = {}
      setmetatable(env, {__index = _G})
      local provider, err = loadfile(func_provider_path, nil, env)
      if provider == nil then
        error(string.format('Failed to import provider "%s": %s', func_provider_path, err))
      end
      ok, rv = pcall(provider)
      if ok then
        if type(rv) ~= 'function' then
          error(string.format('Provider "%s" must return a function, not %s.', func_provider_path, type(rv)))
        end
        _G["do_" .. func_name] = rv
      else
        error(string.format('Provider "%s" failed: %s', func_provider_path, rv))
      end
    end
  end
end


function gen_proxy_backends(backends, proxy_options)
  local result = {}

  for index, backend in pairs(backends) do
    local proxy = {
      host = backend[1] or backend['host'];
      port = backend[2] or backend['port'];
      cached_ip = backend[4] or backend['cached_ip'];
    };

    if proxy_options ~= nil then
      for optname, optvalue in pairs(proxy_options) do
        proxy[optname] = optvalue
      end
    end

    result[index] = {
      weight = backend[3] or backend['weight'];
      proxy = proxy;
    };
  end

  if next(result) == nil then
    error("backends list is empty")
  end

  return result
end


function get_geo(name, default_geo)
  default_geo = default_geo or "random"
  return name .. (DC or default_geo);
end


function check_int(value, var_name)
    return tonumber(value) or error("Could not cast variable \"" .. var_name .. "\" to a number.'")
end

function get_int_var(name, default)
  value = _G[name]
  return value and check_int(value) or default
end


function get_log_path(name, port, default_log_dir)
  default_log_dir = default_log_dir or "/place/db/www/logs"
  rv = (log_dir or default_log_dir) .. "/current-" .. name .. "-balancer";
  if port ~= nil then
    rv = rv .. "-" .. port;
  end
  return rv
end


function get_port_var(name, offset, default)
  value = get_int_var(name, default)
  if value == nil then
    error("Neither port variable \"" .. name .. "\" nor default port is specified.")
  end
  if value < 0 or value > 65535 then
    error("Variable \"" .. name .. "\" is not a valid port: " .. value)
  end
  if offset ~= nil then
    value = value + offset
  end
  return value
end


function get_private_cert_path(name, default_private_cert_dir)
  default_private_cert_dir = default_private_cert_dir or "/dev/shm/balancer/priv"
  return (private_cert_dir or default_private_cert_dir) .. "/" .. name;
end


function get_public_cert_path(name, default_public_cert_dir)
  default_public_cert_dir = default_public_cert_dir or "/dev/shm/balancer"
  return (public_cert_dir or default_public_cert_dir) .. "/" .. name;
end


function get_random_timedelta(start, end_, unit)
  return math.random(start, end_) .. unit;
end


function get_str_var(name, default)
  return _G[name] or default
end


function do_get_workers()
  -- actual get_workers() implementation, can be overridden
  value = _G["workers"]
  if value == nil then
    error('Variable "workers" is not specified.')
  end
  int_value = tonumber(value)
  if int_value == nil then
    error('Could not cast variable "workers" to a number.')
  end
  return int_value
end


function get_workers()
  value = do_get_workers()
  if type(value) ~= 'number' then
    error(string.format('Provided get_workers() implementation must return a number, not %s.', type(value)))
  end
  if value < 0 or value % 1 ~= 0 then
    error(string.format('Provided get_workers() implementation must return a non-negative integer, not %s', value))
  end
  return value
end


_call_func_providers({
  "get_workers";
})


instance = {
  buffer = 65536;
  maxconn = 5000;
  tcp_fastopen = 0;
  tcp_listen_queue = 128;
  workers = get_workers();
  enable_reuse_port = true;
  private_address = "127.0.0.10";
  default_tcp_rst_on_error = true;
  events = {
    stats = "report";
  }; -- events
  dns_ttl = get_random_timedelta(600, 900, "s");
  reset_dns_cache_file = "./controls/reset_dns_cache_file";
  log = get_log_path("childs_log", get_port_var("port"), "/place/db/www/logs");
  admin_addrs = {
    {
      ip = "127.0.0.1";
      port = get_port_var("port");
    };
    {
      ip = "::1";
      port = get_port_var("port");
    };
  }; -- admin_addrs
  unistat = {
    addrs = {
      {
        ip = "*";
        port = get_port_var("port", 2);
        disabled = get_int_var("disable_external", 0);
      };
    }; -- addrs
  }; -- unistat
  addrs = {
    {
      ip = "*";
      port = 80;
      disabled = get_int_var("disable_external", 0);
    };
    {
      ip = "*";
      port = 443;
      disabled = get_int_var("disable_external", 0);
    };
  }; -- addrs
  sd = {
    client_name = "awacs-l7-balancer(geoexport.yandex.ru:yp.man.geoexport.yandex.ru)";
    host = "sd.yandex.net";
    port = 8080;
    connect_timeout = "50ms";
    request_timeout = "1s";
    cache_dir = "./sd_cache";
  }; -- sd
  ipdispatch = {
    admin = {
      ips = {
        "127.0.0.1";
        "::1";
      }; -- ips
      ports = {
        get_port_var("port");
      }; -- ports
      http = {
        maxlen = 65536;
        maxreq = 65536;
        keepalive = true;
        no_keepalive_file = "./controls/keepalive_disabled";
        events = {
          stats = "report";
        }; -- events
        admin = {
          disable_xml_stats = true;
        }; -- admin
      }; -- http
    }; -- admin
    http_section = {
      ips = {
        "*";
      }; -- ips
      ports = {
        80;
      }; -- ports
      errorlog = {
        log_level = "ERROR";
        log = get_log_path("error_log", 80, "/place/db/www/logs");
        http = {
          maxlen = 65536;
          maxreq = 65536;
          keepalive = true;
          no_keepalive_file = "./controls/keepalive_disabled";
          events = {
            stats = "report";
          }; -- events
          accesslog = {
            log = get_log_path("access_log", 80, "/place/db/www/logs");
            shared = {
              uuid = "4348157149700894529";
              report = {
                uuid = "service_total";
                ranges = get_str_var("default_ranges");
                just_storage = false;
                disable_robotness = true;
                disable_sslness = true;
                events = {
                  stats = "report";
                }; -- events
                regexp = {
                  ["awacs-balancer-health-check"] = {
                    priority = 3;
                    match_fsm = {
                      URI = "/awacs-balancer-health-check";
                      case_insensitive = true;
                      surround = false;
                    }; -- match_fsm
                    errordocument = {
                      status = 200;
                      force_conn_close = false;
                    }; -- errordocument
                  }; -- ["awacs-balancer-health-check"]
                  slbping = {
                    priority = 2;
                    match_fsm = {
                      url = "/\\?root=146";
                      case_insensitive = true;
                      surround = false;
                    }; -- match_fsm
                    stats_eater = {
                      balancer2 = {
                        unique_policy = {};
                        attempts = 1;
                        rr = {
                          weights_file = "./controls/slb_check.weights";
                          to_upstream = {
                            weight = 1.000;
                            shared = {
                              uuid = "backends";
                            }; -- shared
                          }; -- to_upstream
                          switch_off = {
                            weight = -1.000;
                            errordocument = {
                              status = 503;
                              force_conn_close = false;
                            }; -- errordocument
                          }; -- switch_off
                        }; -- rr
                      }; -- balancer2
                    }; -- stats_eater
                  }; -- slbping
                  default = {
                    priority = 1;
                    shared = {
                      uuid = "backends";
                      balancer2 = {
                        by_name_policy = {
                          name = get_geo("bygeo_", "random");
                          unique_policy = {};
                        }; -- by_name_policy
                        attempts = 1;
                        rr = {
                          bygeo_man = {
                            weight = 1.000;
                            balancer2 = {
                              unique_policy = {};
                              attempts = 2;
                              weighted2 = {
                                slow_reply_time = "1s";
                                correction_params = {
                                  max_weight = 5.000;
                                  min_weight = 0.050;
                                  history_time = "100s";
                                  feedback_time = "300s";
                                  plus_diff_per_sec = 0.050;
                                  minus_diff_per_sec = 0.100;
                                }; -- correction_params
                                unpack(gen_proxy_backends({
                                  { "geoexport-yp-10.man.yp-c.yandex.net"; 80; 1.000; "2a02:6b8:c0a:353f:0:4a66:b64a:0"; };
                                  { "geoexport-yp-11.man.yp-c.yandex.net"; 80; 1.000; "2a02:6b8:c0a:3ac2:0:4a66:2262:0"; };
                                  { "geoexport-yp-13.man.yp-c.yandex.net"; 80; 1.000; "2a02:6b8:c1a:31b7:0:4a66:4b0d:0"; };
                                  { "geoexport-yp-14.man.yp-c.yandex.net"; 80; 1.000; "2a02:6b8:c1a:2fc0:0:4a66:545f:0"; };
                                  { "geoexport-yp-16.man.yp-c.yandex.net"; 80; 1.000; "2a02:6b8:c0a:32c2:0:4a66:9de8:0"; };
                                  { "geoexport-yp-17.man.yp-c.yandex.net"; 80; 1.000; "2a02:6b8:c0a:39ad:0:4a66:3104:0"; };
                                  { "geoexport-yp-19.man.yp-c.yandex.net"; 80; 1.000; "2a02:6b8:c1a:2fb6:0:4a66:39fb:0"; };
                                  { "geoexport-yp-20.man.yp-c.yandex.net"; 80; 1.000; "2a02:6b8:c0a:3d3a:0:4a66:5242:0"; };
                                  { "geoexport-yp-5.man.yp-c.yandex.net"; 80; 1.000; "2a02:6b8:c1a:32a0:0:4a66:3df5:0"; };
                                  { "geoexport-yp-6.man.yp-c.yandex.net"; 80; 1.000; "2a02:6b8:c0a:40a0:0:4a66:fd48:0"; };
                                }, {
                                  resolve_timeout = "10ms";
                                  connect_timeout = "100ms";
                                  backend_timeout = "300s";
                                  fail_on_5xx = true;
                                  http_backend = true;
                                  buffering = false;
                                  keepalive_count = 0;
                                  need_resolve = true;
                                }))
                              }; -- weighted2
                              attempts_rate_limiter = {
                                limit = 0.300;
                                coeff = 0.990;
                                switch_default = true;
                              }; -- attempts_rate_limiter
                            }; -- balancer2
                          }; -- bygeo_man
                          bygeo_sas = {
                            weight = 1.000;
                            balancer2 = {
                              unique_policy = {};
                              attempts = 2;
                              weighted2 = {
                                slow_reply_time = "1s";
                                correction_params = {
                                  max_weight = 5.000;
                                  min_weight = 0.050;
                                  history_time = "100s";
                                  feedback_time = "300s";
                                  plus_diff_per_sec = 0.050;
                                  minus_diff_per_sec = 0.100;
                                }; -- correction_params
                                unpack(gen_proxy_backends({
                                  { "geoexport-yp-1.sas.yp-c.yandex.net"; 80; 1.000; "2a02:6b8:c10:33a4:0:4a66:3237:0"; };
                                  { "geoexport-yp-10.sas.yp-c.yandex.net"; 80; 1.000; "2a02:6b8:c1b:330e:0:4a66:ed76:0"; };
                                  { "geoexport-yp-11.sas.yp-c.yandex.net"; 80; 1.000; "2a02:6b8:c14:600f:0:4a66:35f9:0"; };
                                  { "geoexport-yp-12.sas.yp-c.yandex.net"; 80; 1.000; "2a02:6b8:c1b:36a2:0:4a66:8028:0"; };
                                  { "geoexport-yp-13.sas.yp-c.yandex.net"; 80; 1.000; "2a02:6b8:c1c:95:0:4a66:27a8:0"; };
                                  { "geoexport-yp-3.sas.yp-c.yandex.net"; 80; 1.000; "2a02:6b8:c08:a194:0:4a66:31b5:0"; };
                                  { "geoexport-yp-4.sas.yp-c.yandex.net"; 80; 1.000; "2a02:6b8:c10:2f28:0:4a66:cfd3:0"; };
                                  { "geoexport-yp-7.sas.yp-c.yandex.net"; 80; 1.000; "2a02:6b8:c1b:269c:0:4a66:199d:0"; };
                                  { "geoexport-yp-8.sas.yp-c.yandex.net"; 80; 1.000; "2a02:6b8:c1b:268b:0:4a66:fa52:0"; };
                                  { "geoexport-yp-9.sas.yp-c.yandex.net"; 80; 1.000; "2a02:6b8:c10:3382:0:4a66:c740:0"; };
                                }, {
                                  resolve_timeout = "10ms";
                                  connect_timeout = "100ms";
                                  backend_timeout = "300s";
                                  fail_on_5xx = true;
                                  http_backend = true;
                                  buffering = false;
                                  keepalive_count = 0;
                                  need_resolve = true;
                                }))
                              }; -- weighted2
                              attempts_rate_limiter = {
                                limit = 0.300;
                                coeff = 0.990;
                                switch_default = true;
                              }; -- attempts_rate_limiter
                            }; -- balancer2
                          }; -- bygeo_sas
                          bygeo_vla = {
                            weight = 1.000;
                            balancer2 = {
                              unique_policy = {};
                              attempts = 2;
                              weighted2 = {
                                slow_reply_time = "1s";
                                correction_params = {
                                  max_weight = 5.000;
                                  min_weight = 0.050;
                                  history_time = "100s";
                                  feedback_time = "300s";
                                  plus_diff_per_sec = 0.050;
                                  minus_diff_per_sec = 0.100;
                                }; -- correction_params
                                unpack(gen_proxy_backends({
                                  { "geoexport-yp-1.vla.yp-c.yandex.net"; 80; 1.000; "2a02:6b8:c18:289f:0:4a66:1b62:0"; };
                                  { "geoexport-yp-10.vla.yp-c.yandex.net"; 80; 1.000; "2a02:6b8:c18:2f9f:0:4a66:21d:0"; };
                                  { "geoexport-yp-11.vla.yp-c.yandex.net"; 80; 1.000; "2a02:6b8:c18:2c83:0:4a66:9a92:0"; };
                                  { "geoexport-yp-13.vla.yp-c.yandex.net"; 80; 1.000; "2a02:6b8:c18:3001:0:4a66:8990:0"; };
                                  { "geoexport-yp-2.vla.yp-c.yandex.net"; 80; 1.000; "2a02:6b8:c18:320c:0:4a66:77b8:0"; };
                                  { "geoexport-yp-3.vla.yp-c.yandex.net"; 80; 1.000; "2a02:6b8:c18:3205:0:4a66:2405:0"; };
                                  { "geoexport-yp-4.vla.yp-c.yandex.net"; 80; 1.000; "2a02:6b8:c18:2b1b:0:4a66:5722:0"; };
                                  { "geoexport-yp-5.vla.yp-c.yandex.net"; 80; 1.000; "2a02:6b8:c18:2a0c:0:4a66:66e4:0"; };
                                  { "geoexport-yp-6.vla.yp-c.yandex.net"; 80; 1.000; "2a02:6b8:c18:2a8a:0:4a66:ed9d:0"; };
                                  { "geoexport-yp-7.vla.yp-c.yandex.net"; 80; 1.000; "2a02:6b8:c18:2b0b:0:4a66:ed9c:0"; };
                                }, {
                                  resolve_timeout = "10ms";
                                  connect_timeout = "100ms";
                                  backend_timeout = "300s";
                                  fail_on_5xx = true;
                                  http_backend = true;
                                  buffering = false;
                                  keepalive_count = 0;
                                  need_resolve = true;
                                }))
                              }; -- weighted2
                              attempts_rate_limiter = {
                                limit = 0.300;
                                coeff = 0.990;
                                switch_default = true;
                              }; -- attempts_rate_limiter
                            }; -- balancer2
                          }; -- bygeo_vla
                        }; -- rr
                      }; -- balancer2
                    }; -- shared
                  }; -- default
                }; -- regexp
              }; -- report
            }; -- shared
          }; -- accesslog
        }; -- http
      }; -- errorlog
    }; -- http_section
    https_section = {
      ips = {
        "*";
      }; -- ips
      ports = {
        443;
      }; -- ports
      errorlog = {
        log_level = "ERROR";
        log = get_log_path("error_log", 443, "/place/db/www/logs");
        ssl_sni = {
          force_ssl = true;
          events = {
            stats = "report";
            reload_ocsp_response = "reload_ocsp";
            reload_ticket_keys = "reload_ticket";
          }; -- events
          contexts = {
            default = {
              priority = 1;
              timeout = "100800s";
              ciphers = get_str_var("default_ciphers");
              log = get_log_path("ssl_sni", 443, "/place/db/www/logs");
              priv = get_private_cert_path("geoexport.yandex.ru.pem", "/dev/shm/balancer/priv");
              cert = get_public_cert_path("allCAs-geoexport.yandex.ru.pem", "/dev/shm/balancer");
              ticket_keys_list = {
                {
                  priority = 3;
                  keyfile = get_private_cert_path("1st.geoexport.yandex.ru.key", "/dev/shm/balancer/priv");
                };
                {
                  priority = 2;
                  keyfile = get_private_cert_path("2nd.geoexport.yandex.ru.key", "/dev/shm/balancer/priv");
                };
                {
                  priority = 1;
                  keyfile = get_private_cert_path("3rd.geoexport.yandex.ru.key", "/dev/shm/balancer/priv");
                };
              }; -- ticket_keys_list
            }; -- default
          }; -- contexts
          http = {
            maxlen = 65536;
            maxreq = 65536;
            keepalive = true;
            no_keepalive_file = "./controls/keepalive_disabled";
            events = {
              stats = "report";
            }; -- events
            accesslog = {
              log = get_log_path("access_log", 443, "/place/db/www/logs");
              shared = {
                uuid = "4348157149700894529";
              }; -- shared
            }; -- accesslog
          }; -- http
        }; -- ssl_sni
      }; -- errorlog
    }; -- https_section
  }; -- ipdispatch
}