from markdown import Extension
from markdown.inlinepatterns import LinkInlineProcessor, LINK_RE


class PatternProcessor(LinkInlineProcessor):
    def __init__(self, base_wiki_url, *args, **kwargs):
        super(PatternProcessor, self).__init__(*args, **kwargs)
        self.base_wiki_url = base_wiki_url

    def handleMatch(self, m):
        el = super(PatternProcessor, self).handleMatch(m)
        if el is not None:
            href = el.get('href')
            if href.startswith('#'):
                href = self.base_wiki_url + href
            el.set('href', href)
        return el


class AbsolutifyHrefs(Extension):
    """Modifies HTML output to open links in a new tab."""

    def __init__(self, base_wiki_url):
        self.base_wiki_url = base_wiki_url
        super(AbsolutifyHrefs, self).__init__()

    def extendMarkdown(self, md, md_globals):
        md.inlinePatterns.register(PatternProcessor(LINK_RE, md), 'link', 160)
