package rtslots

import (
	"encoding/json"
	"io"
)

// TODO: maybe use more reliable storage for state
// etcd cluster or managed database

type State struct {
	Slots []*Slot `json:"slots"`
}

type Slot struct {
	Container     string `json:"container"`
	Address       string `json:"address"`
	PoolName      string `json:"pool_name"`
	LBName        string `json:"lb_name"`
	ResourceGroup string `json:"resource_group"`
}

func (s *Slot) Copy() *Slot {
	return &Slot{
		Container:     s.Container,
		Address:       s.Address,
		PoolName:      s.PoolName,
		LBName:        s.LBName,
		ResourceGroup: s.ResourceGroup,
	}
}

func (s *State) PersistToWriter(w io.Writer) error {
	buf, err := json.Marshal(s)
	if err != nil {
		return err
	}
	if _, err := w.Write(buf); err != nil {
		return err
	}
	return nil
}

func StateFromReader(r io.Reader) (*State, error) {
	buf, err := io.ReadAll(r)
	if err != nil {
		return nil, err
	}
	rv := &State{}
	if err := json.Unmarshal(buf, rv); err != nil {
		return nil, err
	}
	return rv, nil
}

func EmptyState() *State {
	return &State{}
}
