package nshelper

import (
	"runtime"
	"syscall"
)

const (
	SetNSSyscallNum uintptr = 308
	NetNS           uintptr = 0x40000000
)

func RunInNetNSAtPath(path string, f func() error) error {
	fd, err := syscall.Open(path, syscall.O_RDONLY, 0)
	if err != nil {
		return err
	}
	defer syscall.Close(fd)
	return RunInNetNSFD(uintptr(fd), f)
}

func nsEnter(fd uintptr) error {
	rv, _, err := syscall.Syscall(SetNSSyscallNum, fd, NetNS, 0)
	if rv != 0 {
		return err
	}
	return nil
}

func RunInNetNSFD(fd uintptr, f func() error) error {
	currNS, err := syscall.Open("/proc/self/ns/net", syscall.O_RDONLY, 0)
	if err != nil {
		return err
	}
	defer syscall.Close(currNS)
	runtime.LockOSThread()
	defer runtime.UnlockOSThread()
	if err := nsEnter(fd); err != nil {
		return err
	}
	defer nsEnter(uintptr(currNS))
	return f()
}
