package portohelper

import (
	"os"
	"strings"
	"time"

	porto "a.yandex-team.ru/infra/porto/api_go"
)

const (
	fdKey        = "PORTO_NETNS_FD"
	ifaceKey     = "PORTO_L3_IFACE"
	containerKey = "PORTO_CONTAINER"
	labelsKey    = "PORTO_LABELS"
)

type PortoContext struct {
	NetNsFDPath   string
	L3Interface   string
	Labels        map[string]string
	ContainerName string
}

func ContextFromEnv() *PortoContext {
	labels := map[string]string{}
	for _, l := range strings.Split(os.Getenv(labelsKey), ";") {
		parts := strings.SplitN(strings.TrimSpace(l), ":", 1)
		if len(parts) == 2 {
			labels[parts[0]] = parts[1]
		}
	}
	return &PortoContext{
		NetNsFDPath:   os.Getenv(fdKey),
		L3Interface:   os.Getenv(ifaceKey),
		ContainerName: os.Getenv(containerKey),
		Labels:        labels,
	}
}

func GetContainerNamesMap() (map[string]struct{}, error) {
	c, err := porto.Dial()
	c.SetTimeout(time.Second)
	if err != nil {
		return nil, err
	}
	l, err := c.ListContainers("ISS-AGENT--*")
	if err != nil {
		return nil, err
	}
	rv := map[string]struct{}{}
	for _, c := range l {
		rv[c] = struct{}{}
	}
	return rv, nil
}
