resource "azurerm_resource_group" "exp_rg" {
  name     = "rtc-cloud-az-us-east1-exp"
  location = "eastus"
}

module "azuseast1_0001" {
  source        = "./modules/rtc"
  walle_project = "yp-azuseast1-man"
  hostname      = "azuseast1-0001"
  host_num      = "1"
  ipv6_addr     = "2a02:6b8:c06:8000:0:604:1:1"
  bb_ipv6_addr  = "2a02:6b8:c2c::badc:ab1e"
  vm_subnet     = "2a02:6b8:c2c::/57"
  mtn_prefix    = "2a02:6b8:c2c::/64"
  lb_subnet     = "172.31.0.16/28"
  lb_gateway    = "172.31.0.1"
  lb_pool = [
    "172.31.0.16", "172.31.0.17", "172.31.0.18", "172.31.0.19", "172.31.0.20", "172.31.0.21", "172.31.0.22", "172.31.0.23", "172.31.0.24", "172.31.0.25", "172.31.0.26", "172.31.0.27", "172.31.0.28", "172.31.0.29", "172.31.0.30", "172.31.0.31"
  ]
  vm_size             = "Standard_D4s_v3"
  place_size          = 256
  vm_image_id         = data.azurerm_image.rtc_focal.id
  resource_group_name = azurerm_resource_group.exp_rg.name
  shared_rg_name      = data.azurerm_resource_group.shared_rg.name
  location            = azurerm_resource_group.exp_rg.location
  rtc_net_id          = data.azurerm_subnet.rtc.id
  lb_net_id           = data.azurerm_subnet.lb_net.id
  route_table_name    = data.azurerm_route_table.rtc_mtn.name
  lb_nsg_id           = data.azurerm_network_security_group.lb_nsg.id
  diag_endpoint       = data.azurerm_storage_account.diag_storage.primary_blob_endpoint
}

resource "azuread_group_member" "azuseast1_0001" {
  group_object_id  = data.azuread_group.hosts_grp.id
  member_object_id = module.azuseast1_0001.vm_principal_id
}

# module "azuseast1_0002" {
#   source = "./modules/rtc"

#   hostname     = "azuseast1-0002"
#   host_num     = "1"
#   ipv6_addr    = "2a02:6b8:c06:8000:0:604:1:2"
#   bb_ipv6_addr = "2a02:6b8:c2c:80::badc:ab1e"
#   vm_subnet    = "2a02:6b8:c2c:80::/57"
#   mtn_prefix   = "2a02:6b8:c2c:80::/64"
#   lb_subnet    = "172.31.0.32/28"
#   lb_gateway   = "172.31.0.1"
#   lb_pool = [
#     "172.31.0.32", "172.31.0.33", "172.31.0.34", "172.31.0.35", "172.31.0.36", "172.31.0.37", "172.31.0.38", "172.31.0.39", "172.31.0.40", "172.31.0.41", "172.31.0.42", "172.31.0.43", "172.31.0.44", "172.31.0.45", "172.31.0.46", "172.31.0.47"
#   ]
#   vm_size             = "Standard_D8s_v3"
#   place_size          = 256
#   vm_image_id         = data.azurerm_image.rtc_focal.id
#   resource_group_name = azurerm_resource_group.exp_rg.name
#   shared_rg_name      = azurerm_resource_group.shared_rg.name
#   location            = azurerm_resource_group.exp_rg.location
#   rtc_net_id          = azurerm_subnet.rtc.id
#   lb_net_id           = azurerm_subnet.lb_net.id
#   route_table_name    = azurerm_route_table.rtc_mtn.name
#   lb_nsg_id           = azurerm_network_security_group.lb_nsg.id
#   diag_endpoint       = azurerm_storage_account.diag_storage.primary_blob_endpoint
# }

# resource "azuread_group_member" "azuseast1_0002" {
#   group_object_id  = azuread_group.hosts_grp.id
#   member_object_id = module.azuseast1_0002.vm_principal_id
# }

# module "azuseast1_0003" {
#   source = "./modules/rtc"

#   hostname     = "azuseast1-0003"
#   host_num     = "1"
#   ipv6_addr    = "2a02:6b8:c06:8000:0:604:1:3"
#   bb_ipv6_addr = "2a02:6b8:c2c:100::badc:ab1e"
#   vm_subnet    = "2a02:6b8:c2c:100::/57"
#   mtn_prefix   = "2a02:6b8:c2c:100::/64"
#   lb_subnet    = "172.31.0.48/28"
#   lb_gateway   = "172.31.0.1"
#   lb_pool = [
#     "172.31.0.48", "172.31.0.49", "172.31.0.50", "172.31.0.51", "172.31.0.52", "172.31.0.53", "172.31.0.54", "172.31.0.55", "172.31.0.56", "172.31.0.57", "172.31.0.58", "172.31.0.59", "172.31.0.60", "172.31.0.61", "172.31.0.62", "172.31.0.63"
#   ]
#   vm_size             = "Standard_D8s_v3"
#   place_size          = 256
#   vm_image_id         = data.azurerm_image.rtc_focal.id
#   resource_group_name = azurerm_resource_group.exp_rg.name
#   shared_rg_name      = azurerm_resource_group.shared_rg.name
#   location            = azurerm_resource_group.exp_rg.location
#   rtc_net_id          = azurerm_subnet.rtc.id
#   lb_net_id           = azurerm_subnet.lb_net.id
#   route_table_name    = azurerm_route_table.rtc_mtn.name
#   lb_nsg_id           = azurerm_network_security_group.lb_nsg.id
#   diag_endpoint       = azurerm_storage_account.diag_storage.primary_blob_endpoint
# }

# resource "azuread_group_member" "azuseast1_0006" {
#   group_object_id  = azuread_group.hosts_grp.id
#   member_object_id = module.azuseast1_0006.vm_principal_id
# }
