resource "azurerm_resource_group" "geo_rg" {
  name     = "rtc-cloud-az-us-east1-geo"
  location = "eastus"
}

module "azuseast1_0014" {
  source        = "./modules/rtc_snat"
  walle_project = "yp-azuseast1-vla"
  hostname      = "azuseast1-0014"
  host_num      = "14"
  ipv6_addr     = "2a02:6b8:c06:8000:0:604:1:e"
  bb_ipv6_addr  = "2a02:6b8:c2c:680::badc:ab1e"
  vm_subnet     = "2a02:6b8:c2c:680::/57"
  mtn_prefix    = "2a02:6b8:c2c:680::/64"
  snat_net_id   = module.googlesuggest_snat.snat_net_id
  snat_subnet   = "172.16.0.0/16"
  snat_gateway  = "10.1.5.1"
  snat_segment  = "googlesuggest"
  zone          = "1"
  vm_size             = "Standard_F16s_v2"
  vm_image_id         = data.azurerm_image.rtc_focal.id
  resource_group_name = azurerm_resource_group.geo_rg.name
  shared_rg_name      = data.azurerm_resource_group.shared_rg.name
  location            = azurerm_resource_group.geo_rg.location
  rtc_net_id          = data.azurerm_subnet.rtc.id
  route_table_name    = data.azurerm_route_table.rtc_mtn.name
  diag_endpoint       = data.azurerm_storage_account.diag_storage.primary_blob_endpoint
  admin_ssh_key       = "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQCw34MCSuEMEnEFPsWsZEnw/YdmyxWD9Sszh7mV2A3WI3gt37ZyaSCeGqgY3xBOSjetKaJiqwmfmF5mP2oGJF+Nz8HUwzdGOqGvhuRJajAfk/HJQ+JUY8x4s9MSi52rd/3J8Oj+eWlCoko21rN/U9YYs09Rf83kOyYr6GwyVXAbSe84Sc6/MVO2dBasD8J7BtN3Y4Jhye+M5Xtm+c/258L2D1vW+cSLbq8q6f0RThVMxJmLCHp9QYT33hN5LhZ22hICAEecKUBwks1vQU6lTIVpPoy7tlOq+BeF3JI30qeFxjEmAzC1QdyCtV/REAKhy9jUliuBt8iVRZYGctyf401D"
  admin_ssh_login     = "zeebdo"
}

resource "azuread_group_member" "azuseast1_0014" {
  group_object_id  = data.azuread_group.hosts_grp.id
  member_object_id = module.azuseast1_0014.vm_principal_id
}


module "azuseast1_0015" {
  source        = "./modules/rtc_snat"
  walle_project = "yp-azuseast1-vla"
  hostname      = "azuseast1-0015"
  host_num      = "15"
  ipv6_addr     = "2a02:6b8:c06:8000:0:604:1:f"
  bb_ipv6_addr  = "2a02:6b8:c2c:700::badc:ab1e"
  vm_subnet     = "2a02:6b8:c2c:700::/57"
  mtn_prefix    = "2a02:6b8:c2c:700::/64"
  snat_net_id   = module.googlesuggest_snat.snat_net_id
  snat_subnet   = "172.16.0.0/16"
  snat_gateway  = "10.1.5.1"
  snat_segment  = "googlesuggest"
  zone          = "2"
  vm_size             = "Standard_F16s_v2"
  vm_image_id         = data.azurerm_image.rtc_focal.id
  resource_group_name = azurerm_resource_group.geo_rg.name
  shared_rg_name      = data.azurerm_resource_group.shared_rg.name
  location            = azurerm_resource_group.geo_rg.location
  rtc_net_id          = data.azurerm_subnet.rtc.id
  route_table_name    = data.azurerm_route_table.rtc_mtn.name
  diag_endpoint       = data.azurerm_storage_account.diag_storage.primary_blob_endpoint
  admin_ssh_key       = "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQCw34MCSuEMEnEFPsWsZEnw/YdmyxWD9Sszh7mV2A3WI3gt37ZyaSCeGqgY3xBOSjetKaJiqwmfmF5mP2oGJF+Nz8HUwzdGOqGvhuRJajAfk/HJQ+JUY8x4s9MSi52rd/3J8Oj+eWlCoko21rN/U9YYs09Rf83kOyYr6GwyVXAbSe84Sc6/MVO2dBasD8J7BtN3Y4Jhye+M5Xtm+c/258L2D1vW+cSLbq8q6f0RThVMxJmLCHp9QYT33hN5LhZ22hICAEecKUBwks1vQU6lTIVpPoy7tlOq+BeF3JI30qeFxjEmAzC1QdyCtV/REAKhy9jUliuBt8iVRZYGctyf401D"
  admin_ssh_login     = "zeebdo"
}

resource "azuread_group_member" "azuseast1_0015" {
  group_object_id  = data.azuread_group.hosts_grp.id
  member_object_id = module.azuseast1_0015.vm_principal_id
}
