data "azurerm_public_ip_prefix" "public_prefix" {
  resource_group_name = azurerm_resource_group.geo_rg.name
  name = "l3-lb-prefix"
}

module "gsuggest_lb" {
   source        = "./modules/l3lb"
   rg_name = azurerm_resource_group.geo_rg.name
   location = azurerm_resource_group.geo_rg.location
   lb_prefix_id = data.azurerm_public_ip_prefix.public_prefix.id
   balancer_name = "gsuggest"
   vnet_id = data.azurerm_virtual_network.shared_vnet.id
   dummy_address = "172.31.255.247"
   hosts_grp_id = data.azuread_group.hosts_grp.id
}
