resource "azurerm_public_ip" "public_ip" {
  name = "${var.balancer_name}-public"
  location = var.location
  resource_group_name = var.rg_name
  public_ip_prefix_id = var.lb_prefix_id
  allocation_method = "Static"
  sku = "Standard"
}

resource "azurerm_lb_probe" "http_ping" {
  port = 80
  name = "${var.balancer_name}-http-ping"
  request_path = "/ping"
  protocol = "Http"
  loadbalancer_id = azurerm_lb.lb.id
  resource_group_name = var.rg_name
}

resource "azurerm_lb_rule" "http" {
  name = "${var.balancer_name}-http"
  backend_address_pool_ids = [ azurerm_lb_backend_address_pool.backends.id ]
  backend_port = 80
  frontend_port = 80
  frontend_ip_configuration_name = azurerm_lb.lb.frontend_ip_configuration[0].name
  protocol = "tcp"
  resource_group_name = var.rg_name
  loadbalancer_id = azurerm_lb.lb.id
  probe_id = azurerm_lb_probe.http_ping.id
}

resource "azurerm_lb_rule" "https" {
  name = "${var.balancer_name}-https"
  backend_address_pool_ids = [ azurerm_lb_backend_address_pool.backends.id ]
  backend_port = 443
  frontend_port = 443
  frontend_ip_configuration_name = azurerm_lb.lb.frontend_ip_configuration[0].name
  protocol = "tcp"
  resource_group_name = var.rg_name
  loadbalancer_id = azurerm_lb.lb.id
  probe_id = azurerm_lb_probe.http_ping.id
}

resource "azurerm_lb" "lb" {
  resource_group_name = var.rg_name
  location = var.location
  name = var.balancer_name
  frontend_ip_configuration {
    public_ip_address_id = azurerm_public_ip.public_ip.id
    name = "${var.balancer_name}-front"
  }
  sku = "Standard"
}

resource "azurerm_lb_backend_address_pool_address" "dummy_address" {
  name                    = "dummy_address"
  backend_address_pool_id = azurerm_lb_backend_address_pool.backends.id
  virtual_network_id      = var.vnet_id
  ip_address              = var.dummy_address
}

resource "azurerm_lb_backend_address_pool" "backends" {
  loadbalancer_id = azurerm_lb.lb.id
  name = "backend"
}

resource "azurerm_role_assignment" "lb_hosts" {
  scope = azurerm_lb.lb.id
  role_definition_name = "Contributor"
  principal_id = var.hosts_grp_id
}
