
resource "azurerm_subnet" "snat" {
    resource_group_name = var.shared_rg_name
    virtual_network_name = var.vnet_name
    name = var.subnet_name
    address_prefixes = [var.subnet_addr]
}

resource "azurerm_public_ip" "out_ip" {
  name                = "${var.gw_name}-out-ip"
  location            = var.location
  resource_group_name = var.rg_name
  allocation_method   = "Static"
  sku                 = "Standard"
  availability_zone = "Zone-Redundant"
}

resource "azurerm_nat_gateway" "gw" {
  name                    = var.gw_name
  location                = var.location
  resource_group_name     = var.rg_name
  sku_name                = "Standard"
  idle_timeout_in_minutes = 4
#  zones                   = var.zones
}

resource "azurerm_nat_gateway_public_ip_association" "out_ip" {
  nat_gateway_id = azurerm_nat_gateway.gw.id
  public_ip_address_id = azurerm_public_ip.out_ip.id
}

resource "azurerm_subnet_nat_gateway_association" "snat" {
  nat_gateway_id = azurerm_nat_gateway.gw.id
  subnet_id = azurerm_subnet.snat.id
}