resource "azurerm_resource_group" "mobileproducts" {
  name     = "rtc-cloud-az-us-east1-mobileproducts"
  location = "eastus"
}

module "azuseast1_0052" {
  source        = "./modules/rtc"
  walle_project = "yp-azuseast1-vla"
  hostname      = "azuseast1-0052"
  host_num      = "52"
  ipv6_addr     = "2a02:6b8:c06:8000:0:604:1:34"
  bb_ipv6_addr  = "2a02:6b8:c2c:1a00::badc:ab1e"
  vm_subnet     = "2a02:6b8:c2c:1a00::/57"
  mtn_prefix    = "2a02:6b8:c2c:1a00::/64"
  lb_subnet     = "172.31.3.64/28"
  lb_gateway    = "172.31.0.1"
  lb_pool = [
        "172.31.3.64", "172.31.3.65", "172.31.3.66", "172.31.3.67", "172.31.3.68", "172.31.3.69", "172.31.3.70", "172.31.3.71", "172.31.3.72", "172.31.3.73", "172.31.3.74", "172.31.3.75", "172.31.3.76", "172.31.3.77", "172.31.3.78", "172.31.3.79"
  ]
  zone = "1"
  vm_size             = "Standard_E16s_v5"
  vm_image_id         = data.azurerm_image.rtc_focal.id
  resource_group_name = azurerm_resource_group.mobileproducts.name
  shared_rg_name      = data.azurerm_resource_group.shared_rg.name
  location            = azurerm_resource_group.mobileproducts.location
  rtc_net_id          = data.azurerm_subnet.rtc.id
  lb_net_id           = data.azurerm_subnet.lb_net.id
  route_table_name    = data.azurerm_route_table.rtc_mtn.name
  lb_nsg_id           = data.azurerm_network_security_group.lb_nsg.id
  diag_endpoint       = data.azurerm_storage_account.diag_storage.primary_blob_endpoint
  admin_ssh_key       = "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQCw34MCSuEMEnEFPsWsZEnw/YdmyxWD9Sszh7mV2A3WI3gt37ZyaSCeGqgY3xBOSjetKaJiqwmfmF5mP2oGJF+Nz8HUwzdGOqGvhuRJajAfk/HJQ+JUY8x4s9MSi52rd/3J8Oj+eWlCoko21rN/U9YYs09Rf83kOyYr6GwyVXAbSe84Sc6/MVO2dBasD8J7BtN3Y4Jhye+M5Xtm+c/258L2D1vW+cSLbq8q6f0RThVMxJmLCHp9QYT33hN5LhZ22hICAEecKUBwks1vQU6lTIVpPoy7tlOq+BeF3JI30qeFxjEmAzC1QdyCtV/REAKhy9jUliuBt8iVRZYGctyf401D"
  admin_ssh_login     = "zeebdo"
}

resource "azuread_group_member" "azuseast1_0052" {
  group_object_id  = data.azuread_group.hosts_grp.id
  member_object_id = module.azuseast1_0052.vm_principal_id
}

module "azuseast1_0053" {
  source        = "./modules/rtc"
  walle_project = "yp-azuseast1-vla"
  hostname      = "azuseast1-0053"
  host_num      = "53"
  ipv6_addr     = "2a02:6b8:c06:8000:0:604:1:35"
  bb_ipv6_addr  = "2a02:6b8:c2c:1a80::badc:ab1e"
  vm_subnet     = "2a02:6b8:c2c:1a80::/57"
  mtn_prefix    = "2a02:6b8:c2c:1a80::/64"
  lb_subnet     = "172.31.3.80/28"
  lb_gateway    = "172.31.0.1"
  lb_pool = [
        "172.31.3.80", "172.31.3.81", "172.31.3.82", "172.31.3.83", "172.31.3.84", "172.31.3.85", "172.31.3.86", "172.31.3.87", "172.31.3.88", "172.31.3.89", "172.31.3.90", "172.31.3.91", "172.31.3.92", "172.31.3.93", "172.31.3.94", "172.31.3.95"
  ]
  zone = "2"
  vm_size             = "Standard_E16s_v5"
  vm_image_id         = data.azurerm_image.rtc_focal.id
  resource_group_name = azurerm_resource_group.mobileproducts.name
  shared_rg_name      = data.azurerm_resource_group.shared_rg.name
  location            = azurerm_resource_group.mobileproducts.location
  rtc_net_id          = data.azurerm_subnet.rtc.id
  lb_net_id           = data.azurerm_subnet.lb_net.id
  route_table_name    = data.azurerm_route_table.rtc_mtn.name
  lb_nsg_id           = data.azurerm_network_security_group.lb_nsg.id
  diag_endpoint       = data.azurerm_storage_account.diag_storage.primary_blob_endpoint
  admin_ssh_key       = "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQCw34MCSuEMEnEFPsWsZEnw/YdmyxWD9Sszh7mV2A3WI3gt37ZyaSCeGqgY3xBOSjetKaJiqwmfmF5mP2oGJF+Nz8HUwzdGOqGvhuRJajAfk/HJQ+JUY8x4s9MSi52rd/3J8Oj+eWlCoko21rN/U9YYs09Rf83kOyYr6GwyVXAbSe84Sc6/MVO2dBasD8J7BtN3Y4Jhye+M5Xtm+c/258L2D1vW+cSLbq8q6f0RThVMxJmLCHp9QYT33hN5LhZ22hICAEecKUBwks1vQU6lTIVpPoy7tlOq+BeF3JI30qeFxjEmAzC1QdyCtV/REAKhy9jUliuBt8iVRZYGctyf401D"
  admin_ssh_login     = "zeebdo"
}

resource "azuread_group_member" "azuseast1_0053" {
  group_object_id  = data.azuread_group.hosts_grp.id
  member_object_id = module.azuseast1_0053.vm_principal_id
}

module "azuseast1_0054" {
  source        = "./modules/rtc"
  walle_project = "yp-azuseast1-vla"
  hostname      = "azuseast1-0054"
  host_num      = "54"
  ipv6_addr     = "2a02:6b8:c06:8000:0:604:1:36"
  bb_ipv6_addr  = "2a02:6b8:c2c:1b00::badc:ab1e"
  vm_subnet     = "2a02:6b8:c2c:1b00::/57"
  mtn_prefix    = "2a02:6b8:c2c:1b00::/64"
  lb_subnet     = "172.31.3.96/28"
  lb_gateway    = "172.31.0.1"
  lb_pool = [
        "172.31.3.96", "172.31.3.97", "172.31.3.98", "172.31.3.99", "172.31.3.100", "172.31.3.101", "172.31.3.102", "172.31.3.103", "172.31.3.104", "172.31.3.105", "172.31.3.106", "172.31.3.107", "172.31.3.108", "172.31.3.109", "172.31.3.110", "172.31.3.111"
  ]
  zone = "3"
  vm_size             = "Standard_E16s_v5"
  vm_image_id         = data.azurerm_image.rtc_focal.id
  resource_group_name = azurerm_resource_group.mobileproducts.name
  shared_rg_name      = data.azurerm_resource_group.shared_rg.name
  location            = azurerm_resource_group.mobileproducts.location
  rtc_net_id          = data.azurerm_subnet.rtc.id
  lb_net_id           = data.azurerm_subnet.lb_net.id
  route_table_name    = data.azurerm_route_table.rtc_mtn.name
  lb_nsg_id           = data.azurerm_network_security_group.lb_nsg.id
  diag_endpoint       = data.azurerm_storage_account.diag_storage.primary_blob_endpoint
  admin_ssh_key       = "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQCw34MCSuEMEnEFPsWsZEnw/YdmyxWD9Sszh7mV2A3WI3gt37ZyaSCeGqgY3xBOSjetKaJiqwmfmF5mP2oGJF+Nz8HUwzdGOqGvhuRJajAfk/HJQ+JUY8x4s9MSi52rd/3J8Oj+eWlCoko21rN/U9YYs09Rf83kOyYr6GwyVXAbSe84Sc6/MVO2dBasD8J7BtN3Y4Jhye+M5Xtm+c/258L2D1vW+cSLbq8q6f0RThVMxJmLCHp9QYT33hN5LhZ22hICAEecKUBwks1vQU6lTIVpPoy7tlOq+BeF3JI30qeFxjEmAzC1QdyCtV/REAKhy9jUliuBt8iVRZYGctyf401D"
  admin_ssh_login     = "zeebdo"
}

resource "azuread_group_member" "azuseast1_0054" {
  group_object_id  = data.azuread_group.hosts_grp.id
  member_object_id = module.azuseast1_0054.vm_principal_id
}
