resource "azurerm_public_ip_prefix" "mobileproducts_public_prefix" {
  resource_group_name = azurerm_resource_group.mobileproducts.name
  location = azurerm_resource_group.mobileproducts.location
  name = "mobileproducts-l3-lb-prefix"
  prefix_length = 29
}

module "mobileproducts_proxy_lb" {
   source        = "./modules/l3lb"
   rg_name = azurerm_resource_group.mobileproducts.name
   location = azurerm_resource_group.mobileproducts.location
   lb_prefix_id = azurerm_public_ip_prefix.mobileproducts_public_prefix.id
   balancer_name = "postback-proxy"
   vnet_id = data.azurerm_virtual_network.shared_vnet.id
   dummy_address = "172.31.255.251"
   hosts_grp_id = data.azuread_group.hosts_grp.id
}
