
resource "azurerm_resource_group" "shared_rg" {
  name     = "rtc-cloud-az-us-east1-shared"
  location = "eastus"
}

resource "azurerm_network_security_group" "lb_nsg" {
  name                = "lb_nsg"
  location            = azurerm_resource_group.shared_rg.location
  resource_group_name = azurerm_resource_group.shared_rg.name

  security_rule {
    name                       = "http"
    priority                   = 100
    direction                  = "Inbound"
    access                     = "Allow"
    protocol                   = "Tcp"
    source_port_range          = "*"
    destination_port_range     = "80"
    source_address_prefix      = "*"
    destination_address_prefix = "*"
  }

  security_rule {
    name                       = "https"
    priority                   = 101
    direction                  = "Inbound"
    access                     = "Allow"
    protocol                   = "Tcp"
    source_port_range          = "*"
    destination_port_range     = "443"
    source_address_prefix      = "*"
    destination_address_prefix = "*"
  }
}

resource "azurerm_virtual_network" "shared_vnet" {
    name                = "rtc-cloud-az-er1"
    address_space       = ["10.1.0.0/16", "172.30.0.0/16", "172.31.0.0/16", "192.168.0.0/16", "2a02:6b8:c06::/48", "2a02:6b8:c2c::/48", "fc00::/64", "fc01::/64"]
    location            = "eastus"
    resource_group_name = azurerm_resource_group.shared_rg.name

}

resource "azurerm_subnet" "GatewaySubnet" {
  virtual_network_name = azurerm_virtual_network.shared_vnet.name
  resource_group_name = azurerm_resource_group.shared_rg.name
  name = "GatewaySubnet"
  address_prefixes = ["10.1.0.0/24", "2a02:6b8:c06:3c0::/64"]
}

resource "azurerm_subnet" "lb_net" {
  virtual_network_name = azurerm_virtual_network.shared_vnet.name
  name = "lb-net"
  resource_group_name = azurerm_resource_group.shared_rg.name
  address_prefixes = ["172.31.0.0/16", "fc00::/64"]
}

resource "azurerm_subnet" "lb_net6" {
  virtual_network_name = azurerm_virtual_network.shared_vnet.name
  name = "lb-net6"
  resource_group_name = azurerm_resource_group.shared_rg.name
  address_prefixes = ["172.30.0.0/16", "fc01::/64"]
}

resource "azurerm_subnet" "rtc" {
    resource_group_name = azurerm_resource_group.shared_rg.name
    virtual_network_name = azurerm_virtual_network.shared_vnet.name
    name = "rtc"
    address_prefixes = ["192.168.0.0/16", "2a02:6b8:c06:8000::/64"]
}

resource "azurerm_route_table" "rtc_mtn" {
  name = "rtc-mtn-rt"
  resource_group_name = azurerm_resource_group.shared_rg.name
  location = azurerm_resource_group.shared_rg.location
}

resource "azurerm_storage_account" "diag_storage" {
    name = "rtccloudazuseast1diag"
    resource_group_name = azurerm_resource_group.shared_rg.name
    location = azurerm_resource_group.shared_rg.location
    account_tier = "Standard"
    account_replication_type = "LRS"
    account_kind = "StorageV2"
    min_tls_version = "TLS1_2"
}

resource "azurerm_storage_account" "images_storage" {
  name                     = "rtcimages"
  resource_group_name      = azurerm_resource_group.shared_rg.name
  location                 = azurerm_resource_group.shared_rg.location
  account_tier             = "Standard"
  account_replication_type = "LRS"
  account_kind             = "StorageV2"
  min_tls_version          = "TLS1_2"
}

data "azurerm_image" "rtc_focal" {
  name                = "rtc-focal"
  resource_group_name = azurerm_resource_group.shared_rg.name
}

data "azuread_client_config" "current" {}

resource "azuread_group" "hosts_grp" {
  display_name     = "rtc-cloud-az-useast1-hosts"
  owners           = [data.azuread_client_config.current.object_id]
  security_enabled = true
}

resource "azurerm_role_assignment" "hosts_vnet_lb_role" {
  scope                = azurerm_resource_group.shared_rg.id
  role_definition_name = "Network Contributor"
  principal_id         = azuread_group.hosts_grp.object_id
}