resource "azurerm_resource_group" "yabs_rg" {
  name     = "rtc-cloud-az-us-east1-yabs"
  location = "eastus"
}

module "azuseast1_0004" {
  source        = "./modules/rtc_v2"
  walle_project = "yp-azuseast1-vla"
  hostname      = "azuseast1-0004"
  host_num      = "4"
  ipv6_addr     = "2a02:6b8:c06:8000:0:604:1:4"
  bb_ipv6_addr  = "2a02:6b8:c2c:180::badc:ab1e"
  vm_subnet     = "2a02:6b8:c2c:180::/57"
  mtn_prefix    = "2a02:6b8:c2c:180::/64"
  lb_subnet     = "172.31.0.64/28"
  lb_gateway    = "172.31.0.1"
  lb_pool = [
    "172.31.0.64", "172.31.0.65", "172.31.0.66", "172.31.0.67", "172.31.0.68", "172.31.0.69", "172.31.0.70", "172.31.0.71", "172.31.0.72", "172.31.0.73", "172.31.0.74", "172.31.0.75", "172.31.0.76", "172.31.0.77", "172.31.0.78", "172.31.0.79"
  ]
  vm_size             = "Standard_F32s_v2"
  # place_size          = 1024
  vm_image_id         = data.azurerm_image.rtc_focal.id
  resource_group_name = azurerm_resource_group.yabs_rg.name
  shared_rg_name      = data.azurerm_resource_group.shared_rg.name
  location            = azurerm_resource_group.yabs_rg.location
  rtc_net_id          = data.azurerm_subnet.rtc.id
  lb_net_id           = data.azurerm_subnet.lb_net.id
  route_table_name    = data.azurerm_route_table.rtc_mtn.name
  lb_nsg_id           = data.azurerm_network_security_group.lb_nsg.id
  diag_endpoint       = data.azurerm_storage_account.diag_storage.primary_blob_endpoint
}

resource "azuread_group_member" "azuseast1_0004" {
  group_object_id  = data.azuread_group.hosts_grp.id
  member_object_id = module.azuseast1_0004.vm_principal_id
}


module "azuseast1_0005" {
  source        = "./modules/rtc_v2"
  walle_project = "yp-azuseast1-vla"
  hostname      = "azuseast1-0005"
  host_num      = "5"
  ipv6_addr     = "2a02:6b8:c06:8000:0:604:1:5"
  bb_ipv6_addr  = "2a02:6b8:c2c:200::badc:ab1e"
  vm_subnet     = "2a02:6b8:c2c:200::/57"
  mtn_prefix    = "2a02:6b8:c2c:200::/64"
  lb_subnet     = "172.31.0.80/28"
  lb_gateway    = "172.31.0.1"
  lb_pool = [
    "172.31.0.80", "172.31.0.81", "172.31.0.82", "172.31.0.83", "172.31.0.84", "172.31.0.85", "172.31.0.86", "172.31.0.87", "172.31.0.88", "172.31.0.89", "172.31.0.90", "172.31.0.91", "172.31.0.92", "172.31.0.93", "172.31.0.94", "172.31.0.95"
  ]
  vm_size             = "Standard_F32s_v2"
  # place_size          = 1024
  vm_image_id         = data.azurerm_image.rtc_focal.id
  resource_group_name = azurerm_resource_group.yabs_rg.name
  shared_rg_name      = data.azurerm_resource_group.shared_rg.name
  location            = azurerm_resource_group.yabs_rg.location
  rtc_net_id          = data.azurerm_subnet.rtc.id
  lb_net_id           = data.azurerm_subnet.lb_net.id
  route_table_name    = data.azurerm_route_table.rtc_mtn.name
  lb_nsg_id           = data.azurerm_network_security_group.lb_nsg.id
  diag_endpoint       = data.azurerm_storage_account.diag_storage.primary_blob_endpoint
}

resource "azuread_group_member" "azuseast1_0005" {
  group_object_id  = data.azuread_group.hosts_grp.id
  member_object_id = module.azuseast1_0005.vm_principal_id
}


module "azuseast1_0006" {
  source        = "./modules/rtc_v2"
  walle_project = "yp-azuseast1-vla"
  hostname      = "azuseast1-0006"
  host_num      = "6"
  ipv6_addr     = "2a02:6b8:c06:8000:0:604:1:6"
  bb_ipv6_addr  = "2a02:6b8:c2c:280::badc:ab1e"
  vm_subnet     = "2a02:6b8:c2c:280::/57"
  mtn_prefix    = "2a02:6b8:c2c:280::/64"
  lb_subnet     = "172.31.0.96/28"
  lb_gateway    = "172.31.0.1"
  lb_pool = [
    "172.31.0.96", "172.31.0.97", "172.31.0.98", "172.31.0.99", "172.31.0.100", "172.31.0.101", "172.31.0.102", "172.31.0.103", "172.31.0.104", "172.31.0.105", "172.31.0.106", "172.31.0.107", "172.31.0.108", "172.31.0.109", "172.31.0.110", "172.31.0.111"
  ]
  vm_size             = "Standard_F32s_v2"
  # place_size          = 1024
  vm_image_id         = data.azurerm_image.rtc_focal.id
  resource_group_name = azurerm_resource_group.yabs_rg.name
  shared_rg_name      = data.azurerm_resource_group.shared_rg.name
  location            = azurerm_resource_group.yabs_rg.location
  rtc_net_id          = data.azurerm_subnet.rtc.id
  lb_net_id           = data.azurerm_subnet.lb_net.id
  route_table_name    = data.azurerm_route_table.rtc_mtn.name
  lb_nsg_id           = data.azurerm_network_security_group.lb_nsg.id
  diag_endpoint       = data.azurerm_storage_account.diag_storage.primary_blob_endpoint
}

resource "azuread_group_member" "azuseast1_0006" {
  group_object_id  = data.azuread_group.hosts_grp.id
  member_object_id = module.azuseast1_0006.vm_principal_id
}


module "azuseast1_0007" {
  source        = "./modules/rtc_v2"
  walle_project = "yp-azuseast1-vla"
  hostname      = "azuseast1-0007"
  host_num      = "7"
  ipv6_addr     = "2a02:6b8:c06:8000:0:604:1:7"
  bb_ipv6_addr  = "2a02:6b8:c2c:300::badc:ab1e"
  vm_subnet     = "2a02:6b8:c2c:300::/57"
  mtn_prefix    = "2a02:6b8:c2c:300::/64"
  lb_subnet     = "172.31.0.112/28"
  lb_gateway    = "172.31.0.1"
  lb_pool = [
    "172.31.0.112", "172.31.0.113", "172.31.0.114", "172.31.0.115", "172.31.0.116", "172.31.0.117", "172.31.0.118", "172.31.0.119", "172.31.0.120", "172.31.0.121", "172.31.0.122", "172.31.0.123", "172.31.0.124", "172.31.0.125", "172.31.0.126", "172.31.0.127"
  ]
  vm_size             = "Standard_F32s_v2"
  # place_size          = 1024
  vm_image_id         = data.azurerm_image.rtc_focal.id
  resource_group_name = azurerm_resource_group.yabs_rg.name
  shared_rg_name      = data.azurerm_resource_group.shared_rg.name
  location            = azurerm_resource_group.yabs_rg.location
  rtc_net_id          = data.azurerm_subnet.rtc.id
  lb_net_id           = data.azurerm_subnet.lb_net.id
  route_table_name    = data.azurerm_route_table.rtc_mtn.name
  lb_nsg_id           = data.azurerm_network_security_group.lb_nsg.id
  diag_endpoint       = data.azurerm_storage_account.diag_storage.primary_blob_endpoint
}

resource "azuread_group_member" "azuseast1_0007" {
  group_object_id  = data.azuread_group.hosts_grp.id
  member_object_id = module.azuseast1_0007.vm_principal_id
}


module "azuseast1_0008" {
  source        = "./modules/rtc_v2"
  walle_project = "yp-azuseast1-vla"
  hostname      = "azuseast1-0008"
  host_num      = "8"
  ipv6_addr     = "2a02:6b8:c06:8000:0:604:1:8"
  bb_ipv6_addr  = "2a02:6b8:c2c:380::badc:ab1e"
  vm_subnet     = "2a02:6b8:c2c:380::/57"
  mtn_prefix    = "2a02:6b8:c2c:380::/64"
  lb_subnet     = "172.31.0.128/28"
  lb_gateway    = "172.31.0.1"
  lb_pool = [
    "172.31.0.128", "172.31.0.129", "172.31.0.130", "172.31.0.131", "172.31.0.132", "172.31.0.133", "172.31.0.134", "172.31.0.135", "172.31.0.136", "172.31.0.137", "172.31.0.138", "172.31.0.139", "172.31.0.140", "172.31.0.141", "172.31.0.142", "172.31.0.143"
  ]
  vm_size             = "Standard_F32s_v2"
  # place_size          = 1024
  vm_image_id         = data.azurerm_image.rtc_focal.id
  resource_group_name = azurerm_resource_group.yabs_rg.name
  shared_rg_name      = data.azurerm_resource_group.shared_rg.name
  location            = azurerm_resource_group.yabs_rg.location
  rtc_net_id          = data.azurerm_subnet.rtc.id
  lb_net_id           = data.azurerm_subnet.lb_net.id
  route_table_name    = data.azurerm_route_table.rtc_mtn.name
  lb_nsg_id           = data.azurerm_network_security_group.lb_nsg.id
  diag_endpoint       = data.azurerm_storage_account.diag_storage.primary_blob_endpoint
}

resource "azuread_group_member" "azuseast1_0008" {
  group_object_id  = data.azuread_group.hosts_grp.id
  member_object_id = module.azuseast1_0008.vm_principal_id
}


module "azuseast1_0039" {
  source        = "./modules/rtc_v3"
  walle_project = "yp-azuseast1-vla"
  hostname      = "azuseast1-0039"
  host_num      = "39"
  ipv6_addr     = "2a02:6b8:c06:8000:0:604:1:27"
  bb_ipv6_addr  = "2a02:6b8:c2c:1380::badc:ab1e"
  vm_subnet     = "2a02:6b8:c2c:1380::/57"
  mtn_prefix    = "2a02:6b8:c2c:1380::/64"
  lb_subnet     = "172.31.2.112/28"
  lb_gateway    = "172.31.0.1"
  lb_pool = [
	"172.31.2.112", "172.31.2.113", "172.31.2.114", "172.31.2.115", "172.31.2.116", "172.31.2.117", "172.31.2.118", "172.31.2.119", "172.31.2.120", "172.31.2.121", "172.31.2.122", "172.31.2.123", "172.31.2.124", "172.31.2.125", "172.31.2.126", "172.31.2.127"
  ]
  vm_size             = "Standard_E64s_v5"
  vm_image_id         = data.azurerm_image.rtc_focal.id
  resource_group_name = azurerm_resource_group.yabs_rg.name
  shared_rg_name      = data.azurerm_resource_group.shared_rg.name
  location            = azurerm_resource_group.yabs_rg.location
  rtc_net_id          = data.azurerm_subnet.rtc.id
  lb_net_id           = data.azurerm_subnet.lb_net.id
  route_table_name    = data.azurerm_route_table.rtc_mtn.name
  lb_nsg_id           = data.azurerm_network_security_group.lb_nsg.id
  diag_endpoint       = data.azurerm_storage_account.diag_storage.primary_blob_endpoint
  admin_ssh_key       = "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQDJWfn/60SOVh3FUcUpfaApLZRWF7nis19ra1QC7cf/YwW1tVBLMm/AHmNTpM12njPjbh/vZVcoOzv74lLPpU9zvBWiPaPMh9Tzxn0KsZNglVxv9pyghrgh8rICFg9ZWiKCMCg6hhqQoTryJRlXR44RRisdG14ImvYkKx2Gwp3lT2sFzhJwcWFwCcuyP2zpXgtx+URS+nJsUAbfVdB6llZ8zV8k5BRopRjmKWjWxkwyd0UEe1pRNf4PV9ywdupFzwMbH7bb/cTAZv2MEcA+wgYEcxlOjGCwk0Xya5w/FWDK8RQwLxB5vxGTBHmiVcuvSNUCD4YBJGG3FDdQZPpc8kIh"
  admin_ssh_login     = "evgenyemets"
}

resource "azuread_group_member" "azuseast1_0039" {
  group_object_id  = data.azuread_group.hosts_grp.id
  member_object_id = module.azuseast1_0039.vm_principal_id
}


module "azuseast1_0040" {
  source        = "./modules/rtc_v3"
  walle_project = "yp-azuseast1-vla"
  hostname      = "azuseast1-0040"
  host_num      = "40"
  ipv6_addr     = "2a02:6b8:c06:8000:0:604:1:28"
  bb_ipv6_addr  = "2a02:6b8:c2c:1400::badc:ab1e"
  vm_subnet     = "2a02:6b8:c2c:1400::/57"
  mtn_prefix    = "2a02:6b8:c2c:1400::/64"
  lb_subnet     = "172.31.2.128/28"
  lb_gateway    = "172.31.0.1"
  lb_pool = [
	"172.31.2.128", "172.31.2.129", "172.31.2.130", "172.31.2.131", "172.31.2.132", "172.31.2.133", "172.31.2.134", "172.31.2.135", "172.31.2.136", "172.31.2.137", "172.31.2.138", "172.31.2.139", "172.31.2.140", "172.31.2.141", "172.31.2.142", "172.31.2.143"
  ]
  vm_size             = "Standard_E64s_v5"
  vm_image_id         = data.azurerm_image.rtc_focal.id
  resource_group_name = azurerm_resource_group.yabs_rg.name
  shared_rg_name      = data.azurerm_resource_group.shared_rg.name
  location            = azurerm_resource_group.yabs_rg.location
  rtc_net_id          = data.azurerm_subnet.rtc.id
  lb_net_id           = data.azurerm_subnet.lb_net.id
  route_table_name    = data.azurerm_route_table.rtc_mtn.name
  lb_nsg_id           = data.azurerm_network_security_group.lb_nsg.id
  diag_endpoint       = data.azurerm_storage_account.diag_storage.primary_blob_endpoint
  admin_ssh_key       = "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQDJWfn/60SOVh3FUcUpfaApLZRWF7nis19ra1QC7cf/YwW1tVBLMm/AHmNTpM12njPjbh/vZVcoOzv74lLPpU9zvBWiPaPMh9Tzxn0KsZNglVxv9pyghrgh8rICFg9ZWiKCMCg6hhqQoTryJRlXR44RRisdG14ImvYkKx2Gwp3lT2sFzhJwcWFwCcuyP2zpXgtx+URS+nJsUAbfVdB6llZ8zV8k5BRopRjmKWjWxkwyd0UEe1pRNf4PV9ywdupFzwMbH7bb/cTAZv2MEcA+wgYEcxlOjGCwk0Xya5w/FWDK8RQwLxB5vxGTBHmiVcuvSNUCD4YBJGG3FDdQZPpc8kIh"
  admin_ssh_login     = "evgenyemets"
}

resource "azuread_group_member" "azuseast1_0040" {
  group_object_id  = data.azuread_group.hosts_grp.id
  member_object_id = module.azuseast1_0040.vm_principal_id
}


module "azuseast1_0041" {
  source        = "./modules/rtc_v3"
  walle_project = "yp-azuseast1-vla"
  hostname      = "azuseast1-0041"
  host_num      = "41"
  ipv6_addr     = "2a02:6b8:c06:8000:0:604:1:29"
  bb_ipv6_addr  = "2a02:6b8:c2c:1480::badc:ab1e"
  vm_subnet     = "2a02:6b8:c2c:1480::/57"
  mtn_prefix    = "2a02:6b8:c2c:1480::/64"
  lb_subnet     = "172.31.2.144/28"
  lb_gateway    = "172.31.0.1"
  lb_pool = [
	"172.31.2.144", "172.31.2.145", "172.31.2.146", "172.31.2.147", "172.31.2.148", "172.31.2.149", "172.31.2.150", "172.31.2.151", "172.31.2.152", "172.31.2.153", "172.31.2.154", "172.31.2.155", "172.31.2.156", "172.31.2.157", "172.31.2.158", "172.31.2.159"
  ]
  vm_size             = "Standard_E64s_v5"
  vm_image_id         = data.azurerm_image.rtc_focal.id
  resource_group_name = azurerm_resource_group.yabs_rg.name
  shared_rg_name      = data.azurerm_resource_group.shared_rg.name
  location            = azurerm_resource_group.yabs_rg.location
  rtc_net_id          = data.azurerm_subnet.rtc.id
  lb_net_id           = data.azurerm_subnet.lb_net.id
  route_table_name    = data.azurerm_route_table.rtc_mtn.name
  lb_nsg_id           = data.azurerm_network_security_group.lb_nsg.id
  diag_endpoint       = data.azurerm_storage_account.diag_storage.primary_blob_endpoint
  admin_ssh_key       = "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQDJWfn/60SOVh3FUcUpfaApLZRWF7nis19ra1QC7cf/YwW1tVBLMm/AHmNTpM12njPjbh/vZVcoOzv74lLPpU9zvBWiPaPMh9Tzxn0KsZNglVxv9pyghrgh8rICFg9ZWiKCMCg6hhqQoTryJRlXR44RRisdG14ImvYkKx2Gwp3lT2sFzhJwcWFwCcuyP2zpXgtx+URS+nJsUAbfVdB6llZ8zV8k5BRopRjmKWjWxkwyd0UEe1pRNf4PV9ywdupFzwMbH7bb/cTAZv2MEcA+wgYEcxlOjGCwk0Xya5w/FWDK8RQwLxB5vxGTBHmiVcuvSNUCD4YBJGG3FDdQZPpc8kIh"
  admin_ssh_login     = "evgenyemets"
}

resource "azuread_group_member" "azuseast1_0041" {
  group_object_id  = data.azuread_group.hosts_grp.id
  member_object_id = module.azuseast1_0041.vm_principal_id
}


module "azuseast1_0042" {
  source        = "./modules/rtc_v3"
  walle_project = "yp-azuseast1-vla"
  hostname      = "azuseast1-0042"
  host_num      = "42"
  ipv6_addr     = "2a02:6b8:c06:8000:0:604:1:2a"
  bb_ipv6_addr  = "2a02:6b8:c2c:1500::badc:ab1e"
  vm_subnet     = "2a02:6b8:c2c:1500::/57"
  mtn_prefix    = "2a02:6b8:c2c:1500::/64"
  lb_subnet     = "172.31.2.160/28"
  lb_gateway    = "172.31.0.1"
  lb_pool = [
	"172.31.2.160", "172.31.2.161", "172.31.2.162", "172.31.2.163", "172.31.2.164", "172.31.2.165", "172.31.2.166", "172.31.2.167", "172.31.2.168", "172.31.2.169", "172.31.2.170", "172.31.2.171", "172.31.2.172", "172.31.2.173", "172.31.2.174", "172.31.2.175"
  ]
  vm_size             = "Standard_E64s_v5"
  vm_image_id         = data.azurerm_image.rtc_focal.id
  resource_group_name = azurerm_resource_group.yabs_rg.name
  shared_rg_name      = data.azurerm_resource_group.shared_rg.name
  location            = azurerm_resource_group.yabs_rg.location
  rtc_net_id          = data.azurerm_subnet.rtc.id
  lb_net_id           = data.azurerm_subnet.lb_net.id
  route_table_name    = data.azurerm_route_table.rtc_mtn.name
  lb_nsg_id           = data.azurerm_network_security_group.lb_nsg.id
  diag_endpoint       = data.azurerm_storage_account.diag_storage.primary_blob_endpoint
  admin_ssh_key       = "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQDJWfn/60SOVh3FUcUpfaApLZRWF7nis19ra1QC7cf/YwW1tVBLMm/AHmNTpM12njPjbh/vZVcoOzv74lLPpU9zvBWiPaPMh9Tzxn0KsZNglVxv9pyghrgh8rICFg9ZWiKCMCg6hhqQoTryJRlXR44RRisdG14ImvYkKx2Gwp3lT2sFzhJwcWFwCcuyP2zpXgtx+URS+nJsUAbfVdB6llZ8zV8k5BRopRjmKWjWxkwyd0UEe1pRNf4PV9ywdupFzwMbH7bb/cTAZv2MEcA+wgYEcxlOjGCwk0Xya5w/FWDK8RQwLxB5vxGTBHmiVcuvSNUCD4YBJGG3FDdQZPpc8kIh"
  admin_ssh_login     = "evgenyemets"
}

resource "azuread_group_member" "azuseast1_0042" {
  group_object_id  = data.azuread_group.hosts_grp.id
  member_object_id = module.azuseast1_0042.vm_principal_id
}

module "azuseast1_0043" {
  source        = "./modules/rtc_v3"
  walle_project = "yp-azuseast1-vla"
  hostname      = "azuseast1-0043"
  host_num      = "43"
  ipv6_addr     = "2a02:6b8:c06:8000:0:604:1:2b"
  bb_ipv6_addr  = "2a02:6b8:c2c:1580::badc:ab1e"
  vm_subnet     = "2a02:6b8:c2c:1580::/57"
  mtn_prefix    = "2a02:6b8:c2c:1580::/64"
  lb_subnet     = "172.31.2.176/28"
  lb_gateway    = "172.31.0.1"
  lb_pool = [
	"172.31.2.176", "172.31.2.177", "172.31.2.178", "172.31.2.179", "172.31.2.180", "172.31.2.181", "172.31.2.182", "172.31.2.183", "172.31.2.184", "172.31.2.185", "172.31.2.186", "172.31.2.187", "172.31.2.188", "172.31.2.189", "172.31.2.190", "172.31.2.191"
  ]
  vm_size             = "Standard_E64s_v5"
  vm_image_id         = data.azurerm_image.rtc_focal.id
  resource_group_name = azurerm_resource_group.yabs_rg.name
  shared_rg_name      = data.azurerm_resource_group.shared_rg.name
  location            = azurerm_resource_group.yabs_rg.location
  rtc_net_id          = data.azurerm_subnet.rtc.id
  lb_net_id           = data.azurerm_subnet.lb_net.id
  route_table_name    = data.azurerm_route_table.rtc_mtn.name
  lb_nsg_id           = data.azurerm_network_security_group.lb_nsg.id
  diag_endpoint       = data.azurerm_storage_account.diag_storage.primary_blob_endpoint
  admin_ssh_key       = "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQDJWfn/60SOVh3FUcUpfaApLZRWF7nis19ra1QC7cf/YwW1tVBLMm/AHmNTpM12njPjbh/vZVcoOzv74lLPpU9zvBWiPaPMh9Tzxn0KsZNglVxv9pyghrgh8rICFg9ZWiKCMCg6hhqQoTryJRlXR44RRisdG14ImvYkKx2Gwp3lT2sFzhJwcWFwCcuyP2zpXgtx+URS+nJsUAbfVdB6llZ8zV8k5BRopRjmKWjWxkwyd0UEe1pRNf4PV9ywdupFzwMbH7bb/cTAZv2MEcA+wgYEcxlOjGCwk0Xya5w/FWDK8RQwLxB5vxGTBHmiVcuvSNUCD4YBJGG3FDdQZPpc8kIh"
  admin_ssh_login     = "evgenyemets"
}

resource "azuread_group_member" "azuseast1_0043" {
  group_object_id  = data.azuread_group.hosts_grp.id
  member_object_id = module.azuseast1_0043.vm_principal_id
}

module "azuseast1_0044" {
  source        = "./modules/rtc_v3"
  walle_project = "yp-azuseast1-vla"
  hostname      = "azuseast1-0044"
  host_num      = "44"
  ipv6_addr     = "2a02:6b8:c06:8000:0:604:1:2c"
  bb_ipv6_addr  = "2a02:6b8:c2c:1600::badc:ab1e"
  vm_subnet     = "2a02:6b8:c2c:1600::/57"
  mtn_prefix    = "2a02:6b8:c2c:1600::/64"
  lb_subnet     = "172.31.2.192/28"
  lb_gateway    = "172.31.0.1"
  lb_pool = [
	"172.31.2.192", "172.31.2.193", "172.31.2.194", "172.31.2.195", "172.31.2.196", "172.31.2.197", "172.31.2.198", "172.31.2.199", "172.31.2.200", "172.31.2.201", "172.31.2.202", "172.31.2.203", "172.31.2.204", "172.31.2.205", "172.31.2.206", "172.31.2.207"
  ]
  vm_size             = "Standard_E64s_v5"
  vm_image_id         = data.azurerm_image.rtc_focal.id
  resource_group_name = azurerm_resource_group.yabs_rg.name
  shared_rg_name      = data.azurerm_resource_group.shared_rg.name
  location            = azurerm_resource_group.yabs_rg.location
  rtc_net_id          = data.azurerm_subnet.rtc.id
  lb_net_id           = data.azurerm_subnet.lb_net.id
  route_table_name    = data.azurerm_route_table.rtc_mtn.name
  lb_nsg_id           = data.azurerm_network_security_group.lb_nsg.id
  diag_endpoint       = data.azurerm_storage_account.diag_storage.primary_blob_endpoint
  admin_ssh_key       = "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQDJWfn/60SOVh3FUcUpfaApLZRWF7nis19ra1QC7cf/YwW1tVBLMm/AHmNTpM12njPjbh/vZVcoOzv74lLPpU9zvBWiPaPMh9Tzxn0KsZNglVxv9pyghrgh8rICFg9ZWiKCMCg6hhqQoTryJRlXR44RRisdG14ImvYkKx2Gwp3lT2sFzhJwcWFwCcuyP2zpXgtx+URS+nJsUAbfVdB6llZ8zV8k5BRopRjmKWjWxkwyd0UEe1pRNf4PV9ywdupFzwMbH7bb/cTAZv2MEcA+wgYEcxlOjGCwk0Xya5w/FWDK8RQwLxB5vxGTBHmiVcuvSNUCD4YBJGG3FDdQZPpc8kIh"
  admin_ssh_login     = "evgenyemets"
}

resource "azuread_group_member" "azuseast1_0044" {
  group_object_id  = data.azuread_group.hosts_grp.id
  member_object_id = module.azuseast1_0044.vm_principal_id
}

module "azuseast1_0045" {
  source        = "./modules/rtc_v3"
  walle_project = "yp-azuseast1-vla"
  hostname      = "azuseast1-0045"
  host_num      = "45"
  ipv6_addr     = "2a02:6b8:c06:8000:0:604:1:2d"
  bb_ipv6_addr  = "2a02:6b8:c2c:1680::badc:ab1e"
  vm_subnet     = "2a02:6b8:c2c:1680::/57"
  mtn_prefix    = "2a02:6b8:c2c:1680::/64"
  lb_subnet     = "172.31.2.208/28"
  lb_gateway    = "172.31.0.1"
  lb_pool = [
	"172.31.2.208", "172.31.2.209", "172.31.2.210", "172.31.2.211", "172.31.2.212", "172.31.2.213", "172.31.2.214", "172.31.2.215", "172.31.2.216", "172.31.2.217", "172.31.2.218", "172.31.2.219", "172.31.2.220", "172.31.2.221", "172.31.2.222", "172.31.2.223"
  ]
  vm_size             = "Standard_E48s_v5"
  vm_image_id         = data.azurerm_image.rtc_focal.id
  resource_group_name = azurerm_resource_group.yabs_rg.name
  shared_rg_name      = data.azurerm_resource_group.shared_rg.name
  location            = azurerm_resource_group.yabs_rg.location
  rtc_net_id          = data.azurerm_subnet.rtc.id
  lb_net_id           = data.azurerm_subnet.lb_net.id
  route_table_name    = data.azurerm_route_table.rtc_mtn.name
  lb_nsg_id           = data.azurerm_network_security_group.lb_nsg.id
  diag_endpoint       = data.azurerm_storage_account.diag_storage.primary_blob_endpoint
  admin_ssh_key       = "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQDJWfn/60SOVh3FUcUpfaApLZRWF7nis19ra1QC7cf/YwW1tVBLMm/AHmNTpM12njPjbh/vZVcoOzv74lLPpU9zvBWiPaPMh9Tzxn0KsZNglVxv9pyghrgh8rICFg9ZWiKCMCg6hhqQoTryJRlXR44RRisdG14ImvYkKx2Gwp3lT2sFzhJwcWFwCcuyP2zpXgtx+URS+nJsUAbfVdB6llZ8zV8k5BRopRjmKWjWxkwyd0UEe1pRNf4PV9ywdupFzwMbH7bb/cTAZv2MEcA+wgYEcxlOjGCwk0Xya5w/FWDK8RQwLxB5vxGTBHmiVcuvSNUCD4YBJGG3FDdQZPpc8kIh"
  admin_ssh_login     = "evgenyemets"
}

resource "azuread_group_member" "azuseast1_0045" {
  group_object_id  = data.azuread_group.hosts_grp.id
  member_object_id = module.azuseast1_0045.vm_principal_id
}

module "azuseast1_0046" {
  source        = "./modules/rtc_v3"
  walle_project = "yp-azuseast1-vla"
  hostname      = "azuseast1-0046"
  host_num      = "46"
  ipv6_addr     = "2a02:6b8:c06:8000:0:604:1:2e"
  bb_ipv6_addr  = "2a02:6b8:c2c:1700::badc:ab1e"
  vm_subnet     = "2a02:6b8:c2c:1700::/57"
  mtn_prefix    = "2a02:6b8:c2c:1700::/64"
  lb_subnet     = "172.31.2.224/28"
  lb_gateway    = "172.31.0.1"
  lb_pool = [
	"172.31.2.224", "172.31.2.225", "172.31.2.226", "172.31.2.227", "172.31.2.228", "172.31.2.229", "172.31.2.230", "172.31.2.231", "172.31.2.232", "172.31.2.233", "172.31.2.234", "172.31.2.235", "172.31.2.236", "172.31.2.237", "172.31.2.238", "172.31.2.239"
  ]
  vm_size             = "Standard_E48s_v5"
  vm_image_id         = data.azurerm_image.rtc_focal.id
  resource_group_name = azurerm_resource_group.yabs_rg.name
  shared_rg_name      = data.azurerm_resource_group.shared_rg.name
  location            = azurerm_resource_group.yabs_rg.location
  rtc_net_id          = data.azurerm_subnet.rtc.id
  lb_net_id           = data.azurerm_subnet.lb_net.id
  route_table_name    = data.azurerm_route_table.rtc_mtn.name
  lb_nsg_id           = data.azurerm_network_security_group.lb_nsg.id
  diag_endpoint       = data.azurerm_storage_account.diag_storage.primary_blob_endpoint
  admin_ssh_key       = "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQDJWfn/60SOVh3FUcUpfaApLZRWF7nis19ra1QC7cf/YwW1tVBLMm/AHmNTpM12njPjbh/vZVcoOzv74lLPpU9zvBWiPaPMh9Tzxn0KsZNglVxv9pyghrgh8rICFg9ZWiKCMCg6hhqQoTryJRlXR44RRisdG14ImvYkKx2Gwp3lT2sFzhJwcWFwCcuyP2zpXgtx+URS+nJsUAbfVdB6llZ8zV8k5BRopRjmKWjWxkwyd0UEe1pRNf4PV9ywdupFzwMbH7bb/cTAZv2MEcA+wgYEcxlOjGCwk0Xya5w/FWDK8RQwLxB5vxGTBHmiVcuvSNUCD4YBJGG3FDdQZPpc8kIh"
  admin_ssh_login     = "evgenyemets"
}

resource "azuread_group_member" "azuseast1_0046" {
  group_object_id  = data.azuread_group.hosts_grp.id
  member_object_id = module.azuseast1_0046.vm_principal_id
}

module "azuseast1_0047" {
  source        = "./modules/rtc_v3"
  walle_project = "yp-azuseast1-vla"
  hostname      = "azuseast1-0047"
  host_num      = "47"
  ipv6_addr     = "2a02:6b8:c06:8000:0:604:1:2f"
  bb_ipv6_addr  = "2a02:6b8:c2c:1780::badc:ab1e"
  vm_subnet     = "2a02:6b8:c2c:1780::/57"
  mtn_prefix    = "2a02:6b8:c2c:1780::/64"
  lb_subnet     = "172.31.2.240/28"
  lb_gateway    = "172.31.0.1"
  lb_pool = [
	"172.31.2.240", "172.31.2.241", "172.31.2.242", "172.31.2.243", "172.31.2.244", "172.31.2.245", "172.31.2.246", "172.31.2.247", "172.31.2.248", "172.31.2.249", "172.31.2.250", "172.31.2.251", "172.31.2.252", "172.31.2.253", "172.31.2.254", "172.31.2.255"
  ]
  vm_size             = "Standard_E48s_v5"
  vm_image_id         = data.azurerm_image.rtc_focal.id
  resource_group_name = azurerm_resource_group.yabs_rg.name
  shared_rg_name      = data.azurerm_resource_group.shared_rg.name
  location            = azurerm_resource_group.yabs_rg.location
  rtc_net_id          = data.azurerm_subnet.rtc.id
  lb_net_id           = data.azurerm_subnet.lb_net.id
  route_table_name    = data.azurerm_route_table.rtc_mtn.name
  lb_nsg_id           = data.azurerm_network_security_group.lb_nsg.id
  diag_endpoint       = data.azurerm_storage_account.diag_storage.primary_blob_endpoint
  admin_ssh_key       = "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQDJWfn/60SOVh3FUcUpfaApLZRWF7nis19ra1QC7cf/YwW1tVBLMm/AHmNTpM12njPjbh/vZVcoOzv74lLPpU9zvBWiPaPMh9Tzxn0KsZNglVxv9pyghrgh8rICFg9ZWiKCMCg6hhqQoTryJRlXR44RRisdG14ImvYkKx2Gwp3lT2sFzhJwcWFwCcuyP2zpXgtx+URS+nJsUAbfVdB6llZ8zV8k5BRopRjmKWjWxkwyd0UEe1pRNf4PV9ywdupFzwMbH7bb/cTAZv2MEcA+wgYEcxlOjGCwk0Xya5w/FWDK8RQwLxB5vxGTBHmiVcuvSNUCD4YBJGG3FDdQZPpc8kIh"
  admin_ssh_login     = "evgenyemets"
}

resource "azuread_group_member" "azuseast1_0047" {
  group_object_id  = data.azuread_group.hosts_grp.id
  member_object_id = module.azuseast1_0047.vm_principal_id
}

module "azuseast1_0048" {
  source        = "./modules/rtc_v3"
  walle_project = "yp-azuseast1-vla"
  hostname      = "azuseast1-0048"
  host_num      = "48"
  ipv6_addr     = "2a02:6b8:c06:8000:0:604:1:30"
  bb_ipv6_addr  = "2a02:6b8:c2c:1800::badc:ab1e"
  vm_subnet     = "2a02:6b8:c2c:1800::/57"
  mtn_prefix    = "2a02:6b8:c2c:1800::/64"
  lb_subnet     = "172.31.3.0/28"
  lb_gateway    = "172.31.0.1"
  lb_pool = [
	"172.31.3.0", "172.31.3.1", "172.31.3.2", "172.31.3.3", "172.31.3.4", "172.31.3.5", "172.31.3.6", "172.31.3.7", "172.31.3.8", "172.31.3.9", "172.31.3.10", "172.31.3.11", "172.31.3.12", "172.31.3.13", "172.31.3.14", "172.31.3.15"
  ]
  vm_size             = "Standard_E48s_v5"
  vm_image_id         = data.azurerm_image.rtc_focal.id
  resource_group_name = azurerm_resource_group.yabs_rg.name
  shared_rg_name      = data.azurerm_resource_group.shared_rg.name
  location            = azurerm_resource_group.yabs_rg.location
  rtc_net_id          = data.azurerm_subnet.rtc.id
  lb_net_id           = data.azurerm_subnet.lb_net.id
  route_table_name    = data.azurerm_route_table.rtc_mtn.name
  lb_nsg_id           = data.azurerm_network_security_group.lb_nsg.id
  diag_endpoint       = data.azurerm_storage_account.diag_storage.primary_blob_endpoint
  admin_ssh_key       = "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQDJWfn/60SOVh3FUcUpfaApLZRWF7nis19ra1QC7cf/YwW1tVBLMm/AHmNTpM12njPjbh/vZVcoOzv74lLPpU9zvBWiPaPMh9Tzxn0KsZNglVxv9pyghrgh8rICFg9ZWiKCMCg6hhqQoTryJRlXR44RRisdG14ImvYkKx2Gwp3lT2sFzhJwcWFwCcuyP2zpXgtx+URS+nJsUAbfVdB6llZ8zV8k5BRopRjmKWjWxkwyd0UEe1pRNf4PV9ywdupFzwMbH7bb/cTAZv2MEcA+wgYEcxlOjGCwk0Xya5w/FWDK8RQwLxB5vxGTBHmiVcuvSNUCD4YBJGG3FDdQZPpc8kIh"
  admin_ssh_login     = "evgenyemets"
}

resource "azuread_group_member" "azuseast1_0048" {
  group_object_id  = data.azuread_group.hosts_grp.id
  member_object_id = module.azuseast1_0048.vm_principal_id
}

module "azuseast1_0049" {
  source        = "./modules/rtc_snat"
  walle_project = "yp-azuseast1-vla"
  hostname      = "azuseast1-0049"
  host_num      = "49"
  ipv6_addr     = "2a02:6b8:c06:8000:0:604:1:31"
  bb_ipv6_addr  = "2a02:6b8:c2c:1880::badc:ab1e"
  vm_subnet     = "2a02:6b8:c2c:1880::/57"
  mtn_prefix    = "2a02:6b8:c2c:1880::/64"
  
  vm_size             = "Standard_F16s_v2"
  snat_net_id = module.pnocsy_snat.snat_net_id
  snat_subnet = "172.16.0.0/16"
  snat_gateway = "10.1.4.1"
  snat_segment = "yabs-pnocsy2"
  zone = "1"
  vm_image_id         = data.azurerm_image.rtc_focal.id
  resource_group_name = azurerm_resource_group.yabs_rg.name
  shared_rg_name      = data.azurerm_resource_group.shared_rg.name
  location            = azurerm_resource_group.yabs_rg.location
  rtc_net_id          = data.azurerm_subnet.rtc.id
  route_table_name    = data.azurerm_route_table.rtc_mtn.name
  diag_endpoint       = data.azurerm_storage_account.diag_storage.primary_blob_endpoint
}

resource "azuread_group_member" "azuseast1_0049" {
  group_object_id  = data.azuread_group.hosts_grp.id
  member_object_id = module.azuseast1_0049.vm_principal_id
}

module "azuseast1_0050" {
  source        = "./modules/rtc_snat"
  walle_project = "yp-azuseast1-vla"
  hostname      = "azuseast1-0050"
  host_num      = "50"
  ipv6_addr     = "2a02:6b8:c06:8000:0:604:1:32"
  bb_ipv6_addr  = "2a02:6b8:c2c:1900::badc:ab1e"
  vm_subnet     = "2a02:6b8:c2c:1900::/57"
  mtn_prefix    = "2a02:6b8:c2c:1900::/64"
  
  vm_size             = "Standard_F16s_v2"
  snat_net_id = module.pnocsy_snat.snat_net_id
  snat_subnet = "172.16.0.0/16"
  snat_gateway = "10.1.4.1"
  snat_segment = "yabs-pnocsy2"
  zone = "2"
  vm_image_id         = data.azurerm_image.rtc_focal.id
  resource_group_name = azurerm_resource_group.yabs_rg.name
  shared_rg_name      = data.azurerm_resource_group.shared_rg.name
  location            = azurerm_resource_group.yabs_rg.location
  rtc_net_id          = data.azurerm_subnet.rtc.id
  route_table_name    = data.azurerm_route_table.rtc_mtn.name
  diag_endpoint       = data.azurerm_storage_account.diag_storage.primary_blob_endpoint
}

resource "azuread_group_member" "azuseast1_0050" {
  group_object_id  = data.azuread_group.hosts_grp.id
  member_object_id = module.azuseast1_0050.vm_principal_id
}

module "azuseast1_0051" {
  source        = "./modules/rtc_snat"
  walle_project = "yp-azuseast1-vla"
  hostname      = "azuseast1-0051"
  host_num      = "51"
  ipv6_addr     = "2a02:6b8:c06:8000:0:604:1:33"
  bb_ipv6_addr  = "2a02:6b8:c2c:1980::badc:ab1e"
  vm_subnet     = "2a02:6b8:c2c:1980::/57"
  mtn_prefix    = "2a02:6b8:c2c:1980::/64"
  
  vm_size             = "Standard_F16s_v2"
  snat_net_id = module.pnocsy_snat.snat_net_id
  snat_subnet = "172.16.0.0/16"
  snat_gateway = "10.1.4.1"
  snat_segment = "yabs-pnocsy2"
  zone = "3"
  vm_image_id         = data.azurerm_image.rtc_focal.id
  resource_group_name = azurerm_resource_group.yabs_rg.name
  shared_rg_name      = data.azurerm_resource_group.shared_rg.name
  location            = azurerm_resource_group.yabs_rg.location
  rtc_net_id          = data.azurerm_subnet.rtc.id
  route_table_name    = data.azurerm_route_table.rtc_mtn.name
  diag_endpoint       = data.azurerm_storage_account.diag_storage.primary_blob_endpoint
}

resource "azuread_group_member" "azuseast1_0051" {
  group_object_id  = data.azuread_group.hosts_grp.id
  member_object_id = module.azuseast1_0051.vm_principal_id
}

module "azuseast1_0055" {
  source        = "./modules/rtc_v4"
  walle_project = "yp-azuseast1-vla"
  hostname      = "azuseast1-0055"
  host_num      = "55"
  ipv6_addr     = "2a02:6b8:c06:8000:0:604:1:37"
  bb_ipv6_addr  = "2a02:6b8:c2c:1b80::badc:ab1e"
  vm_subnet     = "2a02:6b8:c2c:1b80::/57"
  mtn_prefix    = "2a02:6b8:c2c:1b80::/64"
  lb_subnet     = "172.31.3.112/28"
  lb_gateway    = "172.31.0.1"
  lb_pool = [
  "172.31.3.112", "172.31.3.113", "172.31.3.114", "172.31.3.115", "172.31.3.116", "172.31.3.117", "172.31.3.118", "172.31.3.119", "172.31.3.120", "172.31.3.121", "172.31.3.122", "172.31.3.123", "172.31.3.124", "172.31.3.125", "172.31.3.126", "172.31.3.127"
  ]
  vm_size             = "Standard_E64s_v5"
  vm_image_id         = data.azurerm_image.rtc_focal.id
  resource_group_name = azurerm_resource_group.yabs_rg.name
  shared_rg_name      = data.azurerm_resource_group.shared_rg.name
  location            = azurerm_resource_group.yabs_rg.location
  rtc_net_id          = data.azurerm_subnet.rtc.id
  lb_net_id           = data.azurerm_subnet.lb_net.id
  route_table_name    = data.azurerm_route_table.rtc_mtn.name
  lb_nsg_id           = data.azurerm_network_security_group.lb_nsg.id
  diag_endpoint       = data.azurerm_storage_account.diag_storage.primary_blob_endpoint
  zone = "1"
}

resource "azuread_group_member" "azuseast1_0055" {
  group_object_id  = data.azuread_group.hosts_grp.id
  member_object_id = module.azuseast1_0055.vm_principal_id
}

module "azuseast1_0056" {
  source        = "./modules/rtc_v4"
  walle_project = "yp-azuseast1-vla"
  hostname      = "azuseast1-0056"
  host_num      = "56"
  ipv6_addr     = "2a02:6b8:c06:8000:0:604:1:38"
  bb_ipv6_addr  = "2a02:6b8:c2c:1c00::badc:ab1e"
  vm_subnet     = "2a02:6b8:c2c:1c00::/57"
  mtn_prefix    = "2a02:6b8:c2c:1c00::/64"
  lb_subnet     = "172.31.3.128/28"
  lb_gateway    = "172.31.0.1"
  lb_pool = [
	"172.31.3.128", "172.31.3.129", "172.31.3.130", "172.31.3.131", "172.31.3.132", "172.31.3.133", "172.31.3.134", "172.31.3.135", "172.31.3.136", "172.31.3.137", "172.31.3.138", "172.31.3.139", "172.31.3.140", "172.31.3.141", "172.31.3.142", "172.31.3.143"
  ]
  vm_size             = "Standard_E64s_v5"
  vm_image_id         = data.azurerm_image.rtc_focal.id
  resource_group_name = azurerm_resource_group.yabs_rg.name
  shared_rg_name      = data.azurerm_resource_group.shared_rg.name
  location            = azurerm_resource_group.yabs_rg.location
  rtc_net_id          = data.azurerm_subnet.rtc.id
  lb_net_id           = data.azurerm_subnet.lb_net.id
  route_table_name    = data.azurerm_route_table.rtc_mtn.name
  lb_nsg_id           = data.azurerm_network_security_group.lb_nsg.id
  diag_endpoint       = data.azurerm_storage_account.diag_storage.primary_blob_endpoint
  zone = "2"
}

resource "azuread_group_member" "azuseast1_0056" {
  group_object_id  = data.azuread_group.hosts_grp.id
  member_object_id = module.azuseast1_0056.vm_principal_id
}

module "azuseast1_0057" {
  source        = "./modules/rtc_v4"
  walle_project = "yp-azuseast1-vla"
  hostname      = "azuseast1-0057"
  host_num      = "57"
  ipv6_addr     = "2a02:6b8:c06:8000:0:604:1:39"
  bb_ipv6_addr  = "2a02:6b8:c2c:1c80::badc:ab1e"
  vm_subnet     = "2a02:6b8:c2c:1c80::/57"
  mtn_prefix    = "2a02:6b8:c2c:1c80::/64"
  lb_subnet     = "172.31.3.144/28"
  lb_gateway    = "172.31.0.1"
  lb_pool = [
  "172.31.3.144", "172.31.3.145", "172.31.3.146", "172.31.3.147", "172.31.3.148", "172.31.3.149", "172.31.3.150", "172.31.3.151", "172.31.3.152", "172.31.3.153", "172.31.3.154", "172.31.3.155", "172.31.3.156", "172.31.3.157", "172.31.3.158", "172.31.3.159"
  ]
  vm_size             = "Standard_E64s_v5"
  vm_image_id         = data.azurerm_image.rtc_focal.id
  resource_group_name = azurerm_resource_group.yabs_rg.name
  shared_rg_name      = data.azurerm_resource_group.shared_rg.name
  location            = azurerm_resource_group.yabs_rg.location
  rtc_net_id          = data.azurerm_subnet.rtc.id
  lb_net_id           = data.azurerm_subnet.lb_net.id
  route_table_name    = data.azurerm_route_table.rtc_mtn.name
  lb_nsg_id           = data.azurerm_network_security_group.lb_nsg.id
  diag_endpoint       = data.azurerm_storage_account.diag_storage.primary_blob_endpoint
  zone = "3"
}

resource "azuread_group_member" "azuseast1_0057" {
  group_object_id  = data.azuread_group.hosts_grp.id
  member_object_id = module.azuseast1_0057.vm_principal_id
}

module "azuseast1_0058" {
  source        = "./modules/rtc_v4"
  walle_project = "yp-azuseast1-vla"
  hostname      = "azuseast1-0058"
  host_num      = "58"
  ipv6_addr     = "2a02:6b8:c06:8000:0:604:1:3a"
  bb_ipv6_addr  = "2a02:6b8:c2c:1d00::badc:ab1e"
  vm_subnet     = "2a02:6b8:c2c:1d00::/57"
  mtn_prefix    = "2a02:6b8:c2c:1d00::/64"
  lb_subnet     = "172.31.3.160/28"
  lb_gateway    = "172.31.0.1"
  lb_pool = [
  "172.31.3.160", "172.31.3.161", "172.31.3.162", "172.31.3.163", "172.31.3.164", "172.31.3.165", "172.31.3.166", "172.31.3.167", "172.31.3.168", "172.31.3.169", "172.31.3.170", "172.31.3.171", "172.31.3.172", "172.31.3.173", "172.31.3.174", "172.31.3.175"
  ]
  vm_size             = "Standard_E32s_v5"
  vm_image_id         = data.azurerm_image.rtc_focal.id
  resource_group_name = azurerm_resource_group.yabs_rg.name
  shared_rg_name      = data.azurerm_resource_group.shared_rg.name
  location            = azurerm_resource_group.yabs_rg.location
  rtc_net_id          = data.azurerm_subnet.rtc.id
  lb_net_id           = data.azurerm_subnet.lb_net.id
  route_table_name    = data.azurerm_route_table.rtc_mtn.name
  lb_nsg_id           = data.azurerm_network_security_group.lb_nsg.id
  diag_endpoint       = data.azurerm_storage_account.diag_storage.primary_blob_endpoint
  zone = "1"
}

resource "azuread_group_member" "azuseast1_0058" {
  group_object_id  = data.azuread_group.hosts_grp.id
  member_object_id = module.azuseast1_0058.vm_principal_id
}