data "azurerm_public_ip_prefix" "yabs_public_prefix" {
  resource_group_name = azurerm_resource_group.yabs_rg.name
  name = "l3-lb-prefix"
}

module "ssp_proxy_lb" {
   source        = "./modules/l3lb"
   rg_name = azurerm_resource_group.yabs_rg.name
   location = azurerm_resource_group.yabs_rg.location
   lb_prefix_id = data.azurerm_public_ip_prefix.yabs_public_prefix.id
   balancer_name = "ssp-proxy"
   vnet_id = data.azurerm_virtual_network.shared_vnet.id
   dummy_address = "172.31.255.250"
   hosts_grp_id = data.azuread_group.hosts_grp.id
}

module "exchange_proxy_lb" {
   source        = "./modules/l3lb"
   rg_name = azurerm_resource_group.yabs_rg.name
   location = azurerm_resource_group.yabs_rg.location
   lb_prefix_id = data.azurerm_public_ip_prefix.yabs_public_prefix.id
   balancer_name = "exchange-proxy"
   vnet_id = data.azurerm_virtual_network.shared_vnet.id
   dummy_address = "172.31.255.249"
   hosts_grp_id = data.azuread_group.hosts_grp.id
}

module "crypta_lb" {
   source        = "./modules/l3lb"
   rg_name = azurerm_resource_group.yabs_rg.name
   location = azurerm_resource_group.yabs_rg.location
   lb_prefix_id = data.azurerm_public_ip_prefix.yabs_public_prefix.id
   balancer_name = "cm-intl.crypta.yandex.net"
   vnet_id = data.azurerm_virtual_network.shared_vnet.id
   dummy_address = "172.31.255.248"
   hosts_grp_id = data.azuread_group.hosts_grp.id
}

