
data "azurerm_resource_group" "shared_rg" {
  name = "rtc-cloud-az-us-east1-shared"
}

data "azurerm_network_security_group" "lb_nsg" {
  name                = "lb_nsg"
  resource_group_name = data.azurerm_resource_group.shared_rg.name
}

data "azurerm_virtual_network" "shared_vnet" {
  name = "rtc-cloud-az-er1"
  # address_space       = ["10.4.0.0/16", "172.29.0.0/16", "2a02:6b8:c30::/48", "2a02:6b8:c31::/48", "fc00:1000::/64"]
  resource_group_name = data.azurerm_resource_group.shared_rg.name

}

data "azurerm_subnet" "lb_net" {
  virtual_network_name = data.azurerm_virtual_network.shared_vnet.name
  name                 = "lb-net"
  resource_group_name  = data.azurerm_resource_group.shared_rg.name
  #address_prefixes     = ["172.29.0.0/19"]
}

data "azurerm_subnet" "lb_net6" {
  virtual_network_name = data.azurerm_virtual_network.shared_vnet.name
  name                 = "lb-net6"
  resource_group_name  = data.azurerm_resource_group.shared_rg.name
  #address_prefixes     = ["10.4.2.0/23", "fc00:1000::/64"]
}

data "azurerm_subnet" "rtc" {
  resource_group_name  = data.azurerm_resource_group.shared_rg.name
  virtual_network_name = data.azurerm_virtual_network.shared_vnet.name
  name                 = "rtc"
  #address_prefixes     = ["10.4.0.0/23", "2a02:6b8:c30:80::/64"]
}

data "azurerm_route_table" "rtc_mtn" {
  name                = "rtc-mtn-rt"
  resource_group_name = data.azurerm_resource_group.shared_rg.name
}

data "azurerm_storage_account" "diag_storage" {
  name                = "rtccloudazuseast1diag"
  resource_group_name = data.azurerm_resource_group.shared_rg.name
}

data "azurerm_storage_account" "images_storage" {
  name                = "rtcimages"
  resource_group_name = data.azurerm_resource_group.shared_rg.name
}

data "azurerm_image" "rtc_focal" {
  name                = "rtc-focal"
  resource_group_name = data.azurerm_resource_group.shared_rg.name
}

data "azuread_group" "hosts_grp" {
  display_name     = "rtc-cloud-az-useast1-hosts"
  security_enabled = true
}
