resource "azurerm_resource_group" "vapnik_rg" {
  name     = "rtc-cloud-az-us-east1-vapnik"
  location = "eastus"
}

module "azuseast1_0020" {
  source        = "./modules/rtc_yt_master"
  walle_project = "yp-useast1-yt-vapnik-vla-master"
  hostname      = "azuseast1-0020"
  host_num      = "20"
  ipv6_addr     = "2a02:6b8:c06:8000:0:604:1:14"
  bb_ipv6_addr  = "2a02:6b8:c2c:a00::badc:ab1e"
  vm_subnet     = "2a02:6b8:c2c:a00::/57"
  mtn_prefix    = "2a02:6b8:c2c:a00::/64"
  lb_subnet     = "172.31.1.64/28"
  lb_gateway    = "172.31.0.1"
  lb_pool = [
    "172.31.1.64", "172.31.1.65", "172.31.1.66", "172.31.1.67", "172.31.1.68", "172.31.1.69", "172.31.1.70", "172.31.1.71", "172.31.1.72", "172.31.1.73", "172.31.1.74", "172.31.1.75", "172.31.1.76", "172.31.1.77", "172.31.1.78", "172.31.1.79"
  ]
  vm_size             = "Standard_E16s_v5"
  vm_image_id         = data.azurerm_image.rtc_focal.id
  resource_group_name = azurerm_resource_group.vapnik_rg.name
  shared_rg_name      = data.azurerm_resource_group.shared_rg.name
  location            = azurerm_resource_group.vapnik_rg.location
  rtc_net_id          = data.azurerm_subnet.rtc.id
  lb_net_id           = data.azurerm_subnet.lb_net.id
  route_table_name    = data.azurerm_route_table.rtc_mtn.name
  lb_nsg_id           = data.azurerm_network_security_group.lb_nsg.id
  diag_endpoint       = data.azurerm_storage_account.diag_storage.primary_blob_endpoint
  az                  = ""
  admin_ssh_login     = "zeebdo"
  admin_ssh_key       = "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQCw34MCSuEMEnEFPsWsZEnw/YdmyxWD9Sszh7mV2A3WI3gt37ZyaSCeGqgY3xBOSjetKaJiqwmfmF5mP2oGJF+Nz8HUwzdGOqGvhuRJajAfk/HJQ+JUY8x4s9MSi52rd/3J8Oj+eWlCoko21rN/U9YYs09Rf83kOyYr6GwyVXAbSe84Sc6/MVO2dBasD8J7BtN3Y4Jhye+M5Xtm+c/258L2D1vW+cSLbq8q6f0RThVMxJmLCHp9QYT33hN5LhZ22hICAEecKUBwks1vQU6lTIVpPoy7tlOq+BeF3JI30qeFxjEmAzC1QdyCtV/REAKhy9jUliuBt8iVRZYGctyf401D"
}

resource "azuread_group_member" "azuseast1_0020" {
  group_object_id  = data.azuread_group.hosts_grp.id
  member_object_id = module.azuseast1_0020.vm_principal_id
}

module "azuseast1_0021" {
  source        = "./modules/rtc_yt_master"
  walle_project = "yp-useast1-yt-vapnik-vla-master"
  hostname      = "azuseast1-0021"
  host_num      = "21"
  ipv6_addr     = "2a02:6b8:c06:8000:0:604:1:15"
  bb_ipv6_addr  = "2a02:6b8:c2c:a80::badc:ab1e"
  vm_subnet     = "2a02:6b8:c2c:a80::/57"
  mtn_prefix    = "2a02:6b8:c2c:a80::/64"
  lb_subnet     = "172.31.1.80/28"
  lb_gateway    = "172.31.0.1"
  lb_pool = [
    "172.31.1.80", "172.31.1.81", "172.31.1.82", "172.31.1.83", "172.31.1.84", "172.31.1.85", "172.31.1.86", "172.31.1.87", "172.31.1.88", "172.31.1.89", "172.31.1.90", "172.31.1.91", "172.31.1.92", "172.31.1.93", "172.31.1.94", "172.31.1.95"
  ]
  vm_size             = "Standard_E16s_v5"
  vm_image_id         = data.azurerm_image.rtc_focal.id
  resource_group_name = azurerm_resource_group.vapnik_rg.name
  shared_rg_name      = data.azurerm_resource_group.shared_rg.name
  location            = azurerm_resource_group.vapnik_rg.location
  rtc_net_id          = data.azurerm_subnet.rtc.id
  lb_net_id           = data.azurerm_subnet.lb_net.id
  route_table_name    = data.azurerm_route_table.rtc_mtn.name
  lb_nsg_id           = data.azurerm_network_security_group.lb_nsg.id
  diag_endpoint       = data.azurerm_storage_account.diag_storage.primary_blob_endpoint
  az                  = ""
  admin_ssh_login     = "zeebdo"
  admin_ssh_key       = "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQCw34MCSuEMEnEFPsWsZEnw/YdmyxWD9Sszh7mV2A3WI3gt37ZyaSCeGqgY3xBOSjetKaJiqwmfmF5mP2oGJF+Nz8HUwzdGOqGvhuRJajAfk/HJQ+JUY8x4s9MSi52rd/3J8Oj+eWlCoko21rN/U9YYs09Rf83kOyYr6GwyVXAbSe84Sc6/MVO2dBasD8J7BtN3Y4Jhye+M5Xtm+c/258L2D1vW+cSLbq8q6f0RThVMxJmLCHp9QYT33hN5LhZ22hICAEecKUBwks1vQU6lTIVpPoy7tlOq+BeF3JI30qeFxjEmAzC1QdyCtV/REAKhy9jUliuBt8iVRZYGctyf401D"
}

resource "azuread_group_member" "azuseast1_0021" {
  group_object_id  = data.azuread_group.hosts_grp.id
  member_object_id = module.azuseast1_0021.vm_principal_id
}

module "azuseast1_0022" {
  source        = "./modules/rtc_yt_master"
  walle_project = "yp-useast1-yt-vapnik-vla-master"
  hostname      = "azuseast1-0022"
  host_num      = "22"
  ipv6_addr     = "2a02:6b8:c06:8000:0:604:1:16"
  bb_ipv6_addr  = "2a02:6b8:c2c:b00::badc:ab1e"
  vm_subnet     = "2a02:6b8:c2c:b00::/57"
  mtn_prefix    = "2a02:6b8:c2c:b00::/64"
  lb_subnet     = "172.31.1.96/28"
  lb_gateway    = "172.31.0.1"
  lb_pool = [
    "172.31.1.96", "172.31.1.97", "172.31.1.98", "172.31.1.99", "172.31.1.100", "172.31.1.101", "172.31.1.102", "172.31.1.103", "172.31.1.104", "172.31.1.105", "172.31.1.106", "172.31.1.107", "172.31.1.108", "172.31.1.109", "172.31.1.110", "172.31.1.111"
  ]
  vm_size             = "Standard_E16s_v5"
  vm_image_id         = data.azurerm_image.rtc_focal.id
  resource_group_name = azurerm_resource_group.vapnik_rg.name
  shared_rg_name      = data.azurerm_resource_group.shared_rg.name
  location            = azurerm_resource_group.vapnik_rg.location
  rtc_net_id          = data.azurerm_subnet.rtc.id
  lb_net_id           = data.azurerm_subnet.lb_net.id
  route_table_name    = data.azurerm_route_table.rtc_mtn.name
  lb_nsg_id           = data.azurerm_network_security_group.lb_nsg.id
  diag_endpoint       = data.azurerm_storage_account.diag_storage.primary_blob_endpoint
  az                  = ""
  admin_ssh_login     = "zeebdo"
  admin_ssh_key       = "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQCw34MCSuEMEnEFPsWsZEnw/YdmyxWD9Sszh7mV2A3WI3gt37ZyaSCeGqgY3xBOSjetKaJiqwmfmF5mP2oGJF+Nz8HUwzdGOqGvhuRJajAfk/HJQ+JUY8x4s9MSi52rd/3J8Oj+eWlCoko21rN/U9YYs09Rf83kOyYr6GwyVXAbSe84Sc6/MVO2dBasD8J7BtN3Y4Jhye+M5Xtm+c/258L2D1vW+cSLbq8q6f0RThVMxJmLCHp9QYT33hN5LhZ22hICAEecKUBwks1vQU6lTIVpPoy7tlOq+BeF3JI30qeFxjEmAzC1QdyCtV/REAKhy9jUliuBt8iVRZYGctyf401D"
}

resource "azuread_group_member" "azuseast1_0022" {
  group_object_id  = data.azuread_group.hosts_grp.id
  member_object_id = module.azuseast1_0022.vm_principal_id
}

module "azuseast1_0023" {
  source        = "./modules/rtc_yt_master"
  walle_project = "yp-useast1-yt-vapnik-vla-master"
  hostname      = "azuseast1-0023"
  host_num      = "23"
  ipv6_addr     = "2a02:6b8:c06:8000:0:604:1:17"
  bb_ipv6_addr  = "2a02:6b8:c2c:b80::badc:ab1e"
  vm_subnet     = "2a02:6b8:c2c:b80::/57"
  mtn_prefix    = "2a02:6b8:c2c:b80::/64"
  lb_subnet     = "172.31.1.112/28"
  lb_gateway    = "172.31.0.1"
  lb_pool = [
    "172.31.1.112", "172.31.1.113", "172.31.1.114", "172.31.1.115", "172.31.1.116", "172.31.1.117", "172.31.1.118", "172.31.1.119", "172.31.1.120", "172.31.1.121", "172.31.1.122", "172.31.1.123", "172.31.1.124", "172.31.1.125", "172.31.1.126", "172.31.1.127"
  ]
  vm_size             = "Standard_E16s_v5"
  vm_image_id         = data.azurerm_image.rtc_focal.id
  resource_group_name = azurerm_resource_group.vapnik_rg.name
  shared_rg_name      = data.azurerm_resource_group.shared_rg.name
  location            = azurerm_resource_group.vapnik_rg.location
  rtc_net_id          = data.azurerm_subnet.rtc.id
  lb_net_id           = data.azurerm_subnet.lb_net.id
  route_table_name    = data.azurerm_route_table.rtc_mtn.name
  lb_nsg_id           = data.azurerm_network_security_group.lb_nsg.id
  diag_endpoint       = data.azurerm_storage_account.diag_storage.primary_blob_endpoint
  az                  = ""
  admin_ssh_login     = "zeebdo"
  admin_ssh_key       = "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQCw34MCSuEMEnEFPsWsZEnw/YdmyxWD9Sszh7mV2A3WI3gt37ZyaSCeGqgY3xBOSjetKaJiqwmfmF5mP2oGJF+Nz8HUwzdGOqGvhuRJajAfk/HJQ+JUY8x4s9MSi52rd/3J8Oj+eWlCoko21rN/U9YYs09Rf83kOyYr6GwyVXAbSe84Sc6/MVO2dBasD8J7BtN3Y4Jhye+M5Xtm+c/258L2D1vW+cSLbq8q6f0RThVMxJmLCHp9QYT33hN5LhZ22hICAEecKUBwks1vQU6lTIVpPoy7tlOq+BeF3JI30qeFxjEmAzC1QdyCtV/REAKhy9jUliuBt8iVRZYGctyf401D"
}

resource "azuread_group_member" "azuseast1_0023" {
  group_object_id  = data.azuread_group.hosts_grp.id
  member_object_id = module.azuseast1_0023.vm_principal_id
}

module "azuseast1_0024" {
  source        = "./modules/rtc_yt_master"
  walle_project = "yp-useast1-yt-vapnik-vla-master"
  hostname      = "azuseast1-0024"
  host_num      = "24"
  ipv6_addr     = "2a02:6b8:c06:8000:0:604:1:18"
  bb_ipv6_addr  = "2a02:6b8:c2c:c00::badc:ab1e"
  vm_subnet     = "2a02:6b8:c2c:c00::/57"
  mtn_prefix    = "2a02:6b8:c2c:c00::/64"
  lb_subnet     = "172.31.1.128/28"
  lb_gateway    = "172.31.0.1"
  lb_pool = [
    "172.31.1.128", "172.31.1.129", "172.31.1.130", "172.31.1.131", "172.31.1.132", "172.31.1.133", "172.31.1.134", "172.31.1.135", "172.31.1.136", "172.31.1.137", "172.31.1.138", "172.31.1.139", "172.31.1.140", "172.31.1.141", "172.31.1.142", "172.31.1.143"
  ]
  vm_size             = "Standard_E16s_v5"
  vm_image_id         = data.azurerm_image.rtc_focal.id
  resource_group_name = azurerm_resource_group.vapnik_rg.name
  shared_rg_name      = data.azurerm_resource_group.shared_rg.name
  location            = azurerm_resource_group.vapnik_rg.location
  rtc_net_id          = data.azurerm_subnet.rtc.id
  lb_net_id           = data.azurerm_subnet.lb_net.id
  route_table_name    = data.azurerm_route_table.rtc_mtn.name
  lb_nsg_id           = data.azurerm_network_security_group.lb_nsg.id
  diag_endpoint       = data.azurerm_storage_account.diag_storage.primary_blob_endpoint
  az                  = ""
  admin_ssh_login     = "zeebdo"
  admin_ssh_key       = "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQCw34MCSuEMEnEFPsWsZEnw/YdmyxWD9Sszh7mV2A3WI3gt37ZyaSCeGqgY3xBOSjetKaJiqwmfmF5mP2oGJF+Nz8HUwzdGOqGvhuRJajAfk/HJQ+JUY8x4s9MSi52rd/3J8Oj+eWlCoko21rN/U9YYs09Rf83kOyYr6GwyVXAbSe84Sc6/MVO2dBasD8J7BtN3Y4Jhye+M5Xtm+c/258L2D1vW+cSLbq8q6f0RThVMxJmLCHp9QYT33hN5LhZ22hICAEecKUBwks1vQU6lTIVpPoy7tlOq+BeF3JI30qeFxjEmAzC1QdyCtV/REAKhy9jUliuBt8iVRZYGctyf401D"
}

resource "azuread_group_member" "azuseast1_0024" {
  group_object_id  = data.azuread_group.hosts_grp.id
  member_object_id = module.azuseast1_0024.vm_principal_id
}

module "azuseast1_0030" {
  source        = "./modules/rtc_yt_node"
  walle_project = "yp-useast1-yt-vapnik-vla-nodes"
  hostname      = "azuseast1-0030"
  host_num      = "30"
  ipv6_addr     = "2a02:6b8:c06:8000:0:604:1:1e"
  bb_ipv6_addr  = "2a02:6b8:c2c:f00::badc:ab1e"
  vm_subnet     = "2a02:6b8:c2c:f00::/57"
  mtn_prefix    = "2a02:6b8:c2c:f00::/64"
  lb_subnet     = "172.31.1.224/28"
  lb_gateway    = "172.31.0.1"
  lb_pool = [
    "172.31.1.224", "172.31.1.225", "172.31.1.226", "172.31.1.227", "172.31.1.228", "172.31.1.229", "172.31.1.230", "172.31.1.231", "172.31.1.232", "172.31.1.233", "172.31.1.234", "172.31.1.235", "172.31.1.236", "172.31.1.237", "172.31.1.238", "172.31.1.239"
  ]
  vm_size             = "Standard_E48s_v5"
  vm_image_id         = data.azurerm_image.rtc_focal.id
  resource_group_name = azurerm_resource_group.vapnik_rg.name
  shared_rg_name      = data.azurerm_resource_group.shared_rg.name
  location            = azurerm_resource_group.vapnik_rg.location
  rtc_net_id          = data.azurerm_subnet.rtc.id
  lb_net_id           = data.azurerm_subnet.lb_net.id
  route_table_name    = data.azurerm_route_table.rtc_mtn.name
  lb_nsg_id           = data.azurerm_network_security_group.lb_nsg.id
  diag_endpoint       = data.azurerm_storage_account.diag_storage.primary_blob_endpoint
  az                  = ""
  admin_ssh_login     = "zeebdo"
  admin_ssh_key       = "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQCw34MCSuEMEnEFPsWsZEnw/YdmyxWD9Sszh7mV2A3WI3gt37ZyaSCeGqgY3xBOSjetKaJiqwmfmF5mP2oGJF+Nz8HUwzdGOqGvhuRJajAfk/HJQ+JUY8x4s9MSi52rd/3J8Oj+eWlCoko21rN/U9YYs09Rf83kOyYr6GwyVXAbSe84Sc6/MVO2dBasD8J7BtN3Y4Jhye+M5Xtm+c/258L2D1vW+cSLbq8q6f0RThVMxJmLCHp9QYT33hN5LhZ22hICAEecKUBwks1vQU6lTIVpPoy7tlOq+BeF3JI30qeFxjEmAzC1QdyCtV/REAKhy9jUliuBt8iVRZYGctyf401D"
}

resource "azuread_group_member" "azuseast1_0030" {
  group_object_id  = data.azuread_group.hosts_grp.id
  member_object_id = module.azuseast1_0030.vm_principal_id
}

module "azuseast1_0031" {
  source        = "./modules/rtc_yt_node"
  walle_project = "yp-useast1-yt-vapnik-vla-nodes"
  hostname      = "azuseast1-0031"
  host_num      = "31"
  ipv6_addr     = "2a02:6b8:c06:8000:0:604:1:1f"
  bb_ipv6_addr  = "2a02:6b8:c2c:f80::badc:ab1e"
  vm_subnet     = "2a02:6b8:c2c:f80::/57"
  mtn_prefix    = "2a02:6b8:c2c:f80::/64"
  lb_subnet     = "172.31.1.240/28"
  lb_gateway    = "172.31.0.1"
  lb_pool = [
    "172.31.1.240", "172.31.1.241", "172.31.1.242", "172.31.1.243", "172.31.1.244", "172.31.1.245", "172.31.1.246", "172.31.1.247", "172.31.1.248", "172.31.1.249", "172.31.1.250", "172.31.1.251", "172.31.1.252", "172.31.1.253", "172.31.1.254", "172.31.1.255"
  ]
  vm_size             = "Standard_E48s_v5"
  vm_image_id         = data.azurerm_image.rtc_focal.id
  resource_group_name = azurerm_resource_group.vapnik_rg.name
  shared_rg_name      = data.azurerm_resource_group.shared_rg.name
  location            = azurerm_resource_group.vapnik_rg.location
  rtc_net_id          = data.azurerm_subnet.rtc.id
  lb_net_id           = data.azurerm_subnet.lb_net.id
  route_table_name    = data.azurerm_route_table.rtc_mtn.name
  lb_nsg_id           = data.azurerm_network_security_group.lb_nsg.id
  diag_endpoint       = data.azurerm_storage_account.diag_storage.primary_blob_endpoint
  az                  = ""
  admin_ssh_login     = "zeebdo"
  admin_ssh_key       = "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQCw34MCSuEMEnEFPsWsZEnw/YdmyxWD9Sszh7mV2A3WI3gt37ZyaSCeGqgY3xBOSjetKaJiqwmfmF5mP2oGJF+Nz8HUwzdGOqGvhuRJajAfk/HJQ+JUY8x4s9MSi52rd/3J8Oj+eWlCoko21rN/U9YYs09Rf83kOyYr6GwyVXAbSe84Sc6/MVO2dBasD8J7BtN3Y4Jhye+M5Xtm+c/258L2D1vW+cSLbq8q6f0RThVMxJmLCHp9QYT33hN5LhZ22hICAEecKUBwks1vQU6lTIVpPoy7tlOq+BeF3JI30qeFxjEmAzC1QdyCtV/REAKhy9jUliuBt8iVRZYGctyf401D"
}

resource "azuread_group_member" "azuseast1_0031" {
  group_object_id  = data.azuread_group.hosts_grp.id
  member_object_id = module.azuseast1_0031.vm_principal_id
}

module "azuseast1_0032" {
  source        = "./modules/rtc_yt_node"
  walle_project = "yp-useast1-yt-vapnik-vla-nodes"
  hostname      = "azuseast1-0032"
  host_num      = "32"
  ipv6_addr     = "2a02:6b8:c06:8000:0:604:1:20"
  bb_ipv6_addr  = "2a02:6b8:c2c:1000::badc:ab1e"
  vm_subnet     = "2a02:6b8:c2c:1000::/57"
  mtn_prefix    = "2a02:6b8:c2c:1000::/64"
  lb_subnet     = "172.31.2.0/28"
  lb_gateway    = "172.31.0.1"
  lb_pool = [
    "172.31.2.0", "172.31.2.1", "172.31.2.2", "172.31.2.3", "172.31.2.4", "172.31.2.5", "172.31.2.6", "172.31.2.7", "172.31.2.8", "172.31.2.9", "172.31.2.10", "172.31.2.11", "172.31.2.12", "172.31.2.13", "172.31.2.14", "172.31.2.15"
  ]
  vm_size             = "Standard_E48s_v5"
  vm_image_id         = data.azurerm_image.rtc_focal.id
  resource_group_name = azurerm_resource_group.vapnik_rg.name
  shared_rg_name      = data.azurerm_resource_group.shared_rg.name
  location            = azurerm_resource_group.vapnik_rg.location
  rtc_net_id          = data.azurerm_subnet.rtc.id
  lb_net_id           = data.azurerm_subnet.lb_net.id
  route_table_name    = data.azurerm_route_table.rtc_mtn.name
  lb_nsg_id           = data.azurerm_network_security_group.lb_nsg.id
  diag_endpoint       = data.azurerm_storage_account.diag_storage.primary_blob_endpoint
  az                  = ""
  admin_ssh_login     = "zeebdo"
  admin_ssh_key       = "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQCw34MCSuEMEnEFPsWsZEnw/YdmyxWD9Sszh7mV2A3WI3gt37ZyaSCeGqgY3xBOSjetKaJiqwmfmF5mP2oGJF+Nz8HUwzdGOqGvhuRJajAfk/HJQ+JUY8x4s9MSi52rd/3J8Oj+eWlCoko21rN/U9YYs09Rf83kOyYr6GwyVXAbSe84Sc6/MVO2dBasD8J7BtN3Y4Jhye+M5Xtm+c/258L2D1vW+cSLbq8q6f0RThVMxJmLCHp9QYT33hN5LhZ22hICAEecKUBwks1vQU6lTIVpPoy7tlOq+BeF3JI30qeFxjEmAzC1QdyCtV/REAKhy9jUliuBt8iVRZYGctyf401D"
}

resource "azuread_group_member" "azuseast1_0032" {
  group_object_id  = data.azuread_group.hosts_grp.id
  member_object_id = module.azuseast1_0032.vm_principal_id
}

module "azuseast1_0033" {
  source        = "./modules/rtc_yt_node"
  walle_project = "yp-useast1-yt-vapnik-vla-nodes"
  hostname      = "azuseast1-0033"
  host_num      = "33"
  ipv6_addr     = "2a02:6b8:c06:8000:0:604:1:21"
  bb_ipv6_addr  = "2a02:6b8:c2c:1080::badc:ab1e"
  vm_subnet     = "2a02:6b8:c2c:1080::/57"
  mtn_prefix    = "2a02:6b8:c2c:1080::/64"
  lb_subnet     = "172.31.2.16/28"
  lb_gateway    = "172.31.0.1"
  lb_pool = [
    "172.31.2.16", "172.31.2.17", "172.31.2.18", "172.31.2.19", "172.31.2.20", "172.31.2.21", "172.31.2.22", "172.31.2.23", "172.31.2.24", "172.31.2.25", "172.31.2.26", "172.31.2.27", "172.31.2.28", "172.31.2.29", "172.31.2.30", "172.31.2.31"
  ]
  vm_size             = "Standard_E48s_v5"
  vm_image_id         = data.azurerm_image.rtc_focal.id
  resource_group_name = azurerm_resource_group.vapnik_rg.name
  shared_rg_name      = data.azurerm_resource_group.shared_rg.name
  location            = azurerm_resource_group.vapnik_rg.location
  rtc_net_id          = data.azurerm_subnet.rtc.id
  lb_net_id           = data.azurerm_subnet.lb_net.id
  route_table_name    = data.azurerm_route_table.rtc_mtn.name
  lb_nsg_id           = data.azurerm_network_security_group.lb_nsg.id
  diag_endpoint       = data.azurerm_storage_account.diag_storage.primary_blob_endpoint
  az                  = ""
  admin_ssh_login     = "zeebdo"
  admin_ssh_key       = "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQCw34MCSuEMEnEFPsWsZEnw/YdmyxWD9Sszh7mV2A3WI3gt37ZyaSCeGqgY3xBOSjetKaJiqwmfmF5mP2oGJF+Nz8HUwzdGOqGvhuRJajAfk/HJQ+JUY8x4s9MSi52rd/3J8Oj+eWlCoko21rN/U9YYs09Rf83kOyYr6GwyVXAbSe84Sc6/MVO2dBasD8J7BtN3Y4Jhye+M5Xtm+c/258L2D1vW+cSLbq8q6f0RThVMxJmLCHp9QYT33hN5LhZ22hICAEecKUBwks1vQU6lTIVpPoy7tlOq+BeF3JI30qeFxjEmAzC1QdyCtV/REAKhy9jUliuBt8iVRZYGctyf401D"
}

resource "azuread_group_member" "azuseast1_0033" {
  group_object_id  = data.azuread_group.hosts_grp.id
  member_object_id = module.azuseast1_0033.vm_principal_id
}

module "azuseast1_0034" {
  source        = "./modules/rtc_yt_node"
  walle_project = "yp-useast1-yt-vapnik-vla-nodes"
  hostname      = "azuseast1-0034"
  host_num      = "34"
  ipv6_addr     = "2a02:6b8:c06:8000:0:604:1:22"
  bb_ipv6_addr  = "2a02:6b8:c2c:1100::badc:ab1e"
  vm_subnet     = "2a02:6b8:c2c:1100::/57"
  mtn_prefix    = "2a02:6b8:c2c:1100::/64"
  lb_subnet     = "172.31.2.32/28"
  lb_gateway    = "172.31.0.1"
  lb_pool = [
    "172.31.2.32", "172.31.2.33", "172.31.2.34", "172.31.2.35", "172.31.2.36", "172.31.2.37", "172.31.2.38", "172.31.2.39", "172.31.2.40", "172.31.2.41", "172.31.2.42", "172.31.2.43", "172.31.2.44", "172.31.2.45", "172.31.2.46", "172.31.2.47"
  ]
  vm_size             = "Standard_E48s_v5"
  vm_image_id         = data.azurerm_image.rtc_focal.id
  resource_group_name = azurerm_resource_group.vapnik_rg.name
  shared_rg_name      = data.azurerm_resource_group.shared_rg.name
  location            = azurerm_resource_group.vapnik_rg.location
  rtc_net_id          = data.azurerm_subnet.rtc.id
  lb_net_id           = data.azurerm_subnet.lb_net.id
  route_table_name    = data.azurerm_route_table.rtc_mtn.name
  lb_nsg_id           = data.azurerm_network_security_group.lb_nsg.id
  diag_endpoint       = data.azurerm_storage_account.diag_storage.primary_blob_endpoint
  az                  = ""
  admin_ssh_login     = "zeebdo"
  admin_ssh_key       = "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQCw34MCSuEMEnEFPsWsZEnw/YdmyxWD9Sszh7mV2A3WI3gt37ZyaSCeGqgY3xBOSjetKaJiqwmfmF5mP2oGJF+Nz8HUwzdGOqGvhuRJajAfk/HJQ+JUY8x4s9MSi52rd/3J8Oj+eWlCoko21rN/U9YYs09Rf83kOyYr6GwyVXAbSe84Sc6/MVO2dBasD8J7BtN3Y4Jhye+M5Xtm+c/258L2D1vW+cSLbq8q6f0RThVMxJmLCHp9QYT33hN5LhZ22hICAEecKUBwks1vQU6lTIVpPoy7tlOq+BeF3JI30qeFxjEmAzC1QdyCtV/REAKhy9jUliuBt8iVRZYGctyf401D"
}

resource "azuread_group_member" "azuseast1_0034" {
  group_object_id  = data.azuread_group.hosts_grp.id
  member_object_id = module.azuseast1_0034.vm_principal_id
}

module "azuseast1_0035" {
  source        = "./modules/rtc_yt_node"
  walle_project = "yp-useast1-yt-vapnik-vla-nodes"
  hostname      = "azuseast1-0035"
  host_num      = "35"
  ipv6_addr     = "2a02:6b8:c06:8000:0:604:1:23"
  bb_ipv6_addr  = "2a02:6b8:c2c:1180::badc:ab1e"
  vm_subnet     = "2a02:6b8:c2c:1180::/57"
  mtn_prefix    = "2a02:6b8:c2c:1180::/64"
  lb_subnet     = "172.31.2.48/28"
  lb_gateway    = "172.31.0.1"
  lb_pool = [
    "172.31.2.48", "172.31.2.49", "172.31.2.50", "172.31.2.51", "172.31.2.52", "172.31.2.53", "172.31.2.54", "172.31.2.55", "172.31.2.56", "172.31.2.57", "172.31.2.58", "172.31.2.59", "172.31.2.60", "172.31.2.61", "172.31.2.62", "172.31.2.63"
  ]
  vm_size             = "Standard_E48s_v5"
  vm_image_id         = data.azurerm_image.rtc_focal.id
  resource_group_name = azurerm_resource_group.vapnik_rg.name
  shared_rg_name      = data.azurerm_resource_group.shared_rg.name
  location            = azurerm_resource_group.vapnik_rg.location
  rtc_net_id          = data.azurerm_subnet.rtc.id
  lb_net_id           = data.azurerm_subnet.lb_net.id
  route_table_name    = data.azurerm_route_table.rtc_mtn.name
  lb_nsg_id           = data.azurerm_network_security_group.lb_nsg.id
  diag_endpoint       = data.azurerm_storage_account.diag_storage.primary_blob_endpoint
  az                  = ""
  admin_ssh_login     = "zeebdo"
  admin_ssh_key       = "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQCw34MCSuEMEnEFPsWsZEnw/YdmyxWD9Sszh7mV2A3WI3gt37ZyaSCeGqgY3xBOSjetKaJiqwmfmF5mP2oGJF+Nz8HUwzdGOqGvhuRJajAfk/HJQ+JUY8x4s9MSi52rd/3J8Oj+eWlCoko21rN/U9YYs09Rf83kOyYr6GwyVXAbSe84Sc6/MVO2dBasD8J7BtN3Y4Jhye+M5Xtm+c/258L2D1vW+cSLbq8q6f0RThVMxJmLCHp9QYT33hN5LhZ22hICAEecKUBwks1vQU6lTIVpPoy7tlOq+BeF3JI30qeFxjEmAzC1QdyCtV/REAKhy9jUliuBt8iVRZYGctyf401D"
}

resource "azuread_group_member" "azuseast1_0035" {
  group_object_id  = data.azuread_group.hosts_grp.id
  member_object_id = module.azuseast1_0035.vm_principal_id
}

module "azuseast1_0036" {
  source        = "./modules/rtc_yt_node"
  walle_project = "yp-useast1-yt-vapnik-vla-nodes"
  hostname      = "azuseast1-0036"
  host_num      = "36"
  ipv6_addr     = "2a02:6b8:c06:8000:0:604:1:24"
  bb_ipv6_addr  = "2a02:6b8:c2c:1200::badc:ab1e"
  vm_subnet     = "2a02:6b8:c2c:1200::/57"
  mtn_prefix    = "2a02:6b8:c2c:1200::/64"
  lb_subnet     = "172.31.2.64/28"
  lb_gateway    = "172.31.0.1"
  lb_pool = [
    "172.31.2.64", "172.31.2.65", "172.31.2.66", "172.31.2.67", "172.31.2.68", "172.31.2.69", "172.31.2.70", "172.31.2.71", "172.31.2.72", "172.31.2.73", "172.31.2.74", "172.31.2.75", "172.31.2.76", "172.31.2.77", "172.31.2.78", "172.31.2.79"
  ]
  vm_size             = "Standard_E48s_v5"
  vm_image_id         = data.azurerm_image.rtc_focal.id
  resource_group_name = azurerm_resource_group.vapnik_rg.name
  shared_rg_name      = data.azurerm_resource_group.shared_rg.name
  location            = azurerm_resource_group.vapnik_rg.location
  rtc_net_id          = data.azurerm_subnet.rtc.id
  lb_net_id           = data.azurerm_subnet.lb_net.id
  route_table_name    = data.azurerm_route_table.rtc_mtn.name
  lb_nsg_id           = data.azurerm_network_security_group.lb_nsg.id
  diag_endpoint       = data.azurerm_storage_account.diag_storage.primary_blob_endpoint
  az                  = ""
  admin_ssh_login     = "zeebdo"
  admin_ssh_key       = "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQCw34MCSuEMEnEFPsWsZEnw/YdmyxWD9Sszh7mV2A3WI3gt37ZyaSCeGqgY3xBOSjetKaJiqwmfmF5mP2oGJF+Nz8HUwzdGOqGvhuRJajAfk/HJQ+JUY8x4s9MSi52rd/3J8Oj+eWlCoko21rN/U9YYs09Rf83kOyYr6GwyVXAbSe84Sc6/MVO2dBasD8J7BtN3Y4Jhye+M5Xtm+c/258L2D1vW+cSLbq8q6f0RThVMxJmLCHp9QYT33hN5LhZ22hICAEecKUBwks1vQU6lTIVpPoy7tlOq+BeF3JI30qeFxjEmAzC1QdyCtV/REAKhy9jUliuBt8iVRZYGctyf401D"
}

resource "azuread_group_member" "azuseast1_0036" {
  group_object_id  = data.azuread_group.hosts_grp.id
  member_object_id = module.azuseast1_0036.vm_principal_id
}

module "azuseast1_0037" {
  source        = "./modules/rtc_yt_node"
  walle_project = "yp-useast1-yt-vapnik-vla-nodes"
  hostname      = "azuseast1-0037"
  host_num      = "37"
  ipv6_addr     = "2a02:6b8:c06:8000:0:604:1:25"
  bb_ipv6_addr  = "2a02:6b8:c2c:1280::badc:ab1e"
  vm_subnet     = "2a02:6b8:c2c:1280::/57"
  mtn_prefix    = "2a02:6b8:c2c:1280::/64"
  lb_subnet     = "172.31.2.80/28"
  lb_gateway    = "172.31.0.1"
  lb_pool = [
    "172.31.2.80", "172.31.2.81", "172.31.2.82", "172.31.2.83", "172.31.2.84", "172.31.2.85", "172.31.2.86", "172.31.2.87", "172.31.2.88", "172.31.2.89", "172.31.2.90", "172.31.2.91", "172.31.2.92", "172.31.2.93", "172.31.2.94", "172.31.2.95"
  ]
  vm_size             = "Standard_E48s_v5"
  vm_image_id         = data.azurerm_image.rtc_focal.id
  resource_group_name = azurerm_resource_group.vapnik_rg.name
  shared_rg_name      = data.azurerm_resource_group.shared_rg.name
  location            = azurerm_resource_group.vapnik_rg.location
  rtc_net_id          = data.azurerm_subnet.rtc.id
  lb_net_id           = data.azurerm_subnet.lb_net.id
  route_table_name    = data.azurerm_route_table.rtc_mtn.name
  lb_nsg_id           = data.azurerm_network_security_group.lb_nsg.id
  diag_endpoint       = data.azurerm_storage_account.diag_storage.primary_blob_endpoint
  az                  = ""
  admin_ssh_login     = "zeebdo"
  admin_ssh_key       = "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQCw34MCSuEMEnEFPsWsZEnw/YdmyxWD9Sszh7mV2A3WI3gt37ZyaSCeGqgY3xBOSjetKaJiqwmfmF5mP2oGJF+Nz8HUwzdGOqGvhuRJajAfk/HJQ+JUY8x4s9MSi52rd/3J8Oj+eWlCoko21rN/U9YYs09Rf83kOyYr6GwyVXAbSe84Sc6/MVO2dBasD8J7BtN3Y4Jhye+M5Xtm+c/258L2D1vW+cSLbq8q6f0RThVMxJmLCHp9QYT33hN5LhZ22hICAEecKUBwks1vQU6lTIVpPoy7tlOq+BeF3JI30qeFxjEmAzC1QdyCtV/REAKhy9jUliuBt8iVRZYGctyf401D"
}

resource "azuread_group_member" "azuseast1_0037" {
  group_object_id  = data.azuread_group.hosts_grp.id
  member_object_id = module.azuseast1_0037.vm_principal_id
}

module "azuseast1_0038" {
  source        = "./modules/rtc_yt_node"
  walle_project = "yp-useast1-yt-vapnik-vla-nodes"
  hostname      = "azuseast1-0038"
  host_num      = "38"
  ipv6_addr     = "2a02:6b8:c06:8000:0:604:1:26"
  bb_ipv6_addr  = "2a02:6b8:c2c:1300::badc:ab1e"
  vm_subnet     = "2a02:6b8:c2c:1300::/57"
  mtn_prefix    = "2a02:6b8:c2c:1300::/64"
  lb_subnet     = "172.31.2.96/28"
  lb_gateway    = "172.31.0.1"
  lb_pool = [
    "172.31.2.96", "172.31.2.97", "172.31.2.98", "172.31.2.99", "172.31.2.100", "172.31.2.101", "172.31.2.102", "172.31.2.103", "172.31.2.104", "172.31.2.105", "172.31.2.106", "172.31.2.107", "172.31.2.108", "172.31.2.109", "172.31.2.110", "172.31.2.111"
  ]
  vm_size             = "Standard_E48s_v5"
  vm_image_id         = data.azurerm_image.rtc_focal.id
  resource_group_name = azurerm_resource_group.vapnik_rg.name
  shared_rg_name      = data.azurerm_resource_group.shared_rg.name
  location            = azurerm_resource_group.vapnik_rg.location
  rtc_net_id          = data.azurerm_subnet.rtc.id
  lb_net_id           = data.azurerm_subnet.lb_net.id
  route_table_name    = data.azurerm_route_table.rtc_mtn.name
  lb_nsg_id           = data.azurerm_network_security_group.lb_nsg.id
  diag_endpoint       = data.azurerm_storage_account.diag_storage.primary_blob_endpoint
  az                  = ""
  admin_ssh_login     = "zeebdo"
  admin_ssh_key       = "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQCw34MCSuEMEnEFPsWsZEnw/YdmyxWD9Sszh7mV2A3WI3gt37ZyaSCeGqgY3xBOSjetKaJiqwmfmF5mP2oGJF+Nz8HUwzdGOqGvhuRJajAfk/HJQ+JUY8x4s9MSi52rd/3J8Oj+eWlCoko21rN/U9YYs09Rf83kOyYr6GwyVXAbSe84Sc6/MVO2dBasD8J7BtN3Y4Jhye+M5Xtm+c/258L2D1vW+cSLbq8q6f0RThVMxJmLCHp9QYT33hN5LhZ22hICAEecKUBwks1vQU6lTIVpPoy7tlOq+BeF3JI30qeFxjEmAzC1QdyCtV/REAKhy9jUliuBt8iVRZYGctyf401D"
}

resource "azuread_group_member" "azuseast1_0038" {
  group_object_id  = data.azuread_group.hosts_grp.id
  member_object_id = module.azuseast1_0038.vm_principal_id
}
