resource "azurerm_public_ip_prefix" "lavka_public_prefix" {
  resource_group_name = data.azurerm_resource_group.lavka_rg.name
  location = data.azurerm_resource_group.lavka_rg.location
  name = "lavka-l3-lb-prefix"
  prefix_length = 29
}

module "lavka_proxy_lb" {
   source        = "./modules/l3lb"
   rg_name = data.azurerm_resource_group.lavka_rg.name
   location = data.azurerm_resource_group.lavka_rg.location
   lb_prefix_id = azurerm_public_ip_prefix.lavka_public_prefix.id
   balancer_name = "lavka-lb1"
   vnet_id = data.azurerm_virtual_network.shared_vnet.id
   dummy_address = "172.29.255.247"
   hosts_grp_id = data.azuread_group.hosts_grp.id
}
