resource "azurerm_resource_group" "metrika_rg" {
  name     = "rtc-cloud-az-westeu-metrika"
  location = "westeurope"
}

module "westeu_0007" {
  source        = "./modules/rtc_v3"
  walle_project = "yp-westeu-vla"
  hostname      = "westeu-0007"
  host_num      = "7"
  ipv6_addr     = "2a02:6b8:c30:80:0:604:1:7"
  bb_ipv6_addr  = "2a02:6b8:c31:300::badc:ab1e"
  vm_subnet     = "2a02:6b8:c31:300::/57"
  mtn_prefix    = "2a02:6b8:c31:300::/64"
  lb_subnet     = "172.29.0.112/28"
  lb_gateway    = "172.29.0.1"
  lb_pool = [
	"172.29.0.112", "172.29.0.113", "172.29.0.114", "172.29.0.115", "172.29.0.116", "172.29.0.117", "172.29.0.118", "172.29.0.119", "172.29.0.120", "172.29.0.121", "172.29.0.122", "172.29.0.123", "172.29.0.124", "172.29.0.125", "172.29.0.126", "172.29.0.127"
  ]
  vm_size             = "Standard_E64s_v3"
  vm_image_id         = data.azurerm_image.rtc_focal.id
  resource_group_name = azurerm_resource_group.metrika_rg.name
  shared_rg_name      = data.azurerm_resource_group.shared_rg.name
  location            = azurerm_resource_group.metrika_rg.location
  rtc_net_id          = data.azurerm_subnet.rtc.id
  lb_net_id           = data.azurerm_subnet.lb_net.id
  route_table_name    = data.azurerm_route_table.rtc_mtn.name
  lb_nsg_id           = data.azurerm_network_security_group.lb_nsg.id
  diag_endpoint       = data.azurerm_storage_account.diag_storage.primary_blob_endpoint
  # admin_ssh_key       = "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQDJWfn/60SOVh3FUcUpfaApLZRWF7nis19ra1QC7cf/YwW1tVBLMm/AHmNTpM12njPjbh/vZVcoOzv74lLPpU9zvBWiPaPMh9Tzxn0KsZNglVxv9pyghrgh8rICFg9ZWiKCMCg6hhqQoTryJRlXR44RRisdG14ImvYkKx2Gwp3lT2sFzhJwcWFwCcuyP2zpXgtx+URS+nJsUAbfVdB6llZ8zV8k5BRopRjmKWjWxkwyd0UEe1pRNf4PV9ywdupFzwMbH7bb/cTAZv2MEcA+wgYEcxlOjGCwk0Xya5w/FWDK8RQwLxB5vxGTBHmiVcuvSNUCD4YBJGG3FDdQZPpc8kIh"
  # admin_ssh_login     = "evgenyemets"
  zone                = "1"
}

resource "azuread_group_member" "westeu_0007" {
  group_object_id  = data.azuread_group.hosts_grp.id
  member_object_id = module.westeu_0007.vm_principal_id
}

module "westeu_0008" {
  source        = "./modules/rtc_v3"
  walle_project = "yp-westeu-vla"
  hostname      = "westeu-0008"
  host_num      = "8"
  ipv6_addr     = "2a02:6b8:c30:80:0:604:1:8"
  bb_ipv6_addr  = "2a02:6b8:c31:380::badc:ab1e"
  vm_subnet     = "2a02:6b8:c31:380::/57"
  mtn_prefix    = "2a02:6b8:c31:380::/64"
  lb_subnet     = "172.29.0.128/28"
  lb_gateway    = "172.29.0.1"
  lb_pool = [
	"172.29.0.128", "172.29.0.129", "172.29.0.130", "172.29.0.131", "172.29.0.132", "172.29.0.133", "172.29.0.134", "172.29.0.135", "172.29.0.136", "172.29.0.137", "172.29.0.138", "172.29.0.139", "172.29.0.140", "172.29.0.141", "172.29.0.142", "172.29.0.143"
  ]
  vm_size             = "Standard_E64s_v3"
  vm_image_id         = data.azurerm_image.rtc_focal.id
  resource_group_name = azurerm_resource_group.metrika_rg.name
  shared_rg_name      = data.azurerm_resource_group.shared_rg.name
  location            = azurerm_resource_group.metrika_rg.location
  rtc_net_id          = data.azurerm_subnet.rtc.id
  lb_net_id           = data.azurerm_subnet.lb_net.id
  route_table_name    = data.azurerm_route_table.rtc_mtn.name
  lb_nsg_id           = data.azurerm_network_security_group.lb_nsg.id
  diag_endpoint       = data.azurerm_storage_account.diag_storage.primary_blob_endpoint
  # admin_ssh_key       = "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQDJWfn/60SOVh3FUcUpfaApLZRWF7nis19ra1QC7cf/YwW1tVBLMm/AHmNTpM12njPjbh/vZVcoOzv74lLPpU9zvBWiPaPMh9Tzxn0KsZNglVxv9pyghrgh8rICFg9ZWiKCMCg6hhqQoTryJRlXR44RRisdG14ImvYkKx2Gwp3lT2sFzhJwcWFwCcuyP2zpXgtx+URS+nJsUAbfVdB6llZ8zV8k5BRopRjmKWjWxkwyd0UEe1pRNf4PV9ywdupFzwMbH7bb/cTAZv2MEcA+wgYEcxlOjGCwk0Xya5w/FWDK8RQwLxB5vxGTBHmiVcuvSNUCD4YBJGG3FDdQZPpc8kIh"
  # admin_ssh_login     = "evgenyemets"
  zone                = "2"
}

resource "azuread_group_member" "westeu_0008" {
  group_object_id  = data.azuread_group.hosts_grp.id
  member_object_id = module.westeu_0008.vm_principal_id
}

module "westeu_0009" {
  source        = "./modules/rtc_v3"
  walle_project = "yp-westeu-vla"
  hostname      = "westeu-0009"
  host_num      = "9"
  ipv6_addr     = "2a02:6b8:c30:80:0:604:1:9"
  bb_ipv6_addr  = "2a02:6b8:c31:400::badc:ab1e"
  vm_subnet     = "2a02:6b8:c31:400::/57"
  mtn_prefix    = "2a02:6b8:c31:400::/64"
  lb_subnet     = "172.29.0.144/28"
  lb_gateway    = "172.29.0.1"
  lb_pool = [
	"172.29.0.144", "172.29.0.145", "172.29.0.146", "172.29.0.147", "172.29.0.148", "172.29.0.149", "172.29.0.150", "172.29.0.151", "172.29.0.152", "172.29.0.153", "172.29.0.154", "172.29.0.155", "172.29.0.156", "172.29.0.157", "172.29.0.158", "172.29.0.159"
  ]
  vm_size             = "Standard_E64s_v3"
  vm_image_id         = data.azurerm_image.rtc_focal.id
  resource_group_name = azurerm_resource_group.metrika_rg.name
  shared_rg_name      = data.azurerm_resource_group.shared_rg.name
  location            = azurerm_resource_group.metrika_rg.location
  rtc_net_id          = data.azurerm_subnet.rtc.id
  lb_net_id           = data.azurerm_subnet.lb_net.id
  route_table_name    = data.azurerm_route_table.rtc_mtn.name
  lb_nsg_id           = data.azurerm_network_security_group.lb_nsg.id
  diag_endpoint       = data.azurerm_storage_account.diag_storage.primary_blob_endpoint
  # admin_ssh_key       = "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAABAQDJWfn/60SOVh3FUcUpfaApLZRWF7nis19ra1QC7cf/YwW1tVBLMm/AHmNTpM12njPjbh/vZVcoOzv74lLPpU9zvBWiPaPMh9Tzxn0KsZNglVxv9pyghrgh8rICFg9ZWiKCMCg6hhqQoTryJRlXR44RRisdG14ImvYkKx2Gwp3lT2sFzhJwcWFwCcuyP2zpXgtx+URS+nJsUAbfVdB6llZ8zV8k5BRopRjmKWjWxkwyd0UEe1pRNf4PV9ywdupFzwMbH7bb/cTAZv2MEcA+wgYEcxlOjGCwk0Xya5w/FWDK8RQwLxB5vxGTBHmiVcuvSNUCD4YBJGG3FDdQZPpc8kIh"
  # admin_ssh_login     = "evgenyemets"
  zone                = "3"
}

resource "azuread_group_member" "westeu_0009" {
  group_object_id  = data.azuread_group.hosts_grp.id
  member_object_id = module.westeu_0009.vm_principal_id
}
