data "azurerm_public_ip_prefix" "metrika_public_prefix" {
  resource_group_name = azurerm_resource_group.metrika_rg.name
  name = "l3-lb-prefix"
}

module "emc_lb" {
   source        = "./modules/l3lb"
   rg_name = azurerm_resource_group.metrika_rg.name
   location = azurerm_resource_group.metrika_rg.location
   lb_prefix_id = data.azurerm_public_ip_prefix.metrika_public_prefix.id
   balancer_name = "emc.yandex.com"
   vnet_id = data.azurerm_virtual_network.shared_vnet.id
   dummy_address = "172.29.255.246"
   hosts_grp_id = data.azuread_group.hosts_grp.id
}

module "report_lb" {
   source        = "./modules/l3lb"
   rg_name = azurerm_resource_group.metrika_rg.name
   location = azurerm_resource_group.metrika_rg.location
   lb_prefix_id = data.azurerm_public_ip_prefix.metrika_public_prefix.id
   balancer_name = "report.appmetrica.com"
   vnet_id = data.azurerm_virtual_network.shared_vnet.id
   dummy_address = "172.29.255.245"
   hosts_grp_id = data.azuread_group.hosts_grp.id
}

module "rb_lb" {
   source        = "./modules/l3lb"
   rg_name = azurerm_resource_group.metrika_rg.name
   location = azurerm_resource_group.metrika_rg.location
   lb_prefix_id = data.azurerm_public_ip_prefix.metrika_public_prefix.id
   balancer_name = "rb.appmetrica.com"
   vnet_id = data.azurerm_virtual_network.shared_vnet.id
   dummy_address = "172.29.255.244"
   hosts_grp_id = data.azuread_group.hosts_grp.id
}
