resource "azurerm_public_ip_prefix" "plus_public_prefix" {
  resource_group_name = data.azurerm_resource_group.plus_rg.name
  location = data.azurerm_resource_group.plus_rg.location
  name = "plus-l3-lb-prefix"
  prefix_length = 29
}

module "plus_front_proxy_lb" {
   source        = "./modules/l3lb"
   rg_name = data.azurerm_resource_group.plus_rg.name
   location = data.azurerm_resource_group.plus_rg.location
   lb_prefix_id = azurerm_public_ip_prefix.plus_public_prefix.id
   balancer_name = "plus-front"
   vnet_id = data.azurerm_virtual_network.shared_vnet.id
   dummy_address = "172.29.255.250"
   hosts_grp_id = data.azuread_group.hosts_grp.id
}

module "plus_back_proxy_lb" {
   source        = "./modules/l3lb"
   rg_name = data.azurerm_resource_group.plus_rg.name
   location = data.azurerm_resource_group.plus_rg.location
   lb_prefix_id = azurerm_public_ip_prefix.plus_public_prefix.id
   balancer_name = "plus-back"
   vnet_id = data.azurerm_virtual_network.shared_vnet.id
   dummy_address = "172.29.255.249"
   hosts_grp_id = data.azuread_group.hosts_grp.id
}

module "plus_static_proxy_lb" {
   source        = "./modules/l3lb"
   rg_name = data.azurerm_resource_group.plus_rg.name
   location = data.azurerm_resource_group.plus_rg.location
   lb_prefix_id = azurerm_public_ip_prefix.plus_public_prefix.id
   balancer_name = "plus-static"
   vnet_id = data.azurerm_virtual_network.shared_vnet.id
   dummy_address = "172.29.255.248"
   hosts_grp_id = data.azuread_group.hosts_grp.id
}
