resource "azurerm_resource_group" "taxi_rg" {
  name     = "rtc-cloud-az-westeu-taxi"
  location = "westeurope"
}

module "westeu_0004" {
  source        = "./modules/rtc_v2"
  walle_project = "yp-westeu-vla"
  hostname      = "westeu-0004"
  host_num      = "4"
  ipv6_addr     = "2a02:6b8:c30:80:0:604:1:4"
  bb_ipv6_addr  = "2a02:6b8:c31:180::badc:ab1e"
  vm_subnet     = "2a02:6b8:c31:180::/57"
  mtn_prefix    = "2a02:6b8:c31:180::/64"
  lb_subnet     = "172.29.0.64/28"
  lb_gateway    = "172.29.0.1"
  lb_pool = [
    "172.29.0.64", "172.29.0.65", "172.29.0.66", "172.29.0.67", "172.29.0.68", "172.29.0.69", "172.29.0.70", "172.29.0.71", "172.29.0.72", "172.29.0.73", "172.29.0.74", "172.29.0.75", "172.29.0.76", "172.29.0.77", "172.29.0.78", "172.29.0.79"
  ]
  vm_size             = "Standard_F32s_v2"
  vm_image_id         = data.azurerm_image.rtc_focal.id
  resource_group_name = azurerm_resource_group.taxi_rg.name
  shared_rg_name      = data.azurerm_resource_group.shared_rg.name
  location            = azurerm_resource_group.taxi_rg.location
  rtc_net_id          = data.azurerm_subnet.rtc.id
  lb_net_id           = data.azurerm_subnet.lb_net.id
  route_table_name    = data.azurerm_route_table.rtc_mtn.name
  lb_nsg_id           = data.azurerm_network_security_group.lb_nsg.id
  diag_endpoint       = data.azurerm_storage_account.diag_storage.primary_blob_endpoint
}

resource "azuread_group_member" "westeu_0004" {
  group_object_id  = data.azuread_group.hosts_grp.id
  member_object_id = module.westeu_0004.vm_principal_id
}



module "westeu_0005" {
  source        = "./modules/rtc_v2"
  walle_project = "yp-westeu-vla"
  hostname      = "westeu-0005"
  host_num      = "5"
  ipv6_addr     = "2a02:6b8:c30:80:0:604:1:5"
  bb_ipv6_addr  = "2a02:6b8:c31:200::badc:ab1e"
  vm_subnet     = "2a02:6b8:c31:200::/57"
  mtn_prefix    = "2a02:6b8:c31:200::/64"
  lb_subnet     = "172.29.0.80/28"
  lb_gateway    = "172.29.0.1"
  lb_pool = [
    "172.29.0.80", "172.29.0.81", "172.29.0.82", "172.29.0.83", "172.29.0.84", "172.29.0.85", "172.29.0.86", "172.29.0.87", "172.29.0.88", "172.29.0.89", "172.29.0.90", "172.29.0.91", "172.29.0.92", "172.29.0.93", "172.29.0.94", "172.29.0.95"
  ]
  vm_size             = "Standard_F32s_v2"
  vm_image_id         = data.azurerm_image.rtc_focal.id
  resource_group_name = azurerm_resource_group.taxi_rg.name
  shared_rg_name      = data.azurerm_resource_group.shared_rg.name
  location            = azurerm_resource_group.taxi_rg.location
  rtc_net_id          = data.azurerm_subnet.rtc.id
  lb_net_id           = data.azurerm_subnet.lb_net.id
  route_table_name    = data.azurerm_route_table.rtc_mtn.name
  lb_nsg_id           = data.azurerm_network_security_group.lb_nsg.id
  diag_endpoint       = data.azurerm_storage_account.diag_storage.primary_blob_endpoint
}

resource "azuread_group_member" "westeu_0005" {
  group_object_id  = data.azuread_group.hosts_grp.id
  member_object_id = module.westeu_0005.vm_principal_id
}



module "westeu_0006" {
  source        = "./modules/rtc_v2"
  walle_project = "yp-westeu-vla"
  hostname      = "westeu-0006"
  host_num      = "6"
  ipv6_addr     = "2a02:6b8:c30:80:0:604:1:6"
  bb_ipv6_addr  = "2a02:6b8:c31:280::badc:ab1e"
  vm_subnet     = "2a02:6b8:c31:280::/57"
  mtn_prefix    = "2a02:6b8:c31:280::/64"
  lb_subnet     = "172.29.0.96/28"
  lb_gateway    = "172.29.0.1"
  lb_pool = [
    "172.29.0.96", "172.29.0.97", "172.29.0.98", "172.29.0.99", "172.29.0.100", "172.29.0.101", "172.29.0.102", "172.29.0.103", "172.29.0.104", "172.29.0.105", "172.29.0.106", "172.29.0.107", "172.29.0.108", "172.29.0.109", "172.29.0.110", "172.29.0.111"
  ]
  vm_size             = "Standard_F32s_v2"
  vm_image_id         = data.azurerm_image.rtc_focal.id
  resource_group_name = azurerm_resource_group.taxi_rg.name
  shared_rg_name      = data.azurerm_resource_group.shared_rg.name
  location            = azurerm_resource_group.taxi_rg.location
  rtc_net_id          = data.azurerm_subnet.rtc.id
  lb_net_id           = data.azurerm_subnet.lb_net.id
  route_table_name    = data.azurerm_route_table.rtc_mtn.name
  lb_nsg_id           = data.azurerm_network_security_group.lb_nsg.id
  diag_endpoint       = data.azurerm_storage_account.diag_storage.primary_blob_endpoint
}

resource "azuread_group_member" "westeu_0006" {
  group_object_id  = data.azuread_group.hosts_grp.id
  member_object_id = module.westeu_0006.vm_principal_id
}
