
resource "azurerm_resource_group" "shared_rg" {
  name     = "rtc-cloud-az-westeu-shared"
  location = "westeurope"
}

resource "azurerm_network_security_group" "lb_nsg" {
  name                = "lb_nsg"
  location            = azurerm_resource_group.shared_rg.location
  resource_group_name = azurerm_resource_group.shared_rg.name

  security_rule {
    name                       = "http"
    priority                   = 100
    direction                  = "Inbound"
    access                     = "Allow"
    protocol                   = "Tcp"
    source_port_range          = "*"
    destination_port_range     = "80"
    source_address_prefix      = "*"
    destination_address_prefix = "*"
  }

  security_rule {
    name                       = "https"
    priority                   = 101
    direction                  = "Inbound"
    access                     = "Allow"
    protocol                   = "Tcp"
    source_port_range          = "*"
    destination_port_range     = "443"
    source_address_prefix      = "*"
    destination_address_prefix = "*"
  }
}

resource "azurerm_virtual_network" "shared_vnet" {
  name                = "rtc-cloud-az-er3"
  address_space       = ["10.4.0.0/16", "172.29.0.0/16", "2a02:6b8:c30::/48", "2a02:6b8:c31::/48", "fc00:1000::/64"]
  location            = "westeurope"
  resource_group_name = azurerm_resource_group.shared_rg.name

}

resource "azurerm_subnet" "GatewaySubnet" {
  virtual_network_name = azurerm_virtual_network.shared_vnet.name
  resource_group_name  = azurerm_resource_group.shared_rg.name
  name                 = "GatewaySubnet"
  address_prefixes     = ["10.4.64.0/24", "2a02:6b8:c30::/64"]
}

resource "azurerm_subnet" "lb_net" {
  virtual_network_name = azurerm_virtual_network.shared_vnet.name
  name                 = "lb-net"
  resource_group_name  = azurerm_resource_group.shared_rg.name
  address_prefixes     = ["172.29.0.0/19"]
}

resource "azurerm_subnet" "lb_net6" {
  virtual_network_name = azurerm_virtual_network.shared_vnet.name
  name                 = "lb-net6"
  resource_group_name  = azurerm_resource_group.shared_rg.name
  address_prefixes     = ["10.4.2.0/23", "fc00:1000::/64"]
}

resource "azurerm_subnet" "rtc" {
  resource_group_name  = azurerm_resource_group.shared_rg.name
  virtual_network_name = azurerm_virtual_network.shared_vnet.name
  name                 = "default"
  address_prefixes     = ["10.4.0.0/23", "2a02:6b8:c30:80::/64"]
}

resource "azurerm_route_table" "rtc_mtn" {
  name                = "rtc-mtn-rt"
  resource_group_name = azurerm_resource_group.shared_rg.name
  location            = azurerm_resource_group.shared_rg.location
}

resource "azurerm_storage_account" "diag_storage" {
  name                     = "rtccloudazwesteudiag"
  resource_group_name      = azurerm_resource_group.shared_rg.name
  location                 = azurerm_resource_group.shared_rg.location
  account_tier             = "Standard"
  account_replication_type = "LRS"
  account_kind             = "Storage"
  min_tls_version          = "TLS1_2"
}

resource "azurerm_storage_account" "images_storage" {
  name                     = "rtccloudazwesteuimages"
  resource_group_name      = azurerm_resource_group.shared_rg.name
  location                 = azurerm_resource_group.shared_rg.location
  account_tier             = "Standard"
  account_replication_type = "LRS"
  account_kind             = "Storage"
  min_tls_version          = "TLS1_2"
}

data "azurerm_image" "rtc_focal" {
  name                = "rtc-focal"
  resource_group_name = azurerm_resource_group.shared_rg.name
}

resource "azuread_group" "hosts_grp" {
  display_name     = "rtc-cloud-az-westeu-hosts"
  security_enabled = true
}
