resource "azurerm_resource_group" "taxi_rg" {
  name     = "rtc-cloud-az-westeu-taxi"
  location = "westeurope"
}

module "westeu_0001" {
  source = "./modules/rtc"

  hostname     = "westeu-0001"
  host_num     = "1"
  ipv6_addr    = "2a02:6b8:c30:80:0:604:1:1"
  bb_ipv6_addr = "2a02:6b8:c31::badc:ab1e"
  vm_subnet    = "2a02:6b8:c31::/57"
  mtn_prefix   = "2a02:6b8:c31::/64"
  lb_subnet    = "172.29.0.16/28"
  lb_gateway   = "172.29.0.1"
  lb_pool = [
    "172.29.0.16", "172.29.0.17", "172.29.0.18", "172.29.0.19", "172.29.0.20",
    "172.29.0.21", "172.29.0.22", "172.29.0.23", "172.29.0.24", "172.29.0.25",
    "172.29.0.26", "172.29.0.27", "172.29.0.28", "172.29.0.29", "172.29.0.30", "172.29.0.31"
  ]
  vm_size             = "Standard_F64s_v2"
  place_size          = 1024
  vm_image_id         = data.azurerm_image.rtc_focal.id
  resource_group_name = azurerm_resource_group.taxi_rg.name
  shared_rg_name      = azurerm_resource_group.shared_rg.name
  location            = azurerm_resource_group.taxi_rg.location
  rtc_net_id          = azurerm_subnet.rtc.id
  lb_net_id           = azurerm_subnet.lb_net.id
  route_table_name    = azurerm_route_table.rtc_mtn.name
  lb_nsg_id           = azurerm_network_security_group.lb_nsg.id
  diag_endpoint       = azurerm_storage_account.diag_storage.primary_blob_endpoint
}

resource "azuread_group_member" "westeu_0001" {
  group_object_id  = azuread_group.hosts_grp.id
  member_object_id = module.westeu_0001.vm_principal_id
}

module "westeu_0002" {
  source = "./modules/rtc"

  hostname     = "westeu-0002"
  host_num     = "1"
  ipv6_addr    = "2a02:6b8:c30:80:0:604:1:2"
  bb_ipv6_addr = "2a02:6b8:c31:80::badc:ab1e"
  vm_subnet    = "2a02:6b8:c31:80::/57"
  mtn_prefix   = "2a02:6b8:c31:80::/64"
  lb_subnet    = "172.29.0.32/28"
  lb_gateway   = "172.29.0.1"
  lb_pool = [
     "172.29.0.32", "172.29.0.33", "172.29.0.34", "172.29.0.35", "172.29.0.36", 
     "172.29.0.37", "172.29.0.38", "172.29.0.39", "172.29.0.40", "172.29.0.41",
     "172.29.0.42", "172.29.0.43", "172.29.0.44", "172.29.0.45", "172.29.0.46", "172.29.0.47"
  ]
  vm_size             = "Standard_F64s_v2"
  place_size          = 1024
  vm_image_id         = data.azurerm_image.rtc_focal.id
  resource_group_name = azurerm_resource_group.taxi_rg.name
  shared_rg_name      = azurerm_resource_group.shared_rg.name
  location            = azurerm_resource_group.taxi_rg.location
  rtc_net_id          = azurerm_subnet.rtc.id
  lb_net_id           = azurerm_subnet.lb_net.id
  route_table_name    = azurerm_route_table.rtc_mtn.name
  lb_nsg_id           = azurerm_network_security_group.lb_nsg.id
  diag_endpoint       = azurerm_storage_account.diag_storage.primary_blob_endpoint
}

resource "azuread_group_member" "westeu_0002" {
  group_object_id  = azuread_group.hosts_grp.id
  member_object_id = module.westeu_0002.vm_principal_id
}

module "westeu_0003" {
  source = "./modules/rtc"

  hostname     = "westeu-0003"
  host_num     = "1"
  ipv6_addr    = "2a02:6b8:c30:80:0:604:1:3"
  bb_ipv6_addr = "2a02:6b8:c31:100::badc:ab1e"
  vm_subnet    = "2a02:6b8:c31:100::/57"
  mtn_prefix   = "2a02:6b8:c31:100::/64"
  lb_subnet    = "172.29.0.48/28"
  lb_gateway   = "172.29.0.1"
  lb_pool = [
    "172.29.0.48", "172.29.0.49", "172.29.0.50", "172.29.0.51", "172.29.0.52", 
    "172.29.0.53", "172.29.0.54", "172.29.0.55", "172.29.0.56", "172.29.0.57", 
    "172.29.0.58", "172.29.0.59", "172.29.0.60", "172.29.0.61", "172.29.0.62", "172.29.0.63"
  ]
  vm_size             = "Standard_F64s_v2"
  place_size          = 1024
  vm_image_id         = data.azurerm_image.rtc_focal.id
  resource_group_name = azurerm_resource_group.taxi_rg.name
  shared_rg_name      = azurerm_resource_group.shared_rg.name
  location            = azurerm_resource_group.taxi_rg.location
  rtc_net_id          = azurerm_subnet.rtc.id
  lb_net_id           = azurerm_subnet.lb_net.id
  route_table_name    = azurerm_route_table.rtc_mtn.name
  lb_nsg_id           = azurerm_network_security_group.lb_nsg.id
  diag_endpoint       = azurerm_storage_account.diag_storage.primary_blob_endpoint
}

resource "azuread_group_member" "westeu_0003" {
  group_object_id  = azuread_group.hosts_grp.id
  member_object_id = module.westeu_0003.vm_principal_id
}