#!/bin/bash

hostnamectl set-hostname azuseast1-0005.rtc-oc.yandex.net

cat <<'EOF' > /etc/network/interfaces.d/50-cloud-init.cfg
# This file is generated from information provided by the datasource.  Changes
# to it will not persist across an instance reboot.  To disable cloud-init's
# network configuration capabilities, write a file
# /etc/cloud/cloud.cfg.d/99-disable-network-config.cfg with the following:
# network: {config: disabled}
auto lo lo:700 lo:766
iface lo inet loopback

iface lo:700 inet6 static
   address fc00:5::1/64

iface lo:766 inet6 static
   address fc01:5::1/64

auto eth0
iface eth0 inet dhcp
    metric 100

# control-alias eth0
iface eth0 inet6 static
    address 2a02:6b8:c06:8000:0:604:1:5/64
    dad-attempts 0
    post-up /sbin/ip -6 route replace default via fe80::1234:5678:9abc dev eth0 src 2a02:6b8:c06:8000:0:604:1:5
    pre-down /sbin/ip -6 r del default via fe80::1234:5678:9abc dev eth0 src 2a02:6b8:c06:8000:0:604:1:5

iface eth0 inet6 static
    address 2a02:6b8:c2c:200::badc:ab1e/64
    dad-attempts 0

auto eth1
iface eth1 inet manual
EOF
echo 'network: {config: disabled}' > /etc/cloud/cloud.cfg.d/99-disable-network-config.cfg

systemctl restart networking
apt-get update
mkdir -p /etc/hostman/repo-override/search_runtime
cat <<'EOF' > /etc/hostman/repo-override/search_runtime/top.sls
search_runtime:
  '*':
    - hostctl:apt
    - hostctl:upstream-packages
    - hostctl:yandex-packages
    - deploy.ya-salt
    - hostctl:timezone-sync
    - hostctl:network-interrupts
    - hostctl:yandex-rtc-kvm
    - hostctl:systemd-modules-load
    - hostctl:modules-refresh
    - hostctl:systemd-sysctl
    - hostctl:sysctl-refresh
    - hostctl:logrotate
    - hostctl:cauth
    - hostctl:yandex-dns-manager
    - hostctl:yandex-rtc-nodeinfo-data
    - hostctl:yandex-diskmanager
    - hostctl:postfix
    - hostctl:yandex-porto
    - hostctl:yandex-solomon-sysmond
    - hostctl:atop
    - hostctl:juggler-agent-rtc
    - hostctl:yandex-hbf-agent
    - hostctl:hbf-metrics-pusher
    - hostctl:yasmagent_11003
    - hostctl:yandex-sysconf
    - hostctl:systemd-journald
    - hostctl:lldpd
    - hostctl:ntp
    - hostctl:rsyslog
    - hostctl:ssh
    - hostctl:yandex-rtc-certman
    - hostctl:yandex-rtc-duty-perms
    - hostctl:yandex-rtc-juggler-bundle
    - hostctl:yandex-rtc-pam-sshd
    - hostctl:ebpf-agent
    - hostctl:gideon
    - hostctl:portostatd
    - hostctl:yandex-coroner
    - hostctl:tcp-sampler
    - hostctl:yandex-rtc-nodeinfo
    - hostctl:yandex-iss-agent
    - virtual:hostctl
EOF

sgdisk -N 0 /dev/sdc
partx -u /dev/sdc
mkfs.ext4 /dev/sdc1
echo "UUID=$(blkid /dev/sdc1 | sed -E -e 's/.*UUID="(.*)" TYPE.*/\1/') /place ext4 barrier=1,noatime,lazytime,nosuid,nodev 0 2" >> /etc/fstab
mount /place
mkdir /place/berkanavt
mkdir /place/coredumps

apt-get install -y yandex-search-salt
rm -fv /var/lib/ya-salt/__need_initial_setup__
ya-salt run
apt-get install -y linux-image-server=5.4.161-26.3 linux-image-extra-5.4.161-26.3 linux-tools=5.4.161-26.3
apt-get install -y yandex-gosky
