resource "azurerm_resource_group" "exp" {
  name = "rtc-infra-experimental"
  location = "eastus"
}

resource "azurerm_network_interface" "azuseast1_0003" {
  resource_group_name = azurerm_resource_group.exp.name
  name = "azuseast1-0003420"
  location = azurerm_resource_group.exp.location
  enable_ip_forwarding = true

  ip_configuration {
    name = "ipconfig1"
    subnet_id = azurerm_subnet.rtc.id
    private_ip_address_allocation = "Dynamic"
    private_ip_address_version = "IPv4"
    primary = true
  }

  ip_configuration {
    name = "ipv6"
    subnet_id = azurerm_subnet.rtc.id
    private_ip_address_allocation = "Static"
    private_ip_address_version = "IPv6"
    private_ip_address = "2a02:6b8:c06:8000:0:604:1:3"
  }

}

resource "azurerm_network_interface" "azuseast1_0003_lb" {
  resource_group_name = azurerm_resource_group.exp.name
  name = "azuseast1-0003-lb-nic"
  location = azurerm_resource_group.exp.location
  enable_ip_forwarding = false

  ip_configuration {
    name = "ipconfig1"
    subnet_id = azurerm_subnet.lb_net.id
    private_ip_address_allocation = "Static"
    private_ip_address_version = "IPv4"
    private_ip_address = "172.31.0.48"
    primary = true
  }

  ip_configuration {
    name = "slot2"
    subnet_id = azurerm_subnet.lb_net.id
    private_ip_address_allocation = "Static"
    private_ip_address_version = "IPv4"
    private_ip_address = "172.31.0.49"
  }

  ip_configuration {
    name = "slot3"
    subnet_id = azurerm_subnet.lb_net.id
    private_ip_address_allocation = "Static"
    private_ip_address_version = "IPv4"
    private_ip_address = "172.31.0.50"
  }

  ip_configuration {
    name = "slot4"
    subnet_id = azurerm_subnet.lb_net.id
    private_ip_address_allocation = "Static"
    private_ip_address_version = "IPv4"
    private_ip_address = "172.31.0.51"
  }
}

resource "azurerm_managed_disk" "azuseast1_0003_os" {
    resource_group_name = azurerm_resource_group.exp.name
    location = azurerm_resource_group.exp.location
    name = "azuseast1-0003_disk1_1c294045908f4ab5a6f73c5479cc444f"
    disk_size_gb = 32
    os_type = "Linux"
    hyper_v_generation = "V1"
    storage_account_type = "StandardSSD_LRS"
    create_option = "Copy"
    # disk_iops_read_write = 500
    # disk_mbps_read_write = 60
    on_demand_bursting_enabled = false
    source_resource_id = "/subscriptions/41b8b725-122e-46c1-b1d9-7db20b16c9ca/resourceGroups/rtc-cloud-az-us-east1/providers/Microsoft.Compute/snapshots/rtc-focal_0_h3und21hclm"
    trusted_launch_enabled = false
    zones = []
}

resource "azurerm_managed_disk" "azuseast1_0003_place" {
    resource_group_name = azurerm_resource_group.exp.name
    location = azurerm_resource_group.exp.location
    name = "azuseast1-0003_place"
    disk_size_gb = 256
    storage_account_type = "StandardSSD_LRS"
    create_option = "Empty"
    # disk_iops_read_write = 500
    # disk_mbps_read_write = 60
}

resource "azurerm_virtual_machine" "azuseast1_0003" {
  name = "azuseast1-0003"
  resource_group_name = azurerm_resource_group.exp.name
  location = azurerm_resource_group.exp.location
  network_interface_ids = [azurerm_network_interface.azuseast1_0003.id, azurerm_network_interface.azuseast1_0003_lb.id]
  vm_size = "Standard_D8s_v3"
  boot_diagnostics {
    enabled = true
    storage_uri = azurerm_storage_account.diag_storage.primary_blob_endpoint
  }
  storage_os_disk {
      managed_disk_id = azurerm_managed_disk.azuseast1_0003_os.id
      create_option = "Attach"
      name = azurerm_managed_disk.azuseast1_0003_os.name
      os_type = azurerm_managed_disk.azuseast1_0003_os.os_type
  }
  storage_data_disk {
      managed_disk_id = azurerm_managed_disk.azuseast1_0003_place.id
      create_option = "Attach"
      name = azurerm_managed_disk.azuseast1_0003_place.name
      lun = 0
      disk_size_gb = azurerm_managed_disk.azuseast1_0003_place.disk_size_gb
  }
  primary_network_interface_id = azurerm_network_interface.azuseast1_0003.id
  identity {
    type = "SystemAssigned"
  }
}

resource "azurerm_route" "azuseast1_0003_vm_bb" {
 name = "azuseast1-0003-vm-bb"
 route_table_name = azurerm_route_table.rtc_mtn.name
 resource_group_name = azurerm_resource_group.shared_rg.name
 address_prefix = "2a02:6b8:c2c:100::/57"
 next_hop_type = "VirtualAppliance"
 next_hop_in_ip_address = "2a02:6b8:c06:8000::1:3"
}
