resource "azurerm_resource_group" "geo_suggest" {
  name = "rtc-cloud-az-us-east1-geo-suggest"
  location = "eastus"
}


resource "azurerm_network_interface" "azuseast1_0014" {
  resource_group_name = azurerm_resource_group.geo_suggest.name
  name = "azuseast1-0014-nic"
  location = azurerm_resource_group.geo_suggest.location
  enable_ip_forwarding = true

  ip_configuration {
    name = "ipconfig1"
    subnet_id = azurerm_subnet.rtc.id
    private_ip_address_allocation = "Dynamic"
    private_ip_address_version = "IPv4"
    primary = true
  }

  ip_configuration {
    name = "ipv6"
    subnet_id = azurerm_subnet.rtc.id
    private_ip_address_allocation = "Static"
    private_ip_address_version = "IPv6"
    private_ip_address = "2a02:6b8:c06:8000:0:604:1:e"
  }

}

resource "azurerm_network_interface" "azuseast1_0014_lb" {
  resource_group_name = azurerm_resource_group.geo_suggest.name
  name = "azuseast1-0014-lb-nic"
  location = azurerm_resource_group.geo_suggest.location
  enable_ip_forwarding = false

  ip_configuration {
    name = "slot1"
    subnet_id = azurerm_subnet.lb_net.id
    private_ip_address_allocation = "Static"
    private_ip_address_version = "IPv4"
    private_ip_address = "172.31.0.224"
    primary = true
  }

  ip_configuration {
    name = "slot2"
    subnet_id = azurerm_subnet.lb_net.id
    private_ip_address_allocation = "Static"
    private_ip_address_version = "IPv4"
    private_ip_address = "172.31.0.225"
    primary = false
  }

  ip_configuration {
    name = "slot3"
    subnet_id = azurerm_subnet.lb_net.id
    private_ip_address_allocation = "Static"
    private_ip_address_version = "IPv4"
    private_ip_address = "172.31.0.226"
    primary = false
  }

  ip_configuration {
    name = "slot4"
    subnet_id = azurerm_subnet.lb_net.id
    private_ip_address_allocation = "Static"
    private_ip_address_version = "IPv4"
    private_ip_address = "172.31.0.227"
    primary = false
  }

  ip_configuration {
    name = "slot5"
    subnet_id = azurerm_subnet.lb_net.id
    private_ip_address_allocation = "Static"
    private_ip_address_version = "IPv4"
    private_ip_address = "172.31.0.228"
    primary = false
  }
  ip_configuration {
    name = "slot6"
    subnet_id = azurerm_subnet.lb_net.id
    private_ip_address_allocation = "Static"
    private_ip_address_version = "IPv4"
    private_ip_address = "172.31.0.229"
  }
  ip_configuration {
    name = "slot7"
    subnet_id = azurerm_subnet.lb_net.id
    private_ip_address_allocation = "Static"
    private_ip_address_version = "IPv4"
    private_ip_address = "172.31.0.230"
    primary = false
  }
  ip_configuration {
    name = "slot8"
    subnet_id = azurerm_subnet.lb_net.id
    private_ip_address_allocation = "Static"
    private_ip_address_version = "IPv4"
    private_ip_address = "172.31.0.231"
    primary = false
  }
}

resource "azurerm_managed_disk" "azuseast1_0014_place" {
    resource_group_name = azurerm_resource_group.geo_suggest.name
    location = azurerm_resource_group.geo_suggest.location
    name = "azuseast1-0014_place"
    disk_size_gb = 1024
    storage_account_type = "StandardSSD_LRS"
    create_option = "Empty"
    # disk_iops_read_write = 500
    # disk_mbps_read_write = 60
}

resource "azurerm_linux_virtual_machine" "azuseast1_0014" {
  name = "azuseast1-0014"
  resource_group_name = azurerm_resource_group.geo_suggest.name
  location = azurerm_resource_group.geo_suggest.location
  network_interface_ids = [azurerm_network_interface.azuseast1_0014.id, azurerm_network_interface.azuseast1_0014_lb.id]
  size = "Standard_F64s_v2"
  boot_diagnostics {
    storage_account_uri = azurerm_storage_account.diag_storage.primary_blob_endpoint
  }

  source_image_id = "${data.azurerm_image.rtc_focal.id}"

  os_disk {
      name = "azuseast1-0014-os"
      storage_account_type = "StandardSSD_LRS"
      disk_size_gb = 32
      caching = "ReadWrite"
  }

  identity {
    type = "SystemAssigned"
  }
  custom_data = base64encode(file("${path.module}/bootstrap14.sh"))
  admin_username = "warwish"
  computer_name = "azuseast1-0014.rtc-oc.yandex.net"
  disable_password_authentication = true
  admin_ssh_key {
    public_key = "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAAEAQC/jEZapPBPqmANGZvhwheVq1R1vZEccME0sqyeGVODJz3F4s059L0OLWA8kZhf/6I8OPtbMa6y0YMdhOVRwV1q33Pw6qcEBY7KcOBgtXNCO4QHAlH14FIVomi+PC4QSgbNJVbfL+5iO5EwhKaQ5R09uwkk0Z1sg1ZoPffY7S1GKgFyOrIApIcBKqL7X5FZJyGICueWzhebXAUME1hY5iBUthIdkAr/vReXrnPIMq/8XAr+dfgJTYj7lXKxNBLMDHyBwQE07RtLdwcGmGSh3AdRbErDZF7k5xFDzFQm0ewHb67uN0zSGAPinZY/G0GbkfaTLFCmRDZsr0FlT0yCresPd8c7wGyzth/AyWkYcRzTNDboieZ7kPQJMtYGISNyQi8Dgh81mdq8MRkpYa1WnAnHRBk2zq4QaYMGJDy1S58xbc5vozK4t8MeXPANonyHyACSDHl5yU0Yp0piYJ4PK9HRoYsIvAj2Tdymrk3ucHmristeMAvvD7yIzbaPyj2THg0AUCF7bJZ6ovqpzSyJfCdwPckQxenw/tK1Yk5ehJ9iDRrSR3Lc+4NBWNqw49vxEgd8m+kjNSjU+x9ff+qUzPxE5QLKNQnl28JaPtqm2iAQ5Xglsrwx6PeQRoLxBb1jwNcrtMfBi5zTFYwxZ482tua+1s29RMarFfNzgyZyMbcjMY6ie4KwmJYZ+azJVabxLr1nLX8Jw0S1dTxwcjANOiOOq+TzUml+amUDrDiZyXqQF+seBx+fBG46y4hcMgdgEnkVGrDG9Ku+rDU2Iw2qcBuPEA9Db2aIeK6YlmE2PgpnXiak6lEfti6+gR9aDwG98CQE0FgrVdBYzPb7wTjFAQr22+whAmARREhiz3kqU/oPYcqrkrImdoF3HQtWcQfWAxvgowIz4M+sTy+7m6idDASsdXcyIR1rM81P83uGgsMWm177tpH5Kg0+L5fFKJ/Qlw5A5HDOX7g/qrlvvB0KbMZzn2XLkMsF+aNlNL+lx80tDRQOleJCjNQ959QT7P86Qjs09xQjcDmURf93gBm1xJZZDrB3aOEbzVl8aBtbb+7I/FOOxJqKpXS0nJmC9lHDZ2T4Kkp6yJubovSWffDFq8WxPwSN5nIRaV74m45DDZySe6kFU/ZdJUzjebWpA0Kp0OqqNjw9ezk6ygL8iI9C6JygzAKwLBk0l2qOpdo2W9W4GBjx/WNAtIa6eJPgQSesRT7MRtx2VdPQ6AQ2LM8p071s/TjGZOozQZoZq/km9gy6M+UW3sUFcDnJBIjkgDtxmAtHxuAZrJijh2tYhke6ufamxx56ckO5xyNlEhr+vluCEqFTkpJipN4nLkMzO7/BBr9jFnmywT/yUJqYJv2OhK97 warwish@warwish-osx"
    username = "warwish"
  }
}

resource "azurerm_virtual_machine_data_disk_attachment" "azuseast1_0014_place" {
  managed_disk_id    = azurerm_managed_disk.azuseast1_0014_place.id
  virtual_machine_id = azurerm_linux_virtual_machine.azuseast1_0014.id
  lun                = "0"
  caching            = "ReadWrite"
}

resource "azurerm_route" "azuseast1_0014_vm_bb" {
 name = "azuseast1-0014-vm-bb"
 route_table_name = azurerm_route_table.rtc_mtn.name
 resource_group_name = azurerm_resource_group.shared_rg.name
 address_prefix = "2a02:6b8:c2c:700::/57"
 next_hop_type = "VirtualAppliance"
 next_hop_in_ip_address = "2a02:6b8:c06:8000:0:604:1:e"
}








resource "azurerm_network_interface" "azuseast1_0015" {
  resource_group_name = azurerm_resource_group.geo_suggest.name
  name = "azuseast1-0015-nic"
  location = azurerm_resource_group.geo_suggest.location
  enable_ip_forwarding = true

  ip_configuration {
    name = "ipconfig1"
    subnet_id = azurerm_subnet.rtc.id
    private_ip_address_allocation = "Dynamic"
    private_ip_address_version = "IPv4"
    primary = true
  }

  ip_configuration {
    name = "ipv6"
    subnet_id = azurerm_subnet.rtc.id
    private_ip_address_allocation = "Static"
    private_ip_address_version = "IPv6"
    private_ip_address = "2a02:6b8:c06:8000:0:604:1:f"
  }

}

resource "azurerm_network_interface" "azuseast1_0015_lb" {
  resource_group_name = azurerm_resource_group.geo_suggest.name
  name = "azuseast1-0015-lb-nic"
  location = azurerm_resource_group.geo_suggest.location
  enable_ip_forwarding = false

  ip_configuration {
    name = "slot1"
    subnet_id = azurerm_subnet.lb_net.id
    private_ip_address_allocation = "Static"
    private_ip_address_version = "IPv4"
    private_ip_address = "172.31.0.240"
    primary = true
  }

  ip_configuration {
    name = "slot2"
    subnet_id = azurerm_subnet.lb_net.id
    private_ip_address_allocation = "Static"
    private_ip_address_version = "IPv4"
    private_ip_address = "172.31.0.241"
    primary = false
  }

  ip_configuration {
    name = "slot3"
    subnet_id = azurerm_subnet.lb_net.id
    private_ip_address_allocation = "Static"
    private_ip_address_version = "IPv4"
    private_ip_address = "172.31.0.242"
    primary = false
  }

  ip_configuration {
    name = "slot4"
    subnet_id = azurerm_subnet.lb_net.id
    private_ip_address_allocation = "Static"
    private_ip_address_version = "IPv4"
    private_ip_address = "172.31.0.243"
    primary = false
  }

  ip_configuration {
    name = "slot5"
    subnet_id = azurerm_subnet.lb_net.id
    private_ip_address_allocation = "Static"
    private_ip_address_version = "IPv4"
    private_ip_address = "172.31.0.244"
    primary = false
  }
  ip_configuration {
    name = "slot6"
    subnet_id = azurerm_subnet.lb_net.id
    private_ip_address_allocation = "Static"
    private_ip_address_version = "IPv4"
    private_ip_address = "172.31.0.245"
  }
  ip_configuration {
    name = "slot7"
    subnet_id = azurerm_subnet.lb_net.id
    private_ip_address_allocation = "Static"
    private_ip_address_version = "IPv4"
    private_ip_address = "172.31.0.246"
    primary = false
  }
  ip_configuration {
    name = "slot8"
    subnet_id = azurerm_subnet.lb_net.id
    private_ip_address_allocation = "Static"
    private_ip_address_version = "IPv4"
    private_ip_address = "172.31.0.247"
    primary = false
  }
}

resource "azurerm_managed_disk" "azuseast1_0015_place" {
    resource_group_name = azurerm_resource_group.geo_suggest.name
    location = azurerm_resource_group.geo_suggest.location
    name = "azuseast1-0015_place"
    disk_size_gb = 1024
    storage_account_type = "StandardSSD_LRS"
    create_option = "Empty"
    # disk_iops_read_write = 500
    # disk_mbps_read_write = 60
}

resource "azurerm_linux_virtual_machine" "azuseast1_0015" {
  name = "azuseast1-0015"
  resource_group_name = azurerm_resource_group.geo_suggest.name
  location = azurerm_resource_group.geo_suggest.location
  network_interface_ids = [azurerm_network_interface.azuseast1_0015.id, azurerm_network_interface.azuseast1_0015_lb.id]
  size = "Standard_F64s_v2"
  boot_diagnostics {
    storage_account_uri = azurerm_storage_account.diag_storage.primary_blob_endpoint
  }

  source_image_id = "${data.azurerm_image.rtc_focal.id}"

  os_disk {
      name = "azuseast1-0015-os"
      storage_account_type = "StandardSSD_LRS"
      disk_size_gb = 32
      caching = "ReadWrite"
  }

  identity {
    type = "SystemAssigned"
  }
  custom_data = base64encode(file("${path.module}/bootstrap15.sh"))
  admin_username = "warwish"
  computer_name = "azuseast1-0015.rtc-oc.yandex.net"
  disable_password_authentication = true
  admin_ssh_key {
    public_key = "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAAEAQC/jEZapPBPqmANGZvhwheVq1R1vZEccME0sqyeGVODJz3F4s059L0OLWA8kZhf/6I8OPtbMa6y0YMdhOVRwV1q33Pw6qcEBY7KcOBgtXNCO4QHAlH14FIVomi+PC4QSgbNJVbfL+5iO5EwhKaQ5R09uwkk0Z1sg1ZoPffY7S1GKgFyOrIApIcBKqL7X5FZJyGICueWzhebXAUME1hY5iBUthIdkAr/vReXrnPIMq/8XAr+dfgJTYj7lXKxNBLMDHyBwQE07RtLdwcGmGSh3AdRbErDZF7k5xFDzFQm0ewHb67uN0zSGAPinZY/G0GbkfaTLFCmRDZsr0FlT0yCresPd8c7wGyzth/AyWkYcRzTNDboieZ7kPQJMtYGISNyQi8Dgh81mdq8MRkpYa1WnAnHRBk2zq4QaYMGJDy1S58xbc5vozK4t8MeXPANonyHyACSDHl5yU0Yp0piYJ4PK9HRoYsIvAj2Tdymrk3ucHmristeMAvvD7yIzbaPyj2THg0AUCF7bJZ6ovqpzSyJfCdwPckQxenw/tK1Yk5ehJ9iDRrSR3Lc+4NBWNqw49vxEgd8m+kjNSjU+x9ff+qUzPxE5QLKNQnl28JaPtqm2iAQ5Xglsrwx6PeQRoLxBb1jwNcrtMfBi5zTFYwxZ482tua+1s29RMarFfNzgyZyMbcjMY6ie4KwmJYZ+azJVabxLr1nLX8Jw0S1dTxwcjANOiOOq+TzUml+amUDrDiZyXqQF+seBx+fBG46y4hcMgdgEnkVGrDG9Ku+rDU2Iw2qcBuPEA9Db2aIeK6YlmE2PgpnXiak6lEfti6+gR9aDwG98CQE0FgrVdBYzPb7wTjFAQr22+whAmARREhiz3kqU/oPYcqrkrImdoF3HQtWcQfWAxvgowIz4M+sTy+7m6idDASsdXcyIR1rM81P83uGgsMWm177tpH5Kg0+L5fFKJ/Qlw5A5HDOX7g/qrlvvB0KbMZzn2XLkMsF+aNlNL+lx80tDRQOleJCjNQ959QT7P86Qjs09xQjcDmURf93gBm1xJZZDrB3aOEbzVl8aBtbb+7I/FOOxJqKpXS0nJmC9lHDZ2T4Kkp6yJubovSWffDFq8WxPwSN5nIRaV74m45DDZySe6kFU/ZdJUzjebWpA0Kp0OqqNjw9ezk6ygL8iI9C6JygzAKwLBk0l2qOpdo2W9W4GBjx/WNAtIa6eJPgQSesRT7MRtx2VdPQ6AQ2LM8p071s/TjGZOozQZoZq/km9gy6M+UW3sUFcDnJBIjkgDtxmAtHxuAZrJijh2tYhke6ufamxx56ckO5xyNlEhr+vluCEqFTkpJipN4nLkMzO7/BBr9jFnmywT/yUJqYJv2OhK97 warwish@warwish-osx"
    username = "warwish"
  }
}

resource "azurerm_virtual_machine_data_disk_attachment" "azuseast1_0015_place" {
  managed_disk_id    = azurerm_managed_disk.azuseast1_0015_place.id
  virtual_machine_id = azurerm_linux_virtual_machine.azuseast1_0015.id
  lun                = "0"
  caching            = "ReadWrite"
}

resource "azurerm_route" "azuseast1_0015_vm_bb" {
 name = "azuseast1-0015-vm-bb"
 route_table_name = azurerm_route_table.rtc_mtn.name
 resource_group_name = azurerm_resource_group.shared_rg.name
 address_prefix = "2a02:6b8:c2c:780::/57"
 next_hop_type = "VirtualAppliance"
 next_hop_in_ip_address = "2a02:6b8:c06:8000:0:604:1:f"
}

module "azuseast1_0016" {
  source = "../terraform-westeu/modules/rtc"

  hostname     = "azuseast1-0016"
  host_num     = "1"
  ipv6_addr    = "2a02:6b8:c06:8000:0:604:1:10"
  bb_ipv6_addr = "2a02:6b8:c2c:800::badc:ab1e"
  vm_subnet    = "2a02:6b8:c2c:800::/57"
  mtn_prefix   = "2a02:6b8:c2c:800::/64"
  lb_subnet    = "172.31.1.0/28"
  lb_gateway   = "172.31.0.1"
  lb_pool = [
    "172.31.1.0", "172.31.1.1", "172.31.1.2", "172.31.1.3", "172.31.1.4", 
    "172.31.1.5", "172.31.1.6", "172.31.1.7", "172.31.1.8", "172.31.1.9", 
    "172.31.1.10", "172.31.1.11", "172.31.1.12", "172.31.1.13", "172.31.1.14", "172.31.1.15"
  ]
  vm_size             = "Standard_E32as_v5"
  place_size          = 1024
  vm_image_id         = data.azurerm_image.rtc_focal.id
  resource_group_name = azurerm_resource_group.geo_suggest.name
  shared_rg_name      = azurerm_resource_group.shared_rg.name
  location            = azurerm_resource_group.geo_suggest.location
  rtc_net_id          = azurerm_subnet.rtc.id
  lb_net_id           = azurerm_subnet.lb_net.id
  route_table_name    = azurerm_route_table.rtc_mtn.name
  lb_nsg_id           = azurerm_network_security_group.lb_nsg.id
  diag_endpoint       = azurerm_storage_account.diag_storage.primary_blob_endpoint
}