
resource "azurerm_resource_group" "shared_rg" {
  name     = "rtc-cloud-az-us-east1-shared"
  location = "eastus"
}

resource "azurerm_virtual_network" "shared_vnet" {
    name                = "rtc-cloud-az-er1"
    address_space       = ["10.1.0.0/16", "172.31.0.0/16", "2a02:6b8:c06::/48", "2a02:6b8:c2c::/48", "fc00::/64", "192.168.0.0/16"]
    location            = "eastus"
    resource_group_name = azurerm_resource_group.shared_rg.name

}

resource "azurerm_subnet" "GatewaySubnet" {
  virtual_network_name = azurerm_virtual_network.shared_vnet.name
  resource_group_name = azurerm_resource_group.shared_rg.name
  name = "GatewaySubnet"
  address_prefixes = ["10.1.0.0/24", "2a02:6b8:c06:3c0::/64"]
}

resource "azurerm_subnet" "lb_net" {
  virtual_network_name = azurerm_virtual_network.shared_vnet.name
  name = "lb-net"
  resource_group_name = azurerm_resource_group.shared_rg.name
  address_prefixes = ["172.31.0.0/16", "fc00::/64"]
}

resource "azurerm_subnet" "rtc" {
    resource_group_name = azurerm_resource_group.shared_rg.name
    virtual_network_name = azurerm_virtual_network.shared_vnet.name
    name = "rtc"
    address_prefixes = ["192.168.0.0/16", "2a02:6b8:c06:8000::/64"]
}

resource "azurerm_route_table" "rtc_mtn" {
  name = "rtc-mtn-rt"
  resource_group_name = azurerm_resource_group.shared_rg.name
  location = azurerm_resource_group.shared_rg.location
}

resource "azurerm_route" "yandex" {
 name = "yandex"
 route_table_name = azurerm_route_table.rtc_mtn.name
 resource_group_name = azurerm_resource_group.shared_rg.name
 address_prefix = "::/0"
 next_hop_type = "VirtualAppliance"
 next_hop_in_ip_address = "2a02:6bf:ff70:40a::5"
}

resource "azurerm_storage_account" "diag_storage" {
    name = "rtccloudazuseast1diag"
    resource_group_name = azurerm_resource_group.shared_rg.name
    location = azurerm_resource_group.shared_rg.location
    account_tier = "Standard"
    account_replication_type = "LRS"
    account_kind = "Storage"
    min_tls_version = "TLS1_2"
}

data "azurerm_image" "rtc_focal" {
  name                = "rtc-focal"
  resource_group_name = "rtc-cloud-az-us-east1"
}