resource "azurerm_resource_group" "yabs_proxy" {
  name = "rtc-cloud-az-us-east1-yabs-proxy"
  location = "eastus"
}

resource "azurerm_network_interface" "azuseast1_0004" {
  resource_group_name = azurerm_resource_group.yabs_proxy.name
  name = "azuseast1-0004-nic"
  location = azurerm_resource_group.yabs_proxy.location
  enable_ip_forwarding = true

  ip_configuration {
    name = "ipconfig1"
    subnet_id = azurerm_subnet.rtc.id
    private_ip_address_allocation = "Dynamic"
    private_ip_address_version = "IPv4"
    primary = true
  }

  ip_configuration {
    name = "ipv6"
    subnet_id = azurerm_subnet.rtc.id
    private_ip_address_allocation = "Static"
    private_ip_address_version = "IPv6"
    private_ip_address = "2a02:6b8:c06:8000:0:604:1:4"
  }

}

resource "azurerm_network_interface" "azuseast1_0004_lb" {
  resource_group_name = azurerm_resource_group.yabs_proxy.name
  name = "azuseast1-0004-lb-nic"
  location = azurerm_resource_group.yabs_proxy.location
  enable_ip_forwarding = false

  ip_configuration {
    name = "slot1"
    subnet_id = azurerm_subnet.lb_net.id
    private_ip_address_allocation = "Static"
    private_ip_address_version = "IPv4"
    private_ip_address = "172.31.0.64"
    primary = true
  }

  ip_configuration {
    name = "slot2"
    subnet_id = azurerm_subnet.lb_net.id
    private_ip_address_allocation = "Static"
    private_ip_address_version = "IPv4"
    private_ip_address = "172.31.0.65"
    primary = false
  }

  ip_configuration {
    name = "slot3"
    subnet_id = azurerm_subnet.lb_net.id
    private_ip_address_allocation = "Static"
    private_ip_address_version = "IPv4"
    private_ip_address = "172.31.0.66"
    primary = false
  }

  ip_configuration {
    name = "slot4"
    subnet_id = azurerm_subnet.lb_net.id
    private_ip_address_allocation = "Static"
    private_ip_address_version = "IPv4"
    private_ip_address = "172.31.0.67"
    primary = false
  }

  ip_configuration {
    name = "slot5"
    subnet_id = azurerm_subnet.lb_net.id
    private_ip_address_allocation = "Static"
    private_ip_address_version = "IPv4"
    private_ip_address = "172.31.0.68"
    primary = false
  }
  ip_configuration {
    name = "slot6"
    subnet_id = azurerm_subnet.lb_net.id
    private_ip_address_allocation = "Static"
    private_ip_address_version = "IPv4"
    private_ip_address = "172.31.0.69"
  }
  ip_configuration {
    name = "slot7"
    subnet_id = azurerm_subnet.lb_net.id
    private_ip_address_allocation = "Static"
    private_ip_address_version = "IPv4"
    private_ip_address = "172.31.0.70"
    primary = false
  }
  ip_configuration {
    name = "slot8"
    subnet_id = azurerm_subnet.lb_net.id
    private_ip_address_allocation = "Static"
    private_ip_address_version = "IPv4"
    private_ip_address = "172.31.0.71"
    primary = false
  }
}

resource "azurerm_managed_disk" "azuseast1_0004_os" {
    resource_group_name = azurerm_resource_group.yabs_proxy.name
    location = azurerm_resource_group.yabs_proxy.location
    name = "azuseast1-0004-os"
    disk_size_gb = 32
    os_type = "Linux"
    hyper_v_generation = "V1"
    storage_account_type = "StandardSSD_LRS"
    create_option = "Copy"
    # disk_iops_read_write = 500
    # disk_mbps_read_write = 60
    on_demand_bursting_enabled = false
    source_resource_id = "/subscriptions/41b8b725-122e-46c1-b1d9-7db20b16c9ca/resourceGroups/rtc-cloud-az-us-east1/providers/Microsoft.Compute/snapshots/rtc-focal_0_h3und21hclm"
    trusted_launch_enabled = false
    zones = []
}

resource "azurerm_managed_disk" "azuseast1_0004_place" {
    resource_group_name = azurerm_resource_group.yabs_proxy.name
    location = azurerm_resource_group.yabs_proxy.location
    name = "azuseast1-0004_place"
    disk_size_gb = 256
    storage_account_type = "StandardSSD_LRS"
    create_option = "Empty"
    # disk_iops_read_write = 500
    # disk_mbps_read_write = 60
}

resource "azurerm_virtual_machine" "azuseast1_0004" {
  name = "azuseast1-0004"
  resource_group_name = azurerm_resource_group.yabs_proxy.name
  location = azurerm_resource_group.yabs_proxy.location
  network_interface_ids = [azurerm_network_interface.azuseast1_0004.id, azurerm_network_interface.azuseast1_0004_lb.id]
  vm_size = "Standard_D8s_v3"
  boot_diagnostics {
    enabled = true
    storage_uri = azurerm_storage_account.diag_storage.primary_blob_endpoint
  }
  storage_os_disk {
      managed_disk_id = azurerm_managed_disk.azuseast1_0004_os.id
      create_option = "Attach"
      name = azurerm_managed_disk.azuseast1_0004_os.name
      os_type = azurerm_managed_disk.azuseast1_0004_os.os_type
  }
  storage_data_disk {
      managed_disk_id = azurerm_managed_disk.azuseast1_0004_place.id
      create_option = "Attach"
      name = azurerm_managed_disk.azuseast1_0004_place.name
      lun = 0
      disk_size_gb = azurerm_managed_disk.azuseast1_0004_place.disk_size_gb
  }
  primary_network_interface_id = azurerm_network_interface.azuseast1_0004.id
  identity {
    type = "SystemAssigned"
  }
}

resource "azurerm_route" "azuseast1_0004_vm_bb" {
 name = "azuseast1-0004-vm-bb"
 route_table_name = azurerm_route_table.rtc_mtn.name
 resource_group_name = azurerm_resource_group.shared_rg.name
 address_prefix = "2a02:6b8:c2c:180::/57"
 next_hop_type = "VirtualAppliance"
 next_hop_in_ip_address = "2a02:6b8:c06:8000:0:604:1:4"
}





resource "azurerm_network_interface" "azuseast1_0005" {
  resource_group_name = azurerm_resource_group.yabs_proxy.name
  name = "azuseast1-0005-nic"
  location = azurerm_resource_group.yabs_proxy.location
  enable_ip_forwarding = true

  ip_configuration {
    name = "ipconfig1"
    subnet_id = azurerm_subnet.rtc.id
    private_ip_address_allocation = "Dynamic"
    private_ip_address_version = "IPv4"
    primary = true
  }

  ip_configuration {
    name = "ipv6"
    subnet_id = azurerm_subnet.rtc.id
    private_ip_address_allocation = "Static"
    private_ip_address_version = "IPv6"
    private_ip_address = "2a02:6b8:c06:8000:0:604:1:5"
  }

}

resource "azurerm_network_interface" "azuseast1_0005_lb" {
  resource_group_name = azurerm_resource_group.yabs_proxy.name
  name = "azuseast1-0005-lb-nic"
  location = azurerm_resource_group.yabs_proxy.location
  enable_ip_forwarding = false

  ip_configuration {
    name = "slot1"
    subnet_id = azurerm_subnet.lb_net.id
    private_ip_address_allocation = "Static"
    private_ip_address_version = "IPv4"
    private_ip_address = "172.31.0.80"
    primary = true
  }

  ip_configuration {
    name = "slot2"
    subnet_id = azurerm_subnet.lb_net.id
    private_ip_address_allocation = "Static"
    private_ip_address_version = "IPv4"
    private_ip_address = "172.31.0.81"
    primary = false
  }

  ip_configuration {
    name = "slot3"
    subnet_id = azurerm_subnet.lb_net.id
    private_ip_address_allocation = "Static"
    private_ip_address_version = "IPv4"
    private_ip_address = "172.31.0.82"
    primary = false
  }

  ip_configuration {
    name = "slot4"
    subnet_id = azurerm_subnet.lb_net.id
    private_ip_address_allocation = "Static"
    private_ip_address_version = "IPv4"
    private_ip_address = "172.31.0.83"
    primary = false
  }

  ip_configuration {
    name = "slot5"
    subnet_id = azurerm_subnet.lb_net.id
    private_ip_address_allocation = "Static"
    private_ip_address_version = "IPv4"
    private_ip_address = "172.31.0.84"
    primary = false
  }
  ip_configuration {
    name = "slot6"
    subnet_id = azurerm_subnet.lb_net.id
    private_ip_address_allocation = "Static"
    private_ip_address_version = "IPv4"
    private_ip_address = "172.31.0.85"
  }
  ip_configuration {
    name = "slot7"
    subnet_id = azurerm_subnet.lb_net.id
    private_ip_address_allocation = "Static"
    private_ip_address_version = "IPv4"
    private_ip_address = "172.31.0.86"
    primary = false
  }
  ip_configuration {
    name = "slot8"
    subnet_id = azurerm_subnet.lb_net.id
    private_ip_address_allocation = "Static"
    private_ip_address_version = "IPv4"
    private_ip_address = "172.31.0.87"
    primary = false
  }
}
/*
resource "azurerm_managed_disk" "azuseast1_0005_os" {
    resource_group_name = azurerm_resource_group.yabs_proxy.name
    location = azurerm_resource_group.yabs_proxy.location
    name = "azuseast1-0005-os"
    disk_size_gb = 32
    os_type = "Linux"
    hyper_v_generation = "V1"
    storage_account_type = "StandardSSD_LRS"
    create_option = "Copy"
    # disk_iops_read_write = 500
    # disk_mbps_read_write = 60
    on_demand_bursting_enabled = false
    source_resource_id = "/subscriptions/41b8b725-122e-46c1-b1d9-7db20b16c9ca/resourceGroups/rtc-cloud-az-us-east1/providers/Microsoft.Compute/snapshots/rtc-focal_0_h3und21hclm"
    trusted_launch_enabled = false
    zones = []
}
*/
resource "azurerm_managed_disk" "azuseast1_0005_place" {
    resource_group_name = azurerm_resource_group.yabs_proxy.name
    location = azurerm_resource_group.yabs_proxy.location
    name = "azuseast1-0005_place"
    disk_size_gb = 256
    storage_account_type = "StandardSSD_LRS"
    create_option = "Empty"
    # disk_iops_read_write = 500
    # disk_mbps_read_write = 60
}

resource "azurerm_linux_virtual_machine" "azuseast1_0005" {
  name = "azuseast1-0005"
  resource_group_name = azurerm_resource_group.yabs_proxy.name
  location = azurerm_resource_group.yabs_proxy.location
  network_interface_ids = [azurerm_network_interface.azuseast1_0005.id, azurerm_network_interface.azuseast1_0005_lb.id]
  size = "Standard_D8s_v3"
  boot_diagnostics {
    storage_account_uri = azurerm_storage_account.diag_storage.primary_blob_endpoint
  }

  source_image_id = "${data.azurerm_image.rtc_focal.id}"

  os_disk {
      #managed_disk_id = azurerm_managed_disk.azuseast1_0005_os.id
    #   create_option = "FromImage"
      name = "azuseast1-0005-os"
      #os_type = azurerm_managed_disk.azuseast1_0005_os.os_type
    #   os_type = "Linux"
      storage_account_type = "StandardSSD_LRS"
      disk_size_gb = 32
      caching = "ReadWrite"
  }
#   data_disk {
#       managed_disk_id = azurerm_managed_disk.azuseast1_0005_place.id
#       create_option = "Attach"
#       name = azurerm_managed_disk.azuseast1_0005_place.name
#       lun = 0
#       disk_size_gb = azurerm_managed_disk.azuseast1_0005_place.disk_size_gb
#   }
#   primary_network_interface_id = azurerm_network_interface.azuseast1_0005.id
  identity {
    type = "SystemAssigned"
  }
  custom_data = base64encode(file("${path.module}/bootstrap5.sh"))
  admin_username = "warwish"
  computer_name = "azuseast1-0005.rtc-oc.yandex.net"
  disable_password_authentication = true
  admin_ssh_key {
    public_key = "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAAEAQC/jEZapPBPqmANGZvhwheVq1R1vZEccME0sqyeGVODJz3F4s059L0OLWA8kZhf/6I8OPtbMa6y0YMdhOVRwV1q33Pw6qcEBY7KcOBgtXNCO4QHAlH14FIVomi+PC4QSgbNJVbfL+5iO5EwhKaQ5R09uwkk0Z1sg1ZoPffY7S1GKgFyOrIApIcBKqL7X5FZJyGICueWzhebXAUME1hY5iBUthIdkAr/vReXrnPIMq/8XAr+dfgJTYj7lXKxNBLMDHyBwQE07RtLdwcGmGSh3AdRbErDZF7k5xFDzFQm0ewHb67uN0zSGAPinZY/G0GbkfaTLFCmRDZsr0FlT0yCresPd8c7wGyzth/AyWkYcRzTNDboieZ7kPQJMtYGISNyQi8Dgh81mdq8MRkpYa1WnAnHRBk2zq4QaYMGJDy1S58xbc5vozK4t8MeXPANonyHyACSDHl5yU0Yp0piYJ4PK9HRoYsIvAj2Tdymrk3ucHmristeMAvvD7yIzbaPyj2THg0AUCF7bJZ6ovqpzSyJfCdwPckQxenw/tK1Yk5ehJ9iDRrSR3Lc+4NBWNqw49vxEgd8m+kjNSjU+x9ff+qUzPxE5QLKNQnl28JaPtqm2iAQ5Xglsrwx6PeQRoLxBb1jwNcrtMfBi5zTFYwxZ482tua+1s29RMarFfNzgyZyMbcjMY6ie4KwmJYZ+azJVabxLr1nLX8Jw0S1dTxwcjANOiOOq+TzUml+amUDrDiZyXqQF+seBx+fBG46y4hcMgdgEnkVGrDG9Ku+rDU2Iw2qcBuPEA9Db2aIeK6YlmE2PgpnXiak6lEfti6+gR9aDwG98CQE0FgrVdBYzPb7wTjFAQr22+whAmARREhiz3kqU/oPYcqrkrImdoF3HQtWcQfWAxvgowIz4M+sTy+7m6idDASsdXcyIR1rM81P83uGgsMWm177tpH5Kg0+L5fFKJ/Qlw5A5HDOX7g/qrlvvB0KbMZzn2XLkMsF+aNlNL+lx80tDRQOleJCjNQ959QT7P86Qjs09xQjcDmURf93gBm1xJZZDrB3aOEbzVl8aBtbb+7I/FOOxJqKpXS0nJmC9lHDZ2T4Kkp6yJubovSWffDFq8WxPwSN5nIRaV74m45DDZySe6kFU/ZdJUzjebWpA0Kp0OqqNjw9ezk6ygL8iI9C6JygzAKwLBk0l2qOpdo2W9W4GBjx/WNAtIa6eJPgQSesRT7MRtx2VdPQ6AQ2LM8p071s/TjGZOozQZoZq/km9gy6M+UW3sUFcDnJBIjkgDtxmAtHxuAZrJijh2tYhke6ufamxx56ckO5xyNlEhr+vluCEqFTkpJipN4nLkMzO7/BBr9jFnmywT/yUJqYJv2OhK97 warwish@warwish-osx"
    username = "warwish"
  }
}

resource "azurerm_virtual_machine_data_disk_attachment" "azuseast1_0005_place" {
  managed_disk_id    = azurerm_managed_disk.azuseast1_0005_place.id
  virtual_machine_id = azurerm_linux_virtual_machine.azuseast1_0005.id
  lun                = "0"
  caching            = "ReadWrite"
}

resource "azurerm_route" "azuseast1_0005_vm_bb" {
 name = "azuseast1-0005-vm-bb"
 route_table_name = azurerm_route_table.rtc_mtn.name
 resource_group_name = azurerm_resource_group.shared_rg.name
 address_prefix = "2a02:6b8:c2c:200::/57"
 next_hop_type = "VirtualAppliance"
 next_hop_in_ip_address = "2a02:6b8:c06:8000:0:604:1:5"
}








resource "azurerm_network_interface" "azuseast1_0006" {
  resource_group_name = azurerm_resource_group.yabs_proxy.name
  name = "azuseast1-0006-nic"
  location = azurerm_resource_group.yabs_proxy.location
  enable_ip_forwarding = true

  ip_configuration {
    name = "ipconfig1"
    subnet_id = azurerm_subnet.rtc.id
    private_ip_address_allocation = "Dynamic"
    private_ip_address_version = "IPv4"
    primary = true
  }

  ip_configuration {
    name = "ipv6"
    subnet_id = azurerm_subnet.rtc.id
    private_ip_address_allocation = "Static"
    private_ip_address_version = "IPv6"
    private_ip_address = "2a02:6b8:c06:8000:0:604:1:6"
  }

}

resource "azurerm_network_interface" "azuseast1_0006_lb" {
  resource_group_name = azurerm_resource_group.yabs_proxy.name
  name = "azuseast1-0006-lb-nic"
  location = azurerm_resource_group.yabs_proxy.location
  enable_ip_forwarding = false

  ip_configuration {
    name = "slot1"
    subnet_id = azurerm_subnet.lb_net.id
    private_ip_address_allocation = "Static"
    private_ip_address_version = "IPv4"
    private_ip_address = "172.31.0.92"
    primary = true
  }

  ip_configuration {
    name = "slot2"
    subnet_id = azurerm_subnet.lb_net.id
    private_ip_address_allocation = "Static"
    private_ip_address_version = "IPv4"
    private_ip_address = "172.31.0.93"
    primary = false
  }

  ip_configuration {
    name = "slot3"
    subnet_id = azurerm_subnet.lb_net.id
    private_ip_address_allocation = "Static"
    private_ip_address_version = "IPv4"
    private_ip_address = "172.31.0.94"
    primary = false
  }

  ip_configuration {
    name = "slot4"
    subnet_id = azurerm_subnet.lb_net.id
    private_ip_address_allocation = "Static"
    private_ip_address_version = "IPv4"
    private_ip_address = "172.31.0.95"
    primary = false
  }

  ip_configuration {
    name = "slot5"
    subnet_id = azurerm_subnet.lb_net.id
    private_ip_address_allocation = "Static"
    private_ip_address_version = "IPv4"
    private_ip_address = "172.31.0.96"
    primary = false
  }
  ip_configuration {
    name = "slot6"
    subnet_id = azurerm_subnet.lb_net.id
    private_ip_address_allocation = "Static"
    private_ip_address_version = "IPv4"
    private_ip_address = "172.31.0.97"
  }
  ip_configuration {
    name = "slot7"
    subnet_id = azurerm_subnet.lb_net.id
    private_ip_address_allocation = "Static"
    private_ip_address_version = "IPv4"
    private_ip_address = "172.31.0.98"
    primary = false
  }
  ip_configuration {
    name = "slot8"
    subnet_id = azurerm_subnet.lb_net.id
    private_ip_address_allocation = "Static"
    private_ip_address_version = "IPv4"
    private_ip_address = "172.31.0.99"
    primary = false
  }
}

resource "azurerm_managed_disk" "azuseast1_0006_place" {
    resource_group_name = azurerm_resource_group.yabs_proxy.name
    location = azurerm_resource_group.yabs_proxy.location
    name = "azuseast1-0006_place"
    disk_size_gb = 256
    storage_account_type = "StandardSSD_LRS"
    create_option = "Empty"
    # disk_iops_read_write = 500
    # disk_mbps_read_write = 60
}

resource "azurerm_linux_virtual_machine" "azuseast1_0006" {
  name = "azuseast1-0006"
  resource_group_name = azurerm_resource_group.yabs_proxy.name
  location = azurerm_resource_group.yabs_proxy.location
  network_interface_ids = [azurerm_network_interface.azuseast1_0006.id, azurerm_network_interface.azuseast1_0006_lb.id]
  size = "Standard_D8s_v3"
  boot_diagnostics {
    storage_account_uri = azurerm_storage_account.diag_storage.primary_blob_endpoint
  }

  source_image_id = "${data.azurerm_image.rtc_focal.id}"

  os_disk {
      name = "azuseast1-0006-os"
      storage_account_type = "StandardSSD_LRS"
      disk_size_gb = 32
      caching = "ReadWrite"
  }

  identity {
    type = "SystemAssigned"
  }
  custom_data = base64encode(file("${path.module}/bootstrap6.sh"))
  admin_username = "warwish"
  computer_name = "azuseast1-0006.rtc-oc.yandex.net"
  disable_password_authentication = true
  admin_ssh_key {
    public_key = "ssh-rsa AAAAB3NzaC1yc2EAAAADAQABAAAEAQC/jEZapPBPqmANGZvhwheVq1R1vZEccME0sqyeGVODJz3F4s059L0OLWA8kZhf/6I8OPtbMa6y0YMdhOVRwV1q33Pw6qcEBY7KcOBgtXNCO4QHAlH14FIVomi+PC4QSgbNJVbfL+5iO5EwhKaQ5R09uwkk0Z1sg1ZoPffY7S1GKgFyOrIApIcBKqL7X5FZJyGICueWzhebXAUME1hY5iBUthIdkAr/vReXrnPIMq/8XAr+dfgJTYj7lXKxNBLMDHyBwQE07RtLdwcGmGSh3AdRbErDZF7k5xFDzFQm0ewHb67uN0zSGAPinZY/G0GbkfaTLFCmRDZsr0FlT0yCresPd8c7wGyzth/AyWkYcRzTNDboieZ7kPQJMtYGISNyQi8Dgh81mdq8MRkpYa1WnAnHRBk2zq4QaYMGJDy1S58xbc5vozK4t8MeXPANonyHyACSDHl5yU0Yp0piYJ4PK9HRoYsIvAj2Tdymrk3ucHmristeMAvvD7yIzbaPyj2THg0AUCF7bJZ6ovqpzSyJfCdwPckQxenw/tK1Yk5ehJ9iDRrSR3Lc+4NBWNqw49vxEgd8m+kjNSjU+x9ff+qUzPxE5QLKNQnl28JaPtqm2iAQ5Xglsrwx6PeQRoLxBb1jwNcrtMfBi5zTFYwxZ482tua+1s29RMarFfNzgyZyMbcjMY6ie4KwmJYZ+azJVabxLr1nLX8Jw0S1dTxwcjANOiOOq+TzUml+amUDrDiZyXqQF+seBx+fBG46y4hcMgdgEnkVGrDG9Ku+rDU2Iw2qcBuPEA9Db2aIeK6YlmE2PgpnXiak6lEfti6+gR9aDwG98CQE0FgrVdBYzPb7wTjFAQr22+whAmARREhiz3kqU/oPYcqrkrImdoF3HQtWcQfWAxvgowIz4M+sTy+7m6idDASsdXcyIR1rM81P83uGgsMWm177tpH5Kg0+L5fFKJ/Qlw5A5HDOX7g/qrlvvB0KbMZzn2XLkMsF+aNlNL+lx80tDRQOleJCjNQ959QT7P86Qjs09xQjcDmURf93gBm1xJZZDrB3aOEbzVl8aBtbb+7I/FOOxJqKpXS0nJmC9lHDZ2T4Kkp6yJubovSWffDFq8WxPwSN5nIRaV74m45DDZySe6kFU/ZdJUzjebWpA0Kp0OqqNjw9ezk6ygL8iI9C6JygzAKwLBk0l2qOpdo2W9W4GBjx/WNAtIa6eJPgQSesRT7MRtx2VdPQ6AQ2LM8p071s/TjGZOozQZoZq/km9gy6M+UW3sUFcDnJBIjkgDtxmAtHxuAZrJijh2tYhke6ufamxx56ckO5xyNlEhr+vluCEqFTkpJipN4nLkMzO7/BBr9jFnmywT/yUJqYJv2OhK97 warwish@warwish-osx"
    username = "warwish"
  }
}

resource "azurerm_virtual_machine_data_disk_attachment" "azuseast1_0006_place" {
  managed_disk_id    = azurerm_managed_disk.azuseast1_0006_place.id
  virtual_machine_id = azurerm_linux_virtual_machine.azuseast1_0006.id
  lun                = "0"
  caching            = "ReadWrite"
}

resource "azurerm_route" "azuseast1_0006_vm_bb" {
 name = "azuseast1-0006-vm-bb"
 route_table_name = azurerm_route_table.rtc_mtn.name
 resource_group_name = azurerm_resource_group.shared_rg.name
 address_prefix = "2a02:6b8:c2c:280::/57"
 next_hop_type = "VirtualAppliance"
 next_hop_in_ip_address = "2a02:6b8:c06:8000:0:604:1:6"
}