#include <infra/box_dns_controller/libs/daemon/main.h>

#include <infra/libs/logger/log_printer.h>
#include <infra/libs/sensors/sensor_registry.h>

#include <library/cpp/getopt/modchooser.h>

#include <util/generic/yexception.h>
#include <util/stream/output.h>

int main(int argc, const char* argv[]) {
    NInfra::SetSensorRegistryCommonGroup({"box_dns_controller"});

    TModChooser modChooser;

    modChooser.AddMode(
        "run",
        NInfra::NBoxDns::RunDaemon,
        "Run Box DNS daemon."
    );

    modChooser.AddMode(
        "print_log",
        NInfra::PrintEventLog,
        "Print Box Dns log."
    );

    try {
        return modChooser.Run(argc, argv);
    } catch (...) {
        Cerr << CurrentExceptionMessage() << Endl;
        return EXIT_FAILURE;
    }

    return EXIT_SUCCESS;
}
