#pragma once

#include <infra/box_dns_controller/libs/config/config.pb.h>
#include <infra/box_dns_controller/libs/protos/events_decl.ev.pb.h>

#include <infra/contrib/pdns/power_dns/dnsname.hh>

#include <infra/libs/controller/config/config.pb.h>
#include <infra/libs/controller/object_manager/object_manager.h>
#include <infra/libs/logger/protos/events.ev.pb.h>
#include <infra/libs/sensors/sensor.h>
#include <infra/libs/sensors/sensor_group.h>
#include <infra/libs/updatable_proto_config/accessor.h>

#include <yp/cpp/yp/data_model.h>

namespace NInfra::NBoxDns {

const TStringBuf INVALID_CHARS = "@";

class TBoxDnsManager : public NController::ISingleClusterObjectManager {
public:
    TBoxDnsManager(
        TVector<NYP::NClient::TPod> pods,
        TVector<NYP::NClient::TDnsRecordSet> existingRecordSets,
        const TString& address,
        const ui32 maxUpdateObjectsNumber
    );

    TString GetObjectId() const override final;

    void GenerateYpUpdates(
        const ISingleClusterObjectManager::TDependentObjects& dependentObjects,
        TVector<ISingleClusterObjectManager::TRequest>& requests,
        TLogFramePtr frame
    ) const override final;

private:
    bool TryAddBoxSubnetRootRecords(
        const NYP::NClient::TPod& pod
        , const TString& boxSubnetRootAddress
        , const THashMap<TString, TString>& boxFqdn2BoxId
        , TVector<NYP::NClient::TDnsRecordSet>& actualRecordSets
        , TLogFramePtr frame
    ) const;

    void AddRecords(
        TVector<NYP::NClient::TDnsRecordSet>& actualRecordSets,
        const TString& fqdn,
        const TString& stringAddress,
        const TString& boxSubnetRootAddress
    ) const;

    const TString Address_;
    const ui32 MaxUpdateObjectsNumber_;
    const TVector<NYP::NClient::TDnsRecordSet> ExistingRecordSets_;
    const TVector<NYP::NClient::TPod> Pods_;
    TSensorGroup SensorGroup_;
};

class TBoxDnsManagerFactory : public NController::ISingleClusterObjectManagersFactory {
public:
    TBoxDnsManagerFactory(
        NUpdatableProtoConfig::TAccessor<TBoxDnsConfig> config
        , NUpdatableProtoConfig::TAccessor<NController::TClientConfig> ypClientConfig
        , NController::TShardPtr shard
    );

    TVector<NController::ISingleClusterObjectManager::TSelectArgument> GetSelectArguments(const TVector<TVector<NController::TSelectorResultPtr>>& /* aggregateResults */ = {}, NInfra::TLogFramePtr = {}) const override final;

    TVector<TExpected<NController::TSingleClusterObjectManagerPtr, TValidationError>> GetSingleClusterObjectManagers(
        const TVector<NController::TSelectObjectsResultPtr>& selectorResults,
        TLogFramePtr frame
    ) const override final;

private:
    NUpdatableProtoConfig::TAccessor<TBoxDnsConfig> Config_;
    TBoxDnsConfig ActualConfig_;
    const TString Address_;
};

} // namespace NInfra::NBoxDns
