#include "main.h"

#include <infra/box_dns_controller/libs/config/config.pb.h>
#include <infra/box_dns_controller/libs/controller/controller.h>

#include <infra/libs/controller/config/config.pb.h>
#include <infra/libs/controller/daemon/main.h>
#include <infra/libs/controller/object_manager/object_manager.h>
#include <infra/libs/updatable_proto_config/accessor.h>
#include <infra/libs/updatable_proto_config/holder.h>

#include <library/cpp/proto_config/load.h>

namespace NInfra::NBoxDns {

int RunDaemon(int argc, const char* argv[]) {
    const TConfig config = NProtoConfig::GetOpt<TConfig>(argc, argv, "/proto_config/config.json");
    const NUpdatableProtoConfig::TConfigHolderConfig& updatableConfigOpts = config.GetController().GetUpdatableConfigOptions();

    NUpdatableProtoConfig::TConfigHolderPtr<TConfig> configHolder = NUpdatableProtoConfig::CreateConfigHolder(config, updatableConfigOpts);

    NInfra::NController::TSharding shardsFactory(config.GetController().GetLeadingInvader());

    return NController::RunDaemon<NController::TService>(
        configHolder->Accessor<NController::TControllerConfig>("Controller")
        , new TBoxDnsManagerFactory(
            configHolder->Accessor<TBoxDnsConfig>("BoxConfig"),
            configHolder->Accessor<NController::TClientConfig>("Controller/YpClient"),
            shardsFactory.GetShard(0)
        )
    );
}

} //namspace NInfra::NBoxDns
