#pragma once

#include <infra/box_dns_controller/libs/controller/controller.h>

#include <infra/libs/controller/object_manager/object_manager.h>
#include <infra/libs/controller/standalone_controller/standalone_controller.h>

#include <library/cpp/proto_config/config.h>

namespace NInfra::NBoxDns {

NController::TSingleClusterObjectManagersFactoryPtr CreateFactory(NUpdatableProtoConfig::TAccessor<TConfig> config) {
    NInfra::NController::TSharding shardsFactory(config.Get()->GetController().GetLeadingInvader());

    return new TBoxDnsManagerFactory(
        config.Accessor<TBoxDnsConfig>("BoxConfig")
        , config.Accessor<NController::TClientConfig>("Controller/YpClient")
        , shardsFactory.GetShard(0)
    );
}

class TStandaloneController: public NInfra::NController::TStandaloneController {
public:
    TStandaloneController(NUpdatableProtoConfig::TAccessor<TConfig> config)
        : NInfra::NController::TStandaloneController(
            CONFIG_SNAPSHOT_VALUE(config, GetController()),
            CreateFactory(config)
        )
    {
    }
};

class TStandaloneControllerWrapper: public NInfra::NController::TStandaloneControllerWrapper<TStandaloneController, TConfig> {
    using NInfra::NController::TStandaloneControllerWrapper<TStandaloneController, TConfig>::TStandaloneControllerWrapper;
};

} // namespace NInfra::NBoxDns
