#include "app.h"


namespace NBubbleServer {
    TApp::TApp(const TVector<NBubbleServer::THandler *>& handlers)
        : Handlers_(handlers)
    {
    }

    THttpResponse TApp::DoReply(const NBubbleServer::TRequest &request) {
        THttpResponse response;
        try {
            auto handler = FindHandler(request);
            if (handler) {
                response = handler->Execute(request);
            } else {
                response = MakeResponse(HTTP_NOT_FOUND, "Url not found\r\n");
            }
        } catch (const TNotImplemented& e) {
            response = MakeResponse(HTTP_NOT_IMPLEMENTED, "Url found but handler not implemented\r\n");
        } catch (const yexception& e) {
            TStringStream stream;
            stream << "Internal server error\r\n"
                   << e.what();
            response = MakeResponse(HTTP_INTERNAL_SERVER_ERROR, stream.Str());
        }
        return response;
    }

    THandler* TApp::FindHandler(const NBubbleServer::TRequest &request) {
        for (auto handler : Handlers_) {
            if (handler->MatchRequest(request)) {
                return handler;
            }
        }
        return nullptr;
    }
}
