#include "daemon.h"

namespace NBubbleServer {
    class TReplier: public TRequestReplier {
    public:
        explicit TReplier(TApp* app)
            : App_(app)
        {
        }
        bool DoReply(const TReplyParams& params) override {
            TRequest request(params);
            auto response = App_->DoReply(request);
            response.OutTo(params.Output);
            params.Output.Finish();
            return true;
        }

    private:
        TApp* App_;
    };

    TDaemon::TDaemon(ui16 port, TApp* app)
        : HttpServer_(new THttpServer(this, THttpServer::TOptions(port)))
        , App_(app)
    {
    }

    void TDaemon::ServeForever() {
        Cerr << "Will listen port " << HttpServer_->Options().Port << Endl;
        while (!HttpServer_->Start()) {
            Cerr << "trying to start http server...\n";
            Sleep(TDuration::Seconds(1));
        }
        while (true) {
            Sleep(TDuration::Seconds(5));
        }
    }

    TClientRequest* TDaemon::CreateClient() {
        return new TReplier(App_.Get());
    }
}
