#pragma once

#include "request.h"
#include <library/cpp/http/server/http.h>
#include <library/cpp/http/server/response.h>

namespace NBubbleServer {
    class TNotImplemented: public yexception {};

    using EHttpCodes = HttpCodes;

    class THandler {
    public:
        virtual ~THandler() = default;

        virtual bool MatchRequest(const TRequest&) const {
            return false;
        }

        virtual THttpResponse Execute(const TRequest&) {
            ythrow TNotImplemented();
        }
    };

    THttpResponse MakeResponse(EHttpCodes code = HTTP_OK, const TString& content = "");
}
