#include <infra/bubble/app.h>
#include <infra/bubble/daemon.h>

class TMyHandler: public NBubbleServer::THandler {
    bool MatchRequest(const NBubbleServer::TRequest& request) const override {
        return request.Method == "GET" && request.Path == "/test";
    }
    THttpResponse Execute(const NBubbleServer::TRequest&) override {
        return NBubbleServer::MakeResponse(NBubbleServer::EHttpCodes::HTTP_OK, "Hello world!");
    }
};

int main() {
    ui16 port = 29911;
    auto app = new NBubbleServer::TApp({
            new TMyHandler(),
    });
    NBubbleServer::TDaemon daemon(port, app);
    daemon.ServeForever();
    return 0;
}
