#include "request.h"

#include <library/cpp/cgiparam/cgiparam.h>

namespace NBubbleServer {
    TRequest::TRequest(const TRequestReplier::TReplyParams& params)
        : TParsedHttpFull(params.Input.FirstLine())
        , Input(params.Input)
        , Headers(Input.Headers())
    {
    }

    bool TRequest::Accepts(const TString& mime_type) const {
        for (const auto& kv : Headers) {
            if (kv.Name() == "Accept") {
                return kv.Value() == mime_type;
            }
        }
        return false;
    }

    TSet<TString> TRequest::GetCgi(const TString& param_name) const {
        TCgiParameters params(Cgi);
        TSet<TString> values;
        for (size_t i = 0; i < params.NumOfValues(param_name); ++i) {
            values.insert(params.Get(param_name, i));
        }
        return values;
    }

    TString TRequest::GetCgiFirst(const TString& param_name, const TString& default_value) const {
        TCgiParameters params(Cgi);
        if (params.Has(param_name)) {
            return params.Get(param_name, 0);
        }
        return default_value;
    }
}
