#pragma once

#include <library/cpp/http/server/http.h>
#include <library/cpp/http/misc/parsed_request.h>
#include <util/generic/set.h>

namespace NBubbleServer {
    struct TRequest : TParsedHttpFull {
        explicit TRequest(const TRequestReplier::TReplyParams& params);
        bool Accepts(const TString& mime_type) const;
        TSet<TString> GetCgi(const TString& param_name) const;
        TString GetCgiFirst(const TString& param_name, const TString& default_value) const;

        THttpInput& Input;
        THttpHeaders Headers;
    };
}
