"""
Obsolete. Used only in old callisto hamster.
"""
import time
import random
import logging

import requests

import basesearch
import utils


def get_config_from_basesearch(port):
    return {
        'shard': basesearch.get_basesearch_shard(utils.get_hostname(), port)
    }


def apply_config(settings, config):
    basesearch.apply_basesearch_config(settings, config)


def add_args(parser):
    parser.add_argument('--shard-root', help='Shard root dir', required=True)
    parser.add_argument('--follow-port', help='Follow localhost:<given port>', type=int, required=True)
    parser.add_argument('--interval', help='Report / get config interval, sec', type=int, required=True)


def run_service(args):
    current_config = {}
    while True:
        try:
            if args.follow_port:
                new_config = get_config_from_basesearch(args.follow_port)
                if new_config != current_config:
                    logging.info('New config\n%s', new_config)
                    apply_config(args, new_config)
                    current_config = new_config
                else:
                    logging.debug('No changes in config')
            else:
                logging.debug('Nothing to follow')

        except (RuntimeError, requests.ConnectionError) as ex:
            logging.exception(ex)
        finally:
            time.sleep(args.interval + random.randint(0, 5))
