import gevent.monkey
gevent.monkey.patch_all()  # noqa

import argparse
import library.python.svn_version as svn_version

import hamster
import utils
import v2
import v2.main
import v2.deployer2.resolve_shard_path
import utils.log


SPECIAL_MODES = {
    'old-hamster': hamster.add_args,
    'resolve-path': v2.deployer2.resolve_shard_path.ArgsMode.add_args,
    'resolve-path-env': v2.deployer2.resolve_shard_path.EnvMode.add_args,
}


def _add_v2_args(parser):
    parser.add_argument('--configs-url', help='Url of configs distributor', type=str, required=True)
    parser.add_argument('--reports-url', help='Url of reports collector', type=str, required=True)
    parser.add_argument('--interval', help='Report / get config interval, sec', type=int, required=True)
    parser.add_argument('--readonly', help='Readonly mode', default=False, action='store_true')
    parser.add_argument('--port', help='Port', required=False)
    parser.add_argument('--test-config', help='Local config for testing', required=False)


def _add_logging_args(parser):
    parser.add_argument('--debug', help='Debug mode (affects logging)', action='store_true', default=False)
    parser.add_argument('--log-dir', help='Log dir', default='./logs')


def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument('--version', action='version', version=str(svn_version.svn_revision()))
    subparsers = parser.add_subparsers(dest='mode')
    for mode, module_ in v2.MODES.items():
        sub_parser = subparsers.add_parser(mode)
        _add_v2_args(sub_parser)
        module_.Plugin.add_args(sub_parser)
        _add_logging_args(sub_parser)
    for mode, add_args in SPECIAL_MODES.items():
        sub_parser = subparsers.add_parser(mode)
        add_args(sub_parser)
        _add_logging_args(sub_parser)
    return parser.parse_args()


def main():
    args = parse_args()
    utils.log.setup_logging(args.log_dir, args.debug)

    if args.mode == 'old-hamster':
        hamster.run_service(args)
    elif args.mode == 'resolve-path':
        v2.deployer2.resolve_shard_path.ArgsMode.resolve(args)
    elif args.mode == 'resolve-path-env':
        v2.deployer2.resolve_shard_path.EnvMode.resolve(args)
    else:
        v2.main.run_service(
            utils.get_hostname(),
            args.port or utils.get_port(),
            utils.get_tags(),
            args.configs_url,
            args.reports_url,
            args.mode,
            args.interval,
            args,
        )


if __name__ == '__main__':
    main()
