import requests
import retry

import utils.searchconfig


class Observer(object):
    def __init__(self, host, port):
        self._host = host
        self._port = port

    def get_shard_path(self):
        return _shard_path_from_config(self._host, self._port)


@retry.retry(delay=1, tries=3)
def _shard_path_from_config(host, port):
    r = requests.get(_url(host, port, 'yandsearch', info='getconfig:proto'), timeout=30)
    r.raise_for_status()

    return utils.searchconfig.get_shard_path(r.text)


def _url(host, port, path, info):
    return 'http://{}:{}/{}?info={}'.format(host, port, path, info)
